/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.ui.IMapViewManager;

public class ChangeNodeLevelController {
    public ChangeNodeLevelController(MModeController modeController) {
        modeController.addAction(new ChangeNodeLevelLeftsAction());
        modeController.addAction(new ChangeNodeLevelRightsAction());
    }

    private boolean checkSelection() {
        Controller controller = Controller.getCurrentController();
        IMapSelection selection = controller.getSelection();
        NodeModel selectedNode = selection.getSelected();
        NodeModel selectedParent = selectedNode.getParentNode();
        if (selectedParent == null) {
            UITools.errorMessage((Object)TextUtils.getText((String)"cannot_add_parent_to_root"));
            return false;
        }
        Set selectedNodes = selection.getSelection();
        for (NodeModel node : selectedNodes) {
            if (node.getParentNode() == selectedParent) continue;
            UITools.errorMessage((Object)TextUtils.getText((String)"cannot_add_parent_diff_parents"));
            return false;
        }
        return true;
    }

    private void moveDownwards(NodeModel selectionRoot, NodeModel selectedNode) {
        NodeModel targetCandidate;
        int i;
        if (!this.checkSelection()) {
            return;
        }
        NodeModel selectedParent = selectedNode.getParentNode();
        List selectedNodes = Controller.getCurrentController().getSelection().getSortedSelection(true);
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        int ownPosition = selectedParent.getIndex(selectedNode);
        NodeModel directSibling = null;
        for (i = ownPosition - 1; i >= 0; --i) {
            targetCandidate = selectedParent.getChildAt(i);
            if (!this.canMoveTo(selectionRoot, selectedNode, selectedNodes, targetCandidate)) continue;
            directSibling = targetCandidate;
            break;
        }
        if (directSibling == null) {
            for (i = ownPosition + 1; i < selectedParent.getChildCount(); ++i) {
                targetCandidate = selectedParent.getChildAt(i);
                if (!this.canMoveTo(selectionRoot, selectedNode, selectedNodes, targetCandidate)) continue;
                directSibling = targetCandidate;
                break;
            }
        }
        if (directSibling != null) {
            for (NodeModel node : selectedNodes) {
                ((FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class)).undoableDeactivateHook(node);
            }
            mapController.moveNodes(selectedNodes, directSibling, directSibling.getChildCount());
            Controller.getCurrentModeController().getMapController().selectMultipleNodes(selectedNode, (Collection)selectedNodes);
        }
    }

    private boolean canMoveTo(NodeModel selectionRoot, NodeModel selectedNode, List<NodeModel> selectedNodes, NodeModel targetCandidate) {
        return !selectedNodes.contains(targetCandidate) && selectedNode.isLeft(selectionRoot) == targetCandidate.isLeft(selectionRoot) && (targetCandidate.hasChildren() || !targetCandidate.isHiddenSummary());
    }

    private void moveUpwards(NodeModel selectionRoot, NodeModel selectedNode) {
        if (!this.checkSelection()) {
            return;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        NodeModel selectedParent = selectedNode.getParentNode();
        List selectedNodes = Controller.getCurrentController().getSelection().getSortedSelection(true);
        if (selectedParent == selectionRoot) {
            JComponent mapViewComponent;
            IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
            if (!mapViewManager.isLeftTreeSupported((Component)(mapViewComponent = mapViewManager.getMapViewComponent()))) {
                return;
            }
            NodeModel.Side newSide = selectedNode.isLeft(selectionRoot) ? NodeModel.Side.RIGHT : NodeModel.Side.LEFT;
            mapController.setSide(selectedNodes, newSide);
        } else {
            NodeModel grandParent = selectedParent.getParentNode();
            NodeModel childNode = selectedParent;
            int position = grandParent.getIndex(childNode) + 1;
            selectedParent = grandParent;
            MapStyleModel mapStyleModel = MapStyleModel.getExtension((MapModel)selectedParent.getMap());
            MapViewLayout layoutType = mapStyleModel.getMapViewLayout();
            List movedChildren = layoutType == MapViewLayout.OUTLINE ? this.findMovedChildren(selectedNode.getParentNode(), selectedNodes) : Collections.emptyList();
            for (NodeModel node : selectedNodes) {
                ((FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class)).undoableDeactivateHook(node);
            }
            mapController.moveNodes(selectedNodes, selectedParent, position);
            if (layoutType == MapViewLayout.OUTLINE) {
                for (int i = 0; i < selectedNodes.size(); ++i) {
                    mapController.moveNodes((List)movedChildren.get(i), (NodeModel)selectedNodes.get(i), 0);
                }
            }
        }
        mapController.selectMultipleNodes(selectedNode, selectedNodes);
    }

    private List<List<NodeModel>> findMovedChildren(NodeModel parent, List<NodeModel> movedNodes) {
        ArrayList<List<NodeModel>> movedChildren = new ArrayList<List<NodeModel>>(movedNodes.size());
        int movedNodeCounter = 0;
        List children = parent.getChildren();
        for (NodeModel node : children) {
            List list;
            if (movedNodeCounter < movedNodes.size() && node == movedNodes.get(movedNodeCounter)) {
                ++movedNodeCounter;
                movedChildren.add(new ArrayList());
                continue;
            }
            if (movedNodeCounter <= 0 || (list = (List)movedChildren.get(movedNodeCounter - 1)).size() <= 0 && SummaryNode.isSummaryNode((NodeModel)node)) continue;
            list.add(node);
        }
        return movedChildren;
    }

    private class ChangeNodeLevelLeftsAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        public ChangeNodeLevelLeftsAction() {
            super("ChangeNodeLevelLeftsAction");
        }

        public void actionPerformed(ActionEvent e) {
            Controller controller = Controller.getCurrentController();
            IMapSelection selection = controller.getSelection();
            NodeModel selectedNode = selection.getSelected();
            IMapViewManager mapViewManager = controller.getMapViewManager();
            JComponent mapViewComponent = mapViewManager.getMapViewComponent();
            NodeModel selectionRoot = selection.getSelectionRoot();
            if (mapViewManager.isLeftTreeSupported((Component)mapViewComponent) && selectedNode.isLeft(selectionRoot)) {
                ChangeNodeLevelController.this.moveDownwards(selectionRoot, selectedNode);
            } else {
                ChangeNodeLevelController.this.moveUpwards(selectionRoot, selectedNode);
            }
        }
    }

    private class ChangeNodeLevelRightsAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        public ChangeNodeLevelRightsAction() {
            super("ChangeNodeLevelRightsAction");
        }

        public void actionPerformed(ActionEvent e) {
            JComponent mapViewComponent;
            Controller controller = Controller.getCurrentController();
            IMapSelection selection = controller.getSelection();
            NodeModel selectedNode = selection.getSelected();
            IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
            if (mapViewManager.isLeftTreeSupported((Component)(mapViewComponent = mapViewManager.getMapViewComponent())) && selectedNode.isLeft(selection.getSelectionRoot())) {
                ChangeNodeLevelController.this.moveUpwards(selection.getSelectionRoot(), selectedNode);
            } else {
                ChangeNodeLevelController.this.moveDownwards(selection.getSelectionRoot(), selectedNode);
            }
        }
    }
}

