/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.ViewController;
import org.freeplane.view.swing.map.MapView;

public class MapViewScrollPane
extends JScrollPane
implements IFreeplanePropertyListener {
    private static final Dimension INVISIBLE = new Dimension(0, 0);
    public static final Rectangle EMPTY_RECTANGLE = new Rectangle();
    private static final long serialVersionUID = 1L;
    private final Border defaultBorder;

    public MapViewScrollPane() {
        super(22, 32);
        this.setViewport(new MapViewPort());
        this.defaultBorder = this.getBorder();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && MapViewScrollPane.this.isShowing() && !MapViewScrollPane.this.isValid()) {
                    MapViewScrollPane.this.revalidate();
                    MapViewScrollPane.this.repaint();
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setScrollbarsVisiblilty();
        UITools.setScrollbarIncrement(this);
        ResourceController.getResourceController().addPropertyChangeListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ResourceController.getResourceController().removePropertyChangeListener(this);
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if ("fullscreen_enabled".equals(propertyName) || propertyName.startsWith("scrollbarsVisible")) {
            this.setScrollbarsVisiblilty();
        } else if (propertyName.equals("scrollbar_increment")) {
            int scrollbarIncrement = Integer.valueOf(newValue);
            this.getHorizontalScrollBar().setUnitIncrement(scrollbarIncrement);
            this.getVerticalScrollBar().setUnitIncrement(scrollbarIncrement);
        }
    }

    private void setScrollbarsVisiblilty() {
        ViewController viewController = Controller.getCurrentController().getViewController();
        boolean areScrollbarsVisible = viewController.areScrollbarsVisible();
        if (areScrollbarsVisible) {
            this.getVerticalScrollBar().setPreferredSize(null);
            this.getHorizontalScrollBar().setPreferredSize(null);
        } else {
            this.getVerticalScrollBar().setPreferredSize(INVISIBLE);
            this.getHorizontalScrollBar().setPreferredSize(INVISIBLE);
        }
        boolean isFullScreenEnabled = !UITools.getCurrentFrame().isResizable();
        this.setBorder((Border)(isFullScreenEnabled && !areScrollbarsVisible ? null : this.defaultBorder));
        this.revalidate();
        this.repaint();
    }

    public void setViewportHiddenAreaSupplier(ViewportHiddenAreaSupplier hiddenAreaSupplier) {
        ((MapViewPort)this.getViewport()).setHiddenAreaSupplier(hiddenAreaSupplier);
    }

    @Override
    public void doLayout() {
        Component view;
        if (this.viewport != null && (view = this.viewport.getView()) != null) {
            view.invalidate();
        }
        super.doLayout();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        ActionAcceleratorManager acceleratorManager;
        if (this.viewport != null && (acceleratorManager = ResourceController.getResourceController().getAcceleratorManager()).canProcessKeyEvent(e)) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    static class MapViewPort
    extends JViewport {
        private ViewportHiddenAreaSupplier hiddenAreaSupplier = () -> EMPTY_RECTANGLE;
        private boolean layoutInProgress = false;
        private Timer timer;
        private JComponent backgroundComponent;

        MapViewPort() {
        }

        void setHiddenAreaSupplier(ViewportHiddenAreaSupplier hiddenAreaSupplier) {
            this.hiddenAreaSupplier = hiddenAreaSupplier;
        }

        @Override
        public void doLayout() {
            Component view = this.getView();
            this.layoutInProgress = view != null && !view.isValid();
            super.doLayout();
            this.layoutInProgress = false;
            if (view != null) {
                ((MapView)view).scrollViewAfterLayout();
            }
        }

        public void setBackgroundComponent(JComponent backgroundComponent) {
            this.backgroundComponent = backgroundComponent;
        }

        @Override
        public void scrollRectToVisible(Rectangle newContentRectangle) {
            Rectangle hiddenArea = this.hiddenAreaSupplier.getHiddenArea();
            if (hiddenArea.width != 0 && hiddenArea.height != 0) {
                boolean isHiddenAreaAtTheBottom;
                Point viewportLocation = new Point(0, 0);
                UITools.convertPointToAncestor((Component)this, viewportLocation, JScrollPane.class);
                hiddenArea.x -= viewportLocation.x;
                hiddenArea.y -= viewportLocation.y;
                boolean isHiddenAreaAtTheLeft = hiddenArea.x == 0;
                boolean isHiddenAreaAtTheTop = hiddenArea.y == 0;
                boolean isHiddenAreaAtTheRight = hiddenArea.x + hiddenArea.width == this.getWidth();
                boolean bl = isHiddenAreaAtTheBottom = hiddenArea.y + hiddenArea.height == this.getHeight();
                if (isHiddenAreaAtTheLeft || isHiddenAreaAtTheRight || isHiddenAreaAtTheTop || isHiddenAreaAtTheBottom) {
                    boolean overlapsOnYAxis;
                    Rectangle newContentRectangleWithHiddenArea = new Rectangle(newContentRectangle);
                    int dx = this.positionAdjustment(this.getWidth(), newContentRectangle.width, newContentRectangle.x);
                    int dy = this.positionAdjustment(this.getHeight(), newContentRectangle.height, newContentRectangle.y);
                    boolean overlapsOnXAxis = newContentRectangle.x + dx < hiddenArea.x + hiddenArea.width && newContentRectangle.x + dx + newContentRectangle.width > hiddenArea.x;
                    boolean bl2 = overlapsOnYAxis = newContentRectangle.y + dy < hiddenArea.y + hiddenArea.height && newContentRectangle.y + dy + newContentRectangle.height > hiddenArea.y;
                    if (overlapsOnYAxis && overlapsOnXAxis) {
                        boolean isWidthSufficient;
                        boolean bl3 = isWidthSufficient = hiddenArea.width + newContentRectangle.width < this.getWidth();
                        if (isWidthSufficient && (isHiddenAreaAtTheLeft || isHiddenAreaAtTheRight)) {
                            if (isHiddenAreaAtTheLeft) {
                                newContentRectangleWithHiddenArea.x -= hiddenArea.width;
                                newContentRectangleWithHiddenArea.width += hiddenArea.width;
                            } else if (isHiddenAreaAtTheRight) {
                                newContentRectangleWithHiddenArea.width += hiddenArea.width;
                            }
                        } else {
                            boolean isHeightSufficient;
                            boolean bl4 = isHeightSufficient = hiddenArea.height + newContentRectangle.height < this.getHeight();
                            if (isHeightSufficient) {
                                if (isHiddenAreaAtTheTop) {
                                    newContentRectangleWithHiddenArea.y -= hiddenArea.height;
                                    newContentRectangleWithHiddenArea.height += hiddenArea.height;
                                } else if (isHiddenAreaAtTheBottom) {
                                    newContentRectangleWithHiddenArea.height += hiddenArea.height;
                                }
                            }
                        }
                    }
                    super.scrollRectToVisible(newContentRectangleWithHiddenArea);
                    return;
                }
            }
            super.scrollRectToVisible(newContentRectangle);
        }

        private int positionAdjustment(int parentWidth, int childWidth, int childAt) {
            if (childAt >= 0 && childWidth + childAt <= parentWidth) {
                return 0;
            }
            if (childAt > 0 && childWidth <= parentWidth) {
                return -childAt + parentWidth - childWidth;
            }
            if (childAt <= 0 && childWidth <= parentWidth) {
                return -childAt;
            }
            return 0;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.backgroundComponent != null) {
                this.backgroundComponent.paint(g);
            }
        }

        @Override
        public void setViewPosition(Point p) {
            if (!this.layoutInProgress) {
                Integer scrollingDelay = (Integer)this.getClientProperty("slowScrolling");
                if (scrollingDelay != null && scrollingDelay != 0) {
                    this.putClientProperty("slowScrolling", null);
                    this.slowSetViewPosition(p, scrollingDelay);
                } else {
                    this.stopTimer();
                    this.layoutInProgress = true;
                    super.setViewPosition(p);
                    this.layoutInProgress = false;
                    MapView view = (MapView)this.getView();
                    if (view != null) {
                        view.setAnchorContentLocation();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBounds(int x, int y, int width, int height) {
            boolean layoutWasInProgress = this.layoutInProgress;
            this.layoutInProgress = true;
            try {
                int dX = (width - this.getWidth()) / 2;
                int dY = (height - this.getHeight()) / 2;
                if (dX != 0 || dY != 0) {
                    Point viewPosition = this.getViewPosition();
                    viewPosition.x += dX;
                    viewPosition.y += dY;
                    super.setViewPosition(viewPosition);
                }
                super.setBounds(x, y, width, height);
            }
            finally {
                this.layoutInProgress = layoutWasInProgress;
            }
        }

        @Override
        public void setViewSize(Dimension newSize) {
            Component view = this.getView();
            if (view != null) {
                Dimension oldSize = view.getSize();
                if (newSize.equals(oldSize)) {
                    view.setSize(newSize);
                } else {
                    super.setViewSize(newSize);
                }
            }
        }

        private void slowSetViewPosition(final Point p, final int delay) {
            this.stopTimer();
            Point viewPosition = this.getViewPosition();
            int dx = p.x - viewPosition.x;
            int dy = p.y - viewPosition.y;
            int slowDx = this.calcScrollIncrement(dx);
            int slowDy = this.calcScrollIncrement(dy);
            viewPosition.translate(slowDx, slowDy);
            super.setViewPosition(viewPosition);
            if (slowDx == dx && slowDy == dy) {
                return;
            }
            this.timer = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    timer = null;
                    this.slowSetViewPosition(p, delay);
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }

        private int calcScrollIncrement(int dx) {
            int v = ResourceController.getResourceController().getIntProperty("scrolling_speed");
            int absDx = Math.abs(dx);
            double sqrtDx = Math.sqrt(absDx);
            int slowDX = (int)Math.max((double)absDx * sqrtDx / 20.0, 20.0 * sqrtDx) * v / 100;
            if (Math.abs(dx) > 2 && slowDX < Math.abs(dx)) {
                dx = slowDX * Integer.signum(dx);
            }
            return dx;
        }
    }

    public static interface ViewportHiddenAreaSupplier {
        public Rectangle getHiddenArea();
    }
}

