/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.dnd.Autoscroll;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.extension.HighlightedElements;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.svgicons.GraphicsHints;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.highlight.NodeHighlighter;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.Connectors;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.map.NodeSubtrees;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.print.FitMap;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapScroller;
import org.freeplane.view.swing.map.MapViewScrollPane;
import org.freeplane.view.swing.map.MindMapLayout;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NodeViewFactory;
import org.freeplane.view.swing.map.PaintingMode;
import org.freeplane.view.swing.map.ScrollingDirective;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.link.AConnectorView;
import org.freeplane.view.swing.map.link.ConnectorView;
import org.freeplane.view.swing.map.link.EdgeLinkView;
import org.freeplane.view.swing.map.link.ILinkView;

public class MapView
extends JPanel
implements Printable,
Autoscroll,
IMapChangeListener,
IFreeplanePropertyListener,
Configurable {
    private static final int ROOT_NODE_COMPONENT_INDEX = 0;
    private static final String UNFOLD_ON_NAVIGATION = "unfold_on_navigation";
    private final MapScroller mapScroller;
    private MapViewLayout layoutType;
    private boolean paintConnectorsBehind;
    private Filter filter;
    private boolean showNotes;
    private PaintingMode paintingMode = null;
    private static final int margin = 20;
    static boolean printOnWhiteBackground;
    private static IFreeplanePropertyListener propertyChangeListener;
    public static final String RESOURCES_SELECTED_NODE_COLOR = "standardselectednodecolor";
    public static final String RESOURCES_SELECTED_NODE_RECTANGLE_COLOR = "standardselectednoderectanglecolor";
    private static final String SPOTLIGHT_BACKGROUND_COLOR = "spotlight_background_color";
    private static final String PRESENTATION_DIMMER_TRANSPARENCY = "presentation_dimmer_transparency";
    private static final String HIDE_SINGLE_END_CONNECTORS;
    private static final String SHOW_CONNECTORS_PROPERTY;
    private static final String SHOW_CONNECTOR_LINES;
    private static final String HIDE_CONNECTOR_LINES;
    private static final String SOME_CONNECTORS_PROPERTY = "connector_";
    private static final String HIDE_CONNECTORS;
    private static final String SHOW_CONNECTORS_FOR_SELECTION;
    private static final String SHOW_ICONS_PROPERTY = "show_icons";
    private static final String OUTLINE_VIEW_FITS_WINDOW_WIDTH = "outline_view_fits_window_width";
    private static final String OUTLINE_HGAP_PROPERTY = "outline_hgap";
    private static final PropertyChangeListener repaintOnClientPropertyChangeListener;
    private static final long serialVersionUID = 1L;
    private static boolean drawsRectangleForSelection;
    private static Color selectionRectangleColor;
    private Vector<ILinkView> arrowLinkViews;
    private Color background = null;
    private JComponent backgroundComponent;
    private Rectangle boundingRectangle = null;
    private FitMap fitMap = FitMap.USER_DEFINED;
    private boolean isPreparedForPrinting = false;
    private boolean isPrinting = false;
    private final ModeController modeController;
    private final MapModel model;
    private NodeView currentRootView = null;
    private NodeView currentRootParentView = null;
    private NodeView mapRootView = null;
    private List<NodeView> rootsHistory;
    private boolean selectedsValid = true;
    private final Selection selection = new Selection();
    private int siblingMaxLevel;
    private float zoom = 1.0f;
    private Font noteFont;
    private Font detailFont;
    private int detailHorizontalAlignment;
    private Color detailForeground;
    private Color detailBackground;
    private NodeCss detailCss;
    private int noteHorizontalAlignment;
    private Color noteForeground;
    private Color noteBackground;
    private NodeCss noteCss;
    private static String showConnectorsPropertyValue;
    private static boolean hideSingleEndConnectorsPropertyValue;
    private String showConnectors;
    private boolean hideSingleEndConnectors;
    private static boolean showIcons;
    private boolean fitToViewport;
    private static Color spotlightBackgroundColor;
    private static int outlineHGap;
    private static boolean outlineViewFitsWindowWidth;
    private final ComponentAdapter viewportSizeChangeListener;
    private final INodeChangeListener connectorChangeListener;
    private boolean allowsCompactLayout;
    private static final String INLINE_EDITOR_ACTIVE = "inline_editor_active";
    public static final String SPOTLIGHT_ENABLED = "spotlight";
    private boolean scrollsViewAfterLayout = true;

    public static boolean isElementHighlighted(Component c, Object element) {
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, c);
        if (mapView == null) {
            return false;
        }
        HighlightedElements highlightedElements = mapView.getExtension(HighlightedElements.class);
        if (highlightedElements == null) {
            return false;
        }
        return highlightedElements.isContained(element);
    }

    public MapViewLayout getLayoutType() {
        return this.layoutType;
    }

    protected void setLayoutType(MapViewLayout layoutType) {
        if (this.layoutType != layoutType) {
            this.layoutType = layoutType;
            if (this.outlineViewFitsWindowWidth()) {
                this.currentRootView.updateAll();
            }
        }
    }

    boolean showNotes() {
        return this.showNotes;
    }

    private void setShowNotes() {
        boolean showNotes = NoteController.getController(this.getModeController()).showNotesInMap(this.getModel());
        if (this.showNotes == showNotes) {
            return;
        }
        this.showNotes = showNotes;
        this.getRoot().updateAll();
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    public MapView(MapModel model, ModeController modeController) {
        this.model = model;
        this.modeController = modeController;
        this.rootsHistory = new ArrayList<NodeView>();
        this.mapScroller = new MapScroller(this);
        this.filter = Filter.createTransparentFilter();
        String name = model.getTitle();
        this.setName(name);
        this.setAutoscrolls(true);
        this.setLayout(new MindMapLayout());
        NoteController noteController = NoteController.getController(this.getModeController());
        this.showNotes = noteController != null && noteController.showNotesInMap(this.getModel());
        this.updateContentStyle();
        this.initRoot();
        this.setBackground(this.requiredBackground());
        MapStyleModel mapStyleModel = MapStyleModel.getExtension(model);
        this.zoom = mapStyleModel.getZoom();
        this.layoutType = mapStyleModel.getMapViewLayout();
        IUserInputListenerFactory userInputListenerFactory = this.getModeController().getUserInputListenerFactory();
        this.addMouseListener(userInputListenerFactory.getMapMouseListener());
        this.addMouseMotionListener(userInputListenerFactory.getMapMouseListener());
        this.addMouseWheelListener(userInputListenerFactory.getMapMouseWheelListener());
        this.setFocusTraversalKeys(0, this.emptyNodeViewSet());
        this.setFocusTraversalKeys(1, this.emptyNodeViewSet());
        this.setFocusTraversalKeys(2, this.emptyNodeViewSet());
        this.viewportSizeChangeListener = new ComponentAdapter(){
            boolean firstRun = true;

            @Override
            public void componentResized(ComponentEvent e) {
                if (this.firstRun) {
                    MapView.this.loadBackgroundImage();
                    this.firstRun = false;
                }
                if (MapView.this.fitToViewport) {
                    MapView.this.adjustBackgroundComponentScale();
                }
                if (MapView.this.usesLayoutSpecificMaxNodeWidth()) {
                    MapView.this.currentRootView.updateAll();
                    MapView.this.repaint();
                }
            }
        };
        MapStyle mapStyle = this.getModeController().getExtension(MapStyle.class);
        String fitToViewportAsString = mapStyle.getPropertySetDefault(model, "fit_to_viewport");
        this.fitToViewport = Boolean.parseBoolean(fitToViewportAsString);
        this.allowsCompactLayout = mapStyle.allowsCompactLayout(model);
        this.connectorChangeListener = new INodeChangeListener(){

            @Override
            public void nodeChanged(NodeChangeEvent event) {
                if (NodeLinks.CONNECTOR.equals(event.getProperty()) && event.getNode().getMap().equals(MapView.this.getModel())) {
                    MapView.this.repaint();
                }
            }
        };
        this.addPropertyChangeListener(SPOTLIGHT_ENABLED, repaintOnClientPropertyChangeListener);
        if (ResourceController.getResourceController().getBooleanProperty("activateSpotlightByDefault")) {
            this.putClientProperty(SPOTLIGHT_ENABLED, Boolean.TRUE);
        }
    }

    public void replaceSelection(NodeView[] views) {
        this.selection.replace(views);
        if (views.length > 0) {
            views[0].requestFocusInWindow();
        }
    }

    private Set<AWTKeyStroke> emptyNodeViewSet() {
        return Collections.emptySet();
    }

    @Override
    public void autoscroll(Point cursorLocn) {
        Rectangle r = new Rectangle((int)cursorLocn.getX() - 20, (int)cursorLocn.getY() - 20, 41, 41);
        this.scrollRectToVisible(r);
    }

    boolean frameLayoutCompleted() {
        Frame frame = JOptionPane.getFrameForComponent(this);
        Insets frameInsets = frame.getInsets();
        Component rootPane = frame.getComponent(0);
        boolean frameLayoutCompleted = rootPane.getWidth() == frame.getWidth() - frameInsets.left - frameInsets.right && rootPane.getHeight() == frame.getHeight() - frameInsets.top - frameInsets.bottom;
        return frameLayoutCompleted;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.modeController.getMapController().addUINodeChangeListener(this.connectorChangeListener);
        this.getParent().addComponentListener(this.viewportSizeChangeListener);
    }

    @Override
    public void removeNotify() {
        this.modeController.getMapController().removeNodeChangeListener(this.connectorChangeListener);
        this.getParent().removeComponentListener(this.viewportSizeChangeListener);
        super.removeNotify();
    }

    boolean isLayoutCompleted() {
        JViewport viewPort = (JViewport)this.getParent();
        Dimension visibleDimension = viewPort.getExtentSize();
        return visibleDimension.width > 0;
    }

    private static void createPropertyChangeListener() {
        propertyChangeListener = new IFreeplanePropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                JComponent c = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
                if (!(c instanceof MapView)) {
                    return;
                }
                MapView mapView = (MapView)c;
                if (propertyName.equals(MapView.RESOURCES_SELECTED_NODE_COLOR)) {
                    mapView.repaintSelecteds();
                    return;
                }
                if (propertyName.equals(MapView.RESOURCES_SELECTED_NODE_RECTANGLE_COLOR)) {
                    mapView.repaintSelecteds();
                    return;
                }
                if (propertyName.equals("standarddrawrectangleforselection")) {
                    drawsRectangleForSelection = TreeXmlReader.xmlToBoolean(newValue);
                    mapView.repaintSelecteds();
                    return;
                }
                if (propertyName.equals("printonwhitebackground")) {
                    printOnWhiteBackground = TreeXmlReader.xmlToBoolean(newValue);
                    return;
                }
                if (propertyName.equals(MapView.SPOTLIGHT_BACKGROUND_COLOR)) {
                    spotlightBackgroundColor = ColorUtils.stringToColor(newValue);
                    mapView.repaint();
                    return;
                }
                if (propertyName.equals(HIDE_SINGLE_END_CONNECTORS)) {
                    hideSingleEndConnectorsPropertyValue = ResourceController.getResourceController().getBooleanProperty(HIDE_SINGLE_END_CONNECTORS);
                    mapView.repaint();
                    return;
                }
                if (propertyName.equals(SHOW_CONNECTORS_PROPERTY)) {
                    showConnectorsPropertyValue = ResourceController.getResourceController().getProperty(SHOW_CONNECTORS_PROPERTY).intern();
                    mapView.repaint();
                    return;
                }
                if (propertyName.startsWith(MapView.SOME_CONNECTORS_PROPERTY)) {
                    showConnectorsPropertyValue = ResourceController.getResourceController().getProperty(SHOW_CONNECTORS_PROPERTY).intern();
                    mapView.repaint();
                    return;
                }
                if (propertyName.equals(MapView.SHOW_ICONS_PROPERTY)) {
                    showIcons = ResourceController.getResourceController().getBooleanProperty(MapView.SHOW_ICONS_PROPERTY);
                    mapView.updateIconsRecursively(mapView.getRoot());
                    mapView.repaint();
                    return;
                }
                if (propertyName.equals(MapView.OUTLINE_HGAP_PROPERTY)) {
                    outlineHGap = ResourceController.getResourceController().getLengthProperty(MapView.OUTLINE_HGAP_PROPERTY);
                    if (mapView.isOutlineLayoutSet()) {
                        mapView.getRoot().updateAll();
                        mapView.repaint();
                    }
                    return;
                }
                if (propertyName.equals(MapView.OUTLINE_VIEW_FITS_WINDOW_WIDTH)) {
                    outlineViewFitsWindowWidth = ResourceController.getResourceController().getBooleanProperty(MapView.OUTLINE_VIEW_FITS_WINDOW_WIDTH);
                    if (mapView.isOutlineLayoutSet()) {
                        mapView.getRoot().updateAll();
                        mapView.repaint();
                    }
                    return;
                }
            }
        };
        ResourceController.getResourceController().addPropertyChangeListener(propertyChangeListener);
    }

    public void deselect(NodeView newSelected) {
        if (this.selection.contains(newSelected) && this.selection.deselect(newSelected) && newSelected.getParent() != null) {
            this.onSelectionChange(newSelected);
        }
    }

    private void onSelectionChange(NodeView node) {
        if (!node.isShowing()) {
            return;
        }
        node.update();
        if (SHOW_CONNECTORS_FOR_SELECTION == this.showConnectors) {
            this.repaint(this.getVisibleRect());
        } else {
            node.repaintSelected();
        }
    }

    public Object detectView(Point p) {
        ILinkView arrowView;
        int i;
        if (this.arrowLinkViews == null) {
            return null;
        }
        for (i = 0; i < this.arrowLinkViews.size(); ++i) {
            arrowView = this.arrowLinkViews.get(i);
            if (!arrowView.detectCollision(p, true)) continue;
            return arrowView;
        }
        for (i = 0; i < this.arrowLinkViews.size(); ++i) {
            arrowView = this.arrowLinkViews.get(i);
            if (!arrowView.detectCollision(p, false)) continue;
            return arrowView;
        }
        return null;
    }

    public Object detectObject(Point p) {
        Object view = this.detectView(p);
        if (view instanceof ILinkView) {
            return ((ILinkView)view).getModel();
        }
        return null;
    }

    public void endPrinting() {
        if (!this.isPreparedForPrinting) {
            return;
        }
        this.isPrinting = false;
        this.updatePrintedNodes();
        this.isPreparedForPrinting = false;
        if (printOnWhiteBackground) {
            this.setBackground(this.background);
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        Container parent = this.getParent();
        if (parent == null) {
            return new Insets(0, 0, 0, 0);
        }
        Rectangle outer = this.getBounds();
        Rectangle inner = parent.getBounds();
        return new Insets(inner.y - outer.y + 20, inner.x - outer.x + 20, outer.height - inner.height - inner.y + outer.y + 20, outer.width - inner.width - inner.x + outer.x + 20);
    }

    public Rectangle getInnerBounds() {
        Rectangle innerBounds = this.currentRootView.getBounds();
        Rectangle maxBounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (this.arrowLinkViews != null) {
            for (int i = 0; i < this.arrowLinkViews.size(); ++i) {
                ILinkView arrowView = this.arrowLinkViews.get(i);
                arrowView.increaseBounds(innerBounds);
            }
        }
        return innerBounds.intersection(maxBounds);
    }

    public IMapSelection getMapSelection() {
        return new MapSelection();
    }

    public ModeController getModeController() {
        return this.modeController;
    }

    public MapModel getModel() {
        return this.model;
    }

    public Point getNodeContentLocation(NodeView nodeView) {
        Point contentXY = new Point(0, 0);
        UITools.convertPointToAncestor((Component)nodeView.getContent(), contentXY, this);
        return contentXY;
    }

    private NodeView getNodeView(Object o) {
        if (!(o instanceof NodeModel)) {
            return null;
        }
        NodeView nodeView = this.getNodeView((NodeModel)o);
        return nodeView;
    }

    private NodeView getDisplayedNodeView(NodeModel node) {
        NodeView nodeView = this.getNodeView(node);
        return this.currentRootView == this.mapRootView || nodeView != null && this.isAncestorOf(nodeView) ? nodeView : null;
    }

    public NodeView getNodeView(NodeModel node) {
        if (node == null) {
            return null;
        }
        for (INodeView iNodeView : node.getViewers()) {
            NodeView candidateView;
            if (!(iNodeView instanceof NodeView) || (candidateView = (NodeView)iNodeView).getMap() != this) continue;
            return candidateView;
        }
        NodeView root = this.getRoot();
        if (root.getModel().equals(node)) {
            return root;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    public NodeView getRoot() {
        return this.currentRootView;
    }

    public NodeView getSelected() {
        if (!this.selectedsValid) {
            NodeView node = this.selection.selectedNode;
            if (node == null || !SwingUtilities.isDescendingFrom(node, this)) {
                this.validateSelecteds();
            } else {
                JComponent content = node.getContent();
                if (content == null || !content.isVisible()) {
                    this.validateSelecteds();
                }
            }
        }
        return this.selection.selectedNode;
    }

    public Set<NodeModel> getSelectedNodes() {
        this.validateSelecteds();
        return new AbstractSet<NodeModel>(){

            @Override
            public int size() {
                return MapView.this.selection.size();
            }

            @Override
            public boolean contains(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.contains(nodeView);
            }

            @Override
            public boolean add(NodeModel o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.add(nodeView);
            }

            @Override
            public boolean remove(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.deselect(nodeView);
            }

            @Override
            public Iterator<NodeModel> iterator() {
                return new Iterator<NodeModel>(){
                    final Iterator<NodeView> i;
                    {
                        this.i = MapView.this.selection.getSelectedSet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public NodeModel next() {
                        return this.i.next().getModel();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    public List<NodeModel> getOrderedSelectedNodes() {
        this.validateSelecteds();
        return new AbstractList<NodeModel>(){

            @Override
            public boolean add(NodeModel o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.add(nodeView);
            }

            @Override
            public boolean contains(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.contains(nodeView);
            }

            @Override
            public boolean remove(Object o) {
                NodeView nodeView = MapView.this.getNodeView(o);
                if (nodeView == null) {
                    return false;
                }
                return MapView.this.selection.deselect(nodeView);
            }

            @Override
            public NodeModel get(int index) {
                return ((NodeView)MapView.this.selection.getSelectedList().get(index)).getModel();
            }

            @Override
            public int size() {
                return MapView.this.selection.size();
            }
        };
    }

    ArrayList<NodeModel> getSelectedNodesSortedByY(boolean differentSubtrees) {
        this.validateSelecteds();
        TreeSet<NodeModel> sortedNodes = new TreeSet<NodeModel>(NodeRelativePath.comparator());
        for (NodeView view : this.selection.getSelectedSet()) {
            if (differentSubtrees && this.viewBelongsToSelectedSubtreeOrItsClone(view)) continue;
            sortedNodes.add(view.getModel());
        }
        if (differentSubtrees) {
            return NodeSubtrees.getUniqueSubtreeRoots(sortedNodes);
        }
        return new ArrayList<NodeModel>(sortedNodes);
    }

    private boolean viewBelongsToSelectedSubtreeOrItsClone(NodeView view) {
        HashSet<NodeModel> selectedNodesWithClones = new HashSet<NodeModel>();
        for (NodeView selectedView : this.selection.getSelectedList()) {
            for (NodeModel clone : selectedView.getModel().subtreeClones()) {
                selectedNodesWithClones.add(clone);
            }
        }
        Container parent = view.getParent();
        while (parent instanceof NodeView) {
            if (selectedNodesWithClones.contains(((NodeView)parent).getModel())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public Collection<NodeView> getSelection() {
        this.validateSelecteds();
        return this.selection.getSelection();
    }

    public int getSiblingMaxLevel() {
        return this.siblingMaxLevel;
    }

    public Dimension getViewportSize() {
        JViewport mapViewport = (JViewport)this.getParent();
        return mapViewport == null ? null : mapViewport.getSize();
    }

    private NodeView getVisibleLeft(NodeView oldSelected) {
        NodeView newSelected = oldSelected;
        if (this.isRoot(oldSelected)) {
            newSelected = oldSelected.getPreferredVisibleChild(this.isOutlineLayoutSet(), true);
        } else if (!oldSelected.isLeft()) {
            newSelected = this.getVisibleSummarizedOrParentView(oldSelected);
        } else {
            if (oldSelected.isFolded() && this.unfoldsOnNavigation()) {
                this.getModeController().getMapController().unfold(oldSelected.getModel(), this.filter);
                return oldSelected;
            }
            for (newSelected = oldSelected.getPreferredVisibleChild(this.isOutlineLayoutSet(), true); newSelected != null && !newSelected.getModel().hasVisibleContent(this.filter); newSelected = newSelected.getPreferredVisibleChild(this.isOutlineLayoutSet(), true)) {
            }
            if (newSelected == null) {
                newSelected = this.getVisibleSummaryView(oldSelected);
            }
        }
        return newSelected;
    }

    private boolean unfoldsOnNavigation() {
        return ResourceController.getResourceController().getBooleanProperty(UNFOLD_ON_NAVIGATION);
    }

    boolean isOutlineLayoutSet() {
        return this.layoutType.equals((Object)MapViewLayout.OUTLINE);
    }

    protected NodeView getVisibleSummarizedOrParentView(NodeView view) {
        return view.getVisibleSummarizedOrParentView();
    }

    private NodeView getVisibleSummaryView(NodeView node) {
        Component component;
        int currentSummaryLevel;
        if (this.isRoot(node)) {
            return null;
        }
        int level = currentSummaryLevel = SummaryNode.getSummaryLevel(this.currentRootView.getModel(), node.getModel());
        int requiredSummaryLevel = level + 1;
        NodeView parent = node.getParentView();
        for (int i = 1 + this.getIndex(node); i < parent.getComponentCount() && (component = parent.getComponent(i)) instanceof NodeView; ++i) {
            NodeView next = (NodeView)component;
            if (next.isLeft() != node.isLeft()) continue;
            level = next.isSummary() ? ++level : 0;
            if (level == requiredSummaryLevel) {
                if (next.getModel().hasVisibleContent(this.filter)) {
                    return next;
                }
                NodeView preferredVisibleChild = next.getPreferredVisibleChild(this.isOutlineLayoutSet(), next.isLeft());
                if (preferredVisibleChild == null) break;
                return preferredVisibleChild;
            }
            if (level == currentSummaryLevel && SummaryNode.isFirstGroupNode(next.getModel())) break;
        }
        return this.getVisibleSummaryView(parent);
    }

    int getIndex(NodeView node) {
        NodeView parent = node.getParentView();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            if (!parent.getComponent(i).equals(node)) continue;
            return i;
        }
        return -1;
    }

    private NodeView getVisibleRight(NodeView oldSelected) {
        NodeView newSelected = oldSelected;
        NodeModel oldModel = oldSelected.getModel();
        if (this.isRoot(oldSelected)) {
            newSelected = oldSelected.getPreferredVisibleChild(this.isOutlineLayoutSet(), false);
        } else if (oldSelected.isLeft()) {
            newSelected = this.getVisibleSummarizedOrParentView(oldSelected);
        } else {
            if (oldSelected.isFolded() && this.unfoldsOnNavigation()) {
                this.getModeController().getMapController().unfoldAndScroll(oldModel, this.filter);
                if (oldSelected.getModel().hasVisibleContent(this.filter)) {
                    return oldSelected;
                }
            }
            for (newSelected = oldSelected.getPreferredVisibleChild(this.isOutlineLayoutSet(), false); newSelected != null && !newSelected.getModel().hasVisibleContent(this.filter); newSelected = newSelected.getPreferredVisibleChild(this.isOutlineLayoutSet(), false)) {
            }
            if (newSelected == null) {
                newSelected = this.getVisibleSummaryView(oldSelected);
            }
        }
        return newSelected;
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getZoomed(int number) {
        return (int)Math.ceil((float)number * this.zoom);
    }

    public int getZoomed(double number) {
        return (int)Math.ceil(number * (double)this.zoom);
    }

    private void initRoot() {
        this.mapRootView = this.currentRootView = NodeViewFactory.getInstance().newNodeView(this.getModel().getRootNode(), this, this, 0);
        this.mapScroller.setAnchorView(this.currentRootView);
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public boolean isSelected(NodeView n) {
        if (this.isPrinting || !this.selectedsValid && (this.selection.selectedNode == null || !SwingUtilities.isDescendingFrom(this.selection.selectedNode, this) || !this.selection.selectedNode.getContent().isVisible())) {
            return false;
        }
        return this.selection.contains(n);
    }

    void addSelected(NodeView newSelected, boolean scroll) {
        if (newSelected.isContentVisible()) {
            this.selection.add(newSelected);
            if (scroll) {
                this.mapScroller.scrollNodeToVisible(newSelected);
            }
        }
    }

    @Override
    public void mapChanged(MapChangeEvent event) {
        String fitToViewportAsString;
        Object property = event.getProperty();
        if (property.equals("standardbackgroundcolor")) {
            this.setBackground(this.requiredBackground());
            return;
        }
        if (property.equals("MAP_STYLES")) {
            this.updateContentStyle();
            this.repaint();
        }
        if (property.equals("MAP_STYLES") && event.getMap().equals(this.model) || property.equals("AttributeViewType") || property.equals(Filter.class) || property.equals("map_url")) {
            this.setBackground(this.requiredBackground());
            this.getRoot().updateAll();
            return;
        }
        if (property.equals("show_icon_for_attributes") || property.equals("show_note_icons")) {
            this.updateIconsRecursively(this.getRoot());
        }
        if (property.equals("show_notes_in_map")) {
            this.setShowNotes();
        }
        if (property.equals("backgroundImageURI")) {
            fitToViewportAsString = MapStyle.getController(this.modeController).getPropertySetDefault(this.model, "fit_to_viewport");
            this.setFitToViewport(Boolean.parseBoolean(fitToViewportAsString));
            this.loadBackgroundImage();
        }
        if (property.equals("allow_compact_layout")) {
            MapStyle mapStyle = this.getModeController().getExtension(MapStyle.class);
            this.allowsCompactLayout = mapStyle.allowsCompactLayout(this.model);
            this.getRoot().updateAll();
            this.revalidate();
            this.repaint();
        }
        if (property.equals("fit_to_viewport")) {
            fitToViewportAsString = MapStyle.getController(this.modeController).getPropertySetDefault(this.model, "fit_to_viewport");
            this.setFitToViewport(Boolean.parseBoolean(fitToViewportAsString));
            this.adjustBackgroundComponentScale();
        }
        if (property.equals("edgeColorConfiguration")) {
            this.getRoot().updateAll();
            this.repaint();
        }
    }

    private void setFitToViewport(boolean fitToViewport) {
        this.fitToViewport = fitToViewport;
        this.updateBackground();
    }

    private void loadBackgroundImage() {
        ViewerController vc;
        MapStyle mapStyle = this.getModeController().getExtension(MapStyle.class);
        this.backgroundComponent = null;
        this.updateBackground();
        URI uri = mapStyle.getBackgroundImage(this.model);
        if (uri != null && (vc = this.getModeController().getExtension(ViewerController.class)) != null) {
            IViewerFactory factory = vc.getViewerFactory();
            this.assignViewerToBackgroundComponent(factory, uri);
        }
        this.repaint();
    }

    private void assignViewerToBackgroundComponent(IViewerFactory factory, URI uri) {
        try {
            if (this.fitToViewport) {
                JViewport vp = (JViewport)this.getParent();
                Dimension viewPortSize = vp.getVisibleRect().getSize();
                JComponent viewer = (JComponent)((Object)factory.createViewer(uri, viewPortSize, () -> this.getParent().repaint()));
                this.setBackgroundComponent(viewer);
            } else {
                JComponent viewer = (JComponent)((Object)factory.createViewer(uri, this.zoom, () -> this.getParent().repaint()));
                this.setBackgroundComponent(viewer);
            }
            if (this.backgroundComponent == null) {
                LogUtils.warn("no viewer created for " + uri);
                return;
            }
        }
        catch (FileNotFoundException e1) {
            LogUtils.warn(e1);
        }
        catch (Exception e1) {
            LogUtils.severe(e1);
        }
    }

    private void setBackgroundComponent(JComponent viewer) {
        this.backgroundComponent = viewer;
        this.updateBackground();
    }

    private void updateBackground() {
        MapViewScrollPane.MapViewPort viewport = (MapViewScrollPane.MapViewPort)this.getParent();
        if (viewport != null) {
            if (this.fitToViewport) {
                viewport.setBackground(this.getBackground());
                viewport.setBackgroundComponent(this.backgroundComponent);
                this.setOpaque(this.backgroundComponent != null);
            } else {
                viewport.setBackgroundComponent(null);
                this.setOpaque(true);
            }
        }
        this.setOpaque(!this.fitToViewport || this.backgroundComponent == null);
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        this.updateBackground();
    }

    private void updateIconsRecursively(NodeView node) {
        MainView mainView = node.getMainView();
        if (mainView == null) {
            return;
        }
        mainView.updateIcons(node);
        for (int i = 0; i < node.getComponentCount(); ++i) {
            Component component = node.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            this.updateIconsRecursively((NodeView)component);
        }
    }

    private void updateContentStyle() {
        NodeStyleController style = Controller.getCurrentModeController().getExtension(NodeStyleController.class);
        MapModel map = this.getModel();
        MapStyleModel model = MapStyleModel.getExtension(map);
        NodeModel detailStyleNode = model.getStyleNodeSafe(MapStyleModel.DETAILS_STYLE);
        this.detailFont = UITools.scale(style.getFont(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        this.detailBackground = style.getBackgroundColor(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.detailForeground = style.getColor(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.detailHorizontalAlignment = style.getHorizontalTextAlignment((NodeModel)detailStyleNode, (LogicalStyleController.StyleOption)LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).swingConstant;
        this.detailCss = style.getStyleSheet(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        NodeModel noteStyleNode = model.getStyleNodeSafe(MapStyleModel.NOTE_STYLE);
        this.noteFont = UITools.scale(style.getFont(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        this.noteBackground = style.getBackgroundColor(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.noteForeground = style.getColor(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.noteHorizontalAlignment = style.getHorizontalTextAlignment((NodeModel)noteStyleNode, (LogicalStyleController.StyleOption)LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).swingConstant;
        this.noteCss = style.getStyleSheet(noteStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        this.updateSelectionColors();
    }

    public boolean selectLeft(boolean continious) {
        NodeView selected = this.getSelected();
        NodeView newSelected = this.getVisibleLeft(selected);
        return this.selectRightOrLeft(newSelected, continious);
    }

    private boolean selectRightOrLeft(NodeView newSelected, boolean continious) {
        if (newSelected == null) {
            return false;
        }
        if (continious) {
            if (newSelected.isParentOf(this.getSelected())) {
                this.selectAsTheOnlyOneSelected(newSelected);
                this.addBranchToSelection(newSelected);
            } else {
                this.addBranchToSelection(this.getSelected());
            }
        } else {
            this.selectAsTheOnlyOneSelected(newSelected);
        }
        return true;
    }

    public boolean selectRight(boolean continious) {
        NodeView selected = this.getSelected();
        NodeView newSelected = this.getVisibleRight(selected);
        return this.selectRightOrLeft(newSelected, continious);
    }

    public boolean selectUp(boolean continious) {
        return this.selectSibling(continious, false, false);
    }

    private boolean selectSibling(boolean continious, boolean page, boolean down) {
        NodeView oldSelectionEnd = this.selection.getSelectionEnd();
        if (oldSelectionEnd == null) {
            return false;
        }
        NodeView nextSelected = oldSelectionEnd;
        NodeView nextVisibleSibling = this.getNextVisibleSibling(nextSelected, down);
        if (nextSelected == nextVisibleSibling) {
            return false;
        }
        nextSelected = nextVisibleSibling;
        if (page) {
            NodeView sibling = nextSelected;
            while (true) {
                boolean noNextNodeFound;
                boolean bl = noNextNodeFound = (sibling = this.getNextVisibleSibling(sibling, down)) == nextSelected;
                if (noNextNodeFound || sibling.getParentView() != nextSelected.getParentView() || sibling.isSelected() && sibling.getParentView() != oldSelectionEnd.getParentView()) break;
                nextSelected = sibling;
            }
            if (nextSelected.isSelected() && nextSelected.getParentView() == oldSelectionEnd.getParentView()) {
                nextSelected = this.getNextVisibleSibling(nextSelected, down);
            }
        }
        if (continious) {
            NodeView selectionStart = this.selection.getSelectionStart();
            this.selectAsTheOnlyOneSelected(selectionStart);
            Boolean selectsDown = this.selectsDown(selectionStart, nextSelected);
            if (selectsDown != null) {
                NodeView node = selectionStart;
                do {
                    NodeView nextVisibleSibling2;
                    if (node == (nextVisibleSibling2 = this.getNextVisibleSibling(node, selectsDown))) {
                        this.selectAsTheOnlyOneSelected(nextSelected);
                        LogUtils.severe("Can not select next visible sibling in continious selection, endless loop");
                        break;
                    }
                    node = nextVisibleSibling2;
                    this.addSelected(node, false);
                } while (node != nextSelected);
                this.selection.setSelectionEnd(nextSelected);
                this.mapScroller.scrollNodeToVisible(nextSelected);
            }
        } else {
            this.selectAsTheOnlyOneSelected(nextSelected);
        }
        return true;
    }

    private Boolean selectsDown(NodeView first, NodeView second) {
        if (first == second) {
            return null;
        }
        NodeView node = first;
        for (boolean down : new boolean[]{true, false}) {
            NodeView nextVisibleSibling;
            while (node != (nextVisibleSibling = this.getNextVisibleSibling(node, down))) {
                node = nextVisibleSibling;
                if (node != second) continue;
                return down;
            }
        }
        return null;
    }

    public NodeView getNextVisibleSibling(NodeView node, boolean down) {
        return down ? node.getNextVisibleSibling() : node.getPreviousVisibleSibling();
    }

    public boolean selectDown(boolean continious) {
        return this.selectSibling(continious, false, true);
    }

    public boolean selectPageDown(boolean continious) {
        return this.selectSibling(continious, true, true);
    }

    public boolean selectPageUp(boolean continious) {
        return this.selectSibling(continious, true, false);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isPrinting && this.isPreparedForPrinting) {
            this.isPreparedForPrinting = false;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapView.this.endPrinting();
                    MapView.this.repaint();
                }
            });
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (!this.isPrinting && g2.getRenderingHint(GraphicsHints.CACHE_ICONS) != null) {
                g2.setRenderingHint(GraphicsHints.CACHE_ICONS, Boolean.TRUE);
            }
            Controller.getCurrentController().getMapViewManager().setTextRenderingHint(g2);
            if (this.containsExtension(Connectors.class)) {
                this.hideSingleEndConnectors = false;
                this.showConnectors = SHOW_CONNECTOR_LINES;
                this.paintConnectorsBehind = false;
            } else {
                this.hideSingleEndConnectors = hideSingleEndConnectorsPropertyValue;
                this.showConnectors = showConnectorsPropertyValue;
                this.paintConnectorsBehind = ResourceController.getResourceController().getBooleanProperty("paint_connectors_behind");
            }
            super.paint(g2);
        }
        finally {
            this.paintingMode = null;
            g2.dispose();
        }
    }

    public void paintOverview(Graphics2D g) {
        g.setRenderingHint(GraphicsHints.CACHE_ICONS, Boolean.FALSE);
        this.isPrinting = true;
        this.isPreparedForPrinting = true;
        this.updatePrintedSelectedNodes();
        super.print(g);
        this.isPrinting = false;
        this.updatePrintedSelectedNodes();
        this.isPreparedForPrinting = false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.backgroundComponent != null && !this.fitToViewport) {
            this.paintBackgroundComponent(g);
        }
    }

    private void paintBackgroundComponent(Graphics g) {
        Graphics backgroundGraphics = g.create();
        try {
            this.setBackgroundComponentLocation(backgroundGraphics);
            this.backgroundComponent.paint(backgroundGraphics);
        }
        finally {
            backgroundGraphics.dispose();
        }
    }

    private void setBackgroundComponentLocation(Graphics g) {
        if (!this.fitToViewport) {
            Point centerPoint = this.getRootCenterPoint();
            Point backgroundImageTopLeft = this.getBackgroundImageTopLeft(centerPoint);
            g.translate(backgroundImageTopLeft.x, backgroundImageTopLeft.y);
        }
    }

    private Point getRootCenterPoint() {
        Point centerPoint = new Point(this.getRoot().getMainView().getWidth() / 2, this.getRoot().getMainView().getHeight() / 2);
        UITools.convertPointToAncestor((Component)this.getRoot().getMainView(), centerPoint, this);
        return centerPoint;
    }

    private Point getBackgroundImageTopLeft(Point centerPoint) {
        int x = centerPoint.x - this.backgroundComponent.getWidth() / 2;
        int y = centerPoint.y - this.backgroundComponent.getHeight() / 2;
        return new Point(x, y);
    }

    @Override
    protected void paintChildren(Graphics g) {
        PaintingMode[] paintModes = this.paintConnectorsBehind ? new PaintingMode[]{PaintingMode.CLOUDS, PaintingMode.LINKS, PaintingMode.NODES, PaintingMode.SELECTED_NODES} : new PaintingMode[]{PaintingMode.CLOUDS, PaintingMode.NODES, PaintingMode.SELECTED_NODES, PaintingMode.LINKS};
        Graphics2D g2 = (Graphics2D)g;
        this.paintChildren(g2, paintModes);
        if (this.isSpotlightEnabled()) {
            this.paintDimmer(g2, paintModes);
        }
        this.paintSelecteds(g2);
        this.highlightEditor(g2);
    }

    public boolean isSpotlightEnabled() {
        return Boolean.TRUE == this.getClientProperty(SPOTLIGHT_ENABLED);
    }

    private void paintChildren(Graphics2D g2, PaintingMode[] paintModes) {
        PaintingMode[] paintingModeArray = paintModes;
        int n = paintingModeArray.length;
        block3: for (int i = 0; i < n; ++i) {
            PaintingMode paintingMode;
            this.paintingMode = paintingMode = paintingModeArray[i];
            switch (paintingMode) {
                case LINKS: {
                    if (HIDE_CONNECTORS == this.showConnectors) continue block3;
                    this.paintConnectors(g2);
                    continue block3;
                }
                default: {
                    super.paintChildren(g2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintDimmer(Graphics2D g2, PaintingMode[] paintModes) {
        Color color = g2.getColor();
        try {
            Color dimmer = spotlightBackgroundColor;
            g2.setColor(dimmer);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        finally {
            g2.setColor(color);
        }
        for (NodeView selected : this.getSelection()) {
            this.highlightSelected(g2, selected, paintModes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlightEditor(Graphics2D g2) {
        Component editor = this.getComponent(0);
        if (editor instanceof NodeView) {
            return;
        }
        Shape oldClip = g2.getClip();
        try {
            g2.setClip(editor.getX(), editor.getY(), editor.getWidth(), editor.getHeight());
            super.paintChildren(g2);
        }
        finally {
            g2.setClip(oldClip);
        }
    }

    protected PaintingMode getPaintingMode() {
        return this.paintingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintConnectors(Collection<? extends NodeLinkModel> links, Graphics2D graphics, HashSet<ConnectorModel> alreadyPaintedLinks) {
        Font font = graphics.getFont();
        try {
            for (NodeLinkModel nodeLinkModel : links) {
                AConnectorView arrowLink;
                NodeModel target;
                ConnectorModel ref;
                if (!(nodeLinkModel instanceof ConnectorModel) || !alreadyPaintedLinks.add(ref = (ConnectorModel)nodeLinkModel) || (target = ref.getTarget()) == null) continue;
                NodeModel source = ref.getSource();
                NodeView sourceView = this.getDisplayedNodeView(source);
                NodeView targetView = this.getDisplayedNodeView(target);
                boolean areBothNodesVisible = sourceView != null && targetView != null && source.hasVisibleContent(this.filter) && target.hasVisibleContent(this.filter);
                boolean showConnector = SHOW_CONNECTOR_LINES == this.showConnectors || HIDE_CONNECTOR_LINES == this.showConnectors || SHOW_CONNECTORS_FOR_SELECTION == this.showConnectors && (sourceView != null && sourceView.isSelected() || targetView != null && targetView.isSelected());
                if (!showConnector) continue;
                LinkController linkController = LinkController.getController(this.getModeController());
                if (areBothNodesVisible && (ConnectorShape.EDGE_LIKE.equals(linkController.getShape(ref)) && !ref.isSelfLink() || sourceView.getMap().getLayoutType() == MapViewLayout.OUTLINE)) {
                    arrowLink = new EdgeLinkView(ref, this.getModeController(), sourceView, targetView);
                } else {
                    if (!areBothNodesVisible && this.hideSingleEndConnectors) break;
                    arrowLink = new ConnectorView(ref, sourceView, targetView, this.getBackground());
                }
                arrowLink.paint(graphics);
                this.arrowLinkViews.add(arrowLink);
            }
        }
        finally {
            graphics.setFont(font);
        }
    }

    private void paintConnectors(Graphics2D graphics) {
        this.arrowLinkViews = new Vector();
        Object renderingHint = this.getModeController().getController().getMapViewManager().setEdgesRenderingHint(graphics);
        if (this.hasNodeLinks()) {
            this.paintConnectors(this.currentRootView, graphics, new HashSet<ConnectorModel>());
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
    }

    private void paintConnectors(NodeView source, Graphics2D graphics, HashSet<ConnectorModel> alreadyPaintedConnectors) {
        NodeModel node = source.getModel();
        Collection<? extends NodeLinkModel> outLinks = this.getLinksFrom(node);
        this.paintConnectors(outLinks, graphics, alreadyPaintedConnectors);
        Collection<? extends NodeLinkModel> inLinks = this.getLinksTo(node);
        this.paintConnectors(inLinks, graphics, alreadyPaintedConnectors);
        int nodeViewCount = source.getComponentCount();
        for (int i = 0; i < nodeViewCount; ++i) {
            Component component = source.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView child = (NodeView)component;
            if (!this.isPrinting) {
                if (!child.isSubtreeVisible()) continue;
                Rectangle bounds = SwingUtilities.convertRectangle(source, child.getBounds(), this);
                JViewport vp = (JViewport)this.getParent();
                Rectangle viewRect = vp.getViewRect();
                viewRect.x -= viewRect.width;
                viewRect.y -= viewRect.height;
                viewRect.width *= 3;
                viewRect.height *= 3;
                if (!viewRect.intersects(bounds)) continue;
            }
            this.paintConnectors(child, graphics, alreadyPaintedConnectors);
        }
    }

    private boolean hasNodeLinks() {
        return LinkController.getController(this.getModeController()).hasNodeLinks(this.getModel(), this);
    }

    private Collection<? extends NodeLinkModel> getLinksTo(NodeModel node) {
        return LinkController.getController(this.getModeController()).getLinksTo(node, this);
    }

    private Collection<? extends NodeLinkModel> getLinksFrom(NodeModel node) {
        return LinkController.getController(this.getModeController()).getLinksFrom(node, this);
    }

    private void paintSelecteds(Graphics2D g) {
        if (!drawsRectangleForSelection || this.isPrinting()) {
            return;
        }
        Color c = g.getColor();
        Stroke s = g.getStroke();
        g.setColor(MapView.getSelectionRectangleColor());
        g.setStroke(NodeHighlighter.DEFAULT_STROKE);
        Object renderingHint = this.getModeController().getController().getMapViewManager().setEdgesRenderingHint(g);
        for (NodeView selected : this.getSelection()) {
            this.paintSelectionRectangle(g, selected);
        }
        g.setColor(c);
        g.setStroke(s);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
    }

    private void updateSelectionColors() {
        ResourceController resourceController = ResourceController.getResourceController();
        selectionRectangleColor = ColorUtils.stringToColor(resourceController.getProperty(RESOURCES_SELECTED_NODE_RECTANGLE_COLOR));
    }

    private RoundRectangle2D.Float getRoundRectangleAround(NodeView selected, int gap, int arcw) {
        JComponent content = selected.getContent();
        Point contentLocation = new Point();
        UITools.convertPointToAncestor((Component)content, contentLocation, this);
        RoundRectangle2D.Float roundRectClip = new RoundRectangle2D.Float(contentLocation.x - --gap, contentLocation.y - gap, content.getWidth() + 2 * gap, content.getHeight() + 2 * gap, arcw, arcw);
        return roundRectClip;
    }

    private void paintSelectionRectangle(Graphics2D g, NodeView selected) {
        if (Boolean.TRUE.equals(selected.getMainView().getClientProperty(INLINE_EDITOR_ACTIVE))) {
            return;
        }
        RoundRectangle2D.Float roundRectClip = this.getRoundRectangleAround(selected, 4, 15);
        g.draw(roundRectClip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlightSelected(Graphics2D g, NodeView selected, PaintingMode[] paintedModes) {
        RoundRectangle2D.Float highlightClip = drawsRectangleForSelection ? this.getRoundRectangleAround(selected, 4, 15) : this.getRoundRectangleAround(selected, 4, 2);
        Shape oldClip = g.getClip();
        Rectangle oldClipBounds = g.getClipBounds();
        try {
            g.setClip(highlightClip);
            if (oldClipBounds != null) {
                g.clipRect(oldClipBounds.x, oldClipBounds.y, oldClipBounds.width, oldClipBounds.height);
            }
            Rectangle clipBounds = highlightClip.getBounds();
            Color color = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            g.setColor(color);
            this.paintChildren(g, paintedModes);
        }
        finally {
            g.setClip(oldClip);
        }
    }

    public void preparePrinting() {
        this.isPrinting = true;
        if (!this.isPreparedForPrinting) {
            this.isPreparedForPrinting = true;
            this.updatePrintedNodes();
            if (printOnWhiteBackground) {
                this.background = this.getBackground();
                this.setBackground(Color.WHITE);
            }
            this.fitMap = FitMap.valueOf();
            this.boundingRectangle = this.backgroundComponent != null && this.fitMap == FitMap.BACKGROUND ? this.getBackgroundImageInnerBounds() : this.getInnerBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrintedNodes() {
        if (this.zoom == 1.0f) {
            this.getRoot().updateAll();
            Object object = this.getTreeLock();
            synchronized (object) {
                this.validateTree();
            }
        } else {
            this.updatePrintedSelectedNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrintedSelectedNodes() {
        if (!drawsRectangleForSelection) {
            this.selection.selectedSet.forEach(NodeView::update);
            Object object = this.getTreeLock();
            synchronized (object) {
                this.validateTree();
            }
        }
    }

    private Rectangle getBackgroundImageInnerBounds() {
        Point centerPoint = this.getRootCenterPoint();
        Point backgroundImageTopLeft = this.getBackgroundImageTopLeft(centerPoint);
        return new Rectangle(backgroundImageTopLeft.x, backgroundImageTopLeft.y, this.backgroundComponent.getWidth(), this.backgroundComponent.getHeight());
    }

    @Override
    public void print(Graphics g) {
        try {
            this.preparePrinting();
            super.print(g);
        }
        finally {
            this.isPrinting = false;
        }
    }

    public void render(Graphics g1, Rectangle source, Rectangle target) {
        Graphics2D g = (Graphics2D)g1;
        AffineTransform old = g.getTransform();
        double scaleX = (0.0 + (double)target.width) / (double)source.width;
        double scaleY = (0.0 + (double)target.height) / (double)source.height;
        double zoom = scaleX < scaleY ? scaleX : scaleY;
        AffineTransform tr2 = new AffineTransform(old);
        tr2.translate(target.getWidth() / 2.0, target.getHeight() / 2.0);
        tr2.scale(zoom, zoom);
        tr2.translate(-source.getX() - source.getWidth() / 2.0, -source.getY() - source.getHeight() / 2.0);
        g.setTransform(tr2);
        Rectangle clipBounds = g1.getClipBounds();
        g1.clipRect(source.x, source.y, source.width, source.height);
        this.print(g1);
        g.setTransform(old);
        g1.setClip(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double zoomFactor;
        double userZoomFactor = ResourceController.getResourceController().getDoubleProperty("user_zoom", 1.0);
        userZoomFactor = Math.max(0.0, userZoomFactor);
        userZoomFactor = Math.min(2.0, userZoomFactor);
        if ((this.fitMap == FitMap.PAGE || this.fitMap == FitMap.BACKGROUND) && pageIndex > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics.create();
        this.preparePrinting();
        double imageableX = pageFormat.getImageableX();
        double imageableY = pageFormat.getImageableY();
        double imageableWidth = pageFormat.getImageableWidth();
        double imageableHeight = pageFormat.getImageableHeight();
        g2.clipRect((int)imageableX, (int)imageableY, (int)imageableWidth, (int)imageableHeight);
        double mapWidth = this.boundingRectangle.getWidth();
        double mapHeight = this.boundingRectangle.getHeight();
        if (this.fitMap == FitMap.PAGE || this.fitMap == FitMap.BACKGROUND) {
            double zoomFactorX = imageableWidth / mapWidth;
            double zoomFactorY = imageableHeight / mapHeight;
            zoomFactor = Math.min(zoomFactorX, zoomFactorY) * 0.99;
        } else {
            int nrPagesInHeight;
            zoomFactor = this.fitMap == FitMap.WIDTH ? imageableWidth / mapWidth * 0.99 : (this.fitMap == FitMap.HEIGHT ? imageableHeight / mapHeight * 0.99 : userZoomFactor / (double)UITools.FONT_SCALE_FACTOR);
            int nrPagesInWidth = (int)Math.ceil(zoomFactor * mapWidth / imageableWidth);
            if (pageIndex >= nrPagesInWidth * (nrPagesInHeight = (int)Math.ceil(zoomFactor * mapHeight / imageableHeight))) {
                return 1;
            }
            int yPageCoord = (int)Math.floor(pageIndex / nrPagesInWidth);
            int xPageCoord = pageIndex - yPageCoord * nrPagesInWidth;
            g2.translate(-imageableWidth * (double)xPageCoord, -imageableHeight * (double)yPageCoord);
        }
        g2.translate(imageableX, imageableY);
        g2.scale(zoomFactor, zoomFactor);
        double mapX = this.boundingRectangle.getX();
        double mapY = this.boundingRectangle.getY();
        g2.translate(-mapX, -mapY);
        this.print(g2);
        g2.dispose();
        return 0;
    }

    private void repaintSelecteds() {
        this.updateSelectionColors();
        for (NodeView selected : this.getSelection()) {
            this.onSelectionChange(selected);
        }
    }

    private Color requiredBackground() {
        MapStyle mapStyle = this.getModeController().getExtension(MapStyle.class);
        Color mapBackground = mapStyle.getBackground(this.model);
        return mapBackground;
    }

    void revalidateSelecteds() {
        this.selectedsValid = false;
    }

    public void selectAsTheOnlyOneSelected(NodeView newSelected) {
        NodeModel node = newSelected.getModel();
        if (node.isHiddenSummary()) {
            throw new AssertionError((Object)"select invisible node");
        }
        this.selectAsTheOnlyOneSelected(newSelected, true);
        this.setSiblingMaxLevel(newSelected.getModel().getNodeLevel(this.filter));
    }

    public void selectAsTheOnlyOneSelected(NodeView newSelected, boolean requestFocus) {
        if (requestFocus) {
            newSelected.requestFocusInWindow();
        }
        if (ResourceController.getResourceController().getBooleanProperty("center_selected_node")) {
            this.mapScroller.scrollNode(newSelected, ScrollingDirective.SCROLL_NODE_TO_CENTER, ResourceController.getResourceController().getBooleanProperty("slow_scroll_selected_node"));
        } else {
            this.mapScroller.scrollNodeToVisible(newSelected);
        }
        if (this.selection.size() == 1 && this.getSelected().equals(newSelected)) {
            return;
        }
        this.selection.select(newSelected);
        Container selectionParent = newSelected.getParent();
        if (selectionParent instanceof NodeView) {
            ((NodeView)selectionParent).setPreferredChild(newSelected);
        }
    }

    private void addBranchToSelection(NodeView newlySelectedNodeView) {
        if (newlySelectedNodeView.isContentVisible()) {
            this.addSelected(newlySelectedNodeView, false);
        }
        for (NodeView target : newlySelectedNodeView.getChildrenViews()) {
            this.addBranchToSelection(target);
        }
    }

    void selectContinuous(NodeView newSelected) {
        NodeView selectionStart = this.selection.getSelectionStart();
        NodeView selectionEnd = this.selection.getSelectionEnd();
        NodeView parentView = newSelected.getParentView();
        boolean left = newSelected.isLeft();
        if (this.isRoot(newSelected) || selectionStart == null || selectionEnd == null || parentView != selectionStart.getParentView() || parentView != selectionEnd.getParentView() || left != selectionStart.isLeft() || newSelected.isLeft() != selectionEnd.isLeft()) {
            this.selection.setSelectionStart(newSelected);
            if (!newSelected.isSelected()) {
                this.selection.add(newSelected);
            }
            this.mapScroller.scrollNodeToVisible(newSelected);
            return;
        }
        boolean selectionFound = false;
        boolean selectionRequired = false;
        for (NodeView child : parentView.getChildrenViews()) {
            if (child.isLeft() != left) continue;
            boolean onOldSelectionMargin = child == selectionStart || child == selectionEnd;
            boolean selectionFoundNow = !selectionFound && onOldSelectionMargin;
            selectionFound = selectionFound || selectionFoundNow;
            boolean onNewSelectionMargin = child == selectionStart || child == newSelected;
            boolean selectionRequiredNow = !selectionRequired && onNewSelectionMargin;
            boolean bl = selectionRequired = selectionRequired || selectionRequiredNow;
            if (selectionRequired && !selectionFound && child.getModel().hasVisibleContent(this.filter)) {
                this.selection.add(child);
            } else if (!selectionRequired && selectionFound) {
                this.selection.deselect(child);
            }
            if (selectionFound && (selectionStart == selectionEnd || !selectionFoundNow && onOldSelectionMargin)) {
                selectionFound = false;
            }
            if (!selectionRequired || selectionStart != newSelected && (selectionRequiredNow || !onNewSelectionMargin)) continue;
            selectionRequired = false;
        }
        this.selection.setSelectionEnd(newSelected);
        this.mapScroller.scrollNodeToVisible(newSelected);
    }

    public void setMoveCursor(boolean isHand) {
        int requiredCursor;
        int n = requiredCursor = isHand ? 13 : 0;
        if (this.getCursor().getType() != requiredCursor) {
            this.setCursor(requiredCursor != 0 ? new Cursor(requiredCursor) : null);
        }
    }

    void setSiblingMaxLevel(int level) {
        this.siblingMaxLevel = level;
    }

    public void setZoom(float zoom) {
        if (this.zoom != zoom) {
            this.zoom = zoom;
            this.scrollsViewAfterLayout = true;
            this.mapScroller.anchorToNode(this.getSelected(), 0.5f, 0.5f);
            this.getRoot().updateAll();
            this.adjustBackgroundComponentScale();
        }
    }

    public void setZoom(float zoom, Point keptPoint) {
        if (this.zoom != zoom) {
            this.zoom = zoom;
            NodeView selected = this.getSelected();
            MainView mainView = selected.getMainView();
            float referenceWidth = mainView.getWidth();
            float referenceHeight = mainView.getHeight();
            Point mainViewLocation = new Point();
            UITools.convertPointToAncestor((Component)mainView, mainViewLocation, this);
            float x = referenceWidth > 0.0f ? (float)(keptPoint.x - mainViewLocation.x) / referenceWidth : 0.0f;
            float y = referenceHeight > 0.0f ? (float)(keptPoint.y - mainViewLocation.y) / referenceHeight : 0.0f;
            this.scrollsViewAfterLayout = true;
            this.mapScroller.anchorToNode(selected, x, y);
            this.getRoot().updateAll();
            this.adjustBackgroundComponentScale();
        }
    }

    private void adjustBackgroundComponentScale() {
        if (this.backgroundComponent != null) {
            if (this.fitToViewport) {
                JViewport vp = (JViewport)this.getParent();
                Dimension viewPortSize = vp.getVisibleRect().getSize();
                ((ScalableComponent)((Object)this.backgroundComponent)).setFinalViewerSize(viewPortSize);
            } else {
                ((ScalableComponent)((Object)this.backgroundComponent)).setMaximumComponentSize(this.getPreferredSize());
                ((ScalableComponent)((Object)this.backgroundComponent)).setFinalViewerSize(this.zoom);
            }
            SwingUtilities.invokeLater(this::repaint);
        }
    }

    private void toggleSelected(NodeView nodeView) {
        if (this.isSelected(nodeView)) {
            if (this.selection.size() > 1) {
                this.selection.deselect(nodeView);
            }
        } else {
            this.selection.setSelectionStart(nodeView);
            this.selection.add(nodeView);
            this.mapScroller.scrollNodeToVisible(nodeView);
        }
    }

    private void validateSelecteds() {
        if (this.selectedsValid) {
            return;
        }
        this.selectedsValid = true;
        NodeView selectedView = this.getSelected();
        if (selectedView == null) {
            NodeView root = this.getRoot();
            this.selectAsTheOnlyOneSelected(root);
            this.mapScroller.scrollToRootNode();
            return;
        }
        NodeModel selectedNode = selectedView.getModel();
        ArrayList<NodeView> selectedNodes = new ArrayList<NodeView>(this.getSelection().size());
        for (NodeView nodeView : this.getSelection()) {
            if (nodeView == null) continue;
            selectedNodes.add(nodeView);
        }
        this.selection.clear();
        for (NodeView nodeView : selectedNodes) {
            if (!nodeView.isContentVisible()) continue;
            this.selection.add(nodeView);
        }
        if (this.getSelected() != null) {
            return;
        }
        for (NodeModel node = selectedNode.getParentNode(); node != null; node = node.getParentNode()) {
            NodeView newNodeView = this.getNodeView(node);
            if (newNodeView == null || !newNodeView.isContentVisible()) continue;
            this.selectAsTheOnlyOneSelected(newNodeView);
            return;
        }
        this.selectAsTheOnlyOneSelected(this.getRoot());
    }

    @Override
    protected void validateTree() {
        if (this.isDisplayable()) {
            this.validateSelecteds();
            this.getRoot().validateTree();
            super.validateTree();
        }
    }

    public void repaintVisible() {
        JViewport vp = (JViewport)this.getParent();
        this.repaint(vp.getViewRect());
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals("highlight_formulas")) {
            UITools.repaintAll(this.getRoot());
        }
    }

    public void selectVisibleAncestorOrSelf(NodeView preferred) {
        while (!preferred.getModel().hasVisibleContent(this.filter)) {
            preferred = preferred.getParentView();
        }
        this.selectAsTheOnlyOneSelected(preferred);
    }

    public Font getNoteFont() {
        return this.noteFont;
    }

    public Color getNoteForeground() {
        return this.noteForeground;
    }

    public Color getNoteBackground() {
        return this.noteBackground;
    }

    public NodeCss getDetailCss() {
        return this.detailCss;
    }

    public NodeCss getNoteCss() {
        return this.noteCss;
    }

    public int getNoteHorizontalAlignment() {
        return this.noteHorizontalAlignment;
    }

    public Font getDetailFont() {
        return this.detailFont;
    }

    public Color getDetailForeground() {
        return this.detailForeground;
    }

    public Color getDetailBackground() {
        return this.detailBackground;
    }

    public int getDetailHorizontalAlignment() {
        return this.detailHorizontalAlignment;
    }

    public boolean isSelected() {
        return Controller.getCurrentController().getMapViewManager().getMapViewComponent() == this;
    }

    void selectIfSelectionIsEmpty(NodeView nodeView) {
        if (this.selection.selectedNode == null) {
            this.selectAsTheOnlyOneSelected(nodeView);
        }
    }

    public static MapView getMapView(Component component) {
        if (component instanceof MapView) {
            return (MapView)component;
        }
        return (MapView)SwingUtilities.getAncestorOfClass(MapView.class, component);
    }

    public void select() {
        this.getModeController().getController().getMapViewManager().changeToMapView(this);
    }

    @Override
    public void setSize(int width, int height) {
        boolean sizeChanged;
        boolean bl = sizeChanged = this.getWidth() != width || this.getHeight() != height;
        if (sizeChanged) {
            super.setSize(width, height);
            this.validate();
        }
    }

    void scrollViewAfterLayout() {
        if (this.isDisplayable()) {
            if (this.scrollsViewAfterLayout) {
                this.scrollsViewAfterLayout = false;
                this.mapScroller.scrollView();
            } else {
                this.setAnchorContentLocation();
            }
        }
    }

    public void scrollBy(int x, int y) {
        this.mapScroller.scrollBy(x, y);
    }

    public void scrollNodeToVisible(NodeView node) {
        this.mapScroller.scrollNodeToVisible(node);
    }

    public void setAnchorContentLocation() {
        this.mapScroller.setAnchorContentLocation();
    }

    public void preserveRootNodeLocationOnScreen() {
        this.mapScroller.anchorToRoot();
    }

    public void preserveSelectedNodeLocation() {
        if (this.selectedsValid) {
            this.preserveNodeLocationOnScreen(this.getSelected());
        }
    }

    public void preserveNodeLocationOnScreen(NodeView nodeView) {
        boolean horizontalPoint = nodeView.isLeft();
        this.preserveNodeLocationOnScreen(nodeView, (float)horizontalPoint, 0.0f);
    }

    public void preserveNodeLocationOnScreen(NodeView nodeView, float horizontalPoint, float verticalPoint) {
        this.mapScroller.anchorToNode(nodeView, horizontalPoint, verticalPoint);
    }

    public void display(NodeModel node) {
        NodeView nodeView;
        NodeModel currentRoot = this.currentRootView.getModel();
        if (currentRoot != node && !node.isDescendantOf(currentRoot)) {
            this.restoreRootNode();
        }
        if ((nodeView = this.getNodeView(node)) != null) {
            return;
        }
        NodeModel parentNode = node.getParentNode();
        if (parentNode == null) {
            return;
        }
        this.display(parentNode);
        NodeView parentView = this.getNodeView(parentNode);
        if (parentView == null) {
            return;
        }
        parentView.setFolded(false);
    }

    public boolean showsConnectorLines() {
        return HIDE_CONNECTOR_LINES != this.showConnectors;
    }

    public boolean showsIcons() {
        return showIcons;
    }

    int getLayoutSpecificMaxNodeWidth() {
        return this.usesLayoutSpecificMaxNodeWidth() ? Math.max(0, this.getViewportSize().width - 10 * this.getZoomed(outlineHGap)) : 0;
    }

    public boolean usesLayoutSpecificMaxNodeWidth() {
        return this.isOutlineLayoutSet() && this.outlineViewFitsWindowWidth();
    }

    private boolean outlineViewFitsWindowWidth() {
        return outlineViewFitsWindowWidth;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public static Color getSelectionRectangleColor() {
        return selectionRectangleColor;
    }

    public static boolean drawsRectangleForSelection() {
        return drawsRectangleForSelection;
    }

    public void onEditingStarted(ZoomableLabel label) {
        if (label instanceof MainView) {
            label.putClientProperty(INLINE_EDITOR_ACTIVE, Boolean.TRUE);
            if (drawsRectangleForSelection) {
                this.repaintSelecteds();
            }
        }
    }

    public void onEditingFinished(ZoomableLabel label) {
        if (label instanceof MainView) {
            label.putClientProperty(INLINE_EDITOR_ACTIVE, null);
            if (drawsRectangleForSelection) {
                this.repaintSelecteds();
            }
        }
    }

    boolean allowsCompactLayout() {
        return this.allowsCompactLayout;
    }

    @Override
    public void invalidate() {
        if (!this.currentRootView.isValid() && !this.isPreparedForPrinting) {
            this.scrollsViewAfterLayout = true;
        }
        super.invalidate();
    }

    boolean isRoot(NodeView nodeView) {
        return nodeView == this.currentRootView;
    }

    public void setRootNode(NodeModel node) {
        NodeModel currentRootNode = this.currentRootView.getModel();
        if (currentRootNode == node) {
            return;
        }
        if (!currentRootNode.isRoot() && node.isDescendantOf(currentRootNode)) {
            this.rootsHistory.add(this.currentRootView);
        } else {
            this.rootsHistory.clear();
        }
        NodeView nodeView = this.getNodeView(node);
        this.setRootNode(nodeView);
    }

    public void usePreviousViewRoot() {
        NodeView newRoot = this.rootsHistory.size() == 0 ? this.mapRootView : this.rootsHistory.remove(this.rootsHistory.size() - 1);
        this.setRootNode(newRoot);
    }

    int calculateComponentIndex(Container parent, int index) {
        if (parent == this.currentRootParentView && index >= this.calculateCurrentRootNodePosition()) {
            return index - 1;
        }
        return index;
    }

    private int calculateCurrentRootNodePosition() {
        NodeModel currentRoot = this.currentRootView.getModel();
        NodeModel currentParent = this.currentRootParentView.getModel();
        return currentParent.getIndex(currentRoot);
    }

    void restoreRootNode() {
        this.restoreRootNode(-1, false);
    }

    void restoreRootNodeTemporarily() {
        this.restoreRootNode(-1, true);
    }

    void restoreRootNode(int index) {
        this.restoreRootNode(index, false);
    }

    private void restoreRootNode(int index, boolean temporarily) {
        if (this.currentRootView == this.mapRootView) {
            return;
        }
        this.remove(0);
        this.add((Component)this.mapRootView, 0);
        if (!this.currentRootParentView.isFolded()) {
            this.currentRootParentView.add((Component)this.currentRootView, index >= 0 ? index : this.calculateCurrentRootNodePosition());
        }
        this.currentRootView = this.mapRootView;
        this.currentRootParentView = null;
        if (!temporarily) {
            this.rootsHistory.clear();
        }
    }

    private void setRootNode(NodeView newRootView) {
        if (this.currentRootView == newRootView) {
            return;
        }
        boolean jumpsOut = this.currentRootView.getModel().isDescendantOf(newRootView.getModel());
        if (jumpsOut) {
            this.preserveNodeLocationOnScreen(this.currentRootView, 0.0f, 0.0f);
        } else {
            this.preserveNodeLocationOnScreen(newRootView, 0.0f, 0.0f);
        }
        NodeView lastSelectedNode = jumpsOut ? this.selection.selectedNode : newRootView;
        this.restoreRootNodeTemporarily();
        if (this.currentRootView != newRootView) {
            this.currentRootView = newRootView;
            this.currentRootParentView = newRootView.getParentView();
            this.remove(0);
            this.add((Component)newRootView, 0);
        } else {
            this.rootsHistory.clear();
        }
        if (jumpsOut) {
            lastSelectedNode.requestFocusInWindow();
        } else {
            this.selectAsTheOnlyOneSelected(lastSelectedNode);
        }
        newRootView.setFolded(false);
        this.revalidate();
        this.repaint();
    }

    static {
        HIDE_SINGLE_END_CONNECTORS = "hide_single_end_connectors".intern();
        SHOW_CONNECTORS_PROPERTY = "show_connectors".intern();
        SHOW_CONNECTOR_LINES = "true".intern();
        HIDE_CONNECTOR_LINES = "false".intern();
        HIDE_CONNECTORS = "never".intern();
        SHOW_CONNECTORS_FOR_SELECTION = "for_selection".intern();
        repaintOnClientPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MapView source = (MapView)evt.getSource();
                source.repaint();
            }
        };
        ResourceController resourceController = ResourceController.getResourceController();
        String drawCircle = resourceController.getProperty("standarddrawrectangleforselection");
        drawsRectangleForSelection = TreeXmlReader.xmlToBoolean(drawCircle);
        String printOnWhite = resourceController.getProperty("printonwhitebackground");
        printOnWhiteBackground = TreeXmlReader.xmlToBoolean(printOnWhite);
        int alpha = 255 - resourceController.getIntProperty(PRESENTATION_DIMMER_TRANSPARENCY, 112);
        resourceController.setDefaultProperty(SPOTLIGHT_BACKGROUND_COLOR, ColorUtils.colorToRGBAString(new Color(0, 0, 0, alpha)));
        spotlightBackgroundColor = resourceController.getColorProperty(SPOTLIGHT_BACKGROUND_COLOR);
        hideSingleEndConnectorsPropertyValue = resourceController.getBooleanProperty(HIDE_SINGLE_END_CONNECTORS);
        showConnectorsPropertyValue = resourceController.getProperty(SHOW_CONNECTORS_PROPERTY).intern();
        showIcons = resourceController.getBooleanProperty(SHOW_ICONS_PROPERTY);
        outlineHGap = resourceController.getLengthProperty(OUTLINE_HGAP_PROPERTY);
        outlineViewFitsWindowWidth = resourceController.getBooleanProperty(OUTLINE_VIEW_FITS_WINDOW_WIDTH);
        MapView.createPropertyChangeListener();
    }

    private class Selection {
        private final Set<NodeView> selectedSet = new LinkedHashSet<NodeView>();
        private final List<NodeView> selectedList = new ArrayList<NodeView>();
        private NodeView selectedNode = null;
        private NodeView selectionStart = null;
        private NodeView selectionEnd = null;

        private void select(NodeView node) {
            NodeView[] oldSelecteds = MapView.this.selection.toArray();
            this.clear();
            this.selectedSet.add(node);
            this.selectedList.add(node);
            this.selectedNode = node;
            this.selectionEnd = this.selectionStart = node;
            this.addSelectionForHooks(node);
            MapView.this.onSelectionChange(node);
            for (NodeView oldSelected : oldSelecteds) {
                if (oldSelected == null || oldSelected == node) continue;
                MapView.this.onSelectionChange(oldSelected);
            }
        }

        private boolean add(NodeView node) {
            if (this.selectedNode == null) {
                this.select(node);
                return true;
            }
            if (this.selectedSet.add(node)) {
                this.selectedList.add(node);
                MapView.this.onSelectionChange(node);
                return true;
            }
            return false;
        }

        private void addSelectionForHooks(NodeView node) {
            if (!MapView.this.isSelected()) {
                return;
            }
            ModeController modeController = MapView.this.getModeController();
            MapController mapController = modeController.getMapController();
            NodeModel model = node.getModel();
            mapController.onSelect(model);
        }

        private void clear() {
            if (this.selectedNode != null) {
                this.removeSelectionForHooks(this.selectedNode);
                this.selectedNode = null;
                this.selectedSet.clear();
                this.selectedList.clear();
                this.selectionStart = null;
                this.selectionEnd = null;
            }
        }

        private boolean contains(NodeView node) {
            return this.selectedSet.contains(node);
        }

        public Set<NodeView> getSelection() {
            return Collections.unmodifiableSet(this.selectedSet);
        }

        private boolean deselect(NodeView node) {
            boolean selectedChanged;
            if (this.selectionStart == node) {
                this.selectionStart = null;
                this.selectionEnd = null;
            } else if (this.selectionEnd == node) {
                this.selectionEnd = this.selectionStart;
            }
            boolean bl = selectedChanged = this.selectedNode != null && this.selectedNode.equals(node);
            if (selectedChanged) {
                this.removeSelectionForHooks(node);
            }
            if (this.selectedSet.remove(node)) {
                int last = this.selectedList.size() - 1;
                if (this.selectedList.get(last).equals(node)) {
                    this.selectedList.remove(last);
                } else {
                    this.selectedList.remove(node);
                }
                MapView.this.onSelectionChange(node);
                if (selectedChanged) {
                    if (this.size() > 0) {
                        this.selectedNode = this.selectedSet.iterator().next();
                        this.addSelectionForHooks(this.selectedNode);
                    } else {
                        this.selectedNode = null;
                    }
                }
                return true;
            }
            return false;
        }

        private void removeSelectionForHooks(NodeView node) {
            if (node.getModel() == null || !MapView.this.isSelected()) {
                return;
            }
            MapView.this.getModeController().getMapController().onDeselect(node.getModel());
        }

        private int size() {
            return this.selectedSet.size();
        }

        private void replace(NodeView[] newSelection) {
            boolean selectedChanges;
            if (newSelection.length == 0) {
                return;
            }
            boolean bl = selectedChanges = !newSelection[0].equals(this.selectedNode);
            if (selectedChanges) {
                if (this.selectedNode != null) {
                    this.removeSelectionForHooks(this.selectedNode);
                }
                this.selectedNode = newSelection[0];
            }
            NodeView[] nodesAddedToSelection = (NodeView[])Stream.of(newSelection).filter(view -> !this.selectedSet.contains(view)).toArray(NodeView[]::new);
            NodeView[] oldSelection = this.selectedSet.toArray(new NodeView[this.selectedSet.size()]);
            this.selectedSet.clear();
            this.selectedList.clear();
            for (NodeView view2 : newSelection) {
                if (!this.selectedSet.add(view2)) continue;
                this.selectedList.add(view2);
            }
            if (!this.selectedSet.contains(this.selectionStart)) {
                this.selectionEnd = this.selectionStart = this.selectedNode;
            } else if (!this.selectedSet.contains(this.selectionEnd)) {
                this.selectionEnd = this.selectionStart;
            }
            for (NodeView view2 : nodesAddedToSelection) {
                MapView.this.onSelectionChange(view2);
            }
            if (selectedChanges) {
                this.addSelectionForHooks(this.selectedNode);
            }
            for (NodeView view2 : oldSelection) {
                if (this.selectedSet.contains(view2)) continue;
                MapView.this.onSelectionChange(view2);
            }
        }

        public NodeView[] toArray() {
            return this.selectedList.toArray(new NodeView[this.selectedList.size()]);
        }

        private List<NodeView> getSelectedList() {
            return this.selectedList;
        }

        private Set<NodeView> getSelectedSet() {
            return this.selectedSet;
        }

        public NodeView getSelectionStart() {
            return this.selectionStart;
        }

        public void setSelectionStart(NodeView node) {
            this.selectionEnd = this.selectionStart = node;
        }

        public NodeView getSelectionEnd() {
            return this.selectionEnd;
        }

        public void setSelectionEnd(NodeView selectionEnd) {
            this.selectionEnd = selectionEnd;
        }
    }

    private class MapSelection
    implements IMapSelection {
        private MapSelection() {
        }

        @Override
        public void centerNode(NodeModel node) {
            boolean slowScroll = false;
            this.centerNode(node, false);
        }

        @Override
        public void centerNodeSlowly(NodeModel node) {
            boolean slowScroll = true;
            this.centerNode(node, true);
        }

        private void centerNode(NodeModel node, boolean slowScroll) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.mapScroller.scrollNode(nodeView, ScrollingDirective.SCROLL_NODE_TO_CENTER, slowScroll);
            }
        }

        @Override
        public void moveNodeTo(NodeModel node, IMapSelection.NodePosition position) {
            boolean slowScroll = false;
            this.moveNodeTo(node, position, false);
        }

        @Override
        public void slowlyMoveNodeTo(NodeModel node, IMapSelection.NodePosition position) {
            boolean slowScroll = true;
            this.moveNodeTo(node, position, true);
        }

        private void moveNodeTo(NodeModel node, IMapSelection.NodePosition position, boolean slowScroll) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.mapScroller.scrollNode(nodeView, ScrollingDirective.of(position), slowScroll);
            }
        }

        @Override
        public NodeModel getSelected() {
            NodeView selected = MapView.this.getSelected();
            return selected != null ? selected.getModel() : null;
        }

        @Override
        public NodeModel getSelectionRoot() {
            NodeView root = MapView.this.getRoot();
            return root != null ? root.getModel() : null;
        }

        @Override
        public Set<NodeModel> getSelection() {
            return MapView.this.getSelectedNodes();
        }

        @Override
        public List<NodeModel> getOrderedSelection() {
            return MapView.this.getOrderedSelectedNodes();
        }

        @Override
        public List<NodeModel> getSortedSelection(boolean differentSubtrees) {
            return MapView.this.getSelectedNodesSortedByY(differentSubtrees);
        }

        @Override
        public boolean isSelected(NodeModel node) {
            if (!MapView.this.getModel().equals(node.getMap())) {
                return false;
            }
            NodeView nodeView = MapView.this.getNodeView(node);
            return nodeView != null && MapView.this.isSelected(nodeView);
        }

        @Override
        public void preserveRootNodeLocationOnScreen() {
            MapView.this.preserveRootNodeLocationOnScreen();
        }

        @Override
        public void preserveSelectedNodeLocationOnScreen() {
            MapView.this.preserveSelectedNodeLocation();
        }

        @Override
        public void preserveNodeLocationOnScreen(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            MapView.this.preserveNodeLocationOnScreen(nodeView);
        }

        @Override
        public void preserveNodeLocationOnScreen(NodeModel node, float horizontalPoint, float verticalPoint) {
            NodeView nodeView = MapView.this.getNodeView(node);
            MapView.this.preserveNodeLocationOnScreen(nodeView, horizontalPoint, verticalPoint);
        }

        @Override
        public void scrollNodeTreeToVisible(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.mapScroller.scrollNodeTreeToVisible(nodeView);
            }
        }

        @Override
        public void makeTheSelected(NodeModel node) {
            NodeView nodeView = MapView.this.getNodeView(node);
            if (nodeView != null) {
                MapView.this.addSelected(nodeView, false);
            }
        }

        @Override
        public void scrollNodeToVisible(NodeModel node) {
            MapView.this.mapScroller.scrollNodeToVisible(MapView.this.getNodeView(node));
        }

        @Override
        public void selectAsTheOnlyOneSelected(NodeModel node) {
            NodeView nodeView;
            if (node.isVisible(MapView.this.filter)) {
                MapView.this.display(node);
            }
            if ((nodeView = MapView.this.getNodeView(node)) != null) {
                MapView.this.selectAsTheOnlyOneSelected(nodeView);
            }
        }

        @Override
        public void selectBranch(NodeModel node, boolean extend) {
            if (!extend) {
                this.selectAsTheOnlyOneSelected(node);
            }
            MapView.this.addBranchToSelection(MapView.this.getNodeView(node));
        }

        @Override
        public void selectContinuous(NodeModel node) {
            MapView.this.selectContinuous(MapView.this.getNodeView(node));
        }

        @Override
        public void selectRoot() {
            NodeModel rootNode = MapView.this.currentRootView.getModel();
            this.selectAsTheOnlyOneSelected(rootNode);
            MapView.this.mapScroller.scrollToRootNode();
        }

        @Override
        public void setSiblingMaxLevel(int nodeLevel) {
            MapView.this.setSiblingMaxLevel(nodeLevel);
        }

        @Override
        public int size() {
            return this.getSelection().size();
        }

        @Override
        public void toggleSelected(NodeModel node) {
            MapView.this.display(node);
            MapView.this.toggleSelected(MapView.this.getNodeView(node));
        }

        @Override
        public void replaceSelection(NodeModel[] nodes) {
            if (nodes.length == 0) {
                return;
            }
            ArrayList<NodeView> views = new ArrayList<NodeView>(nodes.length);
            for (NodeModel node : nodes) {
                if (node == null || !node.isVisible(MapView.this.filter)) continue;
                MapView.this.display(node);
                NodeView nodeView = MapView.this.getNodeView(node);
                if (nodeView == null) continue;
                views.add(nodeView);
            }
            if (!views.isEmpty()) {
                MapView.this.replaceSelection(views.toArray(new NodeView[0]));
            }
        }

        @Override
        public List<String> getOrderedSelectionIds() {
            List<NodeModel> orderedSelection = this.getOrderedSelection();
            ArrayList<String> ids = new ArrayList<String>(orderedSelection.size());
            for (NodeModel node : orderedSelection) {
                ids.add(node.getID());
            }
            return ids;
        }

        @Override
        public Filter getFilter() {
            return MapView.this.filter;
        }

        @Override
        public void setFilter(Filter filter) {
            MapView.this.filter = filter;
        }
    }
}

