/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.view.swing.map.Drawable;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;

class FoldingCircle
implements Drawable {
    private static final BasicStroke BORDER_STROKE = new BasicStroke(UITools.FONT_SCALE_FACTOR * 1.0f);
    private final boolean folded;

    public FoldingCircle(boolean folded) {
        this.folded = folded;
    }

    @Override
    public void draw(Graphics2D g, NodeView nodeView, Rectangle r) {
        Color fillColor;
        MainView mainView = nodeView.getMainView();
        Color borderColor = mainView.getFoldingCircleBorderColor();
        Color color = fillColor = this.folded ? borderColor : mainView.getFoldingCircleFillColor();
        if (fillColor.getAlpha() != 255) {
            g.setColor(nodeView.getBackgroundColor());
            g.fillOval(r.x, r.y, r.width, r.height);
        }
        g.setColor(fillColor);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(borderColor);
        float minimumStroke = (float)r.height / 8.0f;
        g.setStroke(minimumStroke > UITools.FONT_SCALE_FACTOR * 1.0f ? new BasicStroke(minimumStroke) : BORDER_STROKE);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

