/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.html.CssRuleBuilder;
import org.freeplane.core.util.HtmlProcessor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.FormatContentTransformer;
import org.freeplane.features.text.HighlightedTransformedObject;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.NodeTextBuilder;
import org.freeplane.features.text.NodeTextConditionController;
import org.freeplane.features.text.SetShortenerStateAction;
import org.freeplane.features.text.ShortenedTextModel;
import org.freeplane.features.text.ToggleDetailsAction;
import org.freeplane.features.text.TransformationException;
import org.freeplane.view.swing.map.MainView;

public class TextController
implements IExtension {
    public static final String CONTENT_TYPE_HTML = "html";
    public static final String CONTENT_TYPE_AUTO = "auto";
    public static final String DETAILS_HIDDEN = "DETAILS_HIDDEN";
    public static final String FILTER_NODE = "filter_node";
    public static final String FILTER_ANYTEXT = "filter_any_text";
    public static final String FILTER_NOTE = "filter_note";
    public static final String FILTER_PARENT_TEXT = "filter_parent_text";
    public static final String FILTER_DETAILS = "filter_details";
    private static final Integer NODE_TOOLTIP = 1;
    private static final Integer DETAILS_TOOLTIP = 2;
    public static final String MARK_TRANSFORMED_TEXT = "highlight_formulas";
    private final List<IContentTransformer> textTransformers = new LinkedList<IContentTransformer>();
    protected final ModeController modeController;
    private boolean nodeNumberingEnabled = true;

    public static boolean isMarkTransformedTextSet() {
        return Controller.getCurrentController().getResourceController().getBooleanProperty(MARK_TRANSFORMED_TEXT);
    }

    public static TextController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return TextController.getController(modeController);
    }

    public static TextController getController(ModeController modeController) {
        return modeController.getExtension(TextController.class);
    }

    public static void install() {
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(5, new NodeTextConditionController());
    }

    public void install(ModeController modeController) {
        modeController.addExtension(TextController.class, this);
    }

    public TextController(ModeController modeController) {
        this.modeController = modeController;
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        NodeTextBuilder textBuilder = new NodeTextBuilder();
        textBuilder.registerBy(readManager, writeManager);
        writeManager.addExtensionElementWriter(DetailModel.class, textBuilder);
        writeManager.addExtensionAttributeWriter(ShortenedTextModel.class, textBuilder);
        modeController.addAction(new ToggleDetailsAction());
        modeController.addAction(new SetShortenerStateAction());
        this.addTextTransformer(new FormatContentTransformer(this, 50));
        this.registerDetailsTooltip();
        this.registerNodeTextTooltip();
    }

    public void addTextTransformer(IContentTransformer textTransformer) {
        this.textTransformers.add(textTransformer);
        Collections.sort(this.textTransformers);
    }

    public List<IContentTransformer> getTextTransformers() {
        return this.textTransformers;
    }

    public void removeTextTransformer(IContentTransformer textTransformer) {
        this.textTransformers.remove(textTransformer);
    }

    public String getText(NodeModel nodeModel) {
        return nodeModel.getText();
    }

    public Object getTransformedObject(NodeModel node, Object nodeProperty, Object content) throws TransformationException {
        return this.getTransformedObject(node, nodeProperty, content, IContentTransformer.Mode.VIEW);
    }

    private Object getTransformedObject(NodeModel node, Object nodeProperty, Object content, IContentTransformer.Mode mode) throws TransformationException {
        String string;
        if (content instanceof String && (string = (String)content).length() > 0 && string.charAt(0) == '\'') {
            if (node != null && nodeProperty == node && this.isTextFormattingDisabled(node)) {
                return string;
            }
            return string.substring(1);
        }
        boolean markTransformation = false;
        for (IContentTransformer textTransformer : this.getTextTransformers()) {
            try {
                Object in = content;
                content = textTransformer.transformContent(node, nodeProperty, in, this, mode);
                markTransformation = markTransformation || textTransformer.markTransformation() && !in.equals(content);
            }
            catch (RuntimeException e) {
                throw new TransformationException(e);
            }
        }
        if (markTransformation) {
            return new HighlightedTransformedObject(content);
        }
        return content;
    }

    public boolean isFormula(Object content) {
        String string;
        if (content instanceof String && (string = (String)content).length() > 0 && string.charAt(0) == '\'') {
            return false;
        }
        for (IContentTransformer textTransformer : this.getTextTransformers()) {
            if (!textTransformer.isFormula(content)) continue;
            return true;
        }
        return false;
    }

    public Icon getIcon(Object object) {
        if (object instanceof HighlightedTransformedObject) {
            return this.getIcon(((HighlightedTransformedObject)object).getObject());
        }
        return object instanceof Icon ? (Icon)object : null;
    }

    public boolean isTextFormattingDisabled(NodeModel nodeModel) {
        return "NO_FORMAT".equals(this.getNodeFormat(nodeModel));
    }

    public Object getTransformedObjectNoFormattingNoThrow(NodeModel node, Object nodeProperty, Object data) {
        return this.getTransformedObjectNoFormattingNoThrow(node, nodeProperty, data, IContentTransformer.Mode.VIEW);
    }

    private Object getTransformedObjectNoFormattingNoThrow(NodeModel node, Object nodeProperty, Object data, IContentTransformer.Mode mode) {
        try {
            Object transformedObject = this.getTransformedObject(node, nodeProperty, data, mode);
            if (transformedObject instanceof HighlightedTransformedObject) {
                transformedObject = ((HighlightedTransformedObject)transformedObject).getObject();
            }
            if (transformedObject instanceof IFormattedObject) {
                transformedObject = ((IFormattedObject)transformedObject).getObject();
            }
            return transformedObject;
        }
        catch (Throwable e) {
            LogUtils.warn(e.getMessage());
            return TextUtils.format("MainView.errorUpdateText", data, e.getLocalizedMessage());
        }
    }

    public Object getTransformedObject(NodeModel node) throws TransformationException {
        Object userObject = node.getUserObject();
        return this.getTransformedObject(node, node, userObject);
    }

    public Object getTransformedObjectNoThrow(NodeModel node) {
        Object userObject = node.getUserObject();
        return this.getTransformedObjectNoFormattingNoThrow(node, node, userObject);
    }

    public String getTransformedText(NodeModel node, Object nodeProperty, Object data) throws TransformationException {
        Object transformed = this.getTransformedObject(node, nodeProperty, data);
        if (transformed instanceof Icon) {
            return data.toString();
        }
        return transformed.toString();
    }

    public String getTransformedTextNoThrow(NodeModel node, Object nodeProperty, Object data) {
        Object result = this.getTransformedObjectNoFormattingNoThrow(node, nodeProperty, data);
        return result.toString();
    }

    public String getTransformedTextForClipboard(NodeModel node, Object nodeProperty, Object data) {
        return this.getTransformedObjectNoFormattingNoThrow(node, nodeProperty, data, IContentTransformer.Mode.TEXT).toString();
    }

    public boolean isMinimized(NodeModel node) {
        ShortenedTextModel shortened = ShortenedTextModel.getShortenedTextModel(node);
        return shortened != null;
    }

    public String getPlainTransformedText(NodeModel nodeModel) {
        return HtmlUtils.htmlToPlain(this.getTransformedTextNoThrow(nodeModel));
    }

    public String getPlainTransformedTextWithoutNodeNumber(NodeModel node) {
        return this.withNodeNumbering(false, () -> this.getPlainTransformedText(node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withNodeNumbering(boolean isEnabled, Supplier<T> supplier) {
        boolean nodeNumberingWasEnabled = this.nodeNumberingEnabled;
        this.nodeNumberingEnabled = isEnabled;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.nodeNumberingEnabled = nodeNumberingWasEnabled;
        }
    }

    public String getTransformedTextNoThrow(NodeModel nodeModel) {
        return this.getTransformedTextNoThrow(nodeModel, nodeModel, nodeModel.getUserObject());
    }

    public String getShortPlainText(NodeModel nodeModel, int maximumCharacters, String continuationMark) {
        String adaptedText = this.getPlainTransformedTextWithoutNodeNumber(nodeModel);
        return TextUtils.getShortText(adaptedText, maximumCharacters, continuationMark);
    }

    public String getShortPlainText(NodeModel nodeModel) {
        return this.getShortPlainText(nodeModel, 40, " ...");
    }

    public String getShortText(String longText) {
        boolean isHtml = HtmlUtils.isHtml(longText);
        String text = isHtml ? HtmlUtils.htmlToPlain(longText).trim() : longText;
        int length = text.length();
        int eolPosition = text.indexOf(10);
        int maxShortenedNodeWidth = ResourceController.getResourceController().getIntProperty("max_shortened_text_length");
        if (eolPosition == -1 || eolPosition >= length || eolPosition >= maxShortenedNodeWidth) {
            if (length <= maxShortenedNodeWidth) {
                return longText;
            }
            length = maxShortenedNodeWidth;
        } else {
            length = eolPosition;
        }
        if (isHtml) {
            return new HtmlProcessor(longText).htmlSubstring(0, length);
        }
        return text.substring(0, length);
    }

    public String getDetailsContentType(NodeModel node) {
        Collection<IStyle> collection = LogicalStyleController.getController(this.modeController).getStyles(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        MapStyleModel model = MapStyleModel.getExtension(node.getMap());
        for (IStyle styleKey : collection) {
            String contentType;
            DetailModel details;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (details = DetailModel.getDetail(styleNode)) == null || (contentType = details.getContentType()) == null) continue;
            return contentType;
        }
        return CONTENT_TYPE_HTML;
    }

    public void setDetailsHidden(NodeModel node, boolean isHidden) {
        DetailModel details = DetailModel.createDetailText(node);
        if (isHidden == details.isHidden()) {
            return;
        }
        details.setHidden(isHidden);
        node.addExtension(details);
        NodeChangeEvent nodeChangeEvent = new NodeChangeEvent(node, DETAILS_HIDDEN, !isHidden, isHidden, true, false);
        Controller.getCurrentModeController().getMapController().nodeRefresh(nodeChangeEvent);
    }

    private void registerDetailsTooltip() {
        this.modeController.addToolTipProvider(DETAILS_TOOLTIP, new ITooltipProvider(){

            @Override
            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                return this.getTooltip(modeController, node, (MainView)view);
            }

            private String getTooltip(ModeController modeController, NodeModel node, MainView view) {
                String text;
                DetailModel details = DetailModel.getDetail(node);
                if (details == null || details.getTextOr("").isEmpty() || !details.isHidden() && !ShortenedTextModel.isShortened(node)) {
                    return null;
                }
                NodeStyleController style = modeController.getExtension(NodeStyleController.class);
                MapStyleModel model = MapStyleModel.getExtension(node.getMap());
                NodeModel detailStyleNode = model.getStyleNodeSafe(MapStyleModel.DETAILS_STYLE);
                Font detailFont = style.getFont(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
                Color detailBackground = style.getBackgroundColor(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
                Color detailForeground = style.getColor(detailStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
                int alignment = style.getHorizontalTextAlignment((NodeModel)detailStyleNode, (LogicalStyleController.StyleOption)LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).swingConstant;
                float zoom = view.getNodeView().getMap().getZoom();
                StringBuilder htmlBodyStyle = new StringBuilder("<body><div style=\"").append(new CssRuleBuilder().withHTMLFont(detailFont).withColor(detailForeground).withBackground(detailBackground).withAlignment(alignment).withMaxWidthAsPt(zoom, NodeSizeModel.getMaxNodeWidth(detailStyleNode), style.getMaxWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE))).append("\">");
                String data = details.getText();
                try {
                    Object transformed = TextController.getController().getTransformedObjectNoFormattingNoThrow(node, details, data);
                    text = HtmlUtils.objectToHtml(transformed);
                }
                catch (Exception e) {
                    text = TextUtils.format("MainView.errorUpdateText", data, e.getLocalizedMessage());
                }
                if (!HtmlUtils.isHtml(text)) {
                    text = HtmlUtils.plainToHTML(text);
                }
                String tooltipText = text.replaceFirst("<body>", htmlBodyStyle.toString()).replaceFirst("</body>", "</div></body>");
                return tooltipText;
            }
        });
    }

    private void registerNodeTextTooltip() {
        this.modeController.addToolTipProvider(NODE_TOOLTIP, new ITooltipProvider(){

            @Override
            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                return this.getTooltip(modeController, node, (MainView)view);
            }

            private String getTooltip(ModeController modeController, NodeModel node, MainView view) {
                String text;
                if (!ShortenedTextModel.isShortened(node)) {
                    return null;
                }
                NodeStyleController style = modeController.getExtension(NodeStyleController.class);
                Font font = style.getFont(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
                float zoom = view.getNodeView().getMap().getZoom();
                StringBuilder htmlBodyStyle = new StringBuilder("<body><div style=\"").append(new CssRuleBuilder().withHTMLFont(font).withColor(view.getUnselectedForeground()).withBackground(view.getNodeView().getTextBackground()).withAlignment(view.getHorizontalAlignment()).withMaxWidthAsPt(zoom, style.getMaxWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE)));
                Object data = node.getUserObject();
                try {
                    Object transformed = TextController.getController().getTransformedObjectNoFormattingNoThrow(node, node, data);
                    text = HtmlUtils.objectToHtml(transformed);
                    if (text.equals(TextController.this.getShortText(text))) {
                        return null;
                    }
                }
                catch (Exception e) {
                    text = TextUtils.format("MainView.errorUpdateText", data, e.getLocalizedMessage());
                    htmlBodyStyle.append("color:red;");
                }
                htmlBodyStyle.append("\">");
                if (!HtmlUtils.isHtml(text)) {
                    text = HtmlUtils.plainToHTML(text);
                }
                String tooltipText = text.replaceFirst("<body>", htmlBodyStyle.toString()).replaceFirst("</body>", "</div></body>");
                return tooltipText;
            }
        });
    }

    public void setIsMinimized(NodeModel node, boolean shortened) {
        boolean oldState;
        boolean bl = oldState = ShortenedTextModel.getShortenedTextModel(node) != null;
        if (oldState == shortened) {
            return;
        }
        if (shortened) {
            ShortenedTextModel.createShortenedTextModel(node);
        } else {
            node.removeExtension(ShortenedTextModel.class);
        }
        Controller.getCurrentModeController().getMapController().nodeChanged(node, "SHORTENER", oldState, shortened);
    }

    public boolean parseData() {
        return false;
    }

    public String getNodeFormat(NodeModel node) {
        return this.modeController.getExtension(NodeStyleController.class).getNodeFormat(node);
    }

    public boolean getNodeNumbering(NodeModel node) {
        return this.nodeNumberingEnabled && this.modeController.getExtension(NodeStyleController.class).getNodeNumbering(node);
    }

    public ModeController getModeController() {
        return this.modeController;
    }

    public boolean canEdit() {
        return false;
    }

    public Hyperlink toLink(Object value, NodeModel node, Object extension) {
        if (value instanceof Hyperlink) {
            return (Hyperlink)value;
        }
        Object transformedObject = this.getTransformedObjectNoFormattingNoThrow(node, extension, value);
        return this.modeController.getExtension(LinkController.class).toLink(node, transformedObject);
    }
}

