/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation;

import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.NodeModel;

public class LocationModel
implements IExtension {
    public static final Quantity<LengthUnit> DEFAULT_HGAP = new Quantity(14.0, (Enum)LengthUnit.pt);
    public static final int DEFAULT_HGAP_PX = DEFAULT_HGAP.toBaseUnitsRounded();
    public static Quantity<LengthUnit> DEFAULT_SHIFT_Y = new Quantity(0.0, (Enum)LengthUnit.pt);
    public static Quantity<LengthUnit> DEFAULT_VGAP = new Quantity(2.0, (Enum)LengthUnit.pt);
    public static final LocationModel NULL_LOCATION = new LocationModel(){

        @Override
        public void setHGap(Quantity<LengthUnit> gap) {
            if (gap != this.getHGap()) {
                throw new NoSuchMethodError();
            }
        }

        @Override
        public void setShiftY(Quantity<LengthUnit> shiftY) {
            if (shiftY != this.getShiftY()) {
                throw new NoSuchMethodError();
            }
        }

        @Override
        public void setVGap(Quantity<LengthUnit> gap) {
            if (gap != this.getVGap()) {
                throw new NoSuchMethodError();
            }
        }
    };
    private Quantity<LengthUnit> hGap = DEFAULT_HGAP;
    private Quantity<LengthUnit> shiftY = DEFAULT_SHIFT_Y;
    private Quantity<LengthUnit> vGap = DEFAULT_VGAP;

    public static LocationModel createLocationModel(NodeModel node) {
        LocationModel location = node.getExtension(LocationModel.class);
        if (location == null) {
            location = new LocationModel();
            node.addExtension(location);
        }
        return location;
    }

    public static LocationModel getModel(NodeModel node) {
        LocationModel location = node.getExtension(LocationModel.class);
        return location != null ? location : NULL_LOCATION;
    }

    public Quantity<LengthUnit> getHGap() {
        return this.hGap;
    }

    public Quantity<LengthUnit> getShiftY() {
        return this.shiftY;
    }

    public Quantity<LengthUnit> getVGap() {
        return this.vGap;
    }

    public void setHGap(Quantity<LengthUnit> gap) {
        this.assertNotNull(gap);
        this.hGap = gap;
    }

    private void assertNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public void setShiftY(Quantity<LengthUnit> shiftY) {
        this.assertNotNull(shiftY);
        this.shiftY = shiftY;
    }

    public void setVGap(Quantity<LengthUnit> gap) {
        this.assertNotNull(gap);
        this.vGap = gap.toBaseUnits() >= 0.0 ? gap : new Quantity(0.0, (Enum)((LengthUnit)gap.unit));
    }
}

