/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation;

import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IExtensionAttributeWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodelocation.LocationModel;

class LocationBuilder
implements IExtensionAttributeWriter {
    LocationBuilder() {
    }

    private void registerAttributeHandlers(ReadManager reader) {
        IAttributeHandler vShiftHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LocationModel.createLocationModel(node).setShiftY((Quantity<LengthUnit>)Quantity.fromString((String)value, (Enum)LengthUnit.px));
            }
        };
        reader.addAttributeHandler("node", "VSHIFT", vShiftHandler);
        reader.addAttributeHandler("node", "VSHIFT_QUANTITY", vShiftHandler);
        IAttributeHandler vgapHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LocationModel.createLocationModel(node).setVGap((Quantity<LengthUnit>)Quantity.fromString((String)value, (Enum)LengthUnit.px));
            }
        };
        reader.addAttributeHandler("node", "VGAP", vgapHandler);
        reader.addAttributeHandler("node", "VGAP_QUANTITY", vgapHandler);
        reader.addAttributeHandler("stylenode", "VGAP", vgapHandler);
        reader.addAttributeHandler("stylenode", "VGAP_QUANTITY", vgapHandler);
        IAttributeHandler hgapHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LocationModel.createLocationModel(node).setHGap((Quantity<LengthUnit>)Quantity.fromString((String)value, (Enum)LengthUnit.px));
            }
        };
        reader.addAttributeHandler("node", "HGAP_QUANTITY", hgapHandler);
        reader.addAttributeHandler("node", "HGAP", hgapHandler);
    }

    void registerBy(ReadManager readManager, WriteManager writeManager) {
        this.registerAttributeHandlers(readManager);
        writeManager.addExtensionAttributeWriter(LocationModel.class, this);
    }

    @Override
    public void writeAttributes(ITreeWriter writer, Object userObject, IExtension extension) {
        Quantity<LengthUnit> shiftY;
        LocationModel locationModel = (LocationModel)extension;
        Quantity<LengthUnit> vGap = locationModel.getVGap();
        if (vGap != LocationModel.DEFAULT_VGAP) {
            writer.addAttribute("VGAP_QUANTITY", vGap.toString());
        }
        Quantity<LengthUnit> hGap = locationModel.getHGap();
        if (locationModel.getHGap() != LocationModel.DEFAULT_HGAP) {
            writer.addAttribute("HGAP_QUANTITY", hGap.toString());
        }
        if ((shiftY = locationModel.getShiftY()) != LocationModel.DEFAULT_SHIFT_Y) {
            writer.addAttribute("VSHIFT_QUANTITY", shiftY.toString());
        }
    }
}

