/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.clipboard;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.clipboard.ClipboardAccessor;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeDuplicator;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.CopyIDAction;
import org.freeplane.features.map.clipboard.CopyNodeURIAction;
import org.freeplane.features.map.clipboard.CopySingleAction;
import org.freeplane.features.map.clipboard.MindMapHTMLWriter;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.clipboard.SingleCopySource;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.TextController;

public class MapClipboardController
implements IExtension,
ClipboardController,
INodeDuplicator {
    public static final String NODESEPARATOR = "<nodeseparator>";
    private final ModeController modeController;

    public static MapClipboardController getController() {
        return Controller.getCurrentModeController().getExtension(MapClipboardController.class);
    }

    public static void install(MapClipboardController clipboardController) {
        Controller.getCurrentModeController().addExtension(MapClipboardController.class, clipboardController);
    }

    public MapClipboardController(ModeController modeController) {
        this.modeController = modeController;
        this.createActions();
    }

    public void setClipboardContents(Transferable transferable) {
        ClipboardAccessor.getInstance().setClipboardContents(transferable);
    }

    public MindMapNodesSelection copy(Collection<NodeModel> selectedNodes) {
        try {
            String forNodesFlavor = this.createForNodesFlavor(selectedNodes);
            String plainText = this.getAsPlainText(selectedNodes);
            return new MindMapNodesSelection(forNodesFlavor, plainText, this.getAsHTML(selectedNodes));
        }
        catch (UnsupportedFlavorException ex) {
            LogUtils.severe(ex);
        }
        catch (IOException ex) {
            LogUtils.severe(ex);
        }
        return null;
    }

    public Transferable copy(IMapSelection selection) {
        return this.copy(selection.getSortedSelection(true));
    }

    public Transferable copy(NodeModel node) {
        StringWriter stringWriter = new StringWriter();
        try {
            Controller.getCurrentModeController().getMapController().getMapWriter().writeNodeAsXml(stringWriter, node, MapWriter.Mode.CLIPBOARD, true, true, false);
        }
        catch (IOException e) {
            LogUtils.severe(e);
        }
        return new MindMapNodesSelection(stringWriter.toString());
    }

    public Transferable copySingle(Collection<NodeModel> source) {
        int size = source.size();
        Vector<NodeModel> target = new Vector<NodeModel>(size);
        target.setSize(size);
        int i = 0;
        for (NodeModel node : source) {
            target.set(i, new SingleCopySource(node));
            ++i;
        }
        return this.copy(target);
    }

    private void createActions() {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        modeController.addAction(new CopySingleAction());
        if (!Compat.isApplet()) {
            modeController.addAction(new CopyIDAction());
        }
        modeController.addAction(new CopyNodeURIAction());
    }

    public String createForNodesFlavor(Collection<NodeModel> selectedNodes) throws UnsupportedFlavorException, IOException {
        String forNodesFlavor = "";
        boolean firstLoop = true;
        for (NodeModel tmpNode : selectedNodes) {
            if (firstLoop) {
                firstLoop = false;
            } else {
                forNodesFlavor = forNodesFlavor + NODESEPARATOR;
            }
            forNodesFlavor = forNodesFlavor + this.copy(tmpNode).getTransferData(MindMapNodesSelection.mindMapNodesFlavor);
        }
        return forNodesFlavor;
    }

    public String getAsHTML(Collection<NodeModel> selectedNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            try (BufferedWriter fileout = new BufferedWriter(stringWriter);){
                this.writeHTML(selectedNodes, fileout);
            }
            return stringWriter.toString();
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    public String getAsPlainText(Collection<NodeModel> selectedNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            try (BufferedWriter fileout = new BufferedWriter(stringWriter);){
                Iterator<NodeModel> it = selectedNodes.iterator();
                while (it.hasNext()) {
                    this.writeTXT(it.next(), fileout, 0);
                }
            }
            return stringWriter.toString();
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    public void saveHTML(NodeModel rootNodeOfBranch, File file) throws IOException {
        this.saveHTML(Collections.singletonList(rootNodeOfBranch), file);
    }

    public void saveHTML(List<NodeModel> branchRootNodes, File file) throws IOException {
        BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        MindMapHTMLWriter htmlWriter = new MindMapHTMLWriter(Controller.getCurrentModeController().getMapController(), fileout);
        htmlWriter.configureCharset("UTF-8");
        htmlWriter.writeHTML(branchRootNodes);
    }

    public boolean saveTXT(NodeModel rootNodeOfBranch, File file) {
        boolean bl;
        BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        try {
            this.writeTXT(rootNodeOfBranch, fileout, 0);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LogUtils.severe("Error in MindMapMapModel.saveTXT(): ", e);
                return false;
            }
        }
        fileout.close();
        return bl;
    }

    @Override
    public NodeModel duplicate(NodeModel source, MapModel targetMap, boolean withChildren) {
        try {
            StringWriter writer = new StringWriter();
            MapWriter.Mode copyMode = source.getUserObject() instanceof IStyle ? MapWriter.Mode.STYLE : MapWriter.Mode.CLIPBOARD;
            this.modeController.getMapController().getMapWriter().writeNodeAsXml(writer, source, copyMode, true, withChildren, false);
            String result = writer.toString();
            NodeModel copy = this.modeController.getMapController().getMapReader().createNodeTreeFromXml(targetMap, (Reader)new StringReader(result), copyMode);
            copy.setFolded(false);
            return copy;
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    private void writeChildrenText(NodeModel node, Writer fileout, int depth, String indentation) throws IOException {
        for (NodeModel child : node.getChildren()) {
            if (child.hasVisibleContent(FilterController.getFilter(node.getMap()))) {
                this.writeTXT(child, fileout, depth + 1, indentation);
                continue;
            }
            this.writeChildrenText(child, fileout, depth, indentation);
        }
    }

    public void writeHTML(Collection<NodeModel> selectedNodes, Writer fileout) throws IOException {
        MindMapHTMLWriter htmlWriter = new MindMapHTMLWriter(Controller.getCurrentModeController().getMapController(), fileout);
        htmlWriter.writeHTML(selectedNodes);
    }

    public void writeTXT(NodeModel mindMapNodeModel, Writer fileout, int depth) throws IOException {
        boolean indentTextOutput = ResourceController.getResourceController().getBooleanProperty("indentTextOutput");
        boolean indentationUsesTabsInTextOutput = ResourceController.getResourceController().getBooleanProperty("indentationUsesTabsInTextOutput");
        String indentation = indentTextOutput ? (indentationUsesTabsInTextOutput ? "\t" : "    ") : "";
        this.writeTXT(mindMapNodeModel, fileout, depth, indentation);
    }

    private void writeTXT(NodeModel node, Writer fileout, int depth, String indentation) throws IOException {
        String noteText;
        String detailText;
        String link;
        String core = this.getTransformedTextForClipboard(node, node, node.getUserObject());
        this.writeMultilineTXT(fileout, depth, indentation, core);
        if (NodeLinks.getValidLink(node) != null && !core.contains(link = NodeLinks.getLinkAsString(node))) {
            this.writeTXT(fileout, depth, indentation, " <" + link + ">");
        }
        if ((detailText = DetailModel.getDetailText(node)) != null) {
            String details = this.getTransformedTextForClipboard(node, DetailModel.getDetail(node), detailText);
            this.writeMultilineTXT(fileout, depth + 1, indentation, details);
        }
        if ((noteText = NoteModel.getNoteText(node)) != null) {
            String transformedNote = this.getTransformedTextForClipboard(node, NoteModel.getNote(node), noteText);
            this.writeMultilineTXT(fileout, depth + 1, indentation, transformedNote);
        }
        this.writeChildrenText(node, fileout, depth, indentation);
    }

    private void writeMultilineTXT(Writer fileout, int depth, String indentation, String transformedTextForClipboard) throws IOException {
        String[] plainTextContentStrings;
        for (String plainTextContent : plainTextContentStrings = transformedTextForClipboard.split("\\n")) {
            if (plainTextContent.isEmpty()) continue;
            this.writeTXT(fileout, depth, indentation, plainTextContent);
        }
    }

    private void writeTXT(Writer fileout, int depth, String indentation, String plainTextContent) throws IOException {
        if (!indentation.isEmpty()) {
            for (int i = 0; i < depth; ++i) {
                fileout.write(indentation);
            }
        }
        fileout.write(plainTextContent);
        fileout.write("\n");
    }

    private String getTransformedTextForClipboard(NodeModel node, Object nodeProperty, Object content) {
        String text = TextController.getController().getTransformedTextForClipboard(node, nodeProperty, content);
        String plainTextContent = HtmlUtils.htmlToPlain(text);
        return plainTextContent;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public void copy() {
        Transferable copy;
        Controller controller = Controller.getCurrentController();
        IMapSelection selection = controller.getSelection();
        if (selection != null && (copy = this.copy(selection)) != null) {
            ClipboardAccessor.getInstance().setClipboardContents(copy);
        }
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }
}

