/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.icons;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.link.icons.DecorationRuleMatcher;
import org.freeplane.features.link.icons.LinkDecorationRule;
import org.freeplane.features.link.icons.MatcherFactory;

class LinkDecorationConfig {
    private static final int MODIFICATION_CHECK_INTERVAL = 10000;
    private static final int UNKNOWN = -1;
    private static final String LINK_DECORATION_INI = "linkDecoration.ini";
    private URL iniFile = ResourceController.getResourceController().getResource("linkDecoration.ini");
    private List<LinkDecorationRule> rules;
    private long nextCheckTimeMillis = -1L;
    private long lastLoadedConfigurationTime = -1L;
    private long lastKnownConfigurationFileModificationTime = -1L;

    public List<LinkDecorationRule> getRules() {
        if (this.iniFile == null && this.rules == null) {
            this.rules = Collections.emptyList();
        } else if (this.iniFile != null && (this.rules == null || this.rulesFileHasChanged())) {
            AccessController.doPrivileged(this::loadRules);
            this.loadRules();
        }
        return this.rules;
    }

    private boolean rulesFileHasChanged() {
        if (this.lastLoadedConfigurationTime == -1L) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis >= this.nextCheckTimeMillis) {
            this.lastKnownConfigurationFileModificationTime = this.lastConfigurationFileModificationTime();
            this.nextCheckTimeMillis = currentTimeMillis + 10000L;
        }
        return this.lastLoadedConfigurationTime < this.lastKnownConfigurationFileModificationTime;
    }

    private Void loadRules() {
        this.rules = new ArrayList<LinkDecorationRule>();
        try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(this.iniFile.openStream()));){
            while (inputStream.ready()) {
                String line = inputStream.readLine().trim();
                if (this.isBlank(line) || this.isComment(line)) continue;
                int descriptionStart = line.lastIndexOf("#");
                int iconNameEnd = descriptionStart == -1 ? line.length() : descriptionStart;
                int specificationEnd = line.lastIndexOf("|", iconNameEnd);
                if (specificationEnd > 0 && iconNameEnd > specificationEnd) {
                    String matchSpecification = line.substring(0, specificationEnd).trim();
                    String iconName = line.substring(specificationEnd + 1, iconNameEnd).trim();
                    DecorationRuleMatcher matcher = MatcherFactory.INSTANCE.matcherOf(matchSpecification);
                    LinkDecorationRule rule = new LinkDecorationRule(matcher, iconName);
                    this.rules.add(rule);
                    continue;
                }
                LogUtils.warn("Ignore link decoration rule " + line);
            }
            this.lastLoadedConfigurationTime = this.lastConfigurationFileModificationTime();
            Collections.sort(this.rules, Comparator.comparing(LinkDecorationRule::getMaximalScore).reversed());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    private long lastConfigurationFileModificationTime() {
        File file = Compat.urlToFile(this.iniFile);
        return file != null ? file.lastModified() : 0L;
    }

    private boolean isBlank(String line) {
        return line.length() == 0;
    }

    private boolean isComment(String line) {
        return line.startsWith("#");
    }
}

