/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.awt.event.InputEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.svgicons.FreeplaneIconFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.commandsearch.ItemChecker;
import org.freeplane.features.commandsearch.SearchItem;
import org.freeplane.features.commandsearch.ShowPreferenceItemAction;

public class PreferencesItem
extends SearchItem {
    private static final ImageIcon PREFERENCES_ICON = FreeplaneIconFactory.toImageIcon(ResourceController.getResourceController().getIcon("ShowPreferencesAction.icon"));
    private static final String PREFERENCES_PATH = TextUtils.getText("ShowPreferencesAction.text") + "->";
    private final String tab;
    private final String key;
    private final String displayedText;
    private final String searchedText;
    private final String tooltip;

    PreferencesItem(String tab, String key, String path, String tooltip) {
        this.tab = tab;
        this.key = key;
        this.displayedText = tab + "->" + path;
        this.searchedText = PreferencesItem.normalizeText(path);
        this.tooltip = tooltip;
    }

    @Override
    int getItemTypeRank() {
        return 1;
    }

    @Override
    public String getComparedText() {
        return this.displayedText;
    }

    @Override
    public Icon getTypeIcon() {
        return PREFERENCES_ICON;
    }

    @Override
    public String getDisplayedText() {
        return this.displayedText;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    void execute(InputEvent event) {
        new ShowPreferenceItemAction(this).actionPerformed(null);
    }

    @Override
    void assignNewAccelerator() {
    }

    @Override
    boolean shouldUpdateResultList() {
        return false;
    }

    public String toString() {
        return "PreferencesItem [displayedText=" + this.displayedText + "]";
    }

    @Override
    protected boolean checkAndMatch(String searchTerm, ItemChecker textChecker) {
        return textChecker.contains(this.searchedText, searchTerm);
    }

    String getTab() {
        return this.tab;
    }

    String getKey() {
        return this.key;
    }

    @Override
    public String getCopiedText() {
        return PREFERENCES_PATH + this.getDisplayedText();
    }
}

