/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import org.freeplane.core.resources.ResourceBundles;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.clipboard.ClipboardAccessor;
import org.freeplane.features.format.FormatController;

public class TextUtils {
    private static final String URI_REGEXP = "([a-zA-Z][0-9a-zA-Z+\\-\\.]+:/{0,2}[0-9a-zA-Z;/?:@&=+$\\.\\-_!~*'()%]+)?(#[0-9a-zA-Z;/?:@&=+$\\.\\-_!~*'()%]+)?";
    private static Pattern uriPattern = Pattern.compile("([a-zA-Z][0-9a-zA-Z+\\-\\.]+:/{0,2}[0-9a-zA-Z;/?:@&=+$\\.\\-_!~*'()%]+)?(#[0-9a-zA-Z;/?:@&=+$\\.\\-_!~*'()%]+)?");

    public static String format(String resourceKey, Object ... messageArguments) {
        Object[] processedArguments;
        MessageFormat formatter;
        String text = TextUtils.getText(resourceKey);
        if (text == null) {
            return null;
        }
        try {
            formatter = new MessageFormat(text);
        }
        catch (IllegalArgumentException e) {
            LogUtils.severe("wrong format " + text + " for property " + resourceKey, e);
            return text;
        }
        if (text.startsWith("<html>")) {
            processedArguments = new String[messageArguments.length];
            int i = 0;
            for (Object s : messageArguments) {
                processedArguments[i++] = HtmlUtils.toHTMLEscapedText(s.toString());
            }
        } else {
            processedArguments = messageArguments;
        }
        return formatter.format(processedArguments);
    }

    public static String getOptionalText(String string) {
        return string == null ? null : TextUtils.getRawText(string);
    }

    public static String getOptionalText(String string, String defaultValue) {
        return string == null ? null : TextUtils.getRawText(string, defaultValue);
    }

    public static String removeMnemonic(String rawLabel) {
        int pos = rawLabel.indexOf(38);
        if (pos == -1) {
            return rawLabel;
        }
        int length = rawLabel.length();
        StringBuilder sb = new StringBuilder(length);
        sb.append(rawLabel.subSequence(0, pos));
        sb.append(rawLabel.subSequence(pos + 1, length));
        return sb.toString();
    }

    public static String removeTranslateComment(String inputString) {
        if (inputString != null && inputString.endsWith("[translate me]")) {
            inputString = inputString.substring(0, inputString.length() - "[translate me]".length());
        }
        return inputString;
    }

    public static TranslatedObject createTranslatedString(String key) {
        String fs = TextUtils.getText(key);
        return new TranslatedObject(key, fs);
    }

    public static String getText(String key) {
        String text = TextUtils.getRawText(key);
        if (text == null) {
            return text;
        }
        return TextUtils.removeMnemonic(text);
    }

    public static String getRawText(String key) {
        if (key == null) {
            return null;
        }
        return TextUtils.getLanguageResources().getResourceString(key);
    }

    public static String getOriginalRawText(String key) {
        if (key == null) {
            return null;
        }
        return TextUtils.getLanguageResources().getOriginalString(key);
    }

    public static String getText(String key, String defaultString) {
        String text = TextUtils.getRawText(key, defaultString);
        if (text == null) {
            return text;
        }
        return TextUtils.removeMnemonic(text);
    }

    public static String getRawText(String key, String defaultString) {
        if (key == null) {
            return defaultString;
        }
        return TextUtils.getLanguageResources().getResourceString(key, defaultString);
    }

    private static ResourceBundles getLanguageResources() {
        return (ResourceBundles)ResourceController.getResourceController().getResources();
    }

    public static String getOptionalTranslation(String text) {
        if (text.startsWith("%")) {
            return TextUtils.getText(text.substring(1));
        }
        return text;
    }

    public static Number toNumber(String text) throws NumberFormatException {
        try {
            return text == null ? null : Long.decode(text);
        }
        catch (NumberFormatException e) {
            if (text.length() == 0 || Character.isWhitespace(text.charAt(0))) {
                throw new NumberFormatException("number '" + text + "' empty or starts with space");
            }
            return Double.valueOf(text);
        }
    }

    public static boolean isNumber(String text) {
        if (TextUtils.isEmpty(text)) {
            return false;
        }
        char first = text.charAt(0);
        if (Character.isLetter(first) || Character.isSpaceChar(first)) {
            return false;
        }
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean matchesUriPattern(String text) {
        return text.length() > 0 && (text.startsWith("file:") || uriPattern.matcher(text).matches());
    }

    public static String getShortText(String text, int maximumCharacters, String continuationMark) {
        if (text.length() > maximumCharacters) {
            text = text.substring(0, maximumCharacters) + continuationMark;
        }
        return text;
    }

    public DecimalFormat getDefaultNumberFormat() {
        return FormatController.getController().getDefaultNumberFormat();
    }

    public SimpleDateFormat getDefaultDateFormat() {
        return FormatController.getController().getDefaultDateFormat();
    }

    public SimpleDateFormat getDefaultDateTimeFormat() {
        return FormatController.getController().getDefaultDateTimeFormat();
    }

    public static String capitalize(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (stringBuilder.length() > 0) {
            stringBuilder.setCharAt(0, Character.toTitleCase(stringBuilder.charAt(0)));
        }
        return stringBuilder.toString();
    }

    public static String replaceAtBegin(String source, String from, String to) {
        if (source != null && source.startsWith(from)) {
            source = to + source.substring(from.length());
        }
        return source;
    }

    public static void copyToClipboard(String string) {
        ClipboardAccessor.getInstance().setClipboardContents(string);
    }

    public static void copyHtmlToClipboard(String html) {
        ClipboardAccessor.getInstance().setClipboardContentsToHtml(html);
    }

    public static String escapeUtf8(String str) {
        return TextUtils.escapeUtf8StyleString(str);
    }

    public static void escapeUtf8(Writer out, String str) throws IOException {
        TextUtils.escapeUtf8StyleString(out, str);
    }

    private static String escapeUtf8StyleString(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            TextUtils.escapeUtf8StyleString(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void escapeUtf8StyleString(Writer out, String str) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.write("\\u" + TextUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.write("\\u0" + TextUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.write("\\u00" + TextUtils.hex(ch));
                continue;
            }
            out.write(ch);
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }
}

