/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.logging.internal.LoggingOutputStream;

public class LogUtils {
    private static final Logger LOGGER = Logger.getLogger("org.freeplane");
    private static final Pattern EXCEPTION_START = Pattern.compile("[\\w.]+?(?:Exception|Error)(?::.*)?");

    public static String getLogDirectory() {
        String logDirectory = ResourceController.getResourceController().getFreeplaneUserDirectory() + File.separatorChar + "logs";
        return logDirectory;
    }

    public static void info(String string) {
        LOGGER.log(Level.INFO, string);
    }

    public static void info(Transferable t) {
        System.out.println();
        System.out.println("BEGIN OF Transferable:\t" + t);
        DataFlavor[] dataFlavors = t.getTransferDataFlavors();
        for (int i = 0; i < dataFlavors.length; ++i) {
            System.out.println("  Flavor:\t" + dataFlavors[i]);
            System.out.println("    Supported:\t" + t.isDataFlavorSupported(dataFlavors[i]));
            try {
                System.out.println("    Content:\t" + t.getTransferData(dataFlavors[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("END OF Transferable");
        System.out.println();
    }

    public static void severe(String message) {
        LOGGER.log(Level.SEVERE, message);
    }

    public static void severe(String comment, Throwable e) {
        if (e instanceof SecurityException || e.getCause() instanceof SecurityException) {
            LogUtils.warn(comment, e);
        } else {
            LOGGER.log(Level.SEVERE, comment, e);
        }
    }

    public static void severe(Throwable e) {
        LogUtils.severe("", e);
    }

    public static void warn(String msg) {
        LOGGER.log(Level.WARNING, msg);
    }

    public static void warn(String comment, Throwable e) {
        LOGGER.log(Level.WARNING, comment, e);
    }

    public static void warn(Throwable e) {
        LogUtils.warn("", e);
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static boolean isLikelyToStartErrorLog(LogRecord record) {
        return record.getLevel() == Level.SEVERE && (!LoggingOutputStream.STREAM_LOGGER_NAME.equals(record.getLoggerName()) || LogUtils.matchesExceptionMessage(record.getMessage()));
    }

    static boolean matchesExceptionMessage(String message) {
        return message != null && EXCEPTION_START.matcher(message).matches();
    }
}

