/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.svgicons;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.core.ui.svgicons.SVGIconCreator;
import org.freeplane.core.util.LogUtils;

public class FixedSizeUIIcon
implements Icon {
    private final int width;
    private final int height;
    private final URL url;
    private Image image;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private boolean failure = false;
    private FixedSizeUIIcon chainedIcon = null;

    public FixedSizeUIIcon(URL url, int width, int height) {
        this.url = url;
        this.width = width;
        this.height = height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.isValid()) {
            if (this.image == null) {
                this.createImage(g);
            }
            if (this.image != null) {
                this.drawImage(c, g, x, y);
            }
        }
    }

    private void drawImage(Component c, Graphics g, int x, int y) {
        Graphics2D gg = (Graphics2D)g;
        AffineTransform transform = gg.getTransform();
        if (this.scaleX != transform.getScaleX() || this.scaleY != transform.getScaleY()) {
            this.chainedIcon().paintIcon(c, g, x, y);
        } else if (this.scaleX == 1.0 && this.scaleY == 1.0) {
            gg.drawImage(this.image, x, y, c);
        } else {
            AffineTransform newTransform = AffineTransform.getTranslateInstance((double)x * transform.getScaleX() + transform.getTranslateX(), (double)y * transform.getScaleY() + transform.getTranslateY());
            gg.setTransform(newTransform);
            gg.drawImage(this.image, 0, 0, c);
            gg.setTransform(transform);
        }
    }

    private Icon chainedIcon() {
        if (this.chainedIcon == null) {
            this.chainedIcon = new FixedSizeUIIcon(this.url, this.width, this.height);
        }
        return this.chainedIcon;
    }

    private boolean isValid() {
        return this.width >= 0 && this.height >= 0 && !this.failure;
    }

    private void createImage(Graphics g) {
        try {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform transform = g2.getTransform();
            this.scaleX = transform.getScaleX();
            this.scaleY = transform.getScaleY();
            int scaledWidth = (int)((double)this.getIconWidth() * this.scaleX);
            int scaledHeight = (int)((double)this.getIconHeight() * this.scaleY);
            if (this.url.getPath().endsWith(".svg")) {
                this.image = new SVGIconCreator(this.url).setHeight(scaledHeight).setWidth(scaledWidth).loadImage();
            } else {
                Image unloadedScaledImage = ImageIO.read(this.url).getScaledInstance(scaledWidth, scaledHeight, 4);
                this.image = new ImageIcon(unloadedScaledImage).getImage();
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
            this.failure = true;
            this.image = null;
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public static FixedSizeUIIcon withHeigth(URL url, int heightInPixel, boolean hasStandardSize) {
        FixedSizeUIIcon fixedSizeUIIcon = new FixedSizeUIIcon(url, heightInPixel, heightInPixel);
        return hasStandardSize ? fixedSizeUIIcon : fixedSizeUIIcon.withProportionalWidth();
    }

    public FixedSizeUIIcon withProportionalWidth() {
        if (!this.isValid()) {
            return this;
        }
        try {
            if (this.url.getPath().endsWith(".svg")) {
                Dimension size = new SVGIconCreator(this.url).getSize();
                return new FixedSizeUIIcon(this.url, this.height * size.width / size.height, this.height);
            }
            BufferedImage image = ImageIO.read(this.url);
            return new FixedSizeUIIcon(this.url, this.height * image.getWidth() / image.getHeight(), this.height);
        }
        catch (Exception e) {
            LogUtils.severe("Can not create icon for URL " + this.url, e);
            this.failure = true;
            return null;
        }
    }
}

