/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.JAutoToggleButton;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;
import org.freeplane.core.ui.menubuilders.menu.ComponentProvider;
import org.freeplane.core.ui.menubuilders.menu.IconReplacer;
import org.freeplane.core.ui.menubuilders.menu.JBigButton;
import org.freeplane.core.ui.menubuilders.menu.JButtonWithDropdownMenu;
import org.freeplane.core.ui.menubuilders.menu.JUnitPanel;
import org.freeplane.core.ui.svgicons.FreeplaneIconFactory;
import org.freeplane.core.ui.textchanger.TranslatedElement;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.factory.IconFactory;

public class ToolbarComponentProvider
implements ComponentProvider {
    private final EntryAccessor entryAccessor;

    public ToolbarComponentProvider(ResourceAccessor resourceAccessor) {
        this.entryAccessor = new EntryAccessor(resourceAccessor);
    }

    @Override
    public Component createComponent(Entry entry) {
        JComponent component;
        Component existingComponent = this.entryAccessor.getComponent(entry);
        if (existingComponent != null) {
            return existingComponent;
        }
        AFreeplaneAction action = this.entryAccessor.getAction(entry);
        if (action != null) {
            AbstractButton actionComponent;
            if (action.isSelectable()) {
                actionComponent = new JAutoToggleButton(action);
                IconReplacer.replaceByImageIcon(entry, actionComponent, this.entryAccessor);
            } else if (entry.builders().contains("bigIcon")) {
                actionComponent = new JBigButton(action);
                Icon icon = actionComponent.getIcon();
                Icon scaledIcon = IconFactory.getInstance().getScaledIcon(icon, (Quantity<LengthUnit>)new Quantity((double)(icon.getIconHeight() * 2), (Enum)LengthUnit.px));
                actionComponent.setIcon(FreeplaneIconFactory.toImageIcon(scaledIcon));
            } else {
                actionComponent = new JButton(action);
                IconReplacer.replaceByImageIcon(entry, actionComponent, this.entryAccessor);
            }
            component = actionComponent;
        } else if (entry.builders().contains("separator")) {
            component = new JToolBar.Separator();
        } else if (entry.builders().contains("panel")) {
            component = new JUnitPanel();
        } else if (entry.builders().contains("dropdownMenu")) {
            String textKey = (String)entry.getAttribute("text");
            String text = textKey != null ? TextUtils.getText(textKey) + "..." : "...";
            String iconKey = (String)entry.getAttribute("icon");
            Icon icon = ResourceController.getResourceController().getIcon(iconKey != null ? iconKey : "arrowDown.icon");
            String tooltipKey = (String)entry.getAttribute("tooltip");
            JButtonWithDropdownMenu buttonWithMenu = new JButtonWithDropdownMenu(text, icon);
            IconReplacer.replaceByScaledImageIcon(buttonWithMenu);
            if (textKey != null) {
                TranslatedElement.TEXT.setKey(buttonWithMenu, textKey);
            }
            TranslatedElementFactory.createTooltip(buttonWithMenu, tooltipKey);
            entry.children().stream().map(this.entryAccessor::getAction).filter(x -> x != null).forEach(buttonWithMenu::addMenuAction);
            component = buttonWithMenu;
        } else {
            component = null;
        }
        return component;
    }
}

