/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.html;

import javax.swing.SizeRequirements;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.ParagraphView;
import org.freeplane.core.ui.components.html.ScaledEditorKit;

public class SynchronousScaledEditorKit
extends ScaledEditorKit {
    private static ViewFactory synchronousFactory;
    private static ScaledEditorKit kit;

    public static ScaledEditorKit create() {
        if (kit == null) {
            synchronousFactory = new HTMLEditorKit.HTMLFactory(){

                @Override
                public View create(final Element elem) {
                    View view = super.create(elem);
                    if (elem.getName().equals("br")) {
                        return view;
                    }
                    if (view instanceof InlineView) {
                        return new InlineView(elem){

                            @Override
                            public View breakView(int axis, int p0, float pos, float len) {
                                View fragment = super.breakView(axis, p0, pos, len);
                                if (this != fragment) {
                                    return fragment;
                                }
                                if (axis == 0) {
                                    this.checkPainter();
                                    int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
                                    if (p0 == this.getStartOffset() && p1 == this.getEndOffset()) {
                                        return this;
                                    }
                                    return this.createFragment(p0, p1);
                                }
                                return this;
                            }
                        };
                    }
                    if (view instanceof ParagraphView) {
                        return new ParagraphView(elem){

                            @Override
                            protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
                                if (this.isContainedInTableCell(elem)) {
                                    return super.calculateMinorAxisRequirements(axis, r);
                                }
                                if (r == null) {
                                    r = new SizeRequirements();
                                }
                                float pref = this.layoutPool.getPreferredSpan(axis);
                                float min = this.layoutPool.getMinimumSpan(axis);
                                r.minimum = (int)min;
                                r.preferred = Math.max(r.minimum, (int)pref);
                                r.maximum = Integer.MAX_VALUE;
                                r.alignment = 0.5f;
                                return r;
                            }

                            private boolean isContainedInTableCell(Element elem2) {
                                Element parentElement = elem2.getParentElement();
                                if (parentElement == null) {
                                    return false;
                                }
                                String name = parentElement.getName();
                                return name.equals("td") || name.equals("th");
                            }
                        };
                    }
                    if (view instanceof ImageView) {
                        ((ImageView)view).setLoadsSynchronously(true);
                    }
                    return view;
                }
            };
            kit = new SynchronousScaledEditorKit();
        }
        return kit;
    }

    @Override
    public ViewFactory getViewFactory() {
        return synchronousFactory;
    }
}

