/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.calendar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.freeplane.core.ui.components.calendar.JCalendar;
import org.freeplane.core.ui.components.calendar.JDayChooser;
import org.freeplane.core.ui.components.calendar.JMonthChooser;
import org.freeplane.core.ui.components.calendar.JYearChooser;

public class JTripleCalendar
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private final JCalendar calendarWidget;
    private final JInfoPanel leftPanel;
    private final JInfoPanel rightPanel;

    public static void main(String[] args) {
        JFrame frame = new JFrame("JTripleCalendar");
        frame.setDefaultCloseOperation(2);
        JTripleCalendar jcalendar = new JTripleCalendar(Locale.getDefault());
        frame.getContentPane().add(jcalendar);
        frame.pack();
        frame.setVisible(true);
    }

    public JTripleCalendar(Locale locale) {
        this.setName("JTripleCalendar");
        GridLayout gridLayout = new GridLayout(1, 3);
        gridLayout.setVgap(10);
        this.setLayout(gridLayout);
        this.leftPanel = this.createInfoPanel();
        this.rightPanel = this.createInfoPanel();
        this.add(this.leftPanel);
        this.calendarWidget = new JCalendar(locale);
        this.calendarWidget.addPropertyChangeListener(this);
        this.add(this.calendarWidget);
        this.add(this.rightPanel);
    }

    private JInfoPanel createInfoPanel() {
        JInfoPanel panel = new JInfoPanel();
        return panel;
    }

    public JCalendar getCalendar() {
        return this.calendarWidget;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Calendar gregorianCalendar = (Calendar)this.calendarWidget.getCalendar().clone();
        gregorianCalendar.add(2, -1);
        this.leftPanel.setDate(gregorianCalendar);
        gregorianCalendar.add(2, 2);
        this.rightPanel.setDate(gregorianCalendar);
    }

    public void setCalendar(Calendar c) {
        this.calendarWidget.setCalendar(c);
    }

    public void setDate(Date date) {
        this.calendarWidget.setDate(date);
    }

    private static class JInfoPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JDayChooser dayChooser;
        private final JMonthChooser monthChooser;
        private final JYearChooser yearChooser;

        public JInfoPanel() {
            this.setLayout(new BorderLayout());
            JPanel monthYearPanel = new JPanel();
            monthYearPanel.setLayout(new BorderLayout());
            this.monthChooser = new JMonthChooser();
            this.monthChooser.setEnabled(false);
            this.yearChooser = new JYearChooser();
            this.yearChooser.setEnabled(false);
            monthYearPanel.add((Component)this.monthChooser, "West");
            monthYearPanel.add((Component)this.yearChooser, "Center");
            this.dayChooser = new JDayChooser(true){
                private static final long serialVersionUID = 1L;

                @Override
                protected void init() {
                    super.init();
                    this.selectedColor = this.oldDayBackgroundColor;
                }
            };
            this.dayChooser.setEnabled(false);
            this.add((Component)monthYearPanel, "North");
            this.add((Component)this.dayChooser, "Center");
        }

        public void setDate(Calendar calendar) {
            int year = calendar.get(1);
            int month = calendar.get(2);
            this.monthChooser.setMonth(month);
            this.yearChooser.setYear(year);
            this.dayChooser.setYear(year);
            this.dayChooser.setMonth(month);
            this.dayChooser.setEnabled(false);
        }
    }
}

