/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import org.freeplane.api.LengthUnit;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JFreeplaneCustomizableFileChooser;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.UrlManager;
import org.freeplane.main.application.FreeplaneSplashModern;

public class UITools {
    public static final String MAIN_FREEPLANE_FRAME = "mainFreeplaneFrame";
    private static final AtomicBoolean errorMessageQueued = new AtomicBoolean(false);
    public static final String SCROLLBAR_INCREMENT = "scrollbar_increment";
    public static final Dimension MAX_BUTTON_DIMENSION = new Dimension(1000, 1000);
    public static final float FONT_SCALE_FACTOR;
    private static JTabbedPane FREEPLANE_TABBED_PANEL;

    public static void addEscapeActionToDialog(JDialog dialog) {
        class EscapeAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;
            final /* synthetic */ JDialog val$dialog;

            EscapeAction(JDialog jDialog) {
                this.val$dialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$dialog.dispose();
            }
        }
        UITools.addEscapeActionToDialog(dialog, new EscapeAction(dialog));
    }

    public static void addEscapeActionToDialog(JDialog dialog, Action action) {
        UITools.addKeyActionToDialog(dialog, action, "ESCAPE", "end_dialog");
    }

    public static void addKeyActionToDialog(JDialog dialog, Action action, String keyStroke, String actionId) {
        action.putValue("Name", actionId);
        dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(keyStroke), action.getValue("Name"));
        dialog.getRootPane().getActionMap().put(action.getValue("Name"), action);
    }

    public static void convertPointFromAncestor(Component ancestor, Point p, Component c) {
        while (c != ancestor && c != null) {
            int x = c.getX();
            int y = c.getY();
            p.x -= x;
            p.y -= y;
            c = c.getParent();
        }
    }

    public static void convertPointToAncestor(Component source, Point point, Class<?> ancestorClass) {
        Container destination = SwingUtilities.getAncestorOfClass(ancestorClass, source);
        UITools.convertPointToAncestor(source, point, destination);
    }

    public static void convertRectangleToAncestor(Component from, Rectangle r, Component destination) {
        Point p = new Point(r.x, r.y);
        UITools.convertPointToAncestor(from, p, destination);
        r.x = p.x;
        r.y = p.y;
    }

    public static void convertPointToAncestor(Component from, Point p, Component destination) {
        for (Component c = from; c != destination && c != null; c = c.getParent()) {
            int x = c.getX();
            int y = c.getY();
            p.x += x;
            p.y += y;
        }
    }

    public static void errorMessage(Object message) {
        final String myMessage = message != null ? message.toString() : TextUtils.getText("undefined_error");
        LogUtils.warn(myMessage);
        if (!GraphicsEnvironment.isHeadless() && !errorMessageQueued.getAndSet(true)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component currentRootComponent = UITools.getCurrentRootComponent();
                    if (currentRootComponent != null) {
                        try {
                            currentRootComponent.validate();
                            JOptionPane.showMessageDialog(currentRootComponent, myMessage, "Freeplane", 0);
                        }
                        catch (Exception e) {
                            currentRootComponent.setVisible(false);
                            UITools.getFrame().setVisible(false);
                            JOptionPane.showMessageDialog(null, myMessage, "Freeplane", 0);
                            JOptionPane.showMessageDialog(null, TextUtils.getText("program_terminates"), "Freeplane", 0);
                            System.exit(-1);
                        }
                    }
                    errorMessageQueued.set(false);
                }
            });
        }
    }

    public static Component getCurrentRootComponent() {
        return Controller.getCurrentController().getViewController().getCurrentRootComponent();
    }

    public static Frame getCurrentFrame() {
        Component currentRootComponent = UITools.getCurrentRootComponent();
        return currentRootComponent instanceof Frame ? (Frame)currentRootComponent : JOptionPane.getFrameForComponent(currentRootComponent);
    }

    public static Frame getFrame() {
        Component currentRootComponent = UITools.getMenuComponent();
        return currentRootComponent instanceof Frame ? (Frame)currentRootComponent : JOptionPane.getFrameForComponent(currentRootComponent);
    }

    public static Component getMenuComponent() {
        return Controller.getCurrentController().getViewController().getMenuComponent();
    }

    public static KeyStroke getKeyStroke(String keyStrokeDescription) {
        if (keyStrokeDescription == null) {
            return null;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyStrokeDescription);
        if (keyStroke != null) {
            return keyStroke;
        }
        int lastSpacePos = keyStrokeDescription.lastIndexOf(32) + 1;
        String modifiedDescription = keyStrokeDescription.substring(0, lastSpacePos) + "typed " + keyStrokeDescription.substring(lastSpacePos);
        return KeyStroke.getKeyStroke(modifiedDescription);
    }

    public static String keyStrokeToString(KeyStroke keyStroke) {
        String acceleratorText = "";
        if (keyStroke != null) {
            int modifiers = keyStroke.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + "+";
            }
            acceleratorText = acceleratorText + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return acceleratorText;
    }

    public static void informationMessage(String message) {
        UITools.informationMessage(UITools.getCurrentRootComponent(), message);
    }

    public static void informationMessage(Component frame, String message) {
        UITools.informationMessage(frame, message, "Freeplane");
    }

    public static void informationMessage(Component frame, String message, String title) {
        JOptionPane.showMessageDialog(frame, message, title, 1);
    }

    public static void informationMessage(Component frame, String text, String string, int type) {
        JOptionPane.showMessageDialog(frame, text, string, type);
    }

    public static void setBounds(Component frame, int win_x, int win_y, int win_width, int win_height) {
        Rectangle frameBounds = UITools.getValidFrameBounds(frame, win_x, win_y, win_width, win_height);
        frame.setBounds(frameBounds);
    }

    public static Rectangle getValidFrameBounds(Component frame, int win_x, int win_y, int win_width, int win_height) {
        GraphicsConfiguration graphicsConfiguration = UITools.findGraphicsConfiguration(frame, win_x, win_y);
        Rectangle screenBounds = UITools.getScreenBounds(graphicsConfiguration);
        int screenWidth = screenBounds.width;
        win_width = win_width != -1 ? Math.min(win_width, screenWidth) : screenWidth * 4 / 5;
        int screenHeight = screenBounds.height;
        win_height = win_height != -1 ? Math.min(win_height, screenHeight) : screenHeight * 4 / 5;
        if (win_x != -1) {
            win_x = Math.min(screenWidth + screenBounds.x - win_width, win_x);
            win_x = Math.max(screenBounds.x, win_x);
        } else {
            win_x = screenBounds.x + (screenWidth - win_width) / 2;
        }
        if (win_y != -1) {
            win_y = Math.max(screenBounds.y, win_y);
            win_y = Math.min(screenHeight + screenBounds.y - win_height, win_y);
        } else {
            win_y = screenBounds.y + (screenHeight - win_height) / 2;
        }
        Rectangle frameBounds = new Rectangle(win_x, win_y, win_width, win_height);
        return frameBounds;
    }

    private static GraphicsConfiguration findGraphicsConfiguration(Component component, int x, int y) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                Rectangle screenBounds = gc[i].getBounds();
                if (!screenBounds.contains(x, y)) continue;
                return gc[i];
            }
        }
        return component != null ? component.getGraphicsConfiguration() : null;
    }

    public static Rectangle getAvailableScreenBounds(Component frame) {
        GraphicsConfiguration graphicsConfiguration = frame.getGraphicsConfiguration();
        return UITools.getScreenBounds(graphicsConfiguration);
    }

    public static Rectangle getScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        Insets screenInsets = defaultToolkit.getScreenInsets(graphicsConfiguration);
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        Point screenLocation = screenBounds.getLocation();
        Dimension screenSize = screenBounds.getSize();
        int screenWidth = screenSize.width - screenInsets.left - screenInsets.right;
        int screenHeight = screenSize.height - screenInsets.top - screenInsets.bottom;
        return new Rectangle(screenLocation.x + screenInsets.left, screenLocation.y + screenInsets.top, screenWidth, screenHeight);
    }

    public static void setDialogLocationRelativeTo(JDialog dialog, Component c) {
        if (c == null || !c.isShowing()) {
            return;
        }
        Point location = UITools.findBestLocation(dialog, c);
        dialog.setLocation(location);
    }

    public static Point findBestLocation(Component placedComponent, Component displayedComponent) {
        int bottomSpace;
        int topSpace;
        int dx;
        Point compLocation = displayedComponent.getLocationOnScreen();
        int cw = displayedComponent.getWidth();
        int ch = displayedComponent.getHeight();
        Window window = displayedComponent instanceof Window ? (Window)displayedComponent : SwingUtilities.getWindowAncestor(displayedComponent);
        Point parentLocation = window.getLocationOnScreen();
        int pw = window.getWidth();
        int ph = window.getHeight();
        Rectangle desktopBounds = UITools.getAvailableScreenBounds(displayedComponent);
        int minX = Math.max(parentLocation.x, desktopBounds.x);
        int minY = Math.max(parentLocation.y, desktopBounds.y);
        int maxX = Math.min(parentLocation.x + pw, desktopBounds.x + desktopBounds.width);
        int maxY = Math.min(parentLocation.y + ph, desktopBounds.y + desktopBounds.height);
        Dimension preferredSize = placedComponent.getPreferredSize();
        int dw = preferredSize.width;
        int dh = preferredSize.height;
        if (compLocation.x + cw < minX) {
            dx = minX;
        } else if (compLocation.x > maxX) {
            dx = maxX - dw;
        } else {
            int leftSpace = compLocation.x - minX;
            int rightSpace = maxX - (compLocation.x + cw);
            if (leftSpace > rightSpace) {
                if (leftSpace > dw) {
                    dx = compLocation.x - dw;
                    dh = 0;
                } else {
                    dx = minX;
                }
            } else if (rightSpace > dw) {
                dx = compLocation.x + cw;
                dh = 0;
            } else {
                dx = maxX - dw;
            }
        }
        int dy = compLocation.y + ch < minY ? minY : (compLocation.y > maxY ? maxY - dh : ((topSpace = compLocation.y - minY) > (bottomSpace = maxY - (compLocation.y + ch)) ? (topSpace > dh ? compLocation.y - dh : minY) : (bottomSpace > dh ? compLocation.y + ch : maxY - dh)));
        Point location = new Point(dx, dy);
        return location;
    }

    public static void setDialogLocationRelativeTo(JDialog dialog, NodeModel node) {
        if (node == null) {
            return;
        }
        IMapViewManager viewController = Controller.getCurrentController().getMapViewManager();
        viewController.scrollNodeToVisible(node);
        Component c = viewController.getComponent(node);
        UITools.setDialogLocationRelativeTo(dialog, c);
    }

    public static void setDialogLocationUnder(JDialog dialog, NodeModel node) {
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        JComponent c = (JComponent)viewController.getComponent(node);
        boolean x = false;
        int y = c.getHeight();
        Point location = new Point(0, y);
        SwingUtilities.convertPointToScreen(location, c);
        UITools.setBounds(dialog, location.x, location.y, dialog.getWidth(), dialog.getHeight());
    }

    public static void showAttributeEmptyStringErrorMessage() {
        JOptionPane.showMessageDialog(null, TextUtils.getText("attributes_adding_empty_attribute_error"), TextUtils.getText("error"), 0);
    }

    public static void showMessage(String message, int messageType) {
        UITools.backOtherWindows();
        JTextArea infoPane = new JTextArea();
        infoPane.setEditable(false);
        infoPane.setMargin(new Insets(5, 5, 5, 5));
        infoPane.setLineWrap(true);
        infoPane.setWrapStyleWord(true);
        infoPane.setText(message);
        infoPane.setColumns(60);
        JScrollPane scrollPane = new JScrollPane(infoPane);
        UITools.setScrollbarIncrement(scrollPane);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        JOptionPane.showMessageDialog(UITools.getCurrentRootComponent(), scrollPane, "Freeplane", messageType);
    }

    public static int showConfirmDialog(NodeModel node, Object message, String title, int optionType, int messageType) {
        Component parentComponent;
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        if (node == null) {
            parentComponent = UITools.getCurrentRootComponent();
        } else {
            viewController.scrollNodeToVisible(node);
            parentComponent = viewController.getComponent(node);
        }
        return JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
    }

    public static int showConfirmDialog(NodeModel node, Object message, String title, int optionType) {
        return UITools.showConfirmDialog(node, message, title, optionType, 3);
    }

    public static String showInputDialog(NodeModel node, String message, String initialValue) {
        if (node == null) {
            return null;
        }
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        viewController.scrollNodeToVisible(node);
        Component parentComponent = viewController.getComponent(node);
        return JOptionPane.showInputDialog(parentComponent, message, initialValue);
    }

    public static String showInputDialog(NodeModel node, String text, String title, int type) {
        if (node == null) {
            return null;
        }
        Controller controller = Controller.getCurrentController();
        IMapViewManager viewController = controller.getMapViewManager();
        viewController.scrollNodeToVisible(node);
        Component parentComponent = viewController.getComponent(node);
        return JOptionPane.showInputDialog(parentComponent, text, title, type);
    }

    public static void setScrollbarIncrement(JScrollPane scrollPane) {
        int scrollbarIncrement = ResourceController.getResourceController().getIntProperty(SCROLLBAR_INCREMENT, 1);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(scrollbarIncrement);
        scrollPane.getVerticalScrollBar().setUnitIncrement(scrollbarIncrement);
    }

    public static void addScrollbarIncrementPropertyListener(final JScrollPane scrollPane) {
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (!propertyName.equals(UITools.SCROLLBAR_INCREMENT)) {
                    return;
                }
                int scrollbarIncrement = Integer.valueOf(newValue);
                scrollPane.getHorizontalScrollBar().setUnitIncrement(scrollbarIncrement);
                scrollPane.getVerticalScrollBar().setUnitIncrement(scrollbarIncrement);
            }
        });
    }

    public static Color getTextColorForBackground(Color color) {
        return UITools.isLight(color) ? Color.BLACK : Color.WHITE;
    }

    public static boolean isLight(Color color) {
        return UITools.isLighter(color, 128);
    }

    public static boolean isLighter(Color color, int minimum) {
        int green;
        int blue;
        if (color == null) {
            return true;
        }
        int red = color.getRed();
        return red * red + (blue = color.getBlue()) * blue + (green = color.getGreen()) * green >= minimum * minimum * 3;
    }

    public static void focusOn(JComponent component) {
        component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                final JComponent component = event.getComponent();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        component.requestFocus();
                    }
                });
                component.removeAncestorListener(this);
            }
        });
    }

    public static BasicStroke createStroke(float width, int[] dash, int join) {
        float[] fdash = UITools.dashToFloats(dash);
        BasicStroke stroke = new BasicStroke(width, 0, join, 1.0f, fdash, 0.0f);
        return stroke;
    }

    private static float[] dashToFloats(int[] dash) {
        float[] fdash;
        if (dash != null && dash.length > 0) {
            fdash = new float[dash.length];
            int i = 0;
            int[] nArray = dash;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                float d = nArray[j];
                fdash[i++] = d;
            }
        } else {
            fdash = null;
        }
        return fdash;
    }

    public static void repaintAll(Container root) {
        root.repaint();
        for (int i = 0; i < root.getComponentCount(); ++i) {
            Component component = root.getComponent(i);
            if (component instanceof Container) {
                UITools.repaintAll((Container)component);
                continue;
            }
            component.repaint();
        }
    }

    public static JDialog createCancelDialog(Component component, String titel, String text) {
        Object[] options = new String[]{TextUtils.getText("cancel")};
        JOptionPane infoPane = new JOptionPane(text, -1, -1, null, options);
        JDialog dialog = infoPane.createDialog(component, titel);
        dialog.setModal(false);
        return dialog;
    }

    public static TitledBorder addTitledBorder(JComponent c, String title, float size) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(title);
        Font titleFont = UIManager.getFont("TitledBorder.font");
        titledBorder.setTitleFont(titleFont.deriveFont(size));
        Border btnBorder = c.getBorder();
        if (btnBorder != null) {
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titledBorder, btnBorder);
            c.setBorder(compoundBorder);
        } else {
            c.setBorder(titledBorder);
        }
        return titledBorder;
    }

    public static void backOtherWindows() {
        Component owner = UITools.getMenuComponent();
        if (owner instanceof Window) {
            Window[] ownedWindows;
            for (Window w : ownedWindows = ((Window)owner).getOwnedWindows()) {
                if (!w.isVisible()) continue;
                w.toBack();
            }
        }
    }

    public static JButton createHtmlLinkStyleButton(final URI uri, String title) {
        JButton button = new JButton("<html><a href='" + uri + "'>" + title);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setBackground(Color.lightGray);
        button.setFocusable(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModeController modeController = Controller.getCurrentModeController();
                UrlManager urlManager = modeController.getExtension(UrlManager.class);
                urlManager.loadHyperlink(new Hyperlink(uri));
            }
        });
        return button;
    }

    public static final int getComponentIndex(Component component) {
        if (component != null && component.getParent() != null) {
            Container c = component.getParent();
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (c.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }

    private static float getScaleFactor() {
        int userDefinedScreenResolution;
        int windowY;
        ResourceController resourceController = ResourceController.getResourceController();
        int windowX = resourceController.getIntProperty("appwindow_x", 0);
        GraphicsConfiguration graphicsConfiguration = UITools.findGraphicsConfiguration(windowX, windowY = resourceController.getIntProperty("appwindow_y", 0));
        if (graphicsConfiguration != null) {
            Rectangle screenBounds = graphicsConfiguration.getBounds();
            int w = screenBounds.width;
            int h = screenBounds.height;
            double diagonalPixels = Math.sqrt(w * w + h * h);
            double monitorSize = resourceController.getDoubleProperty("monitor_size_inches", 0.0);
            if (monitorSize >= 1.0 && diagonalPixels >= 1.0) {
                userDefinedScreenResolution = (int)Math.round(diagonalPixels / monitorSize);
                resourceController.setProperty("user_defined_screen_resolution", userDefinedScreenResolution);
            } else {
                userDefinedScreenResolution = resourceController.getIntProperty("user_defined_screen_resolution", 96);
                double effectiveMonitorSize = Math.round(diagonalPixels / (double)userDefinedScreenResolution * 10.0) / 10L;
                resourceController.setDefaultProperty("monitor_size_inches", Double.toString(effectiveMonitorSize));
            }
        } else {
            userDefinedScreenResolution = resourceController.getIntProperty("user_defined_screen_resolution", 96);
            resourceController.setDefaultProperty("monitor_size_inches", Double.toString(0.0));
        }
        return (float)userDefinedScreenResolution / 72.0f;
    }

    private static GraphicsConfiguration findGraphicsConfiguration(int windowX, int windowY) {
        GraphicsConfiguration graphicsConfiguration = UITools.findGraphicsConfiguration(null, windowX, windowY);
        if (graphicsConfiguration != null || windowX == 0 && windowY == 0) {
            return graphicsConfiguration;
        }
        return UITools.findGraphicsConfiguration(null, 0, 0);
    }

    public static Font scale(Font font) {
        return font.deriveFont(font.getSize2D() * FONT_SCALE_FACTOR);
    }

    public static Font scaleUI(Font font) {
        return UITools.scale(font);
    }

    public static Font scaleFontInt(Font font, double additionalFactor) {
        Font derivedFont = font.deriveFont(font.getStyle(), Math.round((double)(font.getSize2D() * FONT_SCALE_FACTOR) * additionalFactor));
        if (font instanceof FontUIResource && !(derivedFont instanceof FontUIResource)) {
            return new FontUIResource(derivedFont);
        }
        return derivedFont;
    }

    public static Font invertScale(Font font) {
        return font.deriveFont(font.getSize2D() / FONT_SCALE_FACTOR);
    }

    public static void showFrame() {
        Component component = UITools.getMenuComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            Window[] ownedWindows = window.getOwnedWindows();
            for (int i = 0; i < ownedWindows.length; ++i) {
                Window ownedWindow = ownedWindows[i];
                if (!ownedWindow.getClass().equals(FreeplaneSplashModern.class) || !ownedWindow.isVisible()) continue;
                ownedWindow.setVisible(false);
            }
            if (window != null && !window.isVisible()) {
                window.setVisible(true);
                window.toFront();
            }
        }
    }

    public static boolean isEditingText() {
        Component focusOwner = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean isTextComponentFocused = focusOwner instanceof JEditorPane;
        return isTextComponentFocused && focusOwner.isShowing() && ((JTextComponent)focusOwner).isEditable();
    }

    public static void executeWhenNodeHasFocus(final Runnable runnable) {
        final Component selectedComponent = Controller.getCurrentController().getMapViewManager().getSelectedComponent();
        if (selectedComponent != null && !selectedComponent.hasFocus()) {
            selectedComponent.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                }

                @Override
                public void focusGained(FocusEvent e) {
                    selectedComponent.removeFocusListener(this);
                    Timer timer = new Timer(100, evt -> runnable.run());
                    timer.setRepeats(false);
                    timer.start();
                }
            });
            selectedComponent.requestFocusInWindow();
        } else {
            runnable.run();
        }
    }

    public static int getUIFontSize(double scalingFactor) {
        return UITools.getUIFontSize((float)scalingFactor);
    }

    public static int getUIFontSize(float scalingFactor) {
        Font font = UITools.getUIFont();
        return Math.round((float)font.getSize() * scalingFactor);
    }

    public static Font getUIFont(float scalingFactor) {
        Font uiFont = UITools.getUIFont();
        return uiFont.deriveFont(uiFont.getSize2D() * scalingFactor);
    }

    public static Font getUIFont() {
        return new JMenuItem().getFont();
    }

    public static Font getDefaultLabelFont() {
        return UIManager.getDefaults().getFont("Label.font");
    }

    public static JFileChooser newFileChooser() {
        return Controller.getCurrentModeController().getExtension(UrlManager.class).getFileChooser();
    }

    public static JFileChooser newFileChooser(File directory) {
        return new JFreeplaneCustomizableFileChooser(directory);
    }

    public static JTabbedPane getFreeplaneTabbedPanel() {
        if (FREEPLANE_TABBED_PANEL == null) {
            FREEPLANE_TABBED_PANEL = UITools.createTabbedPane();
        }
        return FREEPLANE_TABBED_PANEL;
    }

    private static JTabbedPane createTabbedPane() {
        JTabbedPane pane = new JTabbedPane();
        pane.setBorder(BorderFactory.createEmptyBorder((int)(10.0f * FONT_SCALE_FACTOR), 0, 0, 0));
        return pane;
    }

    public static boolean isLightLookAndFeelInstalled() {
        return UITools.isLight(UIManager.getColor("Panel.background"));
    }

    static {
        float factor = Defaults.DEFAULT_FONT_SCALING_FACTOR;
        try {
            factor = UITools.getScaleFactor();
            LengthUnit.setScalingFactor((double)factor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FONT_SCALE_FACTOR = factor;
    }

    public static class Defaults {
        public static float DEFAULT_FONT_SCALING_FACTOR = 1.0f;
    }

    public static final class InsertEolAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            c.replaceSelection("\n");
        }
    }
}

