/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class ToolbarLayout
implements LayoutManager {
    public static final int MAX_WIDTH_BY_PARENT_WIDTH = -1;
    private BlockEndPosition blockEndPosition;
    private int maximumWidth = -1;

    ToolbarLayout(BlockEndPosition blockEndPosition) {
        this.blockEndPosition = blockEndPosition;
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(int maximumWidth) {
        this.maximumWidth = maximumWidth;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container container) {
        if (!container.isVisible()) {
            return;
        }
        int maximumWidth = this.calculateMaxWidth(container);
        int heigth = 0;
        int blockWidth = 0;
        int blockHeight = 0;
        int lastBlockWidth = 0;
        int lastBlockHeight = 0;
        int lastBlockStart = 0;
        int lastBlockFinish = 0;
        int i = 0;
        while (true) {
            Component component;
            Component component2 = component = i < container.getComponentCount() ? container.getComponent(i) : null;
            if (component == null || component instanceof JSeparator || this.blockEndPosition == BlockEndPosition.ANYWHERE) {
                if (i > container.getComponentCount() || lastBlockWidth + blockWidth > maximumWidth) {
                    int x = 0;
                    for (int j = lastBlockStart; j < lastBlockFinish; ++j) {
                        Component c = container.getComponent(j);
                        int width = this.getPreferredWidth(c, maximumWidth);
                        c.setBounds(x, heigth, width, lastBlockHeight);
                        x += width;
                    }
                    heigth += lastBlockHeight;
                    lastBlockWidth = blockWidth;
                    lastBlockHeight = blockHeight;
                    lastBlockStart = lastBlockFinish;
                } else {
                    lastBlockWidth += blockWidth;
                    lastBlockHeight = Math.max(blockHeight, lastBlockHeight);
                }
                lastBlockFinish = i;
                blockHeight = 0;
                blockWidth = 0;
            }
            if (component == null) {
                if (lastBlockStart == container.getComponentCount()) break;
                lastBlockFinish = container.getComponentCount();
            } else {
                blockWidth += this.getPreferredWidth(component, maximumWidth);
                Dimension compPreferredSize = component.getPreferredSize();
                blockHeight = Math.max(compPreferredSize.height, blockHeight);
            }
            ++i;
        }
    }

    private int calculateMaxWidth(Container container) {
        Container viewport = SwingUtilities.getAncestorOfClass(JViewport.class, container);
        if (viewport != null) {
            return viewport.getWidth();
        }
        Container parent = container.getParent();
        if (parent != null) {
            return parent.getWidth();
        }
        if (this.maximumWidth >= 0) {
            return this.maximumWidth;
        }
        return Integer.MAX_VALUE;
    }

    private int getPreferredWidth(Component c, int maxWidth) {
        int width = !c.isVisible() ? 0 : (c instanceof JSeparator && this.blockEndPosition == BlockEndPosition.ANYWHERE ? maxWidth : c.getPreferredSize().width);
        return width;
    }

    @Override
    public Dimension minimumLayoutSize(Container comp) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int maxWidth = this.calculateMaxWidth(container);
        int width = 0;
        int heigth = 0;
        int blockWidth = 0;
        int blockHeight = 0;
        int lastBlockWidth = 0;
        int lastBlockHeight = 0;
        int lastBlockStart = 0;
        int lastBlockFinish = 0;
        int i = 0;
        while (true) {
            Component component;
            Component component2 = component = i < container.getComponentCount() ? container.getComponent(i) : null;
            if (component == null || component instanceof JSeparator || this.blockEndPosition == BlockEndPosition.ANYWHERE) {
                if (i > container.getComponentCount() || lastBlockWidth + blockWidth > maxWidth) {
                    heigth += lastBlockHeight;
                    lastBlockWidth = blockWidth;
                    lastBlockHeight = blockHeight;
                    lastBlockStart = lastBlockFinish;
                } else {
                    lastBlockWidth += blockWidth;
                    lastBlockHeight = Math.max(blockHeight, lastBlockHeight);
                }
                width = Math.max(width, lastBlockWidth);
                lastBlockFinish = i;
                blockHeight = 0;
                blockWidth = 0;
            }
            if (component == null) {
                if (lastBlockStart == container.getComponentCount()) break;
                lastBlockFinish = container.getComponentCount();
            } else {
                blockWidth += this.getPreferredWidth(component, maxWidth);
                Dimension compPreferredSize = component.getPreferredSize();
                blockHeight = Math.max(compPreferredSize.height, blockHeight);
            }
            ++i;
        }
        return new Dimension(width, heigth);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public static ToolbarLayout horizontal() {
        return new ToolbarLayout(BlockEndPosition.ON_SEPARATOR);
    }

    public static ToolbarLayout vertical() {
        return new ToolbarLayout(BlockEndPosition.ANYWHERE);
    }

    static enum BlockEndPosition {
        ON_SEPARATOR,
        ANYWHERE;

    }
}

