/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class OptionalDontShowMeAgainDialog {
    public static final String CONFIRMATION = "confirmation";
    private static final String REMEMBER_MY_DESCISION = "OptionalDontShowMeAgainDialog.rememberMyDescision";
    public static final String DONT_SHOW_AGAIN = "OptionalDontShowMeAgainDialog.dontShowAgain";
    private JDialog dialog;
    private JCheckBox mDontShowAgainBox;
    private final String messageId;
    private final MessageType messageType;
    private final NodeModel node;
    private final Frame parentComponent;
    private final String propertyName;
    private int mResult = 2;
    private final String titleId;

    public static int show(String propertyName, MessageType messageType) {
        return OptionalDontShowMeAgainDialog.show("OptionPanel." + propertyName, CONFIRMATION, propertyName, messageType);
    }

    public static int show(String messageId, String propertyName, MessageType messageType) {
        return OptionalDontShowMeAgainDialog.show(messageId, CONFIRMATION, propertyName, messageType);
    }

    public static int show(String messageId, String titleId, String propertyName, MessageType messageType) {
        return new OptionalDontShowMeAgainDialog(messageId, titleId, propertyName, messageType).show().getResult();
    }

    private OptionalDontShowMeAgainDialog(String messageId, String titleId, String propertyName, MessageType messageType) {
        Controller controller = Controller.getCurrentController();
        this.parentComponent = UITools.getCurrentFrame();
        IMapSelection selection = controller.getSelection();
        this.node = selection != null ? selection.getSelected() : null;
        this.messageId = messageId;
        this.titleId = titleId;
        this.propertyName = propertyName;
        this.messageType = messageType;
    }

    private void close(int pResult) {
        this.mResult = pResult;
        if (this.mDontShowAgainBox.isSelected()) {
            switch (this.messageType) {
                case ONLY_OK_SELECTION_IS_STORED: {
                    if (this.mResult != 0) break;
                    this.setProperty("true");
                    break;
                }
                case ONLY_CANCEL_SELECTION_IS_STORED: {
                    if (this.mResult != 2) break;
                    this.setProperty("false");
                    break;
                }
                default: {
                    this.setProperty(this.mResult == 0 ? "true" : "false");
                }
            }
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    private String getProperty() {
        return ResourceController.getResourceController().getProperty(this.propertyName);
    }

    private int getResult() {
        return this.mResult;
    }

    private void setProperty(String value) {
        ResourceController.getResourceController().setProperty(this.propertyName, value);
    }

    private OptionalDontShowMeAgainDialog show() {
        String property = this.getProperty();
        if (this.messageType != MessageType.ONLY_CANCEL_SELECTION_IS_STORED && StringUtils.equals((String)property, (String)"true")) {
            this.mResult = 0;
            return this;
        }
        if ((this.messageType == MessageType.BOTH_OK_AND_CANCEL_OPTIONS_ARE_STORED || this.messageType == MessageType.ONLY_CANCEL_SELECTION_IS_STORED) && StringUtils.equals((String)property, (String)"false")) {
            this.mResult = 2;
            return this;
        }
        this.dialog = new JDialog(this.parentComponent, TextUtils.getText(this.titleId));
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(0);
        AbstractAction cancelAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent pE) {
                OptionalDontShowMeAgainDialog.this.close(2);
            }
        };
        AbstractAction okAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent pE) {
                OptionalDontShowMeAgainDialog.this.close(0);
            }
        };
        UITools.addEscapeActionToDialog(this.dialog, cancelAction);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent pE) {
                OptionalDontShowMeAgainDialog.this.close(2);
            }
        });
        this.dialog.getContentPane().setLayout(new GridBagLayout());
        JTextArea textArea = new JTextArea(TextUtils.getText(this.messageId));
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setColumns(60);
        textArea.setSize(textArea.getPreferredSize());
        this.dialog.getContentPane().add((Component)textArea, new GridBagConstraints(1, 0, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        Icon questionMark = this.messageType == MessageType.ONLY_OK_SELECTION_IS_SHOWN ? ResourceController.getResourceController().getIcon("/images/icons/messagebox_warning.svg") : ResourceController.getResourceController().getIcon("/images/icons/help.svg");
        this.dialog.getContentPane().add((Component)new JLabel(questionMark), new GridBagConstraints(0, 0, 1, 2, 1.0, 2.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        String boxString = this.messageType != MessageType.BOTH_OK_AND_CANCEL_OPTIONS_ARE_STORED ? DONT_SHOW_AGAIN : REMEMBER_MY_DESCISION;
        this.mDontShowAgainBox = new JCheckBox(TextUtils.getRawText(boxString));
        LabelAndMnemonicSetter.setLabelAndMnemonic(this.mDontShowAgainBox, null);
        this.dialog.getContentPane().add((Component)this.mDontShowAgainBox, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        String okText = this.messageType == MessageType.ONLY_OK_SELECTION_IS_SHOWN ? TextUtils.getRawText("ok") : TextUtils.getRawText("OptionalDontShowMeAgainDialog.ok");
        JButton okButton = new JButton(okText);
        LabelAndMnemonicSetter.setLabelAndMnemonic(okButton, null);
        okButton.addActionListener(okAction);
        this.dialog.getContentPane().add((Component)okButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 0), 0, 0));
        if (this.messageType != MessageType.ONLY_OK_SELECTION_IS_SHOWN) {
            JButton cancelButton = new JButton(TextUtils.getRawText("OptionalDontShowMeAgainDialog.cancel"));
            LabelAndMnemonicSetter.setLabelAndMnemonic(cancelButton, null);
            cancelButton.addActionListener(cancelAction);
            this.dialog.getContentPane().add((Component)cancelButton, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        }
        this.dialog.getRootPane().setDefaultButton(okButton);
        this.dialog.pack();
        if (this.node != null) {
            UITools.setDialogLocationRelativeTo(this.dialog, this.node);
        } else {
            this.dialog.setLocationRelativeTo(null);
        }
        this.dialog.setVisible(true);
        return this;
    }

    public static enum MessageType {
        ONLY_OK_SELECTION_IS_STORED,
        ONLY_CANCEL_SELECTION_IS_STORED,
        BOTH_OK_AND_CANCEL_OPTIONS_ARE_STORED,
        ONLY_OK_SELECTION_IS_SHOWN;

    }
}

