/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class MouseInsideListener
extends MouseAdapter
implements MouseMotionListener {
    private boolean mouseInside = false;
    private final Component c;

    public boolean isMouseInside() {
        return this.mouseInside;
    }

    public MouseInsideListener(Component c) {
        this.c = c;
        this.connect();
    }

    protected void connect() {
        this.recursivelyAddMouseInsideListener(this.c);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseInside = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseInside = false;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseInside = true;
    }

    private void recursivelyAddMouseInsideListener(Component c) {
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
        if (c instanceof Container) {
            Container container = (Container)c;
            for (Component childComponent : container.getComponents()) {
                this.recursivelyAddMouseInsideListener(childComponent);
            }
        }
    }

    private void recursivelyRemoveMouseInsideListener(Component c) {
        c.removeMouseListener(this);
        c.removeMouseMotionListener(this);
        if (c instanceof Container) {
            Container container = (Container)c;
            for (Component childComponent : container.getComponents()) {
                this.recursivelyRemoveMouseInsideListener(childComponent);
            }
        }
    }

    public void disconnect() {
        this.recursivelyRemoveMouseInsideListener(this.c);
    }
}

