/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.io.xml;

import java.io.IOException;
import java.util.Properties;
import org.freeplane.core.io.xml.LocalEntityResolver;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.IXMLReader;
import org.freeplane.n3.nanoxml.StdXMLParser;
import org.freeplane.n3.nanoxml.XMLParseException;

class XMLParser
extends StdXMLParser
implements IXMLParser {
    private boolean skipNextElementContent = false;

    public XMLParser() {
        this.setResolver(new LocalEntityResolver());
    }

    void notParseNextElementContent() {
        this.skipNextElementContent = true;
    }

    @Override
    protected void processElement(String defaultNamespace, Properties namespaces) throws Exception {
        try {
            super.processElement(defaultNamespace, namespaces);
        }
        finally {
            this.skipNextElementContent = false;
        }
    }

    @Override
    protected void processElementContent(String defaultNamespace, Properties namespaces, String fullName, String name, String prefix) throws IOException, XMLParseException, Exception {
        if (this.skipNextElementContent) {
            boolean inComment = false;
            TreeXmlReader builder = (TreeXmlReader)this.getBuilder();
            StringBuilder waitingBuf = new StringBuilder();
            int level = 1;
            while (true) {
                IXMLReader reader = this.getReader();
                char ch = reader.read();
                if (inComment) {
                    waitingBuf.append(ch);
                    if (ch != '-') continue;
                    ch = reader.read();
                    waitingBuf.append(ch);
                    if (ch != '-') continue;
                    ch = reader.read();
                    waitingBuf.append(ch);
                    if (ch != '>') continue;
                    inComment = false;
                    continue;
                }
                if (ch == '<') {
                    ch = reader.read();
                    if (ch == '/') {
                        if (--level == 0) {
                            break;
                        }
                    } else {
                        if (ch == '!') {
                            char read1 = reader.read();
                            char read2 = reader.read();
                            if (read1 != '-' || read2 != '-') {
                                throw new XMLParseException(reader.getSystemID(), reader.getLineNr(), "Invalid input: <!" + read1 + read2);
                            }
                            inComment = true;
                            waitingBuf.append("<!--");
                            continue;
                        }
                        ++level;
                    }
                    waitingBuf.append('<');
                } else if (ch == '/') {
                    ch = reader.read();
                    if (ch == '>') {
                        if (--level == 0) {
                            throw new XMLParseException(reader.getSystemID(), reader.getLineNr(), "Invalid input: />");
                        }
                    } else if (ch == '<') {
                        waitingBuf.append('/');
                        reader.unread(ch);
                        continue;
                    }
                    waitingBuf.append('/');
                }
                waitingBuf.append(ch);
            }
            builder.setElementContent(waitingBuf.toString());
            return;
        }
        super.processElementContent(defaultNamespace, namespaces, fullName, name, prefix);
    }
}

