/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.filter;

import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.FormulaThreadLocalStacks;
import org.freeplane.plugin.script.GroovyScript;
import org.freeplane.plugin.script.NodeScript;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptRunner;
import org.freeplane.plugin.script.ScriptingPermissions;

public class ScriptCondition
extends ASelectableCondition {
    private static final String SCRIPT_FILTER_DESCRIPTION_RESOURCE = "plugins/script_filter";
    private static final String SCRIPT_FILTER_ERROR_RESOURCE = "plugins/script_filter_error";
    private static final String SCRIPT_FILTER_EXECUTE_ERROR_RESOURCE = "plugins/script_filter_execute_error";
    static final String NAME = "script_condition";
    static final String TAG_NAME = "script";
    static final String ATTRIB_NAME = "SCRIPT";
    private final ScriptRunner scriptRunner;
    private final String source;
    private boolean errorReported = false;
    private String errorMessage;

    static ASelectableCondition load(XMLElement element) {
        XMLElement child = element.getFirstChildNamed(TAG_NAME);
        if (child != null) {
            return new ScriptCondition(child.getContent());
        }
        return new ScriptCondition(element.getAttribute(ATTRIB_NAME, null));
    }

    public void fillXML(XMLElement element) {
        XMLElement child = new XMLElement(TAG_NAME);
        super.fillXML(element);
        child.setContent(this.source);
        element.addChild(child);
    }

    protected String getName() {
        return NAME;
    }

    public ScriptCondition(String script) {
        ScriptingPermissions formulaPermissions = ScriptingPermissions.getFormulaPermissions();
        this.source = script;
        this.scriptRunner = new ScriptRunner(new GroovyScript(script, formulaPermissions));
    }

    private String createErrorDescription(NodeModel node, String message, String template) {
        String info = TextUtils.format((String)template, (Object[])new Object[]{!this.errorReported ? this.createDescription() : "...", node.createID() + ", " + node.toString(), message.equals(this.errorMessage) ? "..." : message});
        this.errorMessage = message;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkNode(NodeModel node) {
        Object result;
        block9: {
            block8: {
                NodeScript nodeScript = new NodeScript(node, this.source);
                ScriptContext scriptContext = new ScriptContext(nodeScript);
                if (!FormulaThreadLocalStacks.INSTANCE.push(scriptContext)) {
                    return false;
                }
                this.scriptRunner.setScriptContext(scriptContext);
                result = this.scriptRunner.execute(node);
                if (!(result instanceof Boolean)) break block8;
                boolean bl = (Boolean)result;
                FormulaThreadLocalStacks.INSTANCE.pop();
                this.scriptRunner.setScriptContext(null);
                return bl;
            }
            if (!(result instanceof Number)) break block9;
            boolean bl = ((Number)result).doubleValue() != 0.0;
            FormulaThreadLocalStacks.INSTANCE.pop();
            this.scriptRunner.setScriptContext(null);
            return bl;
        }
        try {
            try {
                String info = this.createErrorDescription(node, String.valueOf(result), SCRIPT_FILTER_ERROR_RESOURCE);
                this.setErrorStatus(info);
            }
            catch (ExecuteScriptException e) {
                String info = this.createErrorDescription(node, String.valueOf(e.getMessage()), SCRIPT_FILTER_EXECUTE_ERROR_RESOURCE);
                this.setErrorStatus(info);
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            FormulaThreadLocalStacks.INSTANCE.pop();
            this.scriptRunner.setScriptContext(null);
        }
    }

    private void setErrorStatus(String info) {
        LogUtils.warn((String)info);
        if (!this.errorReported) {
            this.errorReported = true;
            JOptionPane.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), info, TextUtils.getText((String)"error"), 0);
            String message = info.trim().replaceAll("\\s", " ");
            if (message.length() > 80) {
                message = message.substring(0, 80);
            }
            Controller.getCurrentController().getViewController().out(message);
        }
    }

    protected String createDescription() {
        return TextUtils.format((String)SCRIPT_FILTER_DESCRIPTION_RESOURCE, (Object[])new Object[]{this.source});
    }

    protected JComponent createRendererComponent() {
        JComponent renderer = super.createRendererComponent();
        Dimension preferredSize = renderer.getPreferredSize();
        if (preferredSize.width > 200) {
            renderer.setPreferredSize(new Dimension(200, preferredSize.height));
        }
        if (preferredSize.width > 200 || this.source.contains("\n")) {
            renderer.setToolTipText(HtmlUtils.plainToHTML((String)this.source));
        }
        return renderer;
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ScriptCondition other = (ScriptCondition)((Object)obj);
        return this.source.equals(other.source);
    }
}

