/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngineFactory;
import javax.swing.ComboBoxEditor;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.xml.XMLLocalParserFactory;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IValidator;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.generic.BuildPhaseListener;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.script.IScriptEditorStarter;
import org.freeplane.features.script.IScriptStarter;
import org.freeplane.main.addons.AddOnInstaller;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.main.application.ApplicationLifecycleListener;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.IXMLReader;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.plugin.script.ClasspathScriptCompiler;
import org.freeplane.plugin.script.ExecuteScriptForAllNodes;
import org.freeplane.plugin.script.ExecuteScriptForSelectionAction;
import org.freeplane.plugin.script.GenericScript;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.InternationalizedSecurityManager;
import org.freeplane.plugin.script.ScriptComboBoxEditor;
import org.freeplane.plugin.script.ScriptEditor;
import org.freeplane.plugin.script.ScriptEditorPanel;
import org.freeplane.plugin.script.ScriptEditorWindowConfigurationStorage;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptingConfiguration;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingGuiConfiguration;
import org.freeplane.plugin.script.ScriptingMenuEntryVisitor;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.ScriptingPolicy;
import org.freeplane.plugin.script.addons.ManageAddOnsAction;
import org.freeplane.plugin.script.addons.ManageAddOnsDialog;
import org.freeplane.plugin.script.addons.ScriptAddOnProperties;
import org.freeplane.plugin.script.filter.ScriptConditionController;
import org.freeplane.plugin.script.help.OpenApiDocumentationAction;

class ScriptingRegistration {
    private final HashMap<String, Object> mScriptCookies = new HashMap();

    public HashMap<String, Object> getScriptCookies() {
        return this.mScriptCookies;
    }

    void register(ModeController modeController, CommandLineOptions options) {
        boolean isSecurityManagerEnabled;
        modeController.addExtension(IScriptEditorStarter.class, (IExtension)new IScriptEditorStarter(){

            public String startEditor(String pScriptInput) {
                ScriptModel scriptModel = new ScriptModel(pScriptInput);
                ScriptEditorPanel scriptEditorPanel = new ScriptEditorPanel(scriptModel, false);
                scriptEditorPanel.setVisible(true);
                return scriptModel.getScript();
            }

            public ComboBoxEditor createComboBoxEditor(Dimension minimumSize) {
                ScriptComboBoxEditor scriptComboBoxEditor = new ScriptComboBoxEditor();
                if (minimumSize != null) {
                    scriptComboBoxEditor.setMinimumSize(minimumSize);
                }
                return scriptComboBoxEditor;
            }
        });
        modeController.addExtension(IScriptStarter.class, (IExtension)new IScriptStarter(){

            public void executeScript(NodeModel node, String script) {
                ScriptingEngine.executeScript(node, script);
            }
        });
        this.registerScriptAddOns();
        new ScriptingConfiguration();
        ClasspathScriptCompiler scriptCompiler = new ClasspathScriptCompiler();
        boolean bl = isSecurityManagerEnabled = System.getSecurityManager() != null;
        if (isSecurityManagerEnabled) {
            System.setSecurityManager(null);
        }
        scriptCompiler.compileScriptsOnPath(ScriptResources.getClasspath());
        if (isSecurityManagerEnabled) {
            System.setSecurityManager(new InternationalizedSecurityManager());
        }
        if (!GraphicsEnvironment.isHeadless()) {
            this.registerGuiStuff(modeController);
            this.createUserScriptsDirectory();
            this.createInitScriptsDirectory();
            this.createUserLibDirectory();
        }
        this.registerInitScripts(options.getScriptsToExecute());
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(200, (IElementaryConditionController)new ScriptConditionController());
        ScriptingPolicy.installRestrictingPolicy();
    }

    private void registerGuiStuff(ModeController modeController) {
        this.addPropertiesToOptionPanel();
        modeController.addAction((AFreeplaneAction)new ScriptEditor());
        modeController.addAction((AFreeplaneAction)new ExecuteScriptForAllNodes());
        modeController.addAction((AFreeplaneAction)new ExecuteScriptForSelectionAction());
        modeController.addAction((AFreeplaneAction)new OpenApiDocumentationAction());
        final ManageAddOnsAction manageAddOnsAction = new ManageAddOnsAction();
        modeController.addAction((AFreeplaneAction)manageAddOnsAction);
        modeController.addExtension(AddOnInstaller.class, (IExtension)new AddOnInstaller(){

            public void install(URL url) {
                ManageAddOnsDialog dialog = manageAddOnsAction.getDialog();
                dialog.install(url);
            }
        });
        ScriptingGuiConfiguration configuration = new ScriptingGuiConfiguration();
        this.updateMenus(modeController, configuration);
    }

    private void addPropertiesToOptionPanel() {
        URL preferences = this.getClass().getResource("preferences.xml");
        if (preferences == null) {
            throw new RuntimeException("cannot open preferences");
        }
        Controller.getCurrentController().addOptionValidator(new IValidator(){

            public IValidator.ValidationResult validate(Properties properties) {
                boolean classpathIsSet;
                IValidator.ValidationResult result = new IValidator.ValidationResult();
                String readAccessString = properties.getProperty("execute_scripts_without_file_restriction");
                String writeAccessString = properties.getProperty("execute_scripts_without_write_restriction");
                String classpath = properties.getProperty("script_classpath");
                boolean readAccess = readAccessString != null && Boolean.parseBoolean(readAccessString);
                boolean writeAccess = writeAccessString != null && Boolean.parseBoolean(writeAccessString);
                boolean bl = classpathIsSet = classpath != null && classpath.length() > 0;
                if (classpathIsSet && !readAccess) {
                    result.addError(TextUtils.getText((String)"OptionPanel.validate_classpath_needs_readaccess"));
                }
                if (writeAccess && !readAccess) {
                    result.addWarning(TextUtils.getText((String)"OptionPanel.validate_write_without_read"));
                }
                return result;
            }
        });
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        modeController.getOptionPanelBuilder().load(preferences);
    }

    private void updateMenus(ModeController modeController, ScriptingGuiConfiguration configuration) {
        ScriptingMenuEntryVisitor builder = new ScriptingMenuEntryVisitor(configuration, modeController);
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "userScripts", (EntryVisitor)builder, EntryVisitor.ILLEGAL);
        modeController.getUserInputListenerFactory().addBuildPhaseListener((BuildPhaseListener)builder);
    }

    private void registerScriptAddOns() {
        File[] addonXmlFiles = AddOnsController.getController().getAddOnsDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".script.xml");
            }
        });
        IXMLParser parser = XMLLocalParserFactory.createLocalXMLParser();
        for (File file : addonXmlFiles) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                StdXMLReader reader = new StdXMLReader((InputStream)inputStream);
                parser.setReader((IXMLReader)reader);
                ScriptAddOnProperties addOn = new ScriptAddOnProperties((XMLElement)parser.parse());
                addOn.setAddOnPropertiesFile(file);
                AddOnsController.getController().registerInstalledAddOn((AddOnProperties)addOn);
            }
            catch (Exception e) {
                LogUtils.warn((String)("error parsing " + file), (Throwable)e);
            }
        }
    }

    private void registerInitScripts(final List<String> scripts) {
        FilenameFilter scriptFilenameFilter = ScriptingRegistration.createFilenameFilter(ScriptingRegistration.createScriptRegExp());
        final File[] initScriptFiles = ScriptResources.getInitScriptsDir().isDirectory() ? ScriptResources.getInitScriptsDir().listFiles(scriptFilenameFilter) : new File[]{};
        if (initScriptFiles.length > 0 || scripts.size() > 0) {
            Controller.getCurrentController().addApplicationLifecycleListener(new ApplicationLifecycleListener(){

                public void onStartupFinished() {
                    for (File scriptFile : initScriptFiles) {
                        LogUtils.info((String)("running init script " + scriptFile));
                        try {
                            ScriptingEngine.executeScript(null, scriptFile, null);
                        }
                        catch (Exception e) {
                            LogUtils.warn((Throwable)e);
                        }
                    }
                    for (String scriptFile : scripts) {
                        LogUtils.info((String)("running init script " + scriptFile));
                        try {
                            ScriptingEngine.executeScript(null, new File(scriptFile), ScriptingPermissions.getPermissiveScriptingPermissions());
                        }
                        catch (Exception e) {
                            LogUtils.warn((Throwable)e);
                        }
                    }
                }

                public void onApplicationStopped() {
                }
            });
        }
    }

    private void createUserScriptsDirectory() {
        this.createDirIfNotExists(ScriptResources.getUserScriptsDir(), "user scripts");
    }

    private void createInitScriptsDirectory() {
        this.createDirIfNotExists(ScriptResources.getInitScriptsDir(), "init scripts");
    }

    private void createDirIfNotExists(File scriptDir, String what) {
        if (!scriptDir.exists()) {
            LogUtils.info((String)("creating " + what + " directory " + scriptDir));
            scriptDir.mkdirs();
        }
    }

    private void createUserLibDirectory() {
        File libDir = ScriptResources.getUserLibDir();
        if (!libDir.exists()) {
            LogUtils.info((String)("creating user lib directory " + libDir));
            libDir.mkdirs();
        }
    }

    static FilenameFilter createFilenameFilter(final String regexp) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(regexp);
            }
        };
        return filter;
    }

    static String createScriptRegExp() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (ScriptEngineFactory scriptEngineFactory : GenericScript.createScriptEngineFactories()) {
            extensions.addAll(scriptEngineFactory.getExtensions());
        }
        LogUtils.info((String)("looking for scripts with the following endings: " + extensions));
        return ".+\\.(" + StringUtils.join(extensions, (String)"|") + ")$";
    }

    private final class ScriptModel
    implements ScriptEditorPanel.IScriptModel {
        private final String mOriginalScript;
        private String mScript;

        public ScriptModel(String pScript) {
            this.mScript = pScript;
            this.mOriginalScript = pScript;
        }

        @Override
        public int addNewScript() {
            return 0;
        }

        @Override
        public ScriptEditorWindowConfigurationStorage decorateDialog(ScriptEditorPanel pPanel, String pWindow_preference_storage_property) {
            String marshalled = ResourceController.getResourceController().getProperty(pWindow_preference_storage_property);
            return ScriptEditorWindowConfigurationStorage.decorateDialog(marshalled, pPanel);
        }

        @Override
        public void endDialog(boolean pIsCanceled) {
            if (pIsCanceled) {
                this.mScript = this.mOriginalScript;
            }
        }

        @Override
        public Object executeScript(int pIndex, PrintStream pOutStream, IFreeplaneScriptErrorHandler pErrorHandler) {
            ModeController modeController = Controller.getCurrentModeController();
            ScriptingPermissions restrictedPermissions = ScriptingPermissions.getPermissiveScriptingPermissions();
            return ScriptingEngine.executeScript(modeController.getMapController().getSelectedNode(), this.mScript, pErrorHandler, pOutStream, null, restrictedPermissions);
        }

        @Override
        public int getAmountOfScripts() {
            return 1;
        }

        public String getScript() {
            return this.mScript;
        }

        @Override
        public ScriptEditorPanel.ScriptHolder getScript(int pIndex) {
            return new ScriptEditorPanel.ScriptHolder("Script", this.mScript);
        }

        @Override
        public boolean isDirty() {
            return !StringUtils.equals((String)this.mScript, (String)this.mOriginalScript);
        }

        @Override
        public void setScript(int pIndex, ScriptEditorPanel.ScriptHolder pScript) {
            this.mScript = pScript.getScript();
        }

        @Override
        public void storeDialogPositions(ScriptEditorPanel pPanel, ScriptEditorWindowConfigurationStorage pStorage, String pWindow_preference_storage_property) {
            pStorage.storeDialogPositions(pPanel, pWindow_preference_storage_property);
        }

        @Override
        public String getTitle() {
            return "";
        }
    }
}

