/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.ImageUtils;

public class ImageResource
extends Resource
implements Resource.Cleanable {
    private static final Logger logger = Logger.getLogger(ImageResource.class.getName());
    private static final Comparator<BufferedImage> biComp = Comparator.comparingInt(bi -> bi.getWidth() * bi.getHeight());
    private volatile BufferedImage image = null;
    private List<URI> alternativeLocators = null;
    private List<BufferedImage> loadedImages = null;
    private List<ImageResource> variations = new ArrayList<ImageResource>();

    public ImageResource(String primaryKey, URI resourceLocator) {
        super(primaryKey, resourceLocator);
    }

    public synchronized void addAlternativeResourceLocator(URI uri) {
        if (this.alternativeLocators == null) {
            this.alternativeLocators = new ArrayList<URI>();
        }
        this.alternativeLocators.add(uri);
    }

    public synchronized void addVariation(ImageResource imageResource) {
        this.variations.add(imageResource);
    }

    public synchronized void addAlternativeResourceLocators(List<URI> uris) {
        if (this.alternativeLocators == null) {
            this.alternativeLocators = new ArrayList<URI>();
        }
        this.alternativeLocators.addAll(uris);
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            logger.finest("Preload not ready for " + this.getResourceLocator());
            this.preload();
        }
        return this.image;
    }

    public int getVariationNumberForSeed(int seed) {
        return new Random(seed).nextInt(this.variations.size() + 1);
    }

    public int getVariationNumberForTick(long ticks) {
        return (int)(ticks % (long)(this.variations.size() + 1));
    }

    public int getNumberOfVariations() {
        return this.variations.size() + 1;
    }

    public ImageResource getVariation(int variationNumber) {
        if (this.variations.isEmpty()) {
            return this;
        }
        if (variationNumber >= this.variations.size()) {
            return this;
        }
        return this.variations.get(variationNumber);
    }

    public BufferedImage getImage(int variation, Dimension d, boolean grayscale) {
        return grayscale ? this.getVariation(variation).getGrayscaleImage(d) : this.getVariation(variation).getColorImage(d);
    }

    public BufferedImage getImage(Dimension d, boolean grayscale) {
        return grayscale ? this.getGrayscaleImage(d) : this.getColorImage(d);
    }

    private synchronized BufferedImage findLoadedImage(Predicate<BufferedImage> pred) {
        BufferedImage oim = CollectionUtils.find(this.loadedImages, pred);
        return oim != null ? oim : this.loadedImages.get(this.loadedImages.size() - 1);
    }

    private synchronized boolean haveAlternatives() {
        return this.loadedImages != null;
    }

    private BufferedImage getColorImage(Dimension siz) {
        BufferedImage img = this.getImage();
        if (img == null) {
            return null;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        Dimension dNew = ImageUtils.wildcardDimension(siz, new Dimension(w, h));
        int wNew = dNew.width;
        int hNew = dNew.height;
        if (wNew == w && hNew == h) {
            return img;
        }
        if (this.haveAlternatives()) {
            int fwNew = wNew;
            int fhNew = hNew;
            Predicate<BufferedImage> sizePred = i -> i.getWidth() >= fwNew && i.getHeight() >= fhNew;
            img = this.findLoadedImage(sizePred);
            w = img.getWidth();
            h = img.getHeight();
            dNew = ImageUtils.wildcardDimension(siz, new Dimension(w, h));
            wNew = dNew.width;
            hNew = dNew.height;
            if (wNew == w && hNew == h) {
                return img;
            }
        }
        if (wNew != w || hNew != h) {
            img = ImageUtils.createResizedImage(img, wNew, hNew);
        }
        return img;
    }

    private BufferedImage getGrayscaleImage(Dimension siz) {
        BufferedImage img = this.getColorImage(siz);
        return ImageUtils.createGrayscaleImage(img);
    }

    @Override
    public synchronized void preload() {
        if (this.image == null) {
            this.image = ImageResource.loadImage(this.getResourceLocator());
            if (this.alternativeLocators != null) {
                this.loadedImages = new ArrayList<BufferedImage>();
                if (this.image != null) {
                    this.loadedImages.add(this.image);
                }
                for (URI uri : this.alternativeLocators) {
                    BufferedImage image = ImageResource.loadImage(uri);
                    if (image == null) continue;
                    this.loadedImages.add(image);
                }
                this.loadedImages.sort(biComp);
                if (this.image == null && !this.loadedImages.isEmpty()) {
                    this.image = CollectionUtils.first(this.loadedImages);
                }
            }
            for (ImageResource variation : this.variations) {
                variation.preload();
            }
        }
    }

    private static BufferedImage loadImage(URI uri) {
        try {
            URL url = uri.toURL();
            BufferedImage image = ImageIO.read(url);
            if (image == null) {
                logger.log(Level.WARNING, "Failed to read image from: " + uri);
                return null;
            }
            if (ImageResource.canUseBitmask(uri)) {
                BufferedImage compatibleImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), 2);
                Graphics2D g = compatibleImage.createGraphics();
                g.drawImage((Image)image, 0, 0, null);
                g.dispose();
                return compatibleImage;
            }
            return image;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Exception to loading image from: " + uri, ioe);
            return null;
        }
    }

    @Override
    public void clean() {
        this.image = null;
        if (this.loadedImages != null) {
            this.loadedImages.clear();
        }
        if (this.variations != null) {
            this.variations.stream().forEach(v -> v.clean());
        }
    }

    private static boolean canUseBitmask(URI uri) {
        return uri.toString().contains("center") && !uri.toString().contains("mask");
    }
}

