/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.sound.sampled.AudioInputStream;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.sound.SoundPlayer;

public class AudioResource
extends Resource {
    private final List<File> files = new ArrayList<File>();

    public AudioResource(String primaryKey, URI resourceLocator) throws IOException {
        super(primaryKey, resourceLocator);
        File file = new File(resourceLocator);
        if (!file.isDirectory()) {
            try (AudioInputStream ais = SoundPlayer.getAudioInputStream(file);){
                this.files.add(file);
            }
        } else {
            File[] candidateFiles;
            for (File f : candidateFiles = file.listFiles((dir, name) -> name.endsWith(".ogg") || name.endsWith(".wav"))) {
                try (AudioInputStream ais = SoundPlayer.getAudioInputStream(f);){
                    this.files.add(f);
                }
            }
        }
    }

    @Override
    public void preload() {
    }

    public File getAudio() {
        if (this.files.isEmpty()) {
            return null;
        }
        return this.files.get(new Random().nextInt(this.files.size()));
    }

    public List<File> getAllAudio() {
        return this.files;
    }
}

