/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementStyle;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;

public final class Tile
extends UnitLocation
implements Named,
Ownable {
    private static final Logger logger = Logger.getLogger(Tile.class.getName());
    public static final String TAG = "tile";
    public static final Comparator<Tile> edgeDistanceComparator = Comparator.comparingInt(Tile::getEdgeDistance);
    public static final Comparator<Tile> highSeasComparator = Comparator.comparingInt(Tile::getHighSeasCount);
    public static final Predicate<Tile> isSeaTile = t -> !t.isLand() && t.getHighSeasCount() >= 0;
    public static final String UNIT_CHANGE = "TILE_UNIT_CHANGE";
    public static final int FLAG_RECALCULATE = Integer.MAX_VALUE;
    private static final int LOW_PRODUCTION_WARNING_VALUE = 4;
    public static final int NEAR_RADIUS = 8;
    public static final int OVERLAY_ZINDEX = 100;
    public static final int FOREST_ZINDEX = 200;
    public static final int RESOURCE_ZINDEX = 400;
    public static final int RUMOUR_ZINDEX = 500;
    private TileType type;
    private int x;
    private int y;
    private Player owner;
    private Settlement settlement;
    private Settlement owningSettlement;
    private TileItemContainer tileItemContainer;
    private Region region;
    private int highSeasCount = -1;
    private Boolean moveToEurope;
    private int style;
    private int contiguity = -1;
    private final java.util.Map<Player, Tile> cachedTiles;
    private final java.util.Map<Player, IndianSettlementInternals> playerIndianSettlements;
    private static final String CACHED_TILE_TAG = "cachedTile";
    private static final String CONNECTED_TAG = "connected";
    private static final String CONTIGUITY_TAG = "contiguity";
    private static final String COPIED_TAG = "copied";
    private static final String MOVE_TO_EUROPE_TAG = "moveToEurope";
    private static final String OWNER_TAG = "owner";
    private static final String OWNING_SETTLEMENT_TAG = "owningSettlement";
    private static final String PLAYER_TAG = "player";
    private static final String REGION_TAG = "region";
    private static final String STYLE_TAG = "style";
    private static final String TYPE_TAG = "type";
    private static final String X_TAG = "x";
    private static final String Y_TAG = "y";
    public static final String OLD_PLAYER_EXPLORED_TILE_TAG = "playerExploredTile";
    public static final String OLD_TILE_ITEM_CONTAINER_TAG = "tileitemcontainer";

    public Tile(Game game, TileType type, int locX, int locY) {
        super(game);
        this.type = type;
        this.x = locX;
        this.y = locY;
        this.owningSettlement = null;
        this.settlement = null;
        if (game.isInServer()) {
            this.cachedTiles = new HashMap<Player, Tile>();
            this.playerIndianSettlements = new HashMap<Player, IndianSettlementInternals>();
        } else {
            this.cachedTiles = null;
            this.playerIndianSettlements = null;
        }
    }

    public Tile(Game game, String id) {
        super(game, id);
        if (game.isInServer()) {
            this.cachedTiles = new HashMap<Player, Tile>();
            this.playerIndianSettlements = new HashMap<Player, IndianSettlementInternals>();
        } else {
            this.cachedTiles = null;
            this.playerIndianSettlements = null;
        }
    }

    public TileType getType() {
        return this.type;
    }

    public void setType(TileType t) {
        this.type = t;
    }

    public boolean isExplored() {
        return this.type != null;
    }

    public boolean isLand() {
        return this.type != null && !this.type.isWater();
    }

    public boolean isForested() {
        return this.type != null && this.type.isForested();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Map getMap() {
        return this.getGame().getMap();
    }

    @Override
    public Settlement getSettlement() {
        return this.settlement;
    }

    public void setSettlement(Settlement settlement) {
        this.settlement = settlement;
    }

    public boolean hasSettlement() {
        return this.settlement != null;
    }

    public Settlement getOwningSettlement() {
        return this.owningSettlement;
    }

    public void setOwningSettlement(Settlement owner) {
        this.owningSettlement = owner;
    }

    public TileItemContainer getTileItemContainer() {
        return this.tileItemContainer;
    }

    public void setTileItemContainer(TileItemContainer newTileItemContainer) {
        this.tileItemContainer = newTileItemContainer;
    }

    public List<TileItem> getCompleteItems() {
        return this.tileItemContainer == null ? Collections.emptyList() : this.tileItemContainer.getCompleteItems();
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region newRegion) {
        this.region = newRegion;
    }

    public Region getDiscoverableRegion() {
        return this.region == null ? null : this.region.getDiscoverableRegion();
    }

    public boolean isHighSeasConnected() {
        return this.highSeasCount >= 0;
    }

    public int getHighSeasCount() {
        return this.highSeasCount;
    }

    public void setHighSeasCount(int count) {
        this.highSeasCount = count;
    }

    public boolean isCoastland() {
        return this.isLand() && this.getHighSeasCount() > 0;
    }

    public Boolean getMoveToEurope() {
        return this.moveToEurope;
    }

    public void setMoveToEurope(Boolean moveToEurope) {
        this.moveToEurope = moveToEurope;
    }

    public boolean isDirectlyHighSeasConnected() {
        return this.moveToEurope != null ? this.moveToEurope : (this.type == null ? false : this.type.isDirectlyHighSeasConnected());
    }

    public boolean isRiverCorner() {
        List<Tile> tiles = CollectionUtils.transform(this.getSurroundingTiles(0, 1), Tile::isOnRiver);
        switch (tiles.size()) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: {
                return tiles.get(0).isAdjacent(tiles.get(1));
            }
            case 3: {
                return tiles.get(0).isAdjacent(tiles.get(1)) || tiles.get(1).isAdjacent(tiles.get(2)) || tiles.get(2).isAdjacent(tiles.get(0));
            }
        }
        return true;
    }

    private int getEdgeDistance() {
        Map map = this.getMap();
        int x = this.getX();
        int y = this.getY();
        return Math.min(Math.min(x, map.getWidth() - x), Math.min(y, map.getHeight() - y));
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int newStyle) {
        this.style = newStyle;
    }

    public int getContiguity() {
        return this.contiguity;
    }

    public void setContiguity(int contiguity) {
        this.contiguity = contiguity;
    }

    public boolean isConnectedTo(Tile other) {
        return this.getContiguity() == other.getContiguity();
    }

    public Set<Tile> getContiguityAdjacent(int contiguity) {
        return CollectionUtils.transform(this.getSurroundingTiles(1, 1), CollectionUtils.matchKey(contiguity, Tile::getContiguity), Function.identity(), Collectors.toSet());
    }

    public boolean isOnRiver() {
        TileType greatRiver = this.getSpecification().getTileType("model.tile.greatRiver");
        TileType ocean = this.getSpecification().getTileType("model.tile.ocean");
        boolean ret = this.getType() == greatRiver;
        for (Tile t : this.getSurroundingTiles(1)) {
            if (t.getType() == ocean) {
                return false;
            }
            ret |= t.getType() == greatRiver;
        }
        return ret;
    }

    public boolean isBlocked(Unit unit) {
        Player owner = unit.getOwner();
        Unit u = this.getFirstUnit();
        if (u != null && !owner.owns(u)) {
            return true;
        }
        if (this.isLand()) {
            Settlement s = this.getSettlement();
            if (unit.isNaval()) {
                return s == null || !owner.owns(s);
            }
            return s != null && !owner.owns(s);
        }
        return !unit.isNaval();
    }

    private IndianSettlementInternals getPlayerIndianSettlement(Player player) {
        return this.playerIndianSettlements == null ? null : this.playerIndianSettlements.get(player);
    }

    public List<TileImprovement> getTileImprovements() {
        return this.tileItemContainer == null ? Collections.emptyList() : this.tileItemContainer.getImprovements();
    }

    public List<TileImprovement> getCompleteTileImprovements() {
        return this.tileItemContainer == null ? Collections.emptyList() : this.tileItemContainer.getCompleteImprovements();
    }

    public boolean hasTileImprovement(TileImprovementType type) {
        return type.isChangeType() ? type.changeContainsTarget(this.getType()) : (this.tileItemContainer == null ? false : this.tileItemContainer.hasImprovement(type));
    }

    public TileImprovement getTileImprovement(TileImprovementType type) {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getImprovement(type);
    }

    public boolean hasLostCityRumour() {
        return this.tileItemContainer != null && this.tileItemContainer.getLostCityRumour() != null;
    }

    public LostCityRumour getLostCityRumour() {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getLostCityRumour();
    }

    public boolean hasResource() {
        return this.tileItemContainer != null && this.tileItemContainer.getResource() != null;
    }

    public boolean hasRiver() {
        return this.getRiver() != null;
    }

    public TileImprovement getRiver() {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getRiver();
    }

    public TileImprovementStyle getRiverStyle() {
        TileImprovement river;
        return this.tileItemContainer == null ? null : ((river = this.tileItemContainer.getRiver()) == null ? null : river.getStyle());
    }

    public boolean hasRoad() {
        return this.getRoad() != null;
    }

    public TileImprovement getRoad() {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getRoad();
    }

    private boolean addTileItem(TileItem item) {
        TileItem added;
        if (item == null) {
            return false;
        }
        if (this.tileItemContainer == null) {
            this.tileItemContainer = new TileItemContainer(this.getGame(), this);
        }
        return (added = this.tileItemContainer.tryAddTileItem(item)) != null;
    }

    private <T extends TileItem> T removeTileItem(T item) {
        if (item == null || this.tileItemContainer == null) {
            return null;
        }
        return this.tileItemContainer.removeTileItem(item);
    }

    public void addLostCityRumour(LostCityRumour rumour) {
        this.addTileItem(rumour);
    }

    public LostCityRumour removeLostCityRumour() {
        return this.removeTileItem(this.getLostCityRumour());
    }

    public TileImprovement addRiver(int magnitude, String conns) {
        if (magnitude == 0) {
            return null;
        }
        TileImprovementType riverType = this.getSpecification().getTileImprovementType("model.improvement.river");
        TileImprovement river = new TileImprovement(this.getGame(), this, riverType, TileImprovementStyle.getInstance("0000"));
        river.setTurnsToComplete(0);
        river.setMagnitude(magnitude);
        river.updateRiverConnections(conns);
        return this.addTileItem(river) ? this.getRiver() : null;
    }

    public void removeRiver() {
        TileImprovement river = this.getRiver();
        if (river == null) {
            return;
        }
        river.updateRiverConnections(null);
        this.removeTileItem(river);
    }

    public TileImprovement addRoad() {
        TileImprovementType roadType = this.getSpecification().getTileImprovementType("model.improvement.road");
        TileImprovement road = new TileImprovement(this.getGame(), this, roadType, TileImprovementStyle.getInstance("00000000"));
        road.setMagnitude(1);
        return this.addTileItem(road) ? road : null;
    }

    public TileImprovement removeRoad() {
        TileImprovement road = this.getRoad();
        if (road == null) {
            return null;
        }
        road.updateRoadConnections(false);
        return this.removeTileItem(road);
    }

    public Resource getResource() {
        return this.tileItemContainer == null ? null : this.tileItemContainer.getResource();
    }

    public void addResource(Resource resource) {
        this.addTileItem(resource);
    }

    public Resource removeResource() {
        Resource resource = this.getResource();
        if (resource == null) {
            return null;
        }
        return this.removeTileItem(resource);
    }

    public int getWorkAmount(TileImprovementType workType) {
        return workType == null ? -1 : (this.getTileImprovement(workType) != null ? -1 : this.getType().getBasicWorkTurns() + workType.getAddWorkTurns());
    }

    public boolean isImprovementTypeAllowed(TileImprovementType type) {
        TileImprovement ti;
        return type != null && type.isTileTypeAllowed(this.getType()) && ((ti = this.getTileImprovement(type)) == null || !ti.isComplete());
    }

    public boolean isImprovementAllowed(TileImprovement tip) {
        TileImprovementType type = tip.getType();
        if (!this.isImprovementTypeAllowed(type)) {
            return false;
        }
        TileImprovementType req = type.getRequiredImprovementType();
        if (req != null && this.getTileImprovement(req) == null) {
            return false;
        }
        TileImprovement ti = this.getTileImprovement(type);
        return ti == null || !ti.isComplete();
    }

    public Stream<RandomChoice<Disaster>> getDisasterChoices() {
        return CollectionUtils.concat(this.type.getDisasterChoices(), CollectionUtils.flatten(this.getCompleteTileImprovements(), TileImprovement::getDisasterChoices));
    }

    public StringTemplate getLabel() {
        List<TileItem> keys;
        StringTemplate label;
        StringTemplate stringTemplate = label = this.type != null ? StringTemplate.key(this.type) : StringTemplate.key("unexplored");
        if (this.tileItemContainer != null && !(keys = this.tileItemContainer.getCompleteItems()).isEmpty()) {
            label = StringTemplate.label("/").addNamed(this.type);
            for (Named named : keys) {
                label.addNamed(named);
            }
        }
        return label;
    }

    public StringTemplate getSimpleLabel() {
        return ((StringTemplate)StringTemplate.template("model.tile.simpleLabel").addAmount("%x%", this.getX())).addAmount("%y%", this.getY());
    }

    private StringTemplate getNearLocationLabel(Direction direction, StringTemplate location) {
        return ((StringTemplate)StringTemplate.template("model.tile.nearLocation").addNamed("%direction%", direction)).addStringTemplate("%location%", location);
    }

    private StringTemplate getDetailedLocationLabel() {
        Settlement nearSettlement = null;
        for (Tile tile : this.getSurroundingTiles(8)) {
            nearSettlement = tile.getSettlement();
            if (nearSettlement == null || nearSettlement.getName() == null) continue;
            Direction d = Map.getRoughDirection(tile, this);
            StringTemplate t = StringTemplate.template("model.tile.nameLocation");
            if (d == null) {
                t.addName("%location%", nearSettlement.getName());
            } else {
                t.addStringTemplate("%location%", this.getNearLocationLabel(d, nearSettlement.getLocationLabel()));
            }
            if (this.type == null) {
                t.add("%name%", "unexplored");
            } else {
                t.addNamed("%name%", this.type);
            }
            return t;
        }
        return this.region != null && this.region.getName() != null ? ((StringTemplate)StringTemplate.template("model.tile.nameLocation").addNamed("%name%", this.type)).addStringTemplate("%location%", this.region.getLabel()) : this.getSimpleLabel();
    }

    private StringTemplate getDetailedLocationLabelFor(Player player) {
        Settlement nearSettlement = null;
        for (Tile tile : this.getSurroundingTiles(8)) {
            nearSettlement = tile.getSettlement();
            if (nearSettlement == null || !nearSettlement.hasContacted(player)) continue;
            Direction d = Map.getRoughDirection(tile, this);
            Object t = StringTemplate.template("model.tile.nameLocation").addStringTemplate("%location%", d == null ? nearSettlement.getLocationLabelFor(player) : this.getNearLocationLabel(d, nearSettlement.getLocationLabelFor(player)));
            if (this.type == null) {
                ((StringTemplate)t).add("%name%", "unexplored");
            } else {
                ((StringTemplate)t).addNamed("%name%", this.type);
            }
            return t;
        }
        return this.region != null && this.region.getName() != null ? ((StringTemplate)StringTemplate.template("model.tile.nameLocation").addNamed("%name%", this.type)).addStringTemplate("%location%", this.region.getLabel()) : this.getSimpleLabel();
    }

    public StringTemplate getColonyTileLocationLabel(Colony colony) {
        Tile ct = colony.getTile();
        StringTemplate t = StringTemplate.template("model.tile.nameLocation");
        if (ct == this) {
            t.addStringTemplate("%location%", StringTemplate.key("colonyCenter"));
        } else {
            Direction d = this.getMap().getDirection(ct, this);
            if (d == null) {
                return null;
            }
            t.addNamed("%location%", d);
        }
        if (this.type == null) {
            t.add("%name%", "unexplored");
        } else {
            t.addNamed("%name%", this.type);
        }
        return t;
    }

    public int getDistanceTo(Tile tile) {
        return this.getMap().getDistance(this, tile);
    }

    public Direction getDirection(Tile tile) {
        return this.getMap().getDirection(this, tile);
    }

    public Tile getNeighbourOrNull(Direction direction) {
        return this.getMap().getAdjacentTile(this.x, this.y, direction);
    }

    public boolean isAdjacent(Tile tile) {
        return tile == null ? false : CollectionUtils.any(this.getSurroundingTiles(1, 1), CollectionUtils.matchKey(tile));
    }

    public boolean isPolar() {
        return this.getMap().isPolar(this);
    }

    public boolean isLandLocked() {
        return !this.isLand() ? false : CollectionUtils.all(this.getSurroundingTiles(1, 1), Tile::isLand);
    }

    public boolean isShore() {
        return CollectionUtils.any(this.getSurroundingTiles(1, 1), t -> t.isLand() != this.isLand());
    }

    public boolean isGoodHillTile() {
        return this.isLand() && !this.getType().isElevation() && CollectionUtils.all(this.getSurroundingTiles(1, 1), Tile::isLand);
    }

    public boolean isGoodMountainTile(TileType mountains) {
        return this.isGoodHillTile() && CollectionUtils.none(this.getSurroundingTiles(1, 3), t -> t.getType() == mountains);
    }

    public boolean isGoodRiverTile(TileImprovementType riverType) {
        return riverType.isTileTypeAllowed(this.getType()) && CollectionUtils.all(this.getSurroundingTiles(1, 2), Tile::isLand);
    }

    public Iterable<Tile> getSurroundingTiles(int range) {
        return this.getMap().getCircleTiles(this, true, range);
    }

    public List<Tile> getSurroundingTiles(int rangeMin, int rangeMax) {
        ArrayList<Tile> result = new ArrayList<Tile>();
        if (rangeMin > rangeMax || rangeMin < 0) {
            return result;
        }
        if (rangeMin == 0) {
            result.add(this);
        }
        if (rangeMax > 0) {
            for (Tile t : this.getSurroundingTiles(rangeMax)) {
                result.add(t);
            }
        }
        if (rangeMin > 1) {
            for (Tile t : this.getSurroundingTiles(rangeMin - 1)) {
                result.remove(t);
            }
        }
        return result;
    }

    public boolean hasUnexploredAdjacent() {
        return !CollectionUtils.all(this.getSurroundingTiles(1, 1), Tile::isExplored);
    }

    public int getAvailableAdjacentCount() {
        return CollectionUtils.count(this.getSurroundingTiles(1, 1), CollectionUtils.matchKey(this.isLand(), Tile::isLand));
    }

    public List<Colony> getAdjacentColonies() {
        return CollectionUtils.transform(this.getSurroundingTiles(0, 1), CollectionUtils.isNotNull(UnitLocation::getColony), UnitLocation::getColony);
    }

    public Settlement getNearestSettlement(Player owner, int radius, boolean same) {
        if (radius <= 0) {
            radius = Integer.MAX_VALUE;
        }
        Map map = this.getMap();
        for (Tile t : map.getCircleTiles(this, true, radius)) {
            Settlement settlement;
            if (t == this || same && !this.isConnectedTo(t) || (settlement = t.getSettlement()) == null || owner != null && !owner.owns(settlement)) continue;
            return settlement;
        }
        return null;
    }

    public Tile getSafeTile(Player player, Random random) {
        if (!(this.getFirstUnit() != null && this.getFirstUnit().getOwner() != player || this.hasSettlement() && this.getSettlement().getOwner() != player)) {
            return this;
        }
        int r = 1;
        List<Tile> tiles;
        while (!(tiles = this.getSurroundingTiles(r, r)).isEmpty()) {
            if (random != null) {
                RandomUtils.randomShuffle(logger, "Safe tile", tiles, random);
            }
            for (Tile t : tiles) {
                if (t.getFirstUnit() != null && t.getFirstUnit().getOwner() != player || t.getSettlement() != null && t.getSettlement().getOwner() != player) continue;
                return t;
            }
            ++r;
        }
        return null;
    }

    public double getDefenceValue() {
        TileType type = this.getType();
        return type == null ? 0.0 : (double)Tile.applyModifiers(1.0f, null, type.getDefenceModifiers());
    }

    public int getDefenceBonusPercentage() {
        return (int)this.getType().apply(100.0f, this.getGame().getTurn(), "model.modifier.defence") - 100;
    }

    public List<Tile> getSafestSurroundingLandTiles(Player player) {
        Predicate<Tile> safeTilePred = t -> t.isLand() && (!t.hasSettlement() || player.owns(t.getSettlement()));
        Comparator<Tile> defenceComp = CollectionUtils.cachingDoubleComparator(Tile::getDefenceValue).reversed();
        return CollectionUtils.transform(this.getSurroundingTiles(0, 1), safeTilePred, Function.identity(), defenceComp);
    }

    public Tile getBestDisembarkTile(Player player) {
        return CollectionUtils.find(this.getSafestSurroundingLandTiles(player), Tile::isHighSeasConnected);
    }

    public boolean isDangerousToShip(Unit ship) {
        Player player = ship.getOwner();
        Predicate<Tile> dangerPred = t -> {
            Settlement settlement = t.getSettlement();
            return settlement == null ? false : !player.owns(settlement) && settlement.canBombardEnemyShip() && (player.atWarWith(settlement.getOwner()) || ship.hasAbility("model.ability.piracy"));
        };
        return CollectionUtils.any(this.getSurroundingTiles(0, 1), dangerPred);
    }

    public List<Tile> getSafeAnchoringTiles(Unit unit) {
        return CollectionUtils.transform(this.getSurroundingTiles(0, 1), t -> !t.isLand() && t.isHighSeasConnected() && !t.isDangerousToShip(unit));
    }

    public void changeType(TileType type) {
        this.setType(type);
        if (this.tileItemContainer != null) {
            this.tileItemContainer.removeIncompatibleImprovements();
        }
        if (!this.isLand()) {
            this.settlement = null;
        }
        this.updateColonyTiles();
    }

    public boolean isInUse() {
        return this.getOwningSettlement() instanceof Colony && ((Colony)this.getOwningSettlement()).isTileInUse(this);
    }

    public void changeOwningSettlement(Settlement settlement) {
        if (this.owningSettlement != null) {
            this.owningSettlement.removeTile(this);
        }
        this.setOwningSettlement(settlement);
        if (settlement != null) {
            settlement.addTile(this);
        }
    }

    public void changeOwnership(Player player, Settlement settlement) {
        this.setOwner(player);
        this.changeOwningSettlement(settlement);
    }

    public StringTemplate getBuildColonyWarnings(Unit unit) {
        int food;
        Specification spec = this.getSpecification();
        Player owner = unit.getOwner();
        boolean landLocked = true;
        boolean ownedByEuropeans = false;
        boolean ownedBySelf = false;
        boolean ownedByIndians = false;
        List<GoodsType> typeList = spec.getGoodsTypeList();
        HashMap<GoodsType, Integer> goodsMap = new HashMap<GoodsType, Integer>(typeList.size());
        for (GoodsType goodsType : typeList) {
            if (goodsType.isBuildingMaterial()) {
                while (goodsType.isRefined()) {
                    goodsType = goodsType.getInputType();
                }
            } else if (!goodsType.isFoodType()) continue;
            goodsMap.put(goodsType, 0);
        }
        for (ProductionType productionType : this.getType().getAvailableProductionTypes(true)) {
            for (AbstractGoods ag : productionType.getOutputList()) {
                GoodsType goodsType = ag.getType();
                if (!goodsMap.containsKey(goodsType)) continue;
                int potential = this.getPotentialProduction(goodsType, null);
                Integer oldPotential = (Integer)goodsMap.get(goodsType);
                if (oldPotential != null && potential <= oldPotential) continue;
                goodsMap.put(goodsType, potential);
            }
        }
        block4: for (Tile t : this.getSurroundingTiles(1)) {
            if (!t.isLand()) {
                landLocked = false;
            }
            CollectionUtils.forEachMapEntry(goodsMap, e -> e.setValue((Integer)e.getValue() + t.getPotentialProduction((GoodsType)e.getKey(), spec.getDefaultUnitType(owner))));
            Player tileOwner = t.getOwner();
            if (owner == tileOwner) {
                if (t.getOwningSettlement() != null) {
                    ownedBySelf = true;
                    continue;
                }
                for (Tile ownTile : t.getSurroundingTiles(1)) {
                    Colony colony = ownTile.getColony();
                    if (colony == null || colony.getOwner() != owner) continue;
                    ownedBySelf = true;
                    continue block4;
                }
                continue;
            }
            if (tileOwner != null && tileOwner.isEuropean()) {
                ownedByEuropeans = true;
                continue;
            }
            if (tileOwner == null) continue;
            ownedByIndians = true;
        }
        StringTemplate ret = StringTemplate.label("\n");
        if (landLocked) {
            ret.add("warning.landLocked");
        }
        if ((food = CollectionUtils.sum(goodsMap.entrySet(), e -> ((GoodsType)e.getKey()).isFoodType(), Map.Entry::getValue)) < 8) {
            ret.add("warning.noFood");
        }
        Predicate loPred = e -> !((GoodsType)e.getKey()).isFoodType() && (Integer)e.getValue() < 4;
        CollectionUtils.forEachMapEntry(goodsMap, loPred, e -> ret.addStringTemplate((StringTemplate)StringTemplate.template("warning.noBuildingMaterials").addNamed("%goods%", (Named)e.getKey())));
        if (ownedBySelf) {
            ret.add("warning.ownLand");
        }
        if (ownedByEuropeans) {
            ret.add("warning.europeanLand");
        }
        if (ownedByIndians) {
            ret.add("warning.nativeLand");
        }
        return ret;
    }

    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        return this.type != null && this.type.canProduce(goodsType, unitType) || this.tileItemContainer != null && this.tileItemContainer.canProduce(goodsType, unitType);
    }

    public int getBaseProduction(ProductionType productionType, GoodsType goodsType, UnitType unitType) {
        if (this.type == null || goodsType == null || !goodsType.isFarmed()) {
            return 0;
        }
        int amount = this.type.getBaseProduction(productionType, goodsType, unitType);
        return amount < 0 ? 0 : amount;
    }

    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        if (!this.canProduce(goodsType, unitType)) {
            return 0;
        }
        int amount = this.getBaseProduction(null, goodsType, unitType);
        return (amount = (int)Tile.applyModifiers((float)amount, this.getGame().getTurn(), this.getProductionModifiers(goodsType, unitType))) < 0 ? 0 : amount;
    }

    public Stream<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        return this.tileItemContainer != null && this.canProduce(goodsType, unitType) ? this.tileItemContainer.getProductionModifiers(goodsType, unitType) : Stream.empty();
    }

    private int getMaximumPotential(GoodsType goodsType, UnitType unitType, TileType tileType) {
        float potential = tileType.getPotentialProduction(goodsType, unitType);
        if (tileType == this.getType()) {
            Resource resource;
            Resource resource2 = resource = this.tileItemContainer == null ? null : this.tileItemContainer.getResource();
            if (resource != null) {
                potential = resource.applyBonus(goodsType, unitType, (int)potential);
            }
        }
        List<TileImprovementType> improvements = this.getSpecification().getTileImprovementTypeList();
        for (TileImprovementType ti2 : CollectionUtils.transform(improvements, ti -> !ti.isNatural() && ti.isTileTypeAllowed(tileType) && ti.getBonus(goodsType) > 0)) {
            potential = ti2.getProductionModifier(goodsType).applyTo(potential);
        }
        return (int)potential;
    }

    public int getMaximumPotential(GoodsType goodsType, UnitType unitType) {
        List<TileImprovementType> improvements = this.getSpecification().getTileImprovementTypeList();
        List<TileType> tileTypes = CollectionUtils.transform(improvements, ti -> !ti.isNatural() && ti.getChange(this.getType()) != null, ti -> ti.getChange(this.getType()));
        tileTypes.add(0, this.getType());
        return CollectionUtils.max(tileTypes, tt -> this.getMaximumPotential(goodsType, unitType, (TileType)tt));
    }

    public List<AbstractGoods> getSortedPotential() {
        return this.getSortedPotential(null, null);
    }

    public List<AbstractGoods> getSortedPotential(Unit unit) {
        return this.getSortedPotential(unit.getType(), unit.getOwner());
    }

    public List<AbstractGoods> getSortedPotential(UnitType unitType, Player owner) {
        if (this.getType() == null) {
            return Collections.emptyList();
        }
        ToIntFunction<GoodsType> productionMapper = CollectionUtils.cacheInt(gt -> this.getPotentialProduction((GoodsType)gt, unitType));
        Predicate<GoodsType> productionPred = gt -> productionMapper.applyAsInt((GoodsType)gt) > 0;
        Function<GoodsType, AbstractGoods> goodsMapper = gt -> new AbstractGoods((GoodsType)gt, productionMapper.applyAsInt((GoodsType)gt));
        Comparator<AbstractGoods> goodsComp = owner == null || owner.getMarket() == null ? AbstractGoods.descendingAmountComparator : owner.getMarket().getSalePriceComparator();
        return CollectionUtils.transform(this.getSpecification().getFarmedGoodsTypeList(), productionPred, goodsMapper, goodsComp);
    }

    public AbstractGoods getBestFoodProduction() {
        Comparator<AbstractGoods> goodsComp = Comparator.comparingInt(ag -> this.getPotentialProduction(ag.getType(), null));
        return CollectionUtils.maximize(CollectionUtils.flatten(this.getType().getAvailableProductionTypes(true), ProductionType::getOutputs), AbstractGoods::isFoodType, goodsComp);
    }

    private void updateColonyTiles() {
        WorkLocation wl = CollectionUtils.find(CollectionUtils.flatten(this.getGame().getAllColonies(null), Colony::getAvailableWorkLocations), CollectionUtils.matchKey(this, WorkLocation::getWorkTile));
        if (wl != null) {
            wl.updateProductionType();
        }
    }

    private java.util.Map<Player, Tile> getCachedTiles() {
        return this.cachedTiles;
    }

    private void setCachedTiles(java.util.Map<Player, Tile> cachedTiles) {
        if (this.cachedTiles != null) {
            this.cachedTiles.clear();
            if (cachedTiles != null) {
                this.cachedTiles.putAll(cachedTiles);
            }
        }
    }

    private Tile getCachedTile(Player player) {
        return this.cachedTiles == null ? null : (player.isEuropean() ? this.cachedTiles.get(player) : this);
    }

    public void setCachedTile(Player player, Tile tile) {
        if (this.cachedTiles == null || !player.isEuropean()) {
            return;
        }
        this.cachedTiles.put(player, tile);
    }

    public void seeTile() {
        for (Player p2 : CollectionUtils.transform(this.getGame().getLiveEuropeanPlayers(new Player[0]), p -> p.canSee(this))) {
            this.seeTile(p2);
        }
    }

    public void seeTile(Player player) {
        this.setCachedTile(player, this);
    }

    public Tile getTileToCache() {
        Tile tile = (Tile)this.copy(this.getGame());
        tile.clearUnitList();
        Colony colony = this.getColony();
        if (colony != null) {
            tile.getColony().setDisplayUnitCount(Math.max(1, colony.getUnitCount()));
        }
        return tile;
    }

    public void cacheUnseen() {
        this.cacheUnseen(null, null);
    }

    public void cacheUnseen(Player player) {
        this.cacheUnseen(player, null);
    }

    public void cacheUnseen(Tile copied) {
        this.cacheUnseen(null, copied);
    }

    private void cacheUnseen(Player player, Tile copied) {
        if (this.cachedTiles == null) {
            return;
        }
        for (Player p2 : CollectionUtils.transform(this.getGame().getLiveEuropeanPlayers(player), p -> !p.canSee(this) && this.getCachedTile((Player)p) == this)) {
            if (copied == null) {
                copied = this.getTileToCache();
            }
            this.setCachedTile(p2, copied);
        }
    }

    public void updateIndianSettlement(Player player) {
        if (this.playerIndianSettlements == null || !player.isEuropean()) {
            return;
        }
        IndianSettlementInternals isi = this.getPlayerIndianSettlement(player);
        IndianSettlement is = this.getIndianSettlement();
        if (is == null) {
            if (isi != null) {
                this.removeIndianSettlementInternals(player);
            }
        } else {
            if (isi == null) {
                isi = new IndianSettlementInternals();
                this.playerIndianSettlements.put(player, isi);
            }
            isi.update(is);
        }
    }

    public void removeIndianSettlementInternals(Player player) {
        if (this.playerIndianSettlements == null) {
            return;
        }
        this.playerIndianSettlements.remove(player);
    }

    public UnitType getLearnableSkill(Player player) {
        IndianSettlementInternals isi = this.getPlayerIndianSettlement(player);
        return isi == null ? null : isi.skill;
    }

    public List<GoodsType> getWantedGoods(Player player) {
        IndianSettlementInternals isi = this.getPlayerIndianSettlement(player);
        return isi == null ? null : isi.wantedGoods;
    }

    private void setIndianSettlementInternals(Player player, UnitType skill, List<GoodsType> wanted) {
        IndianSettlementInternals isi = this.getPlayerIndianSettlement(player);
        if (isi == null) {
            isi = new IndianSettlementInternals();
            this.playerIndianSettlements.put(player, isi);
        }
        isi.setValues(skill, wanted);
    }

    public boolean isExploredBy(Player player) {
        return !player.isEuropean() ? true : (!this.isExplored() ? false : (this.cachedTiles == null ? true : this.getCachedTile(player) != null));
    }

    public void setExplored(Player player, boolean reveal) {
        if (this.cachedTiles == null || !player.isEuropean()) {
            return;
        }
        if (reveal) {
            this.seeTile(player);
        } else {
            this.cachedTiles.remove(player);
        }
    }

    public Unit getDefendingUnit(Unit attacker) {
        double power;
        CombatModel cm = this.getGame().getCombatModel();
        Unit defender = null;
        double defenderPower = -1.0;
        for (Unit u2 : CollectionUtils.transform(this.getUnits(), u -> this.isLand() != u.isNaval())) {
            if (!Unit.betterDefender(defender, defenderPower, u2, power = cm.getDefencePower(attacker, u2))) continue;
            defender = u2;
            defenderPower = power;
        }
        if ((defender == null || !defender.isDefensiveUnit()) && this.hasSettlement()) {
            Unit u3 = null;
            try {
                u3 = this.settlement.getDefendingUnit(attacker);
            }
            catch (IllegalStateException e) {
                logger.log(Level.WARNING, "Empty settlement: " + this.settlement.getName(), e);
            }
            if (u3 != null && Unit.betterDefender(defender, defenderPower, u3, power = cm.getDefencePower(attacker, u3))) {
                defender = u3;
            }
        }
        if (defender == null && this.isLand()) {
            defender = this.getFirstUnit();
        }
        return defender;
    }

    public Unit getOccupyingUnit() {
        Unit unit = this.getFirstUnit();
        Player owner = null;
        if (this.getOwningSettlement() != null) {
            owner = this.getOwningSettlement().getOwner();
        }
        return owner != null && unit != null && unit.getOwner() != owner && unit.getOwner().atWarWith(owner) ? CollectionUtils.find(this.getUnits(), Unit::isOffensiveUnit) : null;
    }

    public boolean isOccupied() {
        return this.getOccupyingUnit() != null;
    }

    @Override
    public Tile getTile() {
        return this;
    }

    @Override
    public StringTemplate getLocationLabel() {
        return this.settlement != null ? this.settlement.getLocationLabel() : this.getDetailedLocationLabel();
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        return this.settlement != null ? this.settlement.getLocationLabelFor(player) : this.getDetailedLocationLabelFor(player);
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof TileItem) {
            return this.addTileItem((TileItem)locatable);
        }
        if (locatable instanceof Unit) {
            if (super.add(locatable)) {
                ((Unit)locatable).setState(Unit.UnitState.ACTIVE);
                return true;
            }
            return false;
        }
        return super.add(locatable);
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable instanceof TileItem) {
            return this.removeTileItem((TileItem)locatable) == locatable;
        }
        return super.remove(locatable);
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof TileItem) {
            return this.tileItemContainer != null && this.tileItemContainer.contains((TileItem)locatable);
        }
        return super.contains(locatable);
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable instanceof Unit) {
            return ((Unit)locatable).isTileAccessible(this);
        }
        if (locatable instanceof TileImprovement) {
            return ((TileImprovement)locatable).getType().isTileTypeAllowed(this.getType());
        }
        return false;
    }

    @Override
    public Location up() {
        return this.hasSettlement() ? this.getSettlement() : this;
    }

    @Override
    public int getRank() {
        return this.getX() + this.getY() * this.getMap().getWidth();
    }

    @Override
    public String toShortString() {
        StringBuilder sb = new StringBuilder(16);
        TileType type = this.getType();
        sb.append(this.getX()).append(',').append(this.getY()).append('-').append(type == null ? "?" : type.getSuffix());
        return sb.toString();
    }

    @Override
    public String getNameKey() {
        if (this.getGame().isInClient()) {
            return this.isExplored() ? this.getType().getNameKey() : "unexplored";
        }
        Player player = this.getGame().getCurrentPlayer();
        if (player != null) {
            return this.getCachedTile(player) == null ? "unexplored" : this.getType().getNameKey();
        }
        logger.warning("player == null");
        return "";
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player owner) {
        this.owner = owner;
    }

    @Override
    public void disposeResources() {
        if (this.settlement != null) {
            this.settlement.disposeResources();
            this.settlement = null;
        }
        if (this.tileItemContainer != null) {
            this.tileItemContainer.disposeResources();
            this.tileItemContainer = null;
        }
        super.disposeResources();
    }

    @Override
    public FreeColGameObject getLinkTarget(Player player) {
        return this;
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        Settlement settlement = this.getSettlement();
        if (settlement != null) {
            result = result.combine(settlement.checkIntegrity(fix, lb));
        }
        if (this.tileItemContainer != null) {
            result = result.combine(this.tileItemContainer.checkIntegrity(fix, lb));
        }
        if (this.type == null) {
            lb.add("\n  Tile has no type: ", this.getId());
            result = result.fail();
        } else if (this.isLand() && Boolean.TRUE.equals(this.moveToEurope)) {
            lb.add("\n  Tile is land but has move-to-Europe: ", this.getId());
            if (fix) {
                this.moveToEurope = Boolean.FALSE;
                result = result.fix();
            } else {
                result = result.fail();
            }
        }
        return result;
    }

    @Override
    public Stream<Ability> getAbilities(String id, FreeColSpecObjectType fcgot, Turn turn) {
        return this.getType().getAbilities(id, fcgot, turn);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Tile o = this.copyInCast(other, Tile.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.type = o.getType();
        this.x = o.getX();
        this.y = o.getY();
        this.owner = game.updateRef(o.getOwner());
        this.settlement = game.update(o.getSettlement(), true);
        Settlement owning = null;
        if (o.getOwningSettlement() != null && (owning = game.updateRef(o.getOwningSettlement())) == null) {
            owning = game.update(o.getOwningSettlement(), true);
        }
        this.owningSettlement = owning;
        this.tileItemContainer = game.update(o.getTileItemContainer(), true);
        this.region = game.updateRef(o.getRegion());
        this.highSeasCount = o.getHighSeasCount();
        this.moveToEurope = o.getMoveToEurope();
        this.style = o.getStyle();
        this.contiguity = o.getContiguity();
        this.setCachedTiles(o.getCachedTiles());
        return true;
    }

    @Override
    public FreeColObject getDisplayObject() {
        return this.getType();
    }

    @Override
    public void toXML(FreeColXMLWriter xw, String tag) throws XMLStreamException {
        Player player = xw.getClientPlayer();
        if (player == null) {
            this.internalToXML(xw, tag);
        } else {
            Tile tile = this.getCachedTile(player);
            if (tile != null) {
                tile.internalToXML(xw, tag);
            } else if (this.isExploredBy(player)) {
                this.internalToXML(xw, tag);
            } else {
                xw.writeStartElement(tag);
                xw.writeAttribute("id", this.getId());
                xw.writeAttribute(X_TAG, this.x);
                xw.writeAttribute(Y_TAG, this.y);
                xw.writeEndElement();
            }
        }
    }

    private void internalToXML(FreeColXMLWriter xw, String tag) throws XMLStreamException {
        xw.writeStartElement(tag);
        this.writeAttributes(xw);
        this.writeChildren(xw);
        xw.writeEndElement();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(X_TAG, this.x);
        xw.writeAttribute(Y_TAG, this.y);
        xw.writeAttribute(TYPE_TAG, this.type);
        if (this.owner != null) {
            xw.writeAttribute(OWNER_TAG, this.owner);
        }
        if (this.owningSettlement != null) {
            if (this.owningSettlement.isDisposed() || this.owningSettlement.getId() == null) {
                this.owningSettlement = null;
            } else {
                xw.writeAttribute(OWNING_SETTLEMENT_TAG, this.owningSettlement);
            }
        }
        xw.writeAttribute(STYLE_TAG, this.style);
        if (this.region != null) {
            xw.writeAttribute(REGION_TAG, this.region);
        }
        if (this.moveToEurope != null) {
            xw.writeAttribute(MOVE_TO_EUROPE_TAG, this.moveToEurope);
        }
        if (this.highSeasCount >= 0) {
            xw.writeAttribute(CONNECTED_TAG, this.highSeasCount);
        }
        if (this.contiguity >= 0) {
            xw.writeAttribute(CONTIGUITY_TAG, this.contiguity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        Player player = xw.getClientPlayer();
        if ((player == null || player.canSee(this)) && (this.settlement == null || xw.validFor(this.settlement.getOwner()))) {
            super.writeChildren(xw);
        }
        if (this.settlement != null) {
            this.settlement.toXML(xw);
        }
        if (this.tileItemContainer != null) {
            this.tileItemContainer.toXML(xw);
        }
        if (this.cachedTiles != null && xw.validForSave()) {
            for (Player p : this.getGame().getLiveEuropeanPlayerList(new Player[0])) {
                Tile t = this.getCachedTile(p);
                if (t == null) continue;
                if (t == this && this.getIndianSettlement() != null) {
                    t = this.getTileToCache();
                    t.setIndianSettlementInternals(p, this.getLearnableSkill(p), this.getWantedGoods(p));
                }
                xw.writeStartElement(CACHED_TILE_TAG);
                xw.writeAttribute(PLAYER_TAG, p);
                xw.writeAttribute(COPIED_TAG, t != this);
                if (t != this) {
                    FreeColXMLWriter.WriteScope ws = xw.replaceScope(FreeColXMLWriter.WriteScope.toClient(p));
                    try {
                        t.internalToXML(xw, TAG);
                    }
                    finally {
                        xw.replaceScope(ws);
                    }
                }
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        this.x = xr.getAttribute(X_TAG, 0);
        this.y = xr.getAttribute(Y_TAG, 0);
        this.type = xr.getType(spec, TYPE_TAG, TileType.class, null);
        if (this.type == null) {
            this.style = 0;
            this.highSeasCount = -1;
            this.owner = null;
            this.region = null;
            this.moveToEurope = null;
            this.contiguity = -1;
            this.owningSettlement = null;
            return;
        }
        this.style = xr.getAttribute(STYLE_TAG, 0);
        String str = xr.getAttribute(CONNECTED_TAG, null);
        if (str == null || str.isEmpty()) {
            this.highSeasCount = -1;
        } else {
            try {
                this.highSeasCount = Integer.parseInt(str);
            }
            catch (NumberFormatException nfe) {
                this.highSeasCount = -1;
            }
        }
        this.owner = xr.findFreeColGameObject(game, OWNER_TAG, Player.class, null, false);
        this.region = xr.findFreeColGameObject(game, REGION_TAG, Region.class, null, false);
        this.moveToEurope = xr.hasAttribute(MOVE_TO_EUROPE_TAG) ? Boolean.valueOf(xr.getAttribute(MOVE_TO_EUROPE_TAG, false)) : null;
        this.contiguity = xr.getAttribute(CONTIGUITY_TAG, -1);
        Location loc = xr.getLocationAttribute(game, OWNING_SETTLEMENT_TAG, true);
        this.owningSettlement = loc instanceof Settlement ? (Settlement)loc : null;
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.settlement = null;
        super.readChildren(xr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (CACHED_TILE_TAG.equals(tag)) {
            Player player = xr.findFreeColGameObject(game, PLAYER_TAG, Player.class, null, true);
            boolean copied = xr.getAttribute(COPIED_TAG, false);
            if (copied) {
                FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
                try {
                    IndianSettlement is;
                    int apparent;
                    xr.nextTag();
                    xr.expectTag(TAG);
                    Tile tile = xr.readFreeColObject(game, Tile.class);
                    Colony colony = tile.getColony();
                    if (colony != null && (apparent = colony.getApparentUnitCount()) <= 0) {
                        logger.warning("Copied colony " + colony.getId() + " display unit count set to 1 from corrupt: " + apparent);
                        colony.setDisplayUnitCount(1);
                    }
                    if ((is = tile.getIndianSettlement()) == null) {
                        this.removeIndianSettlementInternals(player);
                    } else {
                        this.setIndianSettlementInternals(player, is.getLearnableSkill(), is.getWantedGoods());
                    }
                    this.setCachedTile(player, tile);
                }
                finally {
                    xr.replaceScope(rs);
                }
            } else {
                this.setCachedTile(player, this);
            }
            xr.closeTag(CACHED_TILE_TAG);
        } else if ("colony".equals(tag)) {
            this.settlement = xr.readFreeColObject(game, Colony.class);
        } else if ("indianSettlement".equals(tag)) {
            this.settlement = xr.readFreeColObject(game, IndianSettlement.class);
        } else if (OLD_PLAYER_EXPLORED_TILE_TAG.equals(tag)) {
            Player player = xr.findFreeColGameObject(game, PLAYER_TAG, Player.class, null, true);
            xr.swallowTag(OLD_PLAYER_EXPLORED_TILE_TAG);
            if (player != null) {
                this.setCachedTile(player, this);
            }
        } else if ("tileItemContainer".equals(tag) || OLD_TILE_ITEM_CONTAINER_TAG.equals(tag)) {
            this.tileItemContainer = xr.readFreeColObject(game, TileItemContainer.class);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(this.getId()).append(' ').append(this.type == null ? "unknown" : this.type.getSuffix()).append(' ').append(this.x).append(',').append(this.y).append((String)(!this.hasSettlement() ? "" : " " + this.getSettlement().getName())).append(']');
        return sb.toString();
    }

    private static class IndianSettlementInternals {
        public UnitType skill = null;
        public List<GoodsType> wantedGoods = null;

        private IndianSettlementInternals() {
        }

        public void update(IndianSettlement is) {
            this.setValues(is.getLearnableSkill(), is.getWantedGoods());
        }

        public void setValues(UnitType skill, List<GoodsType> wanted) {
            this.skill = skill;
            if (wanted == null) {
                this.wantedGoods = null;
            } else if (this.wantedGoods == null) {
                this.wantedGoods = new ArrayList<GoodsType>(wanted);
            } else {
                this.wantedGoods.clear();
                this.wantedGoods.addAll(wanted);
            }
        }
    }
}

