/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class IndividualFatherTest
extends FreeColTestCase {
    private static final BuildableType customHouseType = IndividualFatherTest.spec().getBuildingType("model.building.customHouse");
    private static final BuildingType townHallType = IndividualFatherTest.spec().getBuildingType("model.building.townHall");
    private static final FoundingFather bartolomeDeLasCasas = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.bartolomeDeLasCasas");
    private static final FoundingFather hernanCortes = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.hernanCortes");
    private static final FoundingFather janDeWitt = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.janDeWitt");
    private static final FoundingFather jeanDeBrebeuf = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.fatherJeanDeBrebeuf");
    private static final FoundingFather paulRevere = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.paulRevere");
    private static final FoundingFather peterMinuit = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.peterMinuit");
    private static final FoundingFather peterStuyvesant = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.peterStuyvesant");
    private static final FoundingFather simonBolivar = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.simonBolivar");
    private static final FoundingFather thomasJefferson = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.thomasJefferson");
    private static final FoundingFather thomasPaine = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.thomasPaine");
    private static final FoundingFather williamBrewster = IndividualFatherTest.spec().getFoundingFather("model.foundingFather.williamBrewster");
    private static final GoodsType bellsType = IndividualFatherTest.spec().getGoodsType("model.goods.bells");
    private static final GoodsType horsesType = IndividualFatherTest.spec().getGoodsType("model.goods.horses");
    private static final GoodsType musketsType = IndividualFatherTest.spec().getGoodsType("model.goods.muskets");
    private static final Role soldierRole = IndividualFatherTest.spec().getRole("model.role.soldier");
    private static final Role missionaryRole = IndividualFatherTest.spec().getRole("model.role.missionary");
    private static final UnitType servantType = IndividualFatherTest.spec().getUnitType("model.unit.indenturedServant");
    private static final UnitType colonistType = IndividualFatherTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType statesmanType = IndividualFatherTest.spec().getUnitType("model.unit.elderStatesman");
    private static final UnitType nativeConvertType = IndividualFatherTest.spec().getUnitType("model.unit.indianConvert");

    public void testBolivar() {
        Game game = IndividualFatherTest.getGame();
        game.changeMap(IndividualFatherTest.getTestMap(true));
        int pop = 5;
        Colony colony = this.getStandardColony(5);
        Player player = colony.getOwner();
        ArrayList empty = new ArrayList();
        Building townHall = colony.getBuilding(townHallType);
        IndividualFatherTest.assertEquals((int)0, (int)colony.getLiberty());
        IndividualFatherTest.assertEquals((int)0, (int)colony.getSoL());
        int inc = 400;
        colony.addLiberty(inc);
        IndividualFatherTest.assertEquals((int)inc, (int)colony.getLiberty());
        IndividualFatherTest.assertEquals((int)(100 * inc / 1000), (int)colony.getSoL());
        player.addFather(simonBolivar);
        colony.addLiberty(0);
        IndividualFatherTest.assertEquals((int)inc, (int)colony.getLiberty());
        IndividualFatherTest.assertEquals((int)(100 * inc / 1000 + 20), (int)colony.getSoL());
        Modifier bolivarModifier = CollectionUtils.first(player.getModifiers("model.modifier.SoL"));
        IndividualFatherTest.assertNotNull((Object)bolivarModifier);
        IndividualFatherTest.assertEquals((Object)simonBolivar, (Object)bolivarModifier.getSource());
        colony.addLiberty(1000);
        IndividualFatherTest.assertEquals((int)(inc + 1000), (int)player.getLiberty());
        IndividualFatherTest.assertEquals((int)100, (int)player.getSoL());
    }

    public void testBrebeuf() {
        Game game = IndividualFatherTest.getGame();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        String ability = "model.ability.expertMissionary";
        IndividualFatherTest.assertTrue((boolean)jeanDeBrebeuf.hasAbility(ability));
        IndividualFatherTest.assertFalse((boolean)dutch.hasAbility(ability));
        ServerUnit missionary = new ServerUnit(game, null, dutch, colonistType, missionaryRole);
        IndividualFatherTest.assertEquals((Object)missionaryRole, (Object)missionary.getRole());
        IndividualFatherTest.assertTrue((boolean)missionary.hasAbility("model.ability.establishMission"));
        IndividualFatherTest.assertFalse((boolean)missionary.hasAbility(ability));
        dutch.addFather(jeanDeBrebeuf);
        IndividualFatherTest.assertTrue((boolean)dutch.hasAbility(ability));
        IndividualFatherTest.assertTrue((boolean)missionary.hasAbility(ability));
    }

    public void testBrewster() {
        Game game = IndividualFatherTest.getGame();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        String ability = "model.ability.canRecruitUnit";
        IndividualFatherTest.assertTrue((boolean)dutch.hasAbility(ability));
        for (UnitType unitType : IndividualFatherTest.spec().getUnitTypeList()) {
            if (!unitType.isRecruitable()) continue;
            IndividualFatherTest.assertTrue((String)("Unable to recruit " + unitType.toString()), (boolean)dutch.hasAbility(ability, unitType));
        }
        dutch.addFather(williamBrewster);
        IndividualFatherTest.assertFalse((boolean)dutch.hasAbility(ability));
        for (UnitType unitType : IndividualFatherTest.spec().getUnitTypeList()) {
            if (!unitType.isRecruitable()) continue;
            if (unitType.getSkill() < 0) {
                IndividualFatherTest.assertFalse((String)("Able to recruit " + unitType.toString()), (boolean)dutch.hasAbility(ability, unitType));
                continue;
            }
            IndividualFatherTest.assertTrue((String)("Unable to recruit " + unitType.toString()), (boolean)dutch.hasAbility(ability, unitType));
        }
    }

    public void testCortes() {
        Game game = IndividualFatherTest.getGame();
        game.changeMap(IndividualFatherTest.getTestMap(true));
        Colony colony = this.getStandardColony(4);
        Player player = colony.getOwner();
        Unit unit = colony.getUnitList().get(0);
        NationType inca = IndividualFatherTest.spec().getNationType("model.nationType.inca");
        SettlementType incaCity = inca.getSettlementType("model.settlement.inca");
        RandomRange range = incaCity.getPlunderRange(unit);
        IndividualFatherTest.assertEquals((int)2100, (int)range.getFactor());
        player.addFather(hernanCortes);
        range = incaCity.getPlunderRange(unit);
        IndividualFatherTest.assertEquals((int)3100, (int)range.getFactor());
    }

    public void testDeLasCasas() {
        Game game = IndividualFatherTest.getGame();
        game.changeMap(IndividualFatherTest.getTestMap(true));
        Colony colony = this.getStandardColony(4);
        ServerPlayer player = (ServerPlayer)colony.getOwner();
        Unit unit = colony.getUnitList().get(0);
        unit.setType(nativeConvertType);
        player.csAddFoundingFather(bartolomeDeLasCasas, null, new ChangeSet());
        IndividualFatherTest.assertEquals((Object)unit.getType(), (Object)colonistType);
    }

    public void testDeWitt() {
        Game game = IndividualFatherTest.getGame();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        dutch.getMarket().setArrears(musketsType, 1);
        IndividualFatherTest.assertFalse((boolean)dutch.canTrade(musketsType, Market.Access.EUROPE));
        IndividualFatherTest.assertFalse((boolean)dutch.canTrade(musketsType, Market.Access.CUSTOM_HOUSE));
        dutch.addFather(janDeWitt);
        IndividualFatherTest.assertFalse((boolean)dutch.canTrade(musketsType, Market.Access.EUROPE));
        IndividualFatherTest.assertFalse((boolean)dutch.canTrade(musketsType, Market.Access.CUSTOM_HOUSE));
        dutch.setStance(french, Stance.WAR);
        IndividualFatherTest.assertFalse((boolean)dutch.canTrade(musketsType, Market.Access.EUROPE));
        IndividualFatherTest.assertFalse((boolean)dutch.canTrade(musketsType, Market.Access.CUSTOM_HOUSE));
        dutch.setStance(french, Stance.PEACE);
        IndividualFatherTest.assertFalse((boolean)dutch.canTrade(musketsType, Market.Access.EUROPE));
        IndividualFatherTest.assertTrue((boolean)dutch.canTrade(musketsType, Market.Access.CUSTOM_HOUSE));
    }

    public void testJefferson() {
        Game game = IndividualFatherTest.getGame();
        game.changeMap(IndividualFatherTest.getTestMap(true));
        Modifier jeffersonModifier = CollectionUtils.first(thomasJefferson.getModifiers("model.goods.bells"));
        IndividualFatherTest.assertNotNull((Object)jeffersonModifier);
        IndividualFatherTest.assertTrue((boolean)jeffersonModifier.appliesTo(townHallType));
        Colony colony = this.getStandardColony(4);
        Player player = colony.getOwner();
        Building townHall = colony.getBuilding(townHallType);
        this.clearWorkLocation(townHall);
        Unit unit = colony.getFirstUnit();
        townHall.add(unit);
        IndividualFatherTest.assertTrue((boolean)CollectionUtils.none(player.getModifiers("model.goods.bells")));
        IndividualFatherTest.assertTrue((boolean)CollectionUtils.none(colony.getModifiers("model.goods.bells")));
        int expected = 4;
        IndividualFatherTest.assertEquals((int)expected, (int)townHall.getTotalProductionOf(bellsType));
        player.addFather(thomasJefferson);
        expected = (int)((double)expected + (double)expected * 0.5);
        IndividualFatherTest.assertEquals((int)1, (int)CollectionUtils.count(player.getModifiers("model.goods.bells")));
        IndividualFatherTest.assertTrue((boolean)CollectionUtils.none(colony.getModifiers("model.goods.bells")));
        IndividualFatherTest.assertEquals((int)1, (int)CollectionUtils.count(townHall.getProductionModifiers(bellsType, null)));
        IndividualFatherTest.assertEquals((int)expected, (int)townHall.getTotalProductionOf(bellsType));
    }

    public void testMinuit() {
        Game game = IndividualFatherTest.getGame();
        game.changeMap(IndividualFatherTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        Unit unit = colony.getUnitList().get(0);
        Player player = colony.getOwner();
        Player iroquois = IndividualFatherTest.getGame().getPlayerByNationId("model.nation.iroquois");
        Tile colonyCenterTile = colony.getTile();
        Tile disputedTile = colonyCenterTile.getNeighbourOrNull(Direction.N);
        Tile settlementTile = disputedTile.getNeighbourOrNull(Direction.N);
        IndividualFatherTest.assertNull((Object)settlementTile.getOwner());
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(IndividualFatherTest.getGame());
        IndianSettlement indianSettlement = builder.player(iroquois).settlementTile(settlementTile).skillToTeach(null).build();
        ColonyTile colonyTile = colony.getColonyTile(disputedTile);
        for (Unit u : colonyTile.getUnitList()) {
            u.setLocation(colony.getTile());
        }
        disputedTile.changeOwnership(iroquois, indianSettlement);
        IndividualFatherTest.assertNotNull((Object)settlementTile.getSettlement());
        IndividualFatherTest.assertTrue((player.getLandPrice(disputedTile) > 0 ? 1 : 0) != 0);
        IndividualFatherTest.assertFalse((boolean)colony.getColonyTile(disputedTile).canAdd(unit));
        player.addFather(peterMinuit);
        IndividualFatherTest.assertEquals((String)"Tile should be zero cost", (int)0, (int)player.getLandPrice(disputedTile));
        IndividualFatherTest.assertEquals((String)"Should still have to claim the tile", (Object)((Object)UnitLocation.NoAddReason.CLAIM_REQUIRED), (Object)((Object)colonyTile.getNoAddReason(unit)));
    }

    public void testPaine() {
        Game game = IndividualFatherTest.getGame();
        game.changeMap(IndividualFatherTest.getTestMap(true));
        Colony colony = this.getStandardColony(4);
        Player player = colony.getOwner();
        ArrayList empty = new ArrayList();
        Building townHall = colony.getBuilding(townHallType);
        this.clearWorkLocation(townHall);
        Unit statesman1 = colony.getUnitList().get(0);
        Unit statesman2 = colony.getUnitList().get(1);
        Unit statesman3 = colony.getUnitList().get(2);
        statesman1.setType(statesmanType);
        statesman1.setLocation(townHall);
        IndividualFatherTest.assertEquals((int)7, (int)townHall.getTotalProductionOf(bellsType));
        statesman2.setType(statesmanType);
        statesman2.setLocation(townHall);
        IndividualFatherTest.assertEquals((int)13, (int)townHall.getTotalProductionOf(bellsType));
        statesman3.setType(statesmanType);
        statesman3.setLocation(townHall);
        IndividualFatherTest.assertEquals((int)19, (int)townHall.getTotalProductionOf(bellsType));
        player.setTax(20);
        IndividualFatherTest.assertEquals((int)19, (int)townHall.getTotalProductionOf(bellsType));
        player.addFather(thomasPaine);
        player.recalculateBellsBonus();
        IndividualFatherTest.assertTrue((boolean)player.hasAbility("model.ability.addTaxToBells"));
        List<Modifier> modifiers = CollectionUtils.toList(player.getModifiers("model.goods.bells"));
        IndividualFatherTest.assertEquals((int)1, (int)CollectionUtils.count(modifiers));
        Modifier paineModifier = CollectionUtils.first(modifiers);
        IndividualFatherTest.assertEquals((Object)thomasPaine, (Object)paineModifier.getSource());
        IndividualFatherTest.assertEquals((int)player.getTax(), (int)((int)paineModifier.getValue()));
        int expected = 22;
        IndividualFatherTest.assertEquals((int)expected, (int)townHall.getTotalProductionOf(bellsType));
        player.setTax(30);
        player.recalculateBellsBonus();
        expected = 24;
        IndividualFatherTest.assertEquals((int)expected, (int)townHall.getTotalProductionOf(bellsType));
    }

    public void testRevere() {
        Game game = IndividualFatherTest.getGame();
        game.changeMap(IndividualFatherTest.getTestMap());
        Colony colony = this.getStandardColony();
        Player player = colony.getOwner();
        Unit colonist = colony.getUnitList().get(0);
        IndividualFatherTest.assertNull((String)"No Revere, no auto-equip.", (Object)colonist.getAutomaticRole());
        player.addFather(paulRevere);
        IndividualFatherTest.assertNull((String)"No muskets, no auto-equip", (Object)colonist.getAutomaticRole());
        colony.addGoods(musketsType, 100);
        IndividualFatherTest.assertEquals((String)"Auto equip to soldier role.", (Object)soldierRole, (Object)colonist.getAutomaticRole());
        colony.addGoods(horsesType, 100);
        IndividualFatherTest.assertEquals((String)"Auto equip to soldier role despite horses.", (Object)soldierRole, (Object)colonist.getAutomaticRole());
    }

    public void testStuyvesant() {
        Game game = IndividualFatherTest.getGame();
        game.changeMap(IndividualFatherTest.getTestMap(true));
        Colony colony = this.getStandardColony(4);
        Player player = colony.getOwner();
        IndividualFatherTest.assertFalse((boolean)colony.canBuild(customHouseType));
        player.addFather(peterStuyvesant);
        IndividualFatherTest.assertTrue((boolean)colony.canBuild(customHouseType));
    }
}

