/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;

public class IndianSettlement
extends Settlement
implements TradeLocation {
    private static final Logger logger = Logger.getLogger(IndianSettlement.class.getName());
    public static final String TAG = "indianSettlement";
    public static final double NATIVE_PRODUCTION_EFFICIENCY = 0.67;
    public static final int WANTED_GOODS_COUNT = 3;
    public static final int TALES_RADIUS = 6;
    public static final int TRADE_MINIMUM_SIZE = 20;
    public static final int TRADE_MINIMUM_PRICE = 3;
    public static final int GOODS_BASE_PRICE = 12;
    public static final int KEEP_RAW_MATERIAL = 50;
    public static final int GIFT_THRESHOLD = 25;
    public static final int GIFT_MINIMUM = 10;
    public static final int GIFT_MAXIMUM = 80;
    protected UnitType learnableSkill = null;
    protected final List<GoodsType> wantedGoods = IndianSettlement.emptyWantedGoods();
    protected final Map<Player, ContactLevel> contactLevels = new HashMap<Player, ContactLevel>();
    protected final List<Unit> ownedUnits = new ArrayList<Unit>();
    protected Unit missionary = null;
    protected int convertProgress = 0;
    protected int lastTribute = 0;
    protected Player mostHated = null;
    protected final Map<Player, Tension> alarm = new HashMap<Player, Tension>();
    private final List<Goods> forSale = new ArrayList<Goods>();
    private static final String ALARM_TAG = "alarm";
    private static final String CONTACT_LEVEL_TAG = "contactLevel";
    private static final String CONVERT_PROGRESS_TAG = "convertProgress";
    private static final String LAST_TRIBUTE_TAG = "lastTribute";
    private static final String LEVEL_TAG = "level";
    private static final String MISSIONARY_TAG = "missionary";
    private static final String MOST_HATED_TAG = "mostHated";
    private static final String NAME_TAG = "name";
    private static final String OWNED_UNITS_TAG = "ownedUnits";
    private static final String PLAYER_TAG = "player";
    public static final String LEARNABLE_SKILL_TAG = "learnableSkill";
    public static final String WANTED_GOODS_TAG = "wantedGoods";

    protected IndianSettlement(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
    }

    public IndianSettlement(Game game, String id) {
        super(game, id);
    }

    private static List<GoodsType> emptyWantedGoods() {
        ArrayList<GoodsType> ret = new ArrayList<GoodsType>(3);
        for (int i = 0; i < 3; ++i) {
            ret.add(null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Unit> getOwnedUnitList() {
        List<Unit> list = this.ownedUnits;
        synchronized (list) {
            return new ArrayList<Unit>(this.ownedUnits);
        }
    }

    protected void setOwnedUnitList(List<Unit> ownedUnits) {
        this.clearOwnedUnits();
        this.ownedUnits.addAll(ownedUnits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOwnedUnit(Unit unit) {
        List<Unit> list = this.ownedUnits;
        synchronized (list) {
            if (!this.ownedUnits.contains(unit)) {
                this.ownedUnits.add(unit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOwnedUnits() {
        List<Unit> list = this.ownedUnits;
        synchronized (list) {
            this.ownedUnits.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOwnedUnit(Unit unit) {
        List<Unit> list = this.ownedUnits;
        synchronized (list) {
            return this.ownedUnits.remove(unit);
        }
    }

    public int getLastTribute() {
        return this.lastTribute;
    }

    public void setLastTribute(int lastTribute) {
        this.lastTribute = lastTribute;
    }

    public UnitType getLearnableSkill() {
        return this.learnableSkill;
    }

    public void setLearnableSkill(UnitType skill) {
        this.learnableSkill = skill;
    }

    public StringTemplate getLearnableSkillLabel(boolean visited) {
        return StringTemplate.key(visited ? (this.learnableSkill == null ? "model.indianSettlement.skillNone" : this.learnableSkill.getNameKey()) : "model.indianSettlement.skillUnknown");
    }

    public Unit getMissionary() {
        return this.missionary;
    }

    public boolean hasMissionary() {
        return this.missionary != null;
    }

    public boolean hasMissionary(Player player) {
        return this.missionary != null && player != null && player.owns(this.missionary);
    }

    public void setMissionary(Unit missionary) {
        this.missionary = missionary;
    }

    public int getMissionaryLineOfSight() {
        boolean enhanced = this.getSpecification().getBoolean("model.option.enhancedMissionaries");
        return enhanced ? this.getLineOfSight() : 1;
    }

    public List<Tile> getMissionaryVisibleTiles() {
        return this.getTile().getSurroundingTiles(0, this.getMissionaryLineOfSight());
    }

    public int getConvertProgress() {
        return this.convertProgress;
    }

    public void setConvertProgress(int progress) {
        this.convertProgress = progress;
    }

    private boolean validWantedGoodsIndex(int index) {
        return 0 <= index && index < 3;
    }

    public List<GoodsType> getWantedGoods() {
        return this.wantedGoods;
    }

    public GoodsType getWantedGoods(int index) {
        return this.validWantedGoodsIndex(index) ? this.wantedGoods.get(index) : null;
    }

    public void setWantedGoods(List<GoodsType> wanted) {
        int n = wanted.size();
        for (int i = 0; i < 3; ++i) {
            this.wantedGoods.set(i, i < n ? wanted.get(i) : null);
        }
    }

    public void setWantedGoods(int index, GoodsType type) {
        if (this.validWantedGoodsIndex(index)) {
            this.wantedGoods.set(index, type);
        }
    }

    public int getWantedGoodsCount() {
        return CollectionUtils.count(this.wantedGoods, CollectionUtils.isNotNull());
    }

    public List<StringTemplate> getWantedGoodsLabel(int index, Player player) {
        StringTemplate lab = null;
        StringTemplate tip = null;
        if (this.hasVisited(player)) {
            GoodsType gt = this.getWantedGoods(index);
            if (gt != null) {
                lab = StringTemplate.label("").add(Messages.nameKey(gt));
                String sale = player.getLastSaleString(this, gt);
                if (sale != null) {
                    lab.addName(" " + sale);
                    tip = player.getLastSaleTip(this, gt);
                }
            }
            if (lab == null) {
                lab = StringTemplate.key("model.indianSettlement.wantedGoodsNone");
            }
        } else {
            lab = StringTemplate.name("");
        }
        ArrayList<StringTemplate> ret = new ArrayList<StringTemplate>();
        ret.add(lab);
        if (tip != null) {
            ret.add(tip);
        }
        return ret;
    }

    public Player getMostHated() {
        return this.mostHated;
    }

    public void setMostHated(Player mostHated) {
        this.mostHated = mostHated;
    }

    public StringTemplate getMostHatedLabel(boolean contacted) {
        return contacted ? (this.mostHated == null ? StringTemplate.key("model.indianSettlement.mostHatedNone") : this.mostHated.getCountryLabel()) : StringTemplate.key("model.indianSettlement.mostHatedUnknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContactLevels(Map<Player, ContactLevel> contactLevels) {
        Map<Player, ContactLevel> map = this.contactLevels;
        synchronized (map) {
            this.contactLevels.clear();
            this.contactLevels.putAll(contactLevels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearContactLevels() {
        Map<Player, ContactLevel> map = this.contactLevels;
        synchronized (map) {
            this.contactLevels.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactLevel getContactLevel(Player player) {
        Map<Player, ContactLevel> map = this.contactLevels;
        synchronized (map) {
            ContactLevel cl = this.contactLevels.get(player);
            return cl == null ? ContactLevel.UNCONTACTED : cl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContactLevel(Player player, ContactLevel level) {
        Map<Player, ContactLevel> map = this.contactLevels;
        synchronized (map) {
            this.contactLevels.put(player, level);
        }
    }

    public boolean setContacted(Player player) {
        if (!this.hasContacted(player)) {
            this.setContactLevel(player, ContactLevel.CONTACTED);
            this.initializeAlarm(player);
            return true;
        }
        return false;
    }

    public boolean hasVisited(Player player) {
        return this.getContactLevel(player).ordinal() >= ContactLevel.VISITED.ordinal();
    }

    public boolean setVisited(Player player) {
        if (!this.hasVisited(player)) {
            if (!this.hasContacted(player)) {
                this.initializeAlarm(player);
            }
            this.setContactLevel(player, ContactLevel.VISITED);
            return true;
        }
        return false;
    }

    public boolean hasScouted(Player player) {
        return this.getContactLevel(player) == ContactLevel.SCOUTED;
    }

    public boolean setScouted(Player player) {
        if (!this.hasScouted(player)) {
            if (!this.hasContacted(player)) {
                this.initializeAlarm(player);
            }
            this.setContactLevel(player, ContactLevel.SCOUTED);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyScouted() {
        Map<Player, ContactLevel> map = this.contactLevels;
        synchronized (map) {
            return CollectionUtils.any(this.contactLevels.keySet(), p -> this.hasScouted((Player)p));
        }
    }

    public boolean worthScouting(Player player) {
        ContactLevel cl = this.getContactLevel(player);
        switch (cl) {
            case CONTACTED: {
                return true;
            }
            case VISITED: {
                return !this.getSpecification().getBoolean("model.option.settlementActionsContactChief");
            }
        }
        return false;
    }

    protected Map<Player, Tension> getAlarm() {
        return this.alarm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAlarm(Map<Player, Tension> alarm) {
        this.clearAlarm();
        Map<Player, Tension> map = this.alarm;
        synchronized (map) {
            this.alarm.putAll(alarm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tension getAlarm(Player player) {
        Map<Player, Tension> map = this.alarm;
        synchronized (map) {
            return this.alarm.get(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlarm(Player player, Tension newAlarm) {
        Map<Player, Tension> map = this.alarm;
        synchronized (map) {
            this.alarm.put(player, newAlarm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAlarm() {
        Map<Player, Tension> map = this.alarm;
        synchronized (map) {
            this.alarm.clear();
        }
    }

    protected void initializeAlarm(Player player) {
        Tension tension = this.owner.getTension(player);
        this.setAlarm(player, new Tension(tension.getValue()));
    }

    public String getAlarmLevelKey(Player player) {
        return !player.hasContacted(this.owner) ? "model.indianSettlement.tension.wary" : (!this.hasContacted(player) ? "model.indianSettlement.tension.unknown" : this.getAlarm(player).getNameKey());
    }

    public List<Goods> getGoodsForSale() {
        return this.forSale;
    }

    public void setGoodsForSale(List<Goods> forSale) {
        this.forSale.clear();
        this.forSale.addAll(forSale);
    }

    public boolean allowContact(Unit unit) {
        return unit.getOwner().hasContacted(this.owner) || !unit.isNaval() || unit.hasGoodsCargo();
    }

    public <T extends AbstractGoods> int getPriceToBuy(T goods) {
        return this.getPriceToBuy(goods.getType(), goods.getAmount());
    }

    public int getPriceToBuy(GoodsType type, int amount) {
        if (amount > 100) {
            throw new RuntimeException("Amount " + amount + " > 100");
        }
        int price = 0;
        if (type.getMilitary()) {
            price = this.getMilitaryGoodsPriceToBuy(type, amount);
        }
        if (price == 0) {
            price = this.getNormalGoodsPriceToBuy(type, amount);
        }
        int wantedBase = 100;
        int wantedBonus = type == this.getWantedGoods(0) ? 150 : (type == this.getWantedGoods(1) ? 125 : (type == this.getWantedGoods(2) ? 110 : 100));
        price = wantedBonus * price / 100;
        logger.finest("Full price(" + amount + " " + type + ") -> " + price);
        return price;
    }

    private int getNormalGoodsPriceToBuy(GoodsType type, int amount) {
        int tradeGoodsAdd = 20;
        int capacity = this.getGoodsCapacity();
        int current = this.getGoodsCount(type);
        GoodsType rawType = type.getInputType();
        if (rawType != null) {
            int rawProduction = this.getMaximumProduction(rawType);
            int fakeProduction = rawProduction < 5 ? 10 * rawProduction : (rawProduction < 10 ? 5 * rawProduction + 25 : (rawProduction < 20 ? 2 * rawProduction + 55 : 100));
            current += (fakeProduction /= 2) * Math.max(0, capacity - current) / capacity;
        } else if (type.isTradeGoods()) {
            current += 20;
        }
        int retain = Math.min(this.getWantedGoodsAmount(type), capacity);
        int valued = retain <= current ? 0 : Math.min(amount, retain - current);
        int unitPrice = (12 + this.getType().getTradeBonus()) * Math.max(0, capacity - current) / capacity;
        if (type.isFarmed() || type.isRawBuildingMaterial()) {
            unitPrice /= 2;
        }
        return unitPrice < 0 ? 0 : valued * unitPrice;
    }

    protected int getWantedGoodsAmount(GoodsType type) {
        if (this.getUnitCount() <= 0) {
            return 0;
        }
        Specification spec = this.getSpecification();
        UnitType unitType = this.getFirstUnit().getType();
        List<Role> militaryRoles = Role.getAvailableRoles(this.getOwner(), unitType, spec.getMilitaryRolesList());
        if (type.getMilitary()) {
            return CollectionUtils.sum(this.getOwnedUnitList(), u -> !militaryRoles.contains(u.getRole()), u -> AbstractGoods.getCount(type, u.getGoodsDifference((Role)CollectionUtils.first(militaryRoles), 1)));
        }
        int consumption = this.getConsumptionOf(type);
        if (type == spec.getPrimaryFoodType()) {
            return Math.max(40, consumption * 3);
        }
        if (type.isTradeGoods() || type.isNewWorldLuxuryType() || type.isRefined()) {
            return Math.max(80, consumption * 20);
        }
        return 2 * this.getUnitCount();
    }

    private int getMilitaryGoodsPriceToBuy(GoodsType type, int amount) {
        int full = 12 + this.getType().getTradeBonus();
        int required = this.getWantedGoodsAmount(type);
        if (required == 0) {
            return 0;
        }
        int valued = Math.max(0, required - this.getGoodsCount(type));
        int price = valued > amount / 2 ? full * amount : valued * full + this.getNormalGoodsPriceToBuy(type, amount - valued);
        logger.finest("Military price(" + amount + " " + type + ") valued=" + valued + " -> " + price);
        return price;
    }

    public <T extends AbstractGoods> int getPriceToSell(T goods) {
        return this.getPriceToSell(goods.getType(), goods.getAmount());
    }

    public int getPriceToSell(GoodsType type, int amount) {
        if (amount > 100) {
            throw new RuntimeException("Amount " + amount + " > 100");
        }
        int full = 12 + this.getType().getTradeBonus();
        int price = amount + Math.max(0, 11 * this.getPriceToBuy(type, amount) / 10);
        if (type.getMilitary()) {
            price = Math.max(price, amount * full * 2);
        } else if (type.isTradeGoods()) {
            price = Math.max(price, 150 * amount * full / 100);
        } else {
            GoodsType raw = type.getInputType();
            if (raw != null && this.getMaximumProduction(raw) == 0) {
                price += amount;
            }
        }
        return price;
    }

    public boolean willSell(GoodsType type) {
        return !type.isTradeGoods();
    }

    public List<Goods> getSellGoods(Unit unit) {
        List<Goods> sellGoods = CollectionUtils.transform(this.getCompactGoodsList(), g2 -> this.willSell(g2.getType()));
        ArrayList<Goods> result = new ArrayList<Goods>(sellGoods.size());
        for (Goods g3 : sellGoods) {
            int amount = g3.getAmount();
            int retain = this.getWantedGoodsAmount(g3.getType());
            if (retain >= amount) continue;
            amount -= retain;
            if (unit != null) {
                amount = Math.round(IndianSettlement.applyModifiers((float)amount, this.getGame().getTurn(), unit.getModifiers("model.modifier.tradeVolumePenalty")));
            }
            if (amount < 20) continue;
            if (amount > 100) {
                amount = 100;
            }
            result.add(new Goods(this.getGame(), this, g3.getType(), amount));
        }
        Comparator<Goods> salePriceComparator = Comparator.comparingInt(g -> this.getPriceToSell(g.getType(), g.getAmount())).reversed();
        Comparator<AbstractGoods> exportGoodsComparator = Comparator.comparingInt(g -> g.getType().isNewWorldGoodsType() ? 0 : 1).thenComparing(salePriceComparator).thenComparing(AbstractGoods.descendingAmountComparator);
        return CollectionUtils.sort(result, exportGoodsComparator);
    }

    public void tradeGoodsWithSettlement(IndianSettlement is) {
        Specification spec = this.getSpecification();
        for (GoodsType gt : CollectionUtils.transform(spec.getGoodsTypeList(), GoodsType::getMilitary)) {
            int goodsInStock = this.getGoodsCount(gt);
            if (goodsInStock <= 50) continue;
            int goodsTraded = goodsInStock / 2;
            is.addGoods(gt, goodsTraded);
            this.removeGoods(gt, goodsTraded);
        }
    }

    public int getMaximumProduction(GoodsType goodsType) {
        return CollectionUtils.sum(this.getTile().getSurroundingTiles(0, this.getRadius()), t -> t.getOwningSettlement() == null || t.getOwningSettlement() == this, t -> t.getPotentialProduction(goodsType, null));
    }

    public void updateWantedGoods() {
        Specification spec = this.getSpecification();
        Function identity = Function.identity();
        Map prices = CollectionUtils.transform(spec.getGoodsTypeList(), gt -> !gt.getMilitary() && gt.isStorable(), identity, Collectors.toMap(identity, gt -> this.getNormalGoodsPriceToBuy((GoodsType)gt, 100)));
        int wantedIndex = 0;
        for (Map.Entry e : CollectionUtils.mapEntriesByValue(prices, CollectionUtils.descendingIntegerComparator)) {
            if (!this.validWantedGoodsIndex(wantedIndex) || e.getValue() <= 300) break;
            this.setWantedGoods(wantedIndex, (GoodsType)e.getKey());
            ++wantedIndex;
        }
        while (wantedIndex < 3) {
            this.setWantedGoods(wantedIndex, null);
            ++wantedIndex;
        }
    }

    private GoodsType goodsToMake() {
        ToIntFunction<GoodsType> deficit = CollectionUtils.cacheInt(gt -> this.getWantedGoodsAmount((GoodsType)gt) - this.getGoodsCount((GoodsType)gt));
        Predicate<GoodsType> goodsPred = gt -> gt.isRawMaterial() && gt.getOutputType() != null && !gt.getOutputType().isBreedable() && gt.getOutputType().isStorable() && deficit.applyAsInt((GoodsType)gt) < 0 && deficit.applyAsInt(gt.getOutputType()) > 0;
        Comparator<GoodsType> comp = Comparator.comparingInt(deficit);
        return CollectionUtils.maximize(this.getSpecification().getGoodsTypeList(), goodsPred, comp);
    }

    public Goods getRandomGift(Random random) {
        Specification spec = this.getSpecification();
        Predicate<GoodsType> goodsPred = gt -> this.getGoodsCount((GoodsType)gt) >= 75;
        Function<GoodsType, Goods> newGoodsMapper = gt -> new Goods(this.getGame(), this, (GoodsType)gt, Math.min(RandomUtils.randomInt(logger, "Gift amount", random, this.getGoodsCount((GoodsType)gt) - 50 - 10) + 10, 80));
        return RandomUtils.getRandomMember(logger, "Gift type", CollectionUtils.transform(spec.getNewWorldGoodsTypeList(), goodsPred, newGoodsMapper), random);
    }

    public void addRandomGoods(Random random) {
        HashMap goodsMap = new HashMap();
        for (AbstractGoods ag : CollectionUtils.iterable(CollectionUtils.flatten(this.getOwnedTiles(), t -> t.getSortedPotential().stream()))) {
            CollectionUtils.accumulateToMap(goodsMap, ag.getType().getStoredAs(), ag.getAmount(), (a, b) -> a + b);
        }
        double d = (double)RandomUtils.randomInt(logger, "Goods at " + this.getName(), random, 10) * 0.1 + 1.0;
        CollectionUtils.forEachMapEntry(goodsMap, e -> {
            int i = (Integer)e.getValue();
            if (!((GoodsType)e.getKey()).isFoodType()) {
                i = (int)Math.round(d * (double)((Integer)e.getValue()).intValue());
            }
            if ((i = Math.min(i, 100)) > 0) {
                this.addGoods((GoodsType)e.getKey(), i);
            }
        });
    }

    public int getRequiredDefenders() {
        return this.getType().getMinimumSize() - 1;
    }

    @Override
    public void disposeResources() {
        while (!this.ownedUnits.isEmpty()) {
            this.ownedUnits.remove(0).changeHomeIndianSettlement(null);
        }
        super.disposeResources();
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        return player == null || this.hasContacted(player) ? StringTemplate.name(this.getName()) : StringTemplate.key("model.indianSettlement.nameUnknown");
    }

    @Override
    public boolean add(Locatable locatable) {
        Unit indian;
        boolean result = super.add(locatable);
        if (result && locatable instanceof Unit && (indian = (Unit)locatable).getHomeIndianSettlement() == null) {
            indian.changeHomeIndianSettlement(this);
        }
        return result;
    }

    @Override
    public final IndianSettlement getIndianSettlement() {
        return this;
    }

    @Override
    public Location up() {
        return this;
    }

    @Override
    public String toShortString() {
        return this.getName();
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public int getGoodsCapacity() {
        return this.getType().getWarehouseCapacity();
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        Unit defender = null;
        double defencePower = -1.0;
        for (Unit nextUnit : this.getUnitList()) {
            double unitPower;
            if (!Unit.betterDefender(defender, defencePower, nextUnit, unitPower = attacker.getGame().getCombatModel().getDefencePower(attacker, nextUnit))) continue;
            defender = nextUnit;
            defencePower = unitPower;
        }
        return defender;
    }

    @Override
    public double getDefenceRatio() {
        return (double)this.getUnitCount() * 2.0 / (double)(this.getType().getMinimumSize() + this.getType().getMaximumSize());
    }

    @Override
    public boolean isBadlyDefended() {
        return this.getUnitCount() < this.getRequiredDefenders();
    }

    @Override
    public RandomRange getPlunderRange(Unit attacker) {
        return this.getType().getPlunderRange(attacker);
    }

    @Override
    public int getSoL() {
        return 0;
    }

    @Override
    public int getUpkeep() {
        return 0;
    }

    @Override
    public int getTotalProductionOf(GoodsType type) {
        if (type.isRefined()) {
            if (type != this.goodsToMake()) {
                return 0;
            }
            return this.getUnitCount();
        }
        int tiles = 0;
        int potential = 0;
        for (Tile wt : CollectionUtils.transform(this.getOwnedTiles(), t -> t != this.getTile() && !t.isOccupied())) {
            potential += wt.getPotentialProduction(type, null);
            ++tiles;
        }
        if (tiles > this.getUnitCount()) {
            potential = (int)((double)potential * (double)this.getUnitCount() / (double)tiles);
        }
        if (!type.isFoodType()) {
            potential = (int)Math.round((double)potential * 0.67);
        }
        return potential += this.getTile().getPotentialProduction(type, null);
    }

    @Override
    public boolean hasContacted(Player player) {
        return player != null && (player.isIndian() || this.getContactLevel(player) != ContactLevel.UNCONTACTED);
    }

    @Override
    public StringTemplate getAlarmLevelLabel(Player player) {
        String key = !player.hasContacted(this.owner) ? "model.indianSettlement.tension.wary" : (!this.hasContacted(player) ? "model.indianSettlement.tension.unknown" : "model.indianSettlement." + this.getAlarm(player).getKey());
        return StringTemplate.template(key).addStringTemplate("%nation%", this.getOwner().getNationLabel());
    }

    @Override
    public int calculateSettlementValue(int value, Unit unit) {
        Tension tension = this.getAlarm(unit.getOwner());
        if (tension != null) {
            value += tension.getValue() / 2;
        }
        return value;
    }

    @Override
    public int getAvailableGoodsCount(GoodsType goodsType) {
        return this.getGoodsCount(goodsType);
    }

    @Override
    public int getExportAmount(GoodsType goodsType, int turns) {
        int present = Math.max(0, this.getGoodsCount(goodsType) + turns * this.getTotalProductionOf(goodsType));
        int wanted = this.getWantedGoodsAmount(goodsType);
        return present - wanted;
    }

    @Override
    public int getImportAmount(GoodsType goodsType, int turns) {
        if (goodsType.limitIgnored()) {
            return Integer.MAX_VALUE;
        }
        int present = Math.max(0, this.getGoodsCount(goodsType) - turns * this.getTotalProductionOf(goodsType));
        int capacity = this.getWarehouseCapacity();
        return capacity - present;
    }

    @Override
    public String getLocationName(TradeLocation tradeLocation) {
        return ((IndianSettlement)tradeLocation).getName();
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        Player owner = this.getOwner();
        if (owner != null) {
            for (Unit u : this.getOwnedUnitList()) {
                if (u.getOwner() == owner) continue;
                if (fix) {
                    lb.add("\n  Owned unit with wrong owner reassigned: ", u.getId());
                    result = result.fix();
                    continue;
                }
                lb.add("\n  Owned unit with wrong owner: ", u.getId());
                result = result.fail();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        IndianSettlement o = this.copyInCast(other, IndianSettlement.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.learnableSkill = o.getLearnableSkill();
        this.setWantedGoods(o.getWantedGoods());
        Map<Player, ContactLevel> map = this.contactLevels;
        synchronized (map) {
            this.contactLevels.clear();
            for (Map.Entry<Player, ContactLevel> e : o.contactLevels.entrySet()) {
                this.contactLevels.put(game.updateRef(e.getKey()), e.getValue());
            }
        }
        this.setOwnedUnitList(game.updateRef(o.getOwnedUnitList()));
        this.missionary = game.update(o.getMissionary(), false);
        this.convertProgress = o.getConvertProgress();
        this.lastTribute = o.getLastTribute();
        this.mostHated = o.getMostHated();
        this.setAlarm(o.getAlarm());
        this.setGoodsForSale(o.getGoodsForSale());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        ContactLevel cl = this.getContactLevel(xw.getClientPlayer());
        boolean full = xw.validFor(this.getOwner());
        String name = this.getName();
        if (name != null) {
            xw.writeAttribute(NAME_TAG, name);
        }
        if (full) {
            xw.writeAttribute(LAST_TRIBUTE_TAG, this.lastTribute);
            xw.writeAttribute(CONVERT_PROGRESS_TAG, this.convertProgress);
        }
        if (full || cl == ContactLevel.SCOUTED || cl == ContactLevel.VISITED) {
            if (this.learnableSkill != null) {
                xw.writeAttribute(LEARNABLE_SKILL_TAG, this.learnableSkill);
            }
            for (int i = 0; i < 3; ++i) {
                GoodsType gt = this.getWantedGoods(i);
                if (gt == null) continue;
                xw.writeAttribute(WANTED_GOODS_TAG + i, gt);
            }
            Player hated = this.getMostHated();
            if (hated != null) {
                xw.writeAttribute(MOST_HATED_TAG, hated);
            }
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.missionary != null) {
            xw.writeStartElement(MISSIONARY_TAG);
            this.missionary.toXML(xw);
            xw.writeEndElement();
        }
        if (xw.validFor(this.getOwner())) {
            for (Player p : CollectionUtils.sort(this.contactLevels.keySet())) {
                xw.writeStartElement(CONTACT_LEVEL_TAG);
                xw.writeAttribute(LEVEL_TAG, this.contactLevels.get(p));
                xw.writeAttribute(PLAYER_TAG, p);
                xw.writeEndElement();
            }
            for (Player p : CollectionUtils.sort(this.alarm.keySet())) {
                xw.writeStartElement(ALARM_TAG);
                xw.writeAttribute(PLAYER_TAG, p);
                xw.writeAttribute("value", this.getAlarm(p).getValue());
                xw.writeEndElement();
            }
            for (Unit unit : CollectionUtils.sort(this.ownedUnits)) {
                xw.writeStartElement(OWNED_UNITS_TAG);
                xw.writeAttribute("id", unit);
                xw.writeEndElement();
            }
        } else {
            Tension alarm;
            Player client = xw.getClientPlayer();
            ContactLevel cl = this.getContactLevel(client);
            if (cl != null) {
                xw.writeStartElement(CONTACT_LEVEL_TAG);
                xw.writeAttribute(LEVEL_TAG, cl);
                xw.writeAttribute(PLAYER_TAG, client);
                xw.writeEndElement();
            }
            if ((alarm = this.getAlarm(client)) != null) {
                xw.writeStartElement(ALARM_TAG);
                xw.writeAttribute(PLAYER_TAG, client);
                xw.writeAttribute("value", alarm.getValue());
                xw.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.lastTribute = xr.getAttribute(LAST_TRIBUTE_TAG, 0);
        this.convertProgress = xr.getAttribute(CONVERT_PROGRESS_TAG, 0);
        this.learnableSkill = xr.getType(spec, LEARNABLE_SKILL_TAG, UnitType.class, null);
        this.mostHated = xr.findFreeColGameObject(this.getGame(), MOST_HATED_TAG, Player.class, null, false);
        for (int i = 0; i < 3; ++i) {
            this.setWantedGoods(i, xr.getType(spec, WANTED_GOODS_TAG + i, GoodsType.class, null));
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.clearContactLevels();
        this.clearAlarm();
        this.missionary = null;
        this.clearOwnedUnits();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (ALARM_TAG.equals(tag)) {
            Player player = xr.findFreeColGameObject(game, PLAYER_TAG, Player.class, null, true);
            this.setAlarm(player, new Tension(xr.getAttribute("value", 0)));
            xr.closeTag(ALARM_TAG);
        } else if (CONTACT_LEVEL_TAG.equals(tag)) {
            ContactLevel cl = xr.getAttribute(LEVEL_TAG, ContactLevel.class, ContactLevel.UNCONTACTED);
            Player player = xr.findFreeColGameObject(game, PLAYER_TAG, Player.class, null, true);
            this.setContactLevel(player, cl);
            xr.closeTag(CONTACT_LEVEL_TAG);
        } else if (MISSIONARY_TAG.equals(tag)) {
            xr.nextTag();
            this.missionary = xr.readFreeColObject(game, Unit.class);
            this.missionary.setLocationNoUpdate(this);
            xr.closeTag(MISSIONARY_TAG);
        } else if (OWNED_UNITS_TAG.equals(tag)) {
            Unit unit = xr.makeFreeColObject(game, "id", Unit.class, true);
            this.addOwnedUnit(unit);
            xr.closeTag(OWNED_UNITS_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        String name = this.getName();
        sb.append(name == null ? "NONAME" : name);
        Tile tile = this.getTile();
        if (tile != null) {
            sb.append(" at (").append(tile.getX()).append(',').append(tile.getY()).append(')');
        }
        return sb.toString();
    }

    public static enum ContactLevel {
        UNCONTACTED,
        CONTACTED,
        VISITED,
        SCOUTED;

    }
}

