/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class Building
extends WorkLocation
implements Named,
Consumer {
    private static final Logger logger = Logger.getLogger(Building.class.getName());
    private static final double EPSILON = 1.0E-4;
    public static final String TAG = "building";
    public static final String UNIT_CHANGE = "UNIT_CHANGE";
    protected BuildingType buildingType;
    private static final String BUILDING_TYPE_TAG = "buildingType";

    protected Building(Game game, Colony colony, BuildingType type) {
        super(game);
        this.colony = colony;
        this.buildingType = type;
        this.updateProductionType();
    }

    public Building(Game game, String id) {
        super(game, id);
    }

    public BuildingType getType() {
        return this.buildingType;
    }

    private List<Unit> setType(BuildingType newBuildingType) {
        Colony colony = this.getColony();
        colony.removeFeatures(this.buildingType);
        ArrayList<Unit> eject = new ArrayList<Unit>();
        if (newBuildingType != null) {
            this.buildingType = newBuildingType;
            this.updateProductionType();
            colony.addFeatures(this.buildingType);
            eject.addAll(CollectionUtils.transform(this.getUnits(), u -> !this.canAddType(u.getType())));
        }
        int extra = this.getUnitCount() - this.getUnitCapacity() - eject.size();
        for (Unit unit : this.getUnitList()) {
            if (extra <= 0) break;
            if (eject.contains(unit)) continue;
            eject.add(unit);
            --extra;
        }
        return eject;
    }

    public Stream<Modifier> getCompetenceModifiers(String id, UnitType unitType, Turn turn) {
        float competence = this.getCompetenceFactor();
        return competence == 1.0f ? unitType.getModifiers(id, this.getType(), turn) : CollectionUtils.map(unitType.getModifiers(id, this.getType(), turn), m -> m.getType() == Modifier.ModifierType.ADDITIVE ? Modifier.makeModifier(m).setValue(m.getValue() * competence) : m);
    }

    public boolean canBuildNext() {
        return this.getColony().canBuild(this.getType().getUpgradesTo());
    }

    public boolean canBeDamaged() {
        return !this.getType().isAutomaticBuild() && !this.getColony().isAutomaticBuild(this.getType());
    }

    public List<Unit> downgrade() {
        if (!this.canBeDamaged()) {
            return null;
        }
        List<Unit> ret = this.setType(this.getType().getUpgradesFrom());
        this.getColony().invalidateCache();
        return ret;
    }

    public List<Unit> upgrade() {
        if (!this.canBuildNext()) {
            return null;
        }
        List<Unit> ret = this.setType(this.getType().getUpgradesTo());
        this.getColony().invalidateCache();
        return ret;
    }

    public boolean canAddType(UnitType unitType) {
        return this.canBeWorked() && this.getType().canAdd(unitType);
    }

    private int getAvailable(GoodsType type, List<AbstractGoods> available) {
        return AbstractGoods.getCount(type, available);
    }

    public ProductionInfo getAdjustedProductionInfo(List<AbstractGoods> inputs, List<AbstractGoods> outputs) {
        GoodsType goodsType;
        ProductionInfo result = new ProductionInfo();
        if (!this.hasOutputs()) {
            return result;
        }
        Specification spec = this.getSpecification();
        Turn turn = this.getGame().getTurn();
        boolean avoidOverflow = this.hasAbility("model.ability.avoidExcessProduction");
        int capacity = this.getColony().getWarehouseCapacity();
        double maximumRatio = 0.0;
        double minimumRatio = Double.MAX_VALUE;
        if (this.canAutoProduce()) {
            for (AbstractGoods output : CollectionUtils.transform(this.getOutputs(), AbstractGoods::isPositive)) {
                goodsType = output.getType();
                int available = this.getColony().getGoodsCount(goodsType);
                if (available >= capacity) {
                    maximumRatio = 0.0;
                    minimumRatio = 0.0;
                    continue;
                }
                int divisor = (int)this.getType().apply(0.0f, turn, "model.modifier.breedingDivisor");
                int factor = (int)this.getType().apply(0.0f, turn, "model.modifier.breedingFactor");
                int production = available < goodsType.getBreedingNumber() || divisor <= 0 ? 0 : ((available - 1) / divisor + 1) * factor;
                double newRatio = (double)production / (double)output.getAmount();
                minimumRatio = Math.min(minimumRatio, newRatio);
                maximumRatio = Math.max(maximumRatio, newRatio);
            }
        } else {
            for (AbstractGoods output : CollectionUtils.iterable(this.getOutputs())) {
                goodsType = output.getType();
                float production = CollectionUtils.sum(this.getUnits(), u -> this.getUnitProduction((Unit)u, goodsType));
                production += (float)this.getBaseProduction(null, goodsType, null);
                production = Building.applyModifiers(production, turn, this.getProductionModifiers(goodsType, null));
                production = (int)Math.floor(production);
                double newRatio = production / (float)output.getAmount();
                minimumRatio = Math.min(minimumRatio, newRatio);
                maximumRatio = Math.max(maximumRatio, newRatio);
            }
        }
        for (AbstractGoods input : CollectionUtils.iterable(this.getInputs())) {
            long minimumGoodsInput;
            long required = (long)Math.floor((double)input.getAmount() * minimumRatio);
            long available = this.getAvailable(input.getType(), inputs);
            if (this.canAutoProduce()) {
                available = Math.max(0L, available);
            }
            if (available < required && this.hasAbility("model.ability.expertsUseConnections") && spec.getBoolean("model.option.expertsHaveConnections") && (minimumGoodsInput = (long)(this.getType().getExpertConnectionProduction() * CollectionUtils.count(this.getUnits(), CollectionUtils.matchKey(this.getExpertUnitType(), Unit::getType)))) > available) {
                available = minimumGoodsInput;
            }
            if (available >= required) continue;
            minimumRatio *= (double)available / (double)required;
        }
        if (avoidOverflow) {
            for (AbstractGoods output : CollectionUtils.iterable(this.getOutputs())) {
                double production = (double)output.getAmount() * minimumRatio;
                if (production <= 0.0) continue;
                double headroom = (double)capacity - (double)this.getAvailable(output.getType(), outputs);
                if (production > headroom) {
                    minimumRatio = Math.min(minimumRatio, headroom / (double)output.getAmount());
                }
                if (!((production = (double)output.getAmount() * maximumRatio) > headroom)) continue;
                maximumRatio = Math.min(maximumRatio, headroom / (double)output.getAmount());
            }
        }
        for (AbstractGoods input : CollectionUtils.iterable(this.getInputs())) {
            GoodsType type = input.getType();
            int consumption = (int)Math.floor((double)input.getAmount() * minimumRatio + 1.0E-4);
            int maximumConsumption = (int)Math.floor((double)input.getAmount() * maximumRatio);
            result.addConsumption(new AbstractGoods(type, consumption));
            if (consumption >= maximumConsumption) continue;
            result.addMaximumConsumption(new AbstractGoods(type, maximumConsumption));
        }
        for (AbstractGoods output : CollectionUtils.iterable(this.getOutputs())) {
            GoodsType type = output.getType();
            int production = (int)Math.floor((double)output.getAmount() * minimumRatio + 1.0E-4);
            int maximumProduction = (int)Math.floor((double)output.getAmount() * maximumRatio);
            result.addProduction(new AbstractGoods(type, production));
            if (production >= maximumProduction) continue;
            result.addMaximumProduction(new AbstractGoods(type, maximumProduction));
        }
        return result;
    }

    @Override
    public int evaluateFor(Player player) {
        return super.evaluateFor(player) + CollectionUtils.sum(this.getType().getRequiredGoods(), ag -> ag.evaluateFor(player));
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.template("model.building.locationLabel").addNamed("%location%", this);
    }

    @Override
    public Location up() {
        return this.getColony();
    }

    @Override
    public String toShortString() {
        return this.getColony().getName() + "-" + this.getType().getSuffix();
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        UnitLocation.NoAddReason reason = super.getNoAddReason(locatable);
        if (reason == UnitLocation.NoAddReason.NONE && (reason = this.getType().getNoAddReason(((Unit)locatable).getType())) == UnitLocation.NoAddReason.NONE) {
            reason = this.getNoWorkReason();
        }
        return reason;
    }

    @Override
    public int getUnitCapacity() {
        return this.getType().getWorkPlaces();
    }

    @Override
    public boolean goodSuggestionCheck(UnitType better, Unit unit, GoodsType goodsType) {
        if (this.canAddType(better)) {
            BuildableType bt;
            Colony colony = this.getColony();
            if (this.getLevel() > 1 || unit != null) {
                return true;
            }
            if (colony.getTotalProductionOf(goodsType) == 0 && (bt = colony.getCurrentlyBuilding()) != null && CollectionUtils.any(bt.getRequiredGoods(), AbstractGoods.matches(goodsType))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public StringTemplate getLabel() {
        return this.buildingType == null ? null : StringTemplate.key(this.buildingType);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isCurrent() {
        return true;
    }

    @Override
    public UnitLocation.NoAddReason getNoWorkReason() {
        return UnitLocation.NoAddReason.NONE;
    }

    @Override
    public Tile getWorkTile() {
        return null;
    }

    @Override
    public int getLevel() {
        return this.getType().getLevel();
    }

    @Override
    public boolean canAutoProduce() {
        return this.hasAbility("model.ability.autoProduction");
    }

    @Override
    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        BuildingType type = this.getType();
        return type != null && type.canProduce(goodsType, unitType);
    }

    @Override
    public int getBaseProduction(ProductionType productionType, GoodsType goodsType, UnitType unitType) {
        BuildingType type = this.getType();
        return type == null ? 0 : this.getType().getBaseProduction(productionType, goodsType, unitType);
    }

    @Override
    public Stream<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        BuildingType type = this.getType();
        String id = goodsType == null ? null : goodsType.getId();
        Colony colony = this.getColony();
        Player owner = this.getOwner();
        Turn turn = this.getGame().getTurn();
        return unitType != null ? CollectionUtils.concat(this.getModifiers(id, unitType, turn), colony.getProductionModifiers(goodsType, unitType, this), this.getCompetenceModifiers(id, unitType, turn), owner.getModifiers(id, unitType, turn)) : CollectionUtils.concat(colony.getModifiers(id, type, turn), owner.getModifiers(id, type, turn));
    }

    @Override
    public List<ProductionType> getAvailableProductionTypes(boolean unattended) {
        return this.buildingType == null ? Collections.emptyList() : this.getType().getAvailableProductionTypes(unattended);
    }

    @Override
    public float getCompetenceFactor() {
        return this.getType().getCompetenceFactor();
    }

    @Override
    public float getRebelFactor() {
        return this.getType().getRebelFactor();
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        return CollectionUtils.toList(this.getInputs());
    }

    @Override
    public int getPriority() {
        return this.getType().getPriority();
    }

    @Override
    public Stream<Modifier> getConsumptionModifiers(String id) {
        return this.getModifiers(id);
    }

    @Override
    public String getNameKey() {
        return this.getType().getNameKey();
    }

    @Override
    public Stream<Ability> getAbilities(String id, FreeColSpecObjectType type, Turn turn) {
        return this.getType().getAbilities(id, type, turn);
    }

    @Override
    public Stream<Modifier> getModifiers(String id, FreeColSpecObjectType fcgot, Turn turn) {
        return this.getType().getModifiers(id, fcgot, turn);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Building o = this.copyInCast(other, Building.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.buildingType = o.getType();
        return true;
    }

    @Override
    public FreeColObject getDisplayObject() {
        return this.getType();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(BUILDING_TYPE_TAG, this.buildingType);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.buildingType = xr.getType(spec, BUILDING_TYPE_TAG, BuildingType.class, null);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        Colony c = this.getColony();
        sb.append('[').append(this.getId()).append(' ').append(this.buildingType == null ? "" : StringUtils.lastPart(this.buildingType.getId(), ".")).append('/').append(c == null ? "NO-COLONY" : c.getName()).append(']');
        return sb.toString();
    }
}

