/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.DialogHandler;
import net.sf.freecol.client.gui.option.OptionGroupUI;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.option.OptionGroup;

public abstract class OptionsDialog
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(OptionsDialog.class.getName());
    private OptionGroup group;
    private OptionGroupUI ui;
    private final String defaultFileName;
    private final String optionGroupId;
    private MigPanel optionPanel;
    protected MigPanel panel;
    private DialogHandler<OptionGroup> dialogHandler;

    protected OptionsDialog(FreeColClient freeColClient, OptionGroup group, String headerKey, String defaultFileName, String optionGroupId, boolean editable) {
        super(freeColClient, null, new MigLayout("fill"));
        this.editable = editable;
        this.group = group;
        this.ui = new OptionGroupUI(this.getGUI(), this.group, editable);
        this.defaultFileName = defaultFileName;
        this.optionGroupId = optionGroupId;
        this.preparePanel(headerKey, this.ui);
    }

    protected OptionGroup getGroup() {
        return this.group;
    }

    protected OptionGroupUI getOptionUI() {
        return this.ui;
    }

    protected String getDefaultFileName() {
        return this.defaultFileName;
    }

    protected String getOptionGroupId() {
        return this.optionGroupId;
    }

    public void setDialogHandler(DialogHandler<OptionGroup> dialogHandler) {
        this.dialogHandler = dialogHandler;
    }

    private void preparePanel(String headerKey, OptionGroupUI ui) {
        this.optionPanel = new MigPanel(new MigLayout("fill, insets 0, gap 0 0"));
        this.optionPanel.setOpaque(false);
        this.optionPanel.add((Component)ui, "grow");
        this.optionPanel.setSize(this.optionPanel.getPreferredSize());
        this.panel = new MigPanel(new MigLayout("wrap 1, fill"));
        this.panel.add((Component)Utility.localizedHeader(Messages.nameKey(headerKey), Utility.FONTSPEC_TITLE), "span, center");
    }

    protected void initialize(JFrame frame, List<JButton> extraButtons) {
        this.panel.add((Component)this.optionPanel, "width 100%, height 100%, gap 0 0");
        this.add((Component)this.panel, "grow");
        int numberOfButtons = 1 + extraButtons.size() + (this.isEditable() ? 1 : 0);
        this.add((Component)this.okButton, "newline, span, split " + numberOfButtons + ", tag ok");
        for (JButton button : extraButtons) {
            this.add(button);
        }
        if (this.isEditable()) {
            FreeColButton cancelButton = Utility.localizedButton("cancel");
            cancelButton.setActionCommand("CANCEL");
            cancelButton.addActionListener(this);
            this.add((Component)cancelButton, "tag cancel");
        }
        float scaleFactor = this.getImageLibrary().getScaleFactor();
        int maxWidth = (int)(850.0f * scaleFactor);
        int maxHeight = (int)(650.0f * scaleFactor);
        int width = Math.min(maxWidth, frame.getWidth() - 200);
        int height = Math.min(maxHeight, frame.getHeight() - 200);
        this.panel.setSize(new Dimension(width, height));
    }

    protected void set(OptionGroup group) {
        this.group = group;
        this.update();
    }

    private void update() {
        this.optionPanel.removeAll();
        this.ui = new OptionGroupUI(this.getGUI(), this.group, this.editable);
        this.optionPanel.add((Component)this.ui, "grow");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    protected boolean load(File file) {
        OptionGroup og = this.group;
        if (og == null) {
            og = OptionGroup.loadOptionGroup(file, this.getOptionGroupId(), this.getSpecification());
        } else {
            this.group.load(file);
        }
        if (og == null) {
            return false;
        }
        this.set(og);
        return true;
    }

    protected boolean save(File file) {
        if (this.group.save(file, null, true)) {
            return true;
        }
        this.getGUI().showErrorPanel(FreeCol.badFile("error.couldNotSave", file));
        return false;
    }

    protected boolean loadDefaultOptions() {
        File f = FreeColDirectories.getOptionsFile(this.getDefaultFileName());
        return f.exists() ? this.load(f) : false;
    }

    protected boolean saveDefaultOptions() {
        File f = FreeColDirectories.getOptionsFile(this.getDefaultFileName());
        return this.save(f);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if ("OK".equals(command)) {
            if (!this.isEditable()) {
                this.getGUI().removeComponent(this);
                if (this.dialogHandler != null) {
                    this.dialogHandler.handle(null);
                }
                return;
            }
            this.getOptionUI().updateOption();
            this.saveDefaultOptions();
            this.getGUI().removeComponent(this);
            if (this.dialogHandler != null) {
                this.dialogHandler.handle(this.group);
            }
        } else if ("CANCEL".equals(command)) {
            this.getOptionUI().reset();
            this.getGUI().removeComponent(this);
            if (this.dialogHandler != null) {
                this.dialogHandler.handle(null);
            }
        } else {
            logger.warning("Bad event: " + command);
        }
    }
}

