define(["filerepository","transfermanager","itemrepository"],function(filerepository,transfermanager,itemrepository){"use strict";function getImageUrl(serverId,itemId,imageOptions){serverId=getImagePath(0,itemId,imageOptions.type,imageOptions.index);return filerepository.getImageUrl(serverId)}function getImagePath(serverId,itemId,imageType,index){for(var parts=[],finalParts=(parts.push("images"),parts.push(itemId+"_"+imageType+"_"+(index=index||0).toString()),[]),i=0;i<parts.length;i++)finalParts.push(parts[i]);return finalParts}return{getDirectoryPath:function(item){var parts=[],itemtype=item.Type.toLowerCase(),mediaType=(item.MediaType||"").toLowerCase(),albumArtist=("episode"===itemtype||"series"===itemtype||"season"===itemtype?parts.push("TV"):"trailer"===itemtype?parts.push("Trailers"):"video"===mediaType?parts.push("Videos"):"audio"===itemtype||"musicalbum"===itemtype||"musicartist"===itemtype?parts.push("Music"):"photo"===itemtype||"photoalbum"===itemtype?parts.push("Photos"):"game"!==itemtype&&"gamesystem"!==itemtype||parts.push("Games"),item.AlbumArtist);albumArtist&&parts.push(albumArtist),(albumArtist=item.SeriesName)&&parts.push(albumArtist);(albumArtist=item.SeasonName)&&parts.push(albumArtist),item.Album&&parts.push(item.Album),item.GameSystem&&parts.push(item.GameSystem),("video"===mediaType&&"episode"!==itemtype||"game"===itemtype||item.IsFolder)&&parts.push(item.Name);for(var finalParts=[],i=0;i<parts.length;i++)finalParts.push(filerepository.getValidFileName(parts[i]));return finalParts},getLocalFileName:function(item,originalFileName){return originalFileName=originalFileName||item.Name,filerepository.getValidFileName(originalFileName)},removeLocalItem:function(localItem){return itemrepository.getLibraryItem(localItem.ServerId,localItem.ItemId).then(function(item){function onFileDeletedSuccessOrFail(){return itemrepository.deleteLibraryItem(localItem.ServerId,localItem.ItemId)}var p=Promise.resolve();return item.LocalPath&&(p=p.then(function(){return filerepository.deleteFile(item.LocalPath)})),item&&item.Item&&item.Item.MediaSources&&item.Item.MediaSources.forEach(function(mediaSource){mediaSource.MediaStreams&&0<mediaSource.MediaStreams.length&&mediaSource.MediaStreams.forEach(function(mediaStream){mediaStream.Path&&(p=p.then(function(){return filerepository.deleteFile(mediaStream.Path)}))})}),p.then(onFileDeletedSuccessOrFail,onFileDeletedSuccessOrFail)},function(){return Promise.resolve()})},downloadFile:function(url,localItem){var imageUrl=getImageUrl(localItem.Item.ServerId,localItem.Item.Id,{type:"Primary",index:0});return transfermanager.downloadFile(url,localItem,imageUrl)},downloadSubtitles:function(url,fileName){return transfermanager.downloadSubtitles(url,fileName)},hasImage:function(serverId,itemId,imageType,index){return serverId=getImagePath(0,itemId,imageType,index),itemId=filerepository.getFullMetadataPath(serverId),filerepository.fileExists(itemId).then(function(exists){return Promise.resolve(exists)},function(){return Promise.resolve(!1)})},downloadImage:function(localItem,url,serverId,itemId,imageType,index){return serverId=getImagePath(0,itemId,imageType,index),transfermanager.downloadImage(url,serverId)},getImageUrl:getImageUrl,getSubtitleSaveFileName:function(localItem,mediaPath,language,isForced,format){return mediaPath=function(path){var pos=path.lastIndexOf(".");0<pos&&(path=path.substring(0,pos));return path}(mediaPath),mediaPath=filerepository.getValidFileName(mediaPath),language&&(mediaPath+="."+language.toLowerCase()),isForced&&(mediaPath+=".forced"),mediaPath=mediaPath+"."+format.toLowerCase(),language=filerepository.getParentPath(localItem.LocalPath),filerepository.combinePath(language,mediaPath)},getItemFileSize:function(path){return filerepository.getItemFileSize(path)},isDownloadFileInQueue:function(path){return transfermanager.isDownloadFileInQueue(path)},getDownloadItemCount:function(){return transfermanager.getDownloadItemCount()},resyncTransfers:function(){return transfermanager.resyncTransfers()},fileExists:function(localFilePath){return filerepository.fileExists(localFilePath)},enableBackgroundCompletion:function(){return transfermanager.enableBackgroundCompletion}}});