define(["exports","../utils/events.js","../utils/logger.js","../../browser.js","./media-info.js","../demux/flv-demuxer.js","../remux/mp4-remuxer.js","../demux/demux-errors.js","../io/io-controller.js","./transmuxing-events.js","../io/loader.js"],function(_exports,_events,_logger,_browser,_mediaInfo,_flvDemuxer,_mp4Remuxer,_demuxErrors,_ioController,_transmuxingEvents,_loader){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var TransmuxingController=function(){function TransmuxingController(mediaDataSource,config){babelHelpers.classCallCheck(this,TransmuxingController),this.TAG="TransmuxingController",this._emitter=new _events.default,this._config=config,mediaDataSource.segments||(mediaDataSource.segments=[{duration:mediaDataSource.duration,filesize:mediaDataSource.filesize,url:mediaDataSource.url}]),"boolean"!=typeof mediaDataSource.cors&&(mediaDataSource.cors=!0),"boolean"!=typeof mediaDataSource.withCredentials&&(mediaDataSource.withCredentials=!1),this._mediaDataSource=mediaDataSource;var totalDuration=this._currentSegmentIndex=0;this._mediaDataSource.segments.forEach(function(segment){segment.timestampBase=totalDuration,totalDuration+=segment.duration,segment.cors=mediaDataSource.cors,segment.withCredentials=mediaDataSource.withCredentials,config.referrerPolicy&&(segment.referrerPolicy=config.referrerPolicy)}),isNaN(totalDuration)||this._mediaDataSource.duration===totalDuration||(this._mediaDataSource.duration=totalDuration),this._mediaInfo=null,this._demuxer=null,this._remuxer=null,this._ioctl=null,this._pendingSeekTime=null,this._pendingResolveSeekPoint=null,this._statisticsReporter=null}return babelHelpers.createClass(TransmuxingController,[{key:"destroy",value:function(){this._mediaInfo=null,this._mediaDataSource=null,this._statisticsReporter&&this._disableStatisticsReporter(),this._ioctl&&(this._ioctl.destroy(),this._ioctl=null),this._demuxer&&(this._demuxer.destroy(),this._demuxer=null),this._remuxer&&(this._remuxer.destroy(),this._remuxer=null),this._emitter.removeAllListeners(),this._emitter=null}},{key:"on",value:function(event,listener){this._emitter.addListener(event,listener)}},{key:"off",value:function(event,listener){this._emitter.removeListener(event,listener)}},{key:"start",value:function(){this._loadSegment(0),this._enableStatisticsReporter()}},{key:"_loadSegment",value:function(segmentIndex,optionalFrom){this._currentSegmentIndex=segmentIndex;var dataSource=this._mediaDataSource.segments[segmentIndex],dataSource=this._ioctl=new _ioController.default(dataSource,this._config,segmentIndex);dataSource.onError=this._onIOException.bind(this),dataSource.onSeeked=this._onIOSeeked.bind(this),dataSource.onComplete=this._onIOComplete.bind(this),dataSource.onRedirect=this._onIORedirect.bind(this),dataSource.onRecoveredEarlyEof=this._onIORecoveredEarlyEof.bind(this),optionalFrom?this._demuxer.bindDataSource(this._ioctl):dataSource.onDataArrival=this._onInitChunkArrival.bind(this),dataSource.open(optionalFrom)}},{key:"stop",value:function(){this._internalAbort(),this._disableStatisticsReporter()}},{key:"_internalAbort",value:function(){this._ioctl&&(this._ioctl.destroy(),this._ioctl=null)}},{key:"pause",value:function(){this._ioctl&&this._ioctl.isWorking()&&(this._ioctl.pause(),this._disableStatisticsReporter())}},{key:"resume",value:function(){this._ioctl&&this._ioctl.isPaused()&&(this._ioctl.resume(),this._enableStatisticsReporter())}},{key:"seek",value:function(milliseconds){var targetSegmentIndex,segmentInfo;null!=this._mediaInfo&&this._mediaInfo.isSeekable()&&((targetSegmentIndex=this._searchSegmentIndexContains(milliseconds))===this._currentSegmentIndex?null==(segmentInfo=this._mediaInfo.segments[targetSegmentIndex])?this._pendingSeekTime=milliseconds:(segmentInfo=segmentInfo.getNearestKeyframe(milliseconds),this._remuxer.seek(segmentInfo.milliseconds),this._ioctl.seek(segmentInfo.fileposition),this._pendingResolveSeekPoint=segmentInfo.milliseconds):null==(segmentInfo=this._mediaInfo.segments[targetSegmentIndex])?(this._pendingSeekTime=milliseconds,this._internalAbort(),this._remuxer.seek(),this._remuxer.insertDiscontinuity(),this._loadSegment(targetSegmentIndex)):(segmentInfo=segmentInfo.getNearestKeyframe(milliseconds),this._internalAbort(),this._remuxer.seek(milliseconds),this._remuxer.insertDiscontinuity(),this._demuxer.resetMediaInfo(),this._demuxer.timestampBase=this._mediaDataSource.segments[targetSegmentIndex].timestampBase,this._loadSegment(targetSegmentIndex,segmentInfo.fileposition),this._pendingResolveSeekPoint=segmentInfo.milliseconds,this._reportSegmentMediaInfo(targetSegmentIndex)),this._enableStatisticsReporter())}},{key:"_searchSegmentIndexContains",value:function(milliseconds){for(var segments=this._mediaDataSource.segments,idx=segments.length-1,i=0;i<segments.length;i++)if(milliseconds<segments[i].timestampBase){idx=i-1;break}return idx}},{key:"_onInitChunkArrival",value:function(data,byteStart){var mds,_this=this,probeData=null;return 0<byteStart?(this._demuxer.bindDataSource(this._ioctl),this._demuxer.timestampBase=this._mediaDataSource.segments[this._currentSegmentIndex].timestampBase,this._demuxer.parseChunks(data,byteStart)):(probeData=_flvDemuxer.default.probe(data)).match?(this._demuxer=new _flvDemuxer.default(probeData,this._config),this._remuxer||(this._remuxer=new _mp4Remuxer.default(this._config)),mds=this._mediaDataSource,this._demuxer.timestampBase=mds.segments[this._currentSegmentIndex].timestampBase,this._demuxer.onError=this._onDemuxException.bind(this),this._demuxer.onMediaInfo=this._onMediaInfo.bind(this),this._demuxer.onMetaDataArrived=this._onMetaDataArrived.bind(this),this._demuxer.onScriptDataArrived=this._onScriptDataArrived.bind(this),this._remuxer.bindDataSource(this._demuxer.bindDataSource(this._ioctl)),this._remuxer.onInitSegment=this._onRemuxerInitSegmentArrival.bind(this),this._remuxer.onMediaSegment=this._onRemuxerMediaSegmentArrival.bind(this),this._demuxer.parseChunks(data,byteStart)):(probeData=null,_logger.default.e(this.TAG,"Non-FLV, Unsupported media type!"),Promise.resolve().then(function(){_this._internalAbort()}),this._emitter.emit(_transmuxingEvents.default.DEMUX_ERROR,_demuxErrors.default.FORMAT_UNSUPPORTED,"Non-FLV, Unsupported media type"),0)}},{key:"_onMediaInfo",value:function(mediaInfo){var _this2=this,mediaInfo=(null==this._mediaInfo&&(this._mediaInfo=Object.assign({},mediaInfo),this._mediaInfo.keyframesIndex=null,this._mediaInfo.segments=[],this._mediaInfo.segmentCount=this._mediaDataSource.segments.length,Object.setPrototypeOf(this._mediaInfo,_mediaInfo.default.prototype)),Object.assign({},mediaInfo));Object.setPrototypeOf(mediaInfo,_mediaInfo.default.prototype),this._mediaInfo.segments[this._currentSegmentIndex]=mediaInfo,this._reportSegmentMediaInfo(this._currentSegmentIndex),null!=this._pendingSeekTime&&Promise.resolve().then(function(){var target=_this2._pendingSeekTime;_this2._pendingSeekTime=null,_this2.seek(target)})}},{key:"_onMetaDataArrived",value:function(metadata){this._emitter.emit(_transmuxingEvents.default.METADATA_ARRIVED,metadata)}},{key:"_onScriptDataArrived",value:function(data){this._emitter.emit(_transmuxingEvents.default.SCRIPTDATA_ARRIVED,data)}},{key:"_onIOSeeked",value:function(){this._remuxer.insertDiscontinuity()}},{key:"_onIOComplete",value:function(extraData){extraData+=1;extraData<this._mediaDataSource.segments.length?(this._internalAbort(),this._remuxer.flushStashedSamples(),this._loadSegment(extraData)):(this._remuxer.flushStashedSamples(),this._emitter.emit(_transmuxingEvents.default.LOADING_COMPLETE),this._disableStatisticsReporter())}},{key:"_onIORedirect",value:function(redirectedURL){var segmentIndex=this._ioctl.extraData;this._mediaDataSource.segments[segmentIndex].redirectedURL=redirectedURL}},{key:"_onIORecoveredEarlyEof",value:function(){this._emitter.emit(_transmuxingEvents.default.RECOVERED_EARLY_EOF)}},{key:"_onIOException",value:function(type,info){_logger.default.e(this.TAG,"IOException: type = ".concat(type,", code = ").concat(info.code,", msg = ").concat(info.msg)),this._emitter.emit(_transmuxingEvents.default.IO_ERROR,type,info),this._disableStatisticsReporter()}},{key:"_onDemuxException",value:function(type,info){_logger.default.e(this.TAG,"DemuxException: type = ".concat(type,", info = ").concat(info)),this._emitter.emit(_transmuxingEvents.default.DEMUX_ERROR,type,info)}},{key:"_onRemuxerInitSegmentArrival",value:function(type,initSegment){this._emitter.emit(_transmuxingEvents.default.INIT_SEGMENT,type,initSegment)}},{key:"_onRemuxerMediaSegmentArrival",value:function(type,mediaSegment){null==this._pendingSeekTime&&(this._emitter.emit(_transmuxingEvents.default.MEDIA_SEGMENT,type,mediaSegment),null!=this._pendingResolveSeekPoint&&"video"===type&&(type=mediaSegment.info.syncPoints,mediaSegment=this._pendingResolveSeekPoint,this._pendingResolveSeekPoint=null,_browser.default.safari&&0<type.length&&type[0].originalDts===mediaSegment&&(mediaSegment=type[0].pts),this._emitter.emit(_transmuxingEvents.default.RECOMMEND_SEEKPOINT,mediaSegment)))}},{key:"_enableStatisticsReporter",value:function(){null==this._statisticsReporter&&(this._statisticsReporter=self.setInterval(this._reportStatisticsInfo.bind(this),this._config.statisticsInfoReportInterval))}},{key:"_disableStatisticsReporter",value:function(){this._statisticsReporter&&(self.clearInterval(this._statisticsReporter),this._statisticsReporter=null)}},{key:"_reportSegmentMediaInfo",value:function(segmentIndex){segmentIndex=this._mediaInfo.segments[segmentIndex],segmentIndex=Object.assign({},segmentIndex);segmentIndex.duration=this._mediaInfo.duration,segmentIndex.segmentCount=this._mediaInfo.segmentCount,delete segmentIndex.segments,delete segmentIndex.keyframesIndex,this._emitter.emit(_transmuxingEvents.default.MEDIA_INFO,segmentIndex)}},{key:"_reportStatisticsInfo",value:function(){var info={};info.url=this._ioctl.currentURL,info.hasRedirect=this._ioctl.hasRedirect,info.hasRedirect&&(info.redirectedURL=this._ioctl.currentRedirectedURL),info.speed=this._ioctl.currentSpeed,info.loaderType=this._ioctl.loaderType,info.currentSegmentIndex=this._currentSegmentIndex,info.totalSegmentCount=this._mediaDataSource.segments.length,this._emitter.emit(_transmuxingEvents.default.STATISTICS_INFO,info)}}]),TransmuxingController}();_exports.default=TransmuxingController});