define(["exports","../utils/events.js","../utils/logger.js","../utils/logging-control.js","./transmuxing-controller.js","./transmuxing-events.js","./transmuxing-worker.js","./media-info.js"],function(_exports,_events,_logger,_loggingControl,_transmuxingController,_transmuxingEvents,_transmuxingWorker,_mediaInfo){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_exports.default=function(){function Transmuxer(mediaDataSource,config){if(babelHelpers.classCallCheck(this,Transmuxer),this.TAG="Transmuxer",this._emitter=new _events.default,config.enableWorker&&"undefined"!=typeof Worker)try{var work=require("webworkify");this._worker=work(_transmuxingWorker.default),this._workerDestroying=!1,this._worker.addEventListener("message",this._onWorkerMessage.bind(this)),this._worker.postMessage({cmd:"init",param:[mediaDataSource,config]}),this.e={onLoggingConfigChanged:this._onLoggingConfigChanged.bind(this)},_loggingControl.default.registerListener(this.e.onLoggingConfigChanged),this._worker.postMessage({cmd:"logging_config",param:_loggingControl.default.getConfig()})}catch(error){_logger.default.e(this.TAG,"Error while initialize transmuxing worker, fallback to inline transmuxing"),this._worker=null,this._controller=new _transmuxingController.default(mediaDataSource,config)}else this._controller=new _transmuxingController.default(mediaDataSource,config);this._controller&&((work=this._controller).on(_transmuxingEvents.default.IO_ERROR,this._onIOError.bind(this)),work.on(_transmuxingEvents.default.DEMUX_ERROR,this._onDemuxError.bind(this)),work.on(_transmuxingEvents.default.INIT_SEGMENT,this._onInitSegment.bind(this)),work.on(_transmuxingEvents.default.MEDIA_SEGMENT,this._onMediaSegment.bind(this)),work.on(_transmuxingEvents.default.LOADING_COMPLETE,this._onLoadingComplete.bind(this)),work.on(_transmuxingEvents.default.RECOVERED_EARLY_EOF,this._onRecoveredEarlyEof.bind(this)),work.on(_transmuxingEvents.default.MEDIA_INFO,this._onMediaInfo.bind(this)),work.on(_transmuxingEvents.default.METADATA_ARRIVED,this._onMetaDataArrived.bind(this)),work.on(_transmuxingEvents.default.SCRIPTDATA_ARRIVED,this._onScriptDataArrived.bind(this)),work.on(_transmuxingEvents.default.STATISTICS_INFO,this._onStatisticsInfo.bind(this)),work.on(_transmuxingEvents.default.RECOMMEND_SEEKPOINT,this._onRecommendSeekpoint.bind(this)))}return babelHelpers.createClass(Transmuxer,[{key:"destroy",value:function(){this._worker?this._workerDestroying||(this._workerDestroying=!0,this._worker.postMessage({cmd:"destroy"}),_loggingControl.default.removeListener(this.e.onLoggingConfigChanged),this.e=null):(this._controller.destroy(),this._controller=null),this._emitter.removeAllListeners(),this._emitter=null}},{key:"on",value:function(event,listener){this._emitter.addListener(event,listener)}},{key:"off",value:function(event,listener){this._emitter.removeListener(event,listener)}},{key:"hasWorker",value:function(){return null!=this._worker}},{key:"open",value:function(){this._worker?this._worker.postMessage({cmd:"start"}):this._controller.start()}},{key:"close",value:function(){this._worker?this._worker.postMessage({cmd:"stop"}):this._controller.stop()}},{key:"seek",value:function(milliseconds){this._worker?this._worker.postMessage({cmd:"seek",param:milliseconds}):this._controller.seek(milliseconds)}},{key:"pause",value:function(){this._worker?this._worker.postMessage({cmd:"pause"}):this._controller.pause()}},{key:"resume",value:function(){this._worker?this._worker.postMessage({cmd:"resume"}):this._controller.resume()}},{key:"_onInitSegment",value:function(type,initSegment){var _this=this;Promise.resolve().then(function(){_this._emitter.emit(_transmuxingEvents.default.INIT_SEGMENT,type,initSegment)})}},{key:"_onMediaSegment",value:function(type,mediaSegment){var _this2=this;Promise.resolve().then(function(){_this2._emitter.emit(_transmuxingEvents.default.MEDIA_SEGMENT,type,mediaSegment)})}},{key:"_onLoadingComplete",value:function(){var _this3=this;Promise.resolve().then(function(){_this3._emitter.emit(_transmuxingEvents.default.LOADING_COMPLETE)})}},{key:"_onRecoveredEarlyEof",value:function(){var _this4=this;Promise.resolve().then(function(){_this4._emitter.emit(_transmuxingEvents.default.RECOVERED_EARLY_EOF)})}},{key:"_onMediaInfo",value:function(mediaInfo){var _this5=this;Promise.resolve().then(function(){_this5._emitter.emit(_transmuxingEvents.default.MEDIA_INFO,mediaInfo)})}},{key:"_onMetaDataArrived",value:function(metadata){var _this6=this;Promise.resolve().then(function(){_this6._emitter.emit(_transmuxingEvents.default.METADATA_ARRIVED,metadata)})}},{key:"_onScriptDataArrived",value:function(data){var _this7=this;Promise.resolve().then(function(){_this7._emitter.emit(_transmuxingEvents.default.SCRIPTDATA_ARRIVED,data)})}},{key:"_onStatisticsInfo",value:function(statisticsInfo){var _this8=this;Promise.resolve().then(function(){_this8._emitter.emit(_transmuxingEvents.default.STATISTICS_INFO,statisticsInfo)})}},{key:"_onIOError",value:function(type,info){var _this9=this;Promise.resolve().then(function(){_this9._emitter.emit(_transmuxingEvents.default.IO_ERROR,type,info)})}},{key:"_onDemuxError",value:function(type,info){var _this10=this;Promise.resolve().then(function(){_this10._emitter.emit(_transmuxingEvents.default.DEMUX_ERROR,type,info)})}},{key:"_onRecommendSeekpoint",value:function(milliseconds){var _this11=this;Promise.resolve().then(function(){_this11._emitter.emit(_transmuxingEvents.default.RECOMMEND_SEEKPOINT,milliseconds)})}},{key:"_onLoggingConfigChanged",value:function(config){this._worker&&this._worker.postMessage({cmd:"logging_config",param:config})}},{key:"_onWorkerMessage",value:function(e){var message=e.data,data=message.data;if("destroyed"===message.msg||this._workerDestroying)return this._workerDestroying=!1,this._worker.terminate(),void(this._worker=null);switch(message.msg){case _transmuxingEvents.default.INIT_SEGMENT:case _transmuxingEvents.default.MEDIA_SEGMENT:this._emitter.emit(message.msg,data.type,data.data);break;case _transmuxingEvents.default.LOADING_COMPLETE:case _transmuxingEvents.default.RECOVERED_EARLY_EOF:this._emitter.emit(message.msg);break;case _transmuxingEvents.default.MEDIA_INFO:Object.setPrototypeOf(data,_mediaInfo.default.prototype),this._emitter.emit(message.msg,data);break;case _transmuxingEvents.default.METADATA_ARRIVED:case _transmuxingEvents.default.SCRIPTDATA_ARRIVED:case _transmuxingEvents.default.STATISTICS_INFO:this._emitter.emit(message.msg,data);break;case _transmuxingEvents.default.IO_ERROR:case _transmuxingEvents.default.DEMUX_ERROR:this._emitter.emit(message.msg,data.type,data.info);break;case _transmuxingEvents.default.RECOMMEND_SEEKPOINT:this._emitter.emit(message.msg,data);break;case"logcat_callback":_logger.default.emitter.emit("log",data.type,data.logcat)}}}]),Transmuxer}()});