define(["exports","./../../browser.js","./../../shortcuts.js","./../../emby-apiclient/connectionmanager.js","./../../common/input/api.js","./../../emby-apiclient/events.js","./../../common/globalize.js","./../../dom.js","./../../layoutmanager.js","./../../common/datetime.js","./../../focusmanager.js","./../../loading/loading.js","./../../common/usersettings/usersettings.js","./gridrowrenderer.js","./../emby-button/emby-button.js","./../emby-scroller/emby-scroller.js","./../emby-button/paper-icon-button-light.js","./../../common/methodtimer.js","./../emby-itemscontainer/emby-itemscontainer.js"],function(_exports,_browser,_shortcuts,_connectionmanager,_api,_events,_globalize,_dom,_layoutmanager,_datetime,_focusmanager,_loading,_usersettings,_gridrowrenderer,_embyButton,_embyScroller,_paperIconButtonLight,_methodtimer,_embyItemscontainer){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,require(["css!modules/emby-elements/guide/guide.css","programStyles","material-icons","scrollStyles","flexStyles"]);var cellDurationMs=18e5,msPerMinute=6e4,msPerPage=288e5,startId=Date.now();function normalizeDateToTimeslot(value,roundUp){var delta=value%cellDurationMs;return roundUp&&delta&&(value+=cellDurationMs),value-=delta}function onSettingsButtonClick(){var instance=this;require(["guide-settings-dialog"],function(guideSettingsDialog){guideSettingsDialog.show(instance.categoryOptions,_connectionmanager.default.getApiClient(instance.options.serverId)).then(function(){instance.refresh()})})}function onDateButtonClick(e){var instance=this;require(["actionsheet"],function(actionsheet){var options=function(instance){for(var items=[],start=new Date(instance._startDateMs),end=new Date(instance._endDateMs),nowHours=(today=new Date).getHours(),nowMinutes=30<=today.getMinutes()?30:0,nowHours=(start.setHours(nowHours,nowMinutes,0,0),end.setHours(0,0,0,0),start.getTime()>=end.getTime()&&end.setDate(start.getDate()+1),start=new Date(Math.max(today,start)),instance.scroller),nowMinutes=instance.scroller.getScrollWidth(),today=(nowMinutes-=getChannelCellWidth(instance),instance._startDateMs),instance=instance._endDateMs,nowHours=Math.abs(nowHours.getScrollLeft())/nowMinutes*(instance-today),date=(nowHours+=today,new Date(nowHours));start<=end;)items.push({name:_datetime.default.toLocaleDateString(start,{weekday:"long",month:"short",day:"numeric"}),value:start.getTime().toString(),selected:date.getDate()===start.getDate()&&date.getMonth()===start.getMonth()&&date.getFullYear()===start.getFullYear()}),start.setDate(start.getDate()+1),start.setHours(0,0,0,0);return items}(instance);actionsheet.show({items:options,positionTo:e.target,title:_globalize.default.translate("HeaderSelectDate"),positionY:"bottom",hasItemSelectionState:!0}).then(function(value){scrollToTimeMs(this,value,!1)}.bind(instance))})}function scrollToTimeMs(instance,value,exactTime){value=parseInt(value),exactTime&&(value=normalizeDateToTimeslot(value));var startDate,endDate,date=new Date,value=(date.setTime(value),instance.scroller),scrollWidth=instance.scroller.getScrollWidth();scrollWidth&&(scrollWidth-=getChannelCellWidth(instance),startDate=instance._startDateMs,endDate=instance._endDateMs,exactTime||(exactTime=Math.abs(value.getScrollLeft())/scrollWidth*(endDate-startDate),exactTime+=startDate,exactTime=new Date(exactTime),date.setHours(exactTime.getHours(),exactTime.getMinutes()+1,0,0),date.setTime(normalizeDateToTimeslot(date.getTime()))),exactTime=Math.max(date.getTime()-startDate,0)/(endDate-startDate),value.scrollToPosition({left:exactTime*scrollWidth*value.getScrollLeftMultiplier(),behavior:"instant"}),onScroll.call(instance,{currentTarget:instance.scroller,target:instance.scroller}))}var insetInlineStartProp=CSS.supports("inset-inline-start","0")?"insetInlineStart":"left";function setPaddingLeft(elem,value){(elem._paddingInlineStart||"0")!==value&&(elem._paddingInlineStart=value,elem.style[insetInlineStartProp]=value)}function getChannelCellWidth(instance){var channelCellWidth=instance.channelCellWidth;return channelCellWidth||(channelCellWidth=instance.firstChannelCell.offsetWidth,instance.channelCellWidth=channelCellWidth),channelCellWidth}function getTimeBlockStart(instance,scrollLeft,scrollWidth){var startDate=instance._startDateMs,instance=instance._endDateMs,scrollLeft=scrollWidth?scrollLeft/scrollWidth*(instance-startDate):0;return(scrollLeft=Math.floor(scrollLeft))-scrollLeft%msPerPage+startDate}function getProgramFieldsProperty(){var programFields=[];return"true"===_usersettings.default.get("false"!==_usersettings.default.get("guide-indicator-4k")||"guide-indicator-hd")&&(programFields.push("IsHD"),programFields.push("Width")),programFields.length?programFields.join(","):null}function loadPrograms(instance,epgRowMap,channelIds,timeBlockStart){var promise,apiClient=_connectionmanager.default.getApiClient(instance.options.serverId),cacheKey=[apiClient.getCurrentUserId(),timeBlockStart.toString(),channelIds.join(",")].join("|"),cachedResult=(instance.programCache||(instance.programCache={}),instance.programCache[cacheKey]);(promise=cachedResult?Promise.resolve(cachedResult):promise)||(cachedResult=timeBlockStart===getTimeBlockStart(instance,0,0)?1e3:0,timeBlockStart={UserId:apiClient.getCurrentUserId(),MaxStartDate:new Date(timeBlockStart+msPerPage).toISOString(),MinEndDate:new Date(timeBlockStart+cachedResult).toISOString(),channelIds:channelIds.join(","),ImageTypeLimit:1,SortBy:"StartDate",EnableTotalRecordCount:!1,EnableUserData:!1,Fields:getProgramFieldsProperty()},promise=apiClient.getLiveTvPrograms(timeBlockStart)),promise.then(function(result){return instance.programCache||(instance.programCache={}),instance.programCache[cacheKey]=result,function(instance,epgRowMap,programs){for(var i=0,length=programs.length;i<length;i++){var program=programs[i],epgItem=epgRowMap[program.ChannelId];epgItem&&!function(instance,epgItem,program){_gridrowrenderer.default.parseDates(program);var insertAtIndex,programs=epgItem.Programs,programMap=epgItem.ProgramMap,programId=program.Id;programMap[programId]||(programMap[programId]=program,insertAtIndex=getInsertIndex(programs,program.StartDateLocalMs),programs.splice(insertAtIndex,0,program));epgItem=epgItem.RowElement;{var channelProgramsElement;!epgItem||(channelProgramsElement=epgItem.children[2])&&(programMap=epgItem.ProgramMap)&&!programMap[programId]&&(programMap[programId]=program,programs=epgItem.Programs,insertAtIndex=getInsertIndex(programs,program.StartDateLocalMs),programs.splice(insertAtIndex,0,program),programMap=instance.itemsContainer.currentListOptions.options,programId=programMap.endMs-programMap.startMs,epgItem=_gridrowrenderer.default.getProgramHtml(program,programMap,programId),(programs=channelProgramsElement.children[insertAtIndex])?programs.insertAdjacentHTML("beforebegin",epgItem):channelProgramsElement.insertAdjacentHTML("beforeend",epgItem))}}(instance,epgItem,program)}updateCellTexts(instance)}(instance,epgRowMap,result.Items)})}function getInsertIndex(programs,programStartTime){for(var numPrograms=programs.length,insertAtIndex=numPrograms,i=0,length=numPrograms;i<length;i++)if(programStartTime<=programs[i].StartDateLocalMs){insertAtIndex=i;break}return insertAtIndex}function onScroll(e){var channelCellWidth,absScrollLeft,scrollPct,scrollLeft=(e.currentTarget||e.target).getScrollLeft(),scrollXChanged=this.lastScrollLeft!==scrollLeft||_browser.default.firefox;scrollXChanged&&this.headerScroller.scrollToPosition({left:scrollLeft,behavior:"instant"}),(scrollXChanged||e.forceHorizontalChange)&&(_layoutmanager.default.tv&&(scrollLeft?this.firstChannelCell.classList.add("firstChannelCell-withscroll"):this.firstChannelCell.classList.remove("firstChannelCell-withscroll")),channelCellWidth=getChannelCellWidth(this),channelCellWidth=this.scroller.getScrollWidth()-channelCellWidth,absScrollLeft=scrollLeft?Math.abs(scrollLeft):0,this.lastHorizontalScrollPct=scrollPct=scrollLeft?absScrollLeft/channelCellWidth*100:0,this.startDataLoadTimer(absScrollLeft),this.lastScrollLeft=scrollLeft,updateCellTexts(this,scrollPct,e.updateProgramTextRow),scrollXChanged&&this.updateDateButtonText(absScrollLeft,channelCellWidth))}function updateCellTexts(instance,scrollPct,rowToUpdate){var scrollLeft,channelCellWidth;if(null==scrollPct&&(scrollLeft=Math.abs(instance.scroller.getScrollLeft()),channelCellWidth=getChannelCellWidth(instance),channelCellWidth=instance.scroller.getScrollWidth()-channelCellWidth,scrollPct=scrollLeft?scrollLeft/channelCellWidth*100:0),rowToUpdate)updateProgramCellTextsForRow(rowToUpdate,scrollPct);else for(var activeItemElements=instance.itemsContainer.virtualScroller.getActiveItems().elements,i=0,length=activeItemElements.length;i<length;i++)updateProgramCellTextsForRow(activeItemElements[i],scrollPct)}function updateProgramCellTextsForRow(row,scrollPct){row=row.children[2];if(row)for(var programCells=row.children,caretFound=!1,i=0,length=programCells.length;i<length;i++)!function(cell,scrollPct,hidden){var width;if(hidden||((hidden=cell.posLeft)||(hidden=parseFloat(cell.style[insetInlineStartProp].replace("%","")),cell.posLeft=hidden),(width=cell.posWidth)||(width=parseFloat(cell.style.width.replace("%","")),cell.posWidth=width),99.8<=(width=(Math.max(Math.min(scrollPct,hidden+width),hidden)-hidden)/width*100)&&(width=0)),!(scrollPct=cell.programCellInner)&&width&&(scrollPct=cell.firstChild,cell.programCellInner=scrollPct),!(hidden=cell.caret)&&width&&(hidden=scrollPct.firstChild,cell.caret=hidden),scrollPct){if(width)return setPaddingLeft(scrollPct,width+"%"),hidden&&!1!==hidden._hidden&&(hidden._hidden=!1,hidden.classList.remove("hide")),1;setPaddingLeft(scrollPct,"0"),hidden&&!1===hidden._hidden&&(hidden._hidden=!0,hidden.classList.add("hide"))}}(programCells[i],scrollPct,caretFound)||(caretFound=!0)}function onLiveButtonClick(e){scrollToTimeMs(this,Date.now(),!0)}function onFocusInScroller(e){var customXOffset,elementRect,previousItem,id,lastFocusedItem=this.lastFocusedItem,target=e.target,focused=_focusmanager.default.focusableParent(target),e=(focused&&lastFocusedItem!==focused&&(lastFocusedItem=e.currentTarget,e=this,lastFocusedItem=lastFocusedItem,customXOffset=(focused=focused).closest(".programCell")?0-getChannelCellWidth(e):0,elementRect=focused.getBoundingClientRect(),customXOffset=lastFocusedItem.getElementPosition(focused,!0,{offset:customXOffset*lastFocusedItem.getScrollLeftMultiplier(),itemBoundingClientRect:elementRect}),elementRect=lastFocusedItem.getElementPosition(focused,!1,{offset:0*lastFocusedItem.getScrollTopMultiplier(),itemBoundingClientRect:elementRect}),previousItem=(previousItem=e._previousFocusItem)&&previousItem.closest(".epgRow")===focused.closest(".epgRow")?"isVisible":"anyVisible",e._previousFocusItem=focused,customXOffset[previousItem]||elementRect.isVisible?customXOffset[previousItem]?elementRect.isVisible||lastFocusedItem.scrollToPosition({top:Math.round(elementRect.center)}):lastFocusedItem.scrollToPosition({left:Math.round(customXOffset.start)}):lastFocusedItem.scrollToPosition({left:Math.round(customXOffset.start),top:Math.round(elementRect.center)})),target.closest(".programCell"));e&&(focused=e.closest(".epgRow"),previousItem=_shortcuts.default.getItemFromChildNode(focused,!0).Programs||[],id=e.getAttribute("data-id"),(lastFocusedItem=previousItem.filter(function(p){return p.Id===id})[0])&&_events.default.trigger(this,"focus",[{item:lastFocusedItem}]))}function bindScrollEventOnUpgrade(){this.scroller.addScrollEventListener?(this.scroller.addScrollEventListener(onScroll.bind(this),{passive:!0}),this.headerScroller.addScrollEventListener(function(e){}.bind(this),{passive:!0})):this.scroller.addEventListener("upgraded",bindScrollEventOnUpgrade.bind(this))}function initialRender(instance){return instance.rendered?Promise.resolve():(instance.rendered=!0,require(["text!modules/emby-elements/guide/tvguide.template.html"]).then(function(responses){for(var context=instance.options.element,responses=(context.classList.add("tvguide"),context.innerHTML=_globalize.default.translateDocument(responses[0],"sharedcomponents"),_layoutmanager.default.tv?(context.querySelector(".btnGuideViewSettings-side").classList.remove("hide"),context.querySelector(".btnSelectDate-side").classList.remove("hide")):context.querySelector(".itemsViewSettingsContainer").classList.remove("hide"),instance.firstChannelCell=context.querySelector(".firstChannelCell"),instance.options.condensed&&instance.firstChannelCell.classList.add("channelCell-condensed"),_shortcuts.default.on(context),instance.onTimerCreatedFn=function(e,apiClient,data){for(var programId=data.ProgramId,newTimerId=data.Id,cells=this.options.element.querySelectorAll('.programCell[data-id="'+programId+'"]'),i=0,length=cells.length;i<length;i++){var cell=cells[i];cell.querySelector(".timerIcon")||cell.querySelector(".programCellInner").insertAdjacentHTML("beforeend",'<i class="timerIcon md-icon programIcon">&#xE061;</i>'),newTimerId&&cell.setAttribute("data-timerid",newTimerId)}}.bind(instance),_events.default.on(_api.default,"TimerCreated",instance.onTimerCreatedFn),instance.onSeriesTimerCreatedFn=function(e,apiClient,data){}.bind(instance),_events.default.on(_api.default,"SeriesTimerCreated",instance.onSeriesTimerCreatedFn),instance.onTimerCancelledFn=function(e,apiClient,data){for(var options=this.options,data=data.Id,cells=options.element.querySelectorAll('.programCell[data-timerid="'+data+'"]'),i=0,length=cells.length;i<length;i++){var cell=cells[i],icon=cell.querySelector(".timerIcon");icon&&icon.parentNode.removeChild(icon),cell.removeAttribute("data-timerid")}}.bind(instance),_events.default.on(_api.default,"TimerCancelled",instance.onTimerCancelledFn),instance.onSeriesTimerCancelledFn=function(e,apiClient,data){for(var options=this.options,data=data.Id,cells=options.element.querySelectorAll('.programCell[data-seriestimerid="'+data+'"]'),i=0,length=cells.length;i<length;i++){var cell=cells[i],icon=cell.querySelector(".seriesTimerIcon");icon&&icon.parentNode.removeChild(icon),cell.removeAttribute("data-seriestimerid")}}.bind(instance),_events.default.on(_api.default,"SeriesTimerCancelled",instance.onSeriesTimerCancelledFn),instance.scroller=instance.options.element.querySelector(".virtualScrollerScrollContainer"),instance.headerScroller=instance.options.element.querySelector(".headerScroller"),instance.uniqueId=startId,instance.scrollSliderUniqueClass="epgScrollSlider"+startId,instance.scroller.classList.add("epgVirtualScrollerScrollContainer-both"),bindScrollEventOnUpgrade.call(instance),context.querySelector(".itemsContainer")),settingsButtons=(responses.minItemsForVirtualRendering=0,responses.fetchData=instance.getItems.bind(instance),responses.afterRefresh=function(){var cssClass="guide-currentTimeIndicatorDot guideEpg-currentTimeIndicatorDot hide";this.options.condensed&&(cssClass+=" guide-currentTimeIndicatorDot-condensed"),this.currentTimeIndicatorDots=this.options.element.querySelectorAll(".guide-currentTimeIndicatorDot"),this.currentTimeIndicatorDots.length<2&&(this.itemsContainer.virtualScroller.insertAdjacentHTML("afterbegin",'<div class="'+cssClass+'"></div>'),this.currentTimeIndicatorDots=this.options.element.querySelectorAll(".guide-currentTimeIndicatorDot")),this.startCurrentTimeUpdateInterval()}.bind(instance),responses.virtualChunkSize=25,responses.getListOptions=instance.getListOptions.bind(instance),instance.itemsContainer=responses,instance.boundFocusableElements=function(row,activeElement,direction){if(activeElement.closest(".channelCell")){activeElement=row.querySelectorAll("button.channelCell");if(activeElement.length)return activeElement}else{activeElement=row.querySelectorAll("button.programCell");if(2<=direction){for(var currentPositionMs=this.currentPositionMs+msPerMinute,programs=row.Programs||[],startIndex=0,i=0,length=programs.length;i<length;i++){if(!(programs[i].EndDateLocalMs<=currentPositionMs))break;startIndex=i+1}0<startIndex&&(activeElement=Array.prototype.slice.call(activeElement,startIndex))}if(activeElement.length)return activeElement}return null}.bind(instance),responses.updateVirtualElement=function(row,item,index){var focusedId,activeElement;row&&(activeElement=document.activeElement,row.contains(activeElement)&&(activeElement=activeElement.closest("button"))&&(focusedId=activeElement.getAttribute("data-id"))),_embyItemscontainer.default.prototype.updateVirtualElement.apply(this.itemsContainer,arguments),(item.RowElement=row).Programs=item.Programs.slice(0),row.ProgramMap=getProgramMap(row),row.getFocusableElements=this.boundFocusableElements,this.itemsContainer.itemParts[index]=null,onScroll.call(this,{target:this.scroller,currentTarget:this.scroller,updateProgramTextRow:row,forceHorizontalChange:!0}),focusedId&&((activeElement=row.querySelector('button[data-id="'+focusedId+'"]'))?_focusmanager.default.focus(activeElement):_focusmanager.default.autoFocus(row))}.bind(instance),responses.onRecycleElement=function(row,index){row.ProgramMap=null,row.Programs=null,(row=this.itemsContainer.getItem(index))&&(row.RowElement=null)}.bind(instance),responses.getContextMenuElementFromChildNode=function(child){return _shortcuts.default.getItemElementFromChildNode(child,!1,this)}.bind(responses),instance.channelCellResizeObserver=new ResizeObserver(function(entries){entries[0]&&(this.channelCellWidth=null)}.bind(instance),{}),instance.channelCellResizeObserver.observe(instance.firstChannelCell),instance.channelCellResizeObserver.observe(instance.scroller),context.querySelectorAll(".btnGuideViewSettings")),i=0,length=settingsButtons.length;i<length;i++)settingsButtons[i].addEventListener("click",onSettingsButtonClick.bind(instance));var dateButtons=context.querySelectorAll(".btnSelectDate");for(i=0,length=dateButtons.length;i<length;i++)dateButtons[i].addEventListener("click",onDateButtonClick.bind(instance));_dom.default.addEventListener(instance.scroller,window.PointerEvent?"pointerdown":"mousedown",function(e){e=e.target,this.lastFocusedItem=_focusmanager.default.focusableParent(e),this.focusSourceIsPointer=!0}.bind(instance),{capture:!0,passive:!0}),_dom.default.addEventListener(instance.scroller,"focus",onFocusInScroller.bind(instance),{capture:!0,passive:!0}),instance.btnLiveGuide=instance.options.element.querySelector(".btnLiveGuide"),_dom.default.addEventListener(instance.btnLiveGuide,"click",onLiveButtonClick.bind(instance),{capture:!0,passive:!0}),instance.styleElementUniqueClass="guideStyle"+startId;responses=context.querySelectorAll(".epgScrollSlider");responses[0].classList.add(instance.scrollSliderUniqueClass),responses[1].classList.add(instance.scrollSliderUniqueClass),_layoutmanager.default.tv?(responses[0].classList.add(instance.scrollSliderUniqueClass+"-tv"),responses[1].classList.add(instance.scrollSliderUniqueClass+"-tv")):(responses[0].classList.remove(instance.scrollSliderUniqueClass+"-tv"),responses[1].classList.remove(instance.scrollSliderUniqueClass+"-tv")),startId++}))}function Guide(options){this.options=options,this.categoryOptions={categories:[]},this.boundLoadPrograms=function(){this._dataLoadSection=null;for(var channelCellWidth,offsetWidth,timeBlockStart,originalScrollLeft,timeblocks,scrollLeft,activeItems=this.itemsContainer.virtualScroller.getActiveItems(),elements=activeItems.elements,channelIdsNeedingData=[],epgRowMap={},numActiveRows=Math.min(elements.length,activeItems.lastIndex-activeItems.firstIndex+1),i=0;i<numActiveRows;i++){elements[i];var channelId,itemIndex=activeItems.firstIndex+i,itemIndex=this.itemsContainer.getItem(itemIndex);itemIndex&&(epgRowMap[channelId=itemIndex.Channel.Id]=itemIndex,channelIdsNeedingData.push(channelId))}channelIdsNeedingData.length&&(scrollLeft=this._loadDataInfo,channelCellWidth=getChannelCellWidth(this),channelCellWidth=this.scroller.getScrollWidth()-channelCellWidth,offsetWidth=this.scroller.getScrollContainerBoundingClientRect().width,timeblocks=[],scrollLeft=originalScrollLeft=scrollLeft,scrollLeft=Math.min(scrollLeft,channelCellWidth),scrollLeft=Math.max(scrollLeft,0),timeBlockStart=getTimeBlockStart(this,scrollLeft,channelCellWidth),-1===timeblocks.indexOf(timeBlockStart)&&(loadPrograms(this,epgRowMap,channelIdsNeedingData,timeBlockStart),timeblocks.push(timeBlockStart)),scrollLeft=originalScrollLeft,scrollLeft-=offsetWidth,scrollLeft=Math.min(scrollLeft,channelCellWidth),scrollLeft=Math.max(scrollLeft,0),timeBlockStart=getTimeBlockStart(this,scrollLeft,channelCellWidth),-1===timeblocks.indexOf(timeBlockStart)&&(loadPrograms(this,epgRowMap,channelIdsNeedingData,timeBlockStart),timeblocks.push(timeBlockStart)),scrollLeft=originalScrollLeft,scrollLeft+=offsetWidth,scrollLeft=Math.min(scrollLeft,channelCellWidth),scrollLeft=Math.max(scrollLeft,0),timeBlockStart=getTimeBlockStart(this,scrollLeft,channelCellWidth),-1===timeblocks.indexOf(timeBlockStart)&&(loadPrograms(this,epgRowMap,channelIdsNeedingData,timeBlockStart),timeblocks.push(timeBlockStart)))}.bind(this),this.lastScrollTop=0,this.lastScrollLeft=0}function getDisplayTime(date){if("string"===(typeof date).toString().toLowerCase())try{date=new Date(Date.parse(date))}catch(err){return date}return _datetime.default.getDisplayTime(date)}function renderWidthCss(instance){instance.scrollSliderUniqueClass;var strReplace,strWith,numCells=Math.ceil((instance._endDateMs-instance._startDateMs)/cellDurationMs),originalString=(originalString=numCells="\n.epgScrollSlider {\n        width: "+(37.5*numCells+7)+"vw;\n}\n\n@media all and (min-width: 37.5em) {\n\n    .epgScrollSlider {\n        width: "+(29.167*numCells+7)+"vw;\n    }\n}\n\n@media all and (min-width: 50em) {\n\n    .epgScrollSlider {\n        width: "+(25*numCells+8)+"vw;\n    }\n}\n\n@media all and (min-width: 80em) {\n\n    .epgScrollSlider {\n        width: "+(16.66667*numCells+10)+"vw;\n    }\n}\n    .epgScrollSlider-tv {\n        width: "+(19*numCells+8)+"vw;\n    }\n",strReplace="epgScrollSlider",strWith=instance.scrollSliderUniqueClass,strReplace=strReplace.replace(/([.*+?^=!:${}()|\[\]\/\\])/g,"\\$1"),strReplace=new RegExp(strReplace,"ig"),numCells=originalString.replace(strReplace,strWith),document.querySelector("."+instance.styleElementUniqueClass));originalString?originalString.innerHTML=numCells:((originalString=document.createElement("style")).innerHTML=numCells,document.head.appendChild(originalString))}function onGetGuideInfo(guideInfo){var guideInfo=Date.parse(guideInfo.EndDate),today=new Date,nowHours=today.getHours(),today=30<=today.getMinutes()?30:0,date=new Date,nowHours=(date.setHours(nowHours,today,0,0),_loading.default.show(),this._startDateMs=normalizeDateToTimeslot(date.getTime())),today=this._endDateMs=normalizeDateToTimeslot(guideInfo,!0);return renderWidthCss(this),this.options.element.querySelector(".timeslotHeaders").innerHTML=function(originalStartDateMs,endDateTimeMs){for(var startDate=new Date(originalStartDateMs),numSlots=0;startDate.getTime()<endDateTimeMs;)numSlots++,startDate.setTime(startDate.getTime()+cellDurationMs);var width=100/numSlots,startDate=new Date(originalStartDateMs),html="";for(html+='<div class="guide-currentTimeIndicatorDot guideHeader-currentTimeIndicatorDot"></div>';startDate.getTime()<endDateTimeMs;)html=(html+='<div class="timeslotHeader" style="width:'+width+'%;">')+getDisplayTime(startDate)+"</div>",startDate.setTime(startDate.getTime()+cellDurationMs);return html}(nowHours,today),this.updateDateButtonText(Math.abs(this.scroller.getScrollLeft())),this.options.element.querySelector(".btnSelectDate").classList.remove("hide"),this.itemsContainer.resume({refresh:!0}).then(function(){_loading.default.hide()})}var dateLocalOptions={weekday:"short",month:"short",day:"numeric"};function hideOrShow(elem,hide){!0===elem._showing?hide&&(elem.classList.add("hide"),elem._showing=!1):hide||(elem.classList.remove("hide"),elem._showing=!0)}function getProgramMap(epgItem){for(var programMap={},items=epgItem.Programs,i=0,length=items.length;i<length;i++){var item=items[i];programMap[item.Id]=item}return programMap}Guide.prototype.updateDateButtonText=function(scrollLeft,scrollWidth){null==scrollWidth&&(scrollWidth=this.scroller.getScrollWidth());var startDate=this._startDateMs,scrollLeft=scrollLeft/scrollWidth*(this._endDateMs-startDate),scrollWidth=(this.currentPositionMs=scrollLeft+=startDate,new Date(scrollLeft)),startDate=((this.btnDateText||(this.btnDateText=this.options.element.querySelector(_layoutmanager.default.tv?".btnDateText-side":".btnDateText-main"))).innerHTML=_datetime.default.toLocaleDateString(scrollWidth,dateLocalOptions),this.btnLiveGuide);!_layoutmanager.default.tv&&Math.abs(scrollLeft-Date.now())>cellDurationMs?hideOrShow(startDate,!1):hideOrShow(startDate,!0)},Guide.prototype.stopCurrentTimeUpdateInterval=function(){var interval=this.currentTimeUpdateInterval;interval&&(interval.destroy(),this.currentTimeUpdateInterval=null)},Guide.prototype.startCurrentTimeUpdateInterval=function(){var interval=this.currentTimeUpdateInterval,fn=function(){for(var dots=this.currentTimeIndicatorDots,startDateMs=this._startDateMs,endDate=this._endDateMs,now=Date.now(),pct=startDateMs&&endDate?(now-startDateMs)/(endDate-startDateMs)*100:-100,showIndicator=0<=pct&&pct<=100,displayTime=(pct=pct.toFixed(2)+"%",getDisplayTime(new Date(now))),i=0,length=dots.length;i<length;i++){var dot=dots[i];dot.style[insetInlineStartProp]=pct,dot.setAttribute("aria-label",displayTime),dot.title=displayTime,showIndicator?dot.classList.remove("hide"):dot.classList.add("hide")}}.bind(this);interval||(this.currentTimeUpdateInterval=new _methodtimer.default({onInterval:fn,timeoutMs:4e4,type:"interval"})),setTimeout(fn,200)},Guide.prototype.pause=function(){this.stopCurrentTimeUpdateInterval();var itemsContainer=this.itemsContainer;itemsContainer&&itemsContainer.pause()},Guide.prototype.resume=function(options){var instance=this;return initialRender(instance).then(function(){if(options&&options.refresh)return instance.refresh().then(function(instance,options){return function(){options&&options.autoFocus&&setTimeout(function(){_focusmanager.default.autoFocus(instance.itemsContainer)},_layoutmanager.default.tv?500:100)}}(instance,options));var itemsContainer=instance.itemsContainer;return itemsContainer?itemsContainer.resume(options).then(function(){instance.startCurrentTimeUpdateInterval();var activeElement=document.activeElement;activeElement&&itemsContainer.contains(activeElement)||onLiveButtonClick.call(instance)}):Promise.resolve()})},Guide.prototype.refresh=function(){this.cancelDataLoadTimer();var apiClient=_connectionmanager.default.getApiClient(this.options.serverId);return this.programCache=null,apiClient.getLiveTvGuideInfo().then(onGetGuideInfo.bind(this))},Guide.prototype.getItems=function(query){var options=this.options,options=_connectionmanager.default.getApiClient(options.serverId),endDate=this._startDateMs+msPerPage,maxEndDate=this._endDateMs-2e3,endDate=Math.min(endDate,maxEndDate),maxEndDate=Object.assign({Fields:"PrimaryImageAspectRatio",Limit:25,MaxStartDate:new Date(endDate).toISOString(),MinEndDate:new Date(this._startDateMs+1e3).toISOString(),ProgramFields:getProgramFieldsProperty(),TagIds:_usersettings.default.get("guide-tagids")||null},query||{}),endDate=this.categoryOptions.categories||[],query=!endDate.length||-1!==endDate.indexOf("movies"),displaySportsContent=!endDate.length||-1!==endDate.indexOf("sports"),displayNewsContent=!endDate.length||-1!==endDate.indexOf("news"),displayKidsContent=!endDate.length||-1!==endDate.indexOf("kids"),endDate=!endDate.length||-1!==endDate.indexOf("series");return query&&displaySportsContent&&displayNewsContent&&displayKidsContent?(maxEndDate.IsMovie=null,maxEndDate.IsSports=null,maxEndDate.IsKids=null,maxEndDate.IsNews=null,maxEndDate.IsSeries=null):(displayNewsContent&&(maxEndDate.IsNews=!0),displaySportsContent&&(maxEndDate.IsSports=!0),displayKidsContent&&(maxEndDate.IsKids=!0),query&&(maxEndDate.IsMovie=!0),endDate&&(maxEndDate.IsSeries=!0)),_usersettings.default.addLiveTvChannelSortingToQuery(maxEndDate,_globalize.default),options.getEpg(maxEndDate).then(function(result){for(var items=result.Items,i=(getTimeBlockStart(this,0).toString(),0),length=items.length;i<length;i++){var epgRow=items[i];epgRow.ChannelId=epgRow.Channel.Id,epgRow.ProgramMap=getProgramMap(epgRow)}return result}.bind(this))},Guide.prototype.startDataLoadTimer=function(scrollLeft){this._loadDataInfo=scrollLeft;var scrollWidth=this.scroller.getScrollWidth(),scrollWidth=getTimeBlockStart(this,scrollLeft,scrollWidth);scrollWidth!==this._dataLoadSection&&(this.cancelDataLoadTimer(),this._loadDataInfo=scrollLeft,this._dataLoadSection=scrollWidth,this.getProgramsTimeout=setTimeout(this.boundLoadPrograms,100))},Guide.prototype.cancelDataLoadTimer=function(){var timeout=this.getProgramsTimeout;timeout&&(clearTimeout(timeout),this.getProgramsTimeout=null,this._loadDataInfo=null,this._dataLoadSection=null)},Guide.prototype.getListOptions=function(items){return{renderer:new _gridrowrenderer.default({condensed:this.options.condensed}),options:{categories:this.categoryOptions.categories,startDateMs:this._startDateMs,endDateMs:this._endDateMs,channelAction:this.options.channelAction||"link"},virtualScrollLayout:"vertical-grid"}},Guide.prototype.destroy=function(){this.cancelDataLoadTimer();var options=this.options;this.stopCurrentTimeUpdateInterval(),options&&(options=options.element,_shortcuts.default.off(options),(options=this.onTimerCreatedFn)&&(_events.default.off(_api.default,"TimerCreated",options),this.onTimerCreatedFn=null),(options=this.onSeriesTimerCreatedFn)&&(_events.default.off(_api.default,"SeriesTimerCreated",options),this.onSeriesTimerCreatedFn=null),(options=this.onTimerCancelledFn)&&(_events.default.off(_api.default,"TimerCancelled",options),this.onTimerCancelledFn=null),(options=this.onSeriesTimerCancelledFn)&&(_events.default.off(_api.default,"SeriesTimerCancelled",options),this.onSeriesTimerCancelledFn=null),(options=this.channelCellResizeObserver)&&(options.disconnect(),this.channelCellResizeObserver=null),this.itemsContainer=null,this.currentTimeIndicatorDot=null,this.scroller=null,this.headerScroller=null,this.firstChannelCell=null,this.options=null,this._endDateMs=null,this._startDateMs=null,this.channelCellWidth=null,this.programCache=null,this.btnDateText=null,this.btnLiveGuide=null,this.focusSourceIsPointer=null,this._previousFocusItem=null)},_exports.default=Guide});