define(["exports","./../../browser.js","./../../dom.js","./../emby-input/emby-input.js","./../../layoutmanager.js","./../../common/inputmanager.js"],function(_exports,_browser,_dom,_embyInput,_layoutmanager,_inputmanager){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,require(["css!modules/emby-elements/emby-slider/emby-slider.css"]);var insetInlineStartProp=CSS.supports("inset-inline-start","0")?"insetInlineStart":"left",insetBlockStartProp="bottom",supportsCalc=CSS.supports("width","min(45.2%,calc(100% - .65em))"),supportsMin=CSS.supports("width","min(10em, 5vw)"),supportsCalcMin=supportsCalc&&supportsMin;function onInputCommand(e){var stepUpCommand,stepDownCommand="vertical"===this.getAttribute("orient")?(stepUpCommand="up","down"):"rtl"===document.dir?(stepUpCommand="left","right"):(stepUpCommand="right","left");switch(e.detail.command){case stepUpCommand:e.preventDefault(),this.stepUp();var value=parseFloat(this.value);this.beginEditing(value);break;case stepDownCommand:e.preventDefault(),this.stepDown();value=parseFloat(this.value);this.beginEditing(value)}}function getValueAsPercent(range,value){var min=parseFloat(range.min),value=(value-min)/(parseFloat(range.max)-min);return value*=100}function updateValues(range,value){requestAnimationFrame(function(){var backgroundLower=range.backgroundLower,originalPct=getValueAsPercent(range,value),pct=originalPct+"%",backgroundLower=(backgroundLower&&(prop="vertical"===range.getAttribute("orient")?"height":"width",backgroundLower.style[prop]=pct),range.sliderThumb);if(backgroundLower){var prop="vertical"===range.getAttribute("orient")?insetBlockStartProp:insetInlineStartProp;if(supportsMin){if(originalPct<10)return void(backgroundLower.style[prop]="max("+originalPct+"%,.65em)");if(90<originalPct&&supportsCalcMin)return void(backgroundLower.style[prop]="min("+originalPct+"%,calc(100% - .65em))")}backgroundLower.style[prop]=originalPct+"%"}})}function getBubbleOffsetSize(range){var prop,size=range.bubbleOffsetSize;return size||(prop="vertical"===range.getAttribute("orient")?"offsetHeight":"offsetWidth",range.bubbleOffsetSize=size=range.getBubbleElement()[prop]),size}function updateBubble(range,value,pct,bubble){value=range.getBubbleHtml?range.getBubbleHtml(value):'<h2 class="sliderBubbleText">'+(value=range.getBubbleText?range.getBubbleText(value):Math.round(value))+"</h2>";bubble.innerHTML=value;value="vertical"===range.getAttribute("orient")?insetBlockStartProp:insetInlineStartProp;if(supportsCalcMin){var size=getBubbleOffsetSize(range),size=Math.round(size/2);if(pct<30)return void(bubble.style[value]="max("+pct+"%,"+size+"px)");if(70<pct)return void(bubble.style[value]="min("+pct+"%,calc(100% - "+size+"px))");bubble.style[value]=pct+"%"}size=getBubbleOffsetSize(range),range=function(range){var prop,size=range.containerOffsetSize;return size||(prop="vertical"===range.getAttribute("orient")?"offsetHeight":"offsetWidth",range.containerOffsetSize=size=range.containerElement[prop]),size}(range);pct=range*(pct/100),pct=Math.max(pct,size/2),pct=Math.min(pct,range-size/2),bubble.style[value]=pct+"px"}function setRange(elem,range,startPercent,endPercent){elem=elem.style,elem["vertical"===range.getAttribute("orient")?insetBlockStartProp:insetInlineStartProp]=Math.max(startPercent,0)+"%",endPercent-=startPercent;elem["vertical"===range.getAttribute("orient")?"height":"width"]=Math.max(Math.min(endPercent,100),0)+"%"}var supportsTouchEvent="ontouchstart"in document.documentElement;function onPointerMove(e){var pointerType,dir,rect,min;this.disabled||("touch"===(pointerType=e.pointerType)||!pointerType&&supportsTouchEvent||(this.classList.add("emby-slider-hovering"),this.dragging||(pointerType=this.sliderBubble)&&(rect=this.getBoundingClientRect(),dir=document.dir,dir="vertical"===this.getAttribute("orient")?(rect.bottom-e.clientY)/rect.height:(e=e.clientX,("rtl"===dir?rect.right-e:e-rect.left)/rect.width),dir*=100,dir=Math.min(Math.max(0,dir),100),updateBubble(this,(e=this,rect=dir,rect/=100,min=parseFloat(e.min),(parseFloat(e.max)-min)*rect+min),dir,pointerType))))}function onPointerLeave(e){e.target===e.currentTarget&&this.classList.remove("emby-slider-hovering")}function onInput(e){this.beginEditing(parseFloat(this.value))}function onChange(e){updateValues(this,parseFloat(this.value));e=e.detail;e&&e.isStep||this.endEditing()}function onBlur(e){this.endEditing()}function onContextMenu(e){e.preventDefault()}supportsCalc=function(_HTMLInputElement){babelHelpers.inherits(EmbySlider,_HTMLInputElement);var _super=_createSuper(EmbySlider);function EmbySlider(){var _this;babelHelpers.classCallCheck(this,EmbySlider),_this=_super.call(this);return babelHelpers.possibleConstructorReturn(_this,_this)}return babelHelpers.createClass(EmbySlider,[{key:"connectedCallback",value:function(){var containerElement,htmlToInsert,thumbClass,forceDisplayThumb,backgroundClass;"true"!==this.getAttribute("data-embyslider")&&(this.setAttribute("data-embyslider","true"),this.classList.add("emby-slider"),forceDisplayThumb="true"!==this.getAttribute("data-hoverthumb"),_layoutmanager.default.tv?this.classList.add("emby-slider-tv"):(forceDisplayThumb||this.classList.add("emby-slider-nothumb"),this.classList.add("emby-slider-scalebg")),_dom.default.allowBackdropFilter()&&this.classList.add("emby-slider-backdropfilter"),(containerElement=this.parentNode).classList.add("emby-slider-container"),_layoutmanager.default.tv&&containerElement.classList.add("emby-slider-container-tv"),htmlToInsert="",backgroundClass=((this.getAttribute("data-sliderbackgroundclass")||"")+" emby-slider-background").trim(),thumbClass=((this.getAttribute("data-thumbclass")||"")+" emby-slider-thumb").trim(),_dom.default.allowBackdropFilter()&&(backgroundClass+=" emby-slider-background-backdropfilter",thumbClass+=" emby-slider-thumb-backdropfilter"),forceDisplayThumb||(thumbClass+=" emby-slider-thumb-hoveronly"),htmlToInsert=(htmlToInsert=htmlToInsert+'<div class="'+backgroundClass+'"><div class="emby-slider-background-inner"><div class="emby-slider-background-upper"></div><div class="emby-slider-background-lower"></div></div>')+'</div><div class="'+thumbClass+'"></div>',forceDisplayThumb="sliderBubble dialog",(backgroundClass=this.getAttribute("data-bubbleclass"))&&(forceDisplayThumb+=" "+backgroundClass),_layoutmanager.default.tv&&(forceDisplayThumb+=" sliderBubble-tv"),containerElement.insertAdjacentHTML("beforeend",htmlToInsert+='<div class="'+forceDisplayThumb+'"></div>'),this.backgroundElement=containerElement.querySelector(".emby-slider-background"),this.backgroundLower=containerElement.querySelector(".emby-slider-background-lower"),this.backgroundUpper=containerElement.querySelector(".emby-slider-background-upper"),this.sliderThumb=containerElement.querySelector(".emby-slider-thumb"),this.sliderBubble=containerElement.querySelector(".sliderBubble"),this.containerElement=containerElement,supportsCalcMin||(this.containerResizeObserver=new ResizeObserver(function(){this.containerOffsetSize=null}.bind(this),{}),this.containerResizeObserver.observe(containerElement)),this.bubbleResizeObserver=new ResizeObserver(function(){this.bubbleOffsetSize=null}.bind(this),{}),this.bubbleResizeObserver.observe(this.sliderBubble),_dom.default.addEventListener(this,"input",onInput,{passive:!0}),_dom.default.addEventListener(this,"change",onChange,{passive:!0}),_dom.default.addEventListener(this,"contextmenu",onContextMenu,{}),_dom.default.addEventListener(this,"blur",onBlur,{}),_dom.default.addEventListener(this,window.PointerEvent?"pointermove":"mousemove",onPointerMove,{passive:!0}),_dom.default.addEventListener(this,window.PointerEvent?"pointerleave":"mouseleave",onPointerLeave,{passive:!0}),"false"!==this.getAttribute("data-defaultinputhandling")&&_inputmanager.default.on(this,onInputCommand))}},{key:"setValue",value:function(val){this.value=val,updateValues(this,val)}},{key:"disconnectedCallback",value:function(){this.backgroundUpper=null,this.backgroundLower=null,this.sliderThumb=null,this.sliderBubble=null,this.backgroundElement=null,this.containerElement=null;var observer=this.containerResizeObserver;observer&&observer.disconnect(),this.containerResizeObserver=null,(observer=this.bubbleResizeObserver)&&observer.disconnect(),this.bubbleResizeObserver=null,this.bubbleOffsetSize=null,this.containerOffsetSize=null}},{key:"setBufferedRanges",value:function(ranges,runtime,position){var elem=this.backgroundUpper;if(elem){null!=runtime&&(ranges=function(ranges,runtime){return runtime?ranges.map(function(r){return{start:r.start/runtime*100,end:r.end/runtime*100}}):[]}(ranges,runtime),position=position/runtime*100);for(var i=0,length=ranges.length;i<length;i++){var range=ranges[i];if(!(null!=position&&position>=range.end))return void setRange(elem,this,range.start,range.end)}setRange(elem,this,0,0)}}},{key:"setIsClear",value:function(isClear){var backgroundLower=this.backgroundLower;backgroundLower&&(isClear?backgroundLower.classList.add("emby-slider-background-lower-clear"):backgroundLower.classList.remove("emby-slider-background-lower-clear"))}},{key:"beginEditing",value:function(value){this.dragging=!0,this.classList.add("emby-slider-editing");var sliderBubble=this.sliderBubble;sliderBubble&&updateBubble(this,value,getValueAsPercent(this,value),sliderBubble),updateValues(this,value)}},{key:"cancelEditing",value:function(){this.endEditing(!1)}},{key:"endEditing",value:function(triggerChange,value){this.dragging=!1,this.classList.remove("emby-slider-editing"),triggerChange&&(this.value=value,this.dispatchEvent(new CustomEvent("change",{bubbles:!0,cancelable:!1})))}},{key:"stepUp",value:function(){HTMLInputElement.prototype.stepUp.call(this),this.dispatchEvent(new CustomEvent("change",{bubbles:!0,cancelable:!1,detail:{isStep:!0}}))}},{key:"stepDown",value:function(){HTMLInputElement.prototype.stepDown.call(this),this.dispatchEvent(new CustomEvent("change",{bubbles:!0,cancelable:!1,detail:{isStep:!0}}))}},{key:"getBubbleElement",value:function(){return this.sliderBubble}},{key:"getTrackBackgroundUpper",value:function(){return this.backgroundUpper}}]),EmbySlider}(babelHelpers.wrapNativeSuper(HTMLInputElement));customElements.define("emby-slider",supportsCalc,{extends:"input"}),_exports.default=supportsCalc});