define(["exports","./dom.js","./common/globalize.js","./loading/loading.js","./approuter.js","./common/appsettings.js","./common/playback/playbackmanager.js","./emby-apiclient/connectionmanager.js"],function(_exports,_dom,_globalize,_loading,_approuter,_appsettings,_playbackmanager,_connectionmanager){function downloadFiles(urls){return require(["multi-download"]).then(function(responses){(0,responses[0])(urls)})}function alertText(options){return require(["alert"]).then(function(responses){responses[0](options)})}function removeFromResume(item,options,mode){return require(["confirm"]).then(function(responses){var responses=responses[0],confirmHeader=_globalize.default.translate("nextup"===mode?"HeaderRemoveFromNextUp":"HeaderRemoveFromContinueWatching"),apiClient=_connectionmanager.default.getApiClient(item);return responses({title:confirmHeader,text:_globalize.default.translate("nextup"===mode?"RemoveThisTitleFromNextUp":"RemoveThisTitleFromContinueWatching"),confirmText:_globalize.default.translate("Remove"),primary:"cancel"}).then(function(){return apiClient.updateHideFromResume(item.Id,!0)})})}function markFavorite(item,isFavorite){var apiClient=_connectionmanager.default.getApiClient(item);return apiClient.updateFavoriteStatus(apiClient.getCurrentUserId(),item.Id,isFavorite)}function addToList(itemId,serverId,listType){return require(["addToList"]).then(function(responses){return(new responses[0]).show({items:[itemId],serverId:serverId,type:listType})})}function afterWakeAttempt(){var timeMs,apiClient=this;return timeMs=12e3,new Promise(function(resolve,reject){setTimeout(resolve,timeMs)}).then(function(){return apiClient.getPublicSystemInfo()})}function wakeServer(apiClient){return require(["loadingDialog"]).then(function(responses){var responses=new responses[0]({title:_globalize.default.translate("HeaderWakeServer"),text:_globalize.default.translate("AttemptingWakeServer")}),showDialogPromise=responses.show(),responses={dlg:responses,showDialogPromise:showDialogPromise},showDialogPromise=afterWakeAttempt.bind(apiClient);return apiClient.wakeOnLan().then(showDialogPromise,showDialogPromise).then(function(){var promise=this.showDialogPromise.then(function(){return require(["alert"]).then(function(responses){return responses[0]({text:_globalize.default.translate("WakeServerSuccess"),title:_globalize.default.translate("HeaderWakeServer")}).catch(getResolvedPromise)})}),dlg=this.dlg;return dlg.hide(),dlg.destroy(),promise}.bind(responses),function(){var promise=this.showDialogPromise.then(function(){return require(["alert"]).then(function(responses){return responses[0]({text:_globalize.default.translate("WakeServerError"),title:_globalize.default.translate("HeaderWakeServer")}).catch(getResolvedPromise)})}),dlg=this.dlg;return dlg.hide(),dlg.destroy(),promise}.bind(responses))})}function getResolvedPromise(){return Promise.resolve()}function playAllFromHere(itemElement,serverId,queue){var fetchAll,itemsContainer=itemElement.closest(".itemsContainer"),startIndex=itemsContainer.indexOfElement(itemElement);if(itemsContainer&&itemsContainer.fetchData)return limit=1e3,queue||(limit+=startIndex||0),limit=(fetchAll=!queue&&startIndex<limit)?{Limit:limit}:{StartIndex:startIndex,Limit:limit},itemsContainer.fetchData(limit).then(function(result){return queue?_playbackmanager.default.queue({items:result.Items||result}):_playbackmanager.default.play({items:result.Items||result,startIndex:fetchAll?startIndex:null})});for(var itemsContainer=itemElement.parentNode,limit=itemElement.classList.length?"."+itemElement.classList[0]:"",cards=itemsContainer.querySelectorAll(limit+"[data-id]"),ids=[],foundCard=!1,i=0,length=cards.length;i<length;i++)cards[i]===itemElement&&(foundCard=!0,startIndex=i),!foundCard&&queue||ids.push(cards[i].getAttribute("data-id"));return ids.length?queue?_playbackmanager.default.queue({ids:ids,serverId:serverId}):_playbackmanager.default.play({ids:ids,serverId:serverId,startIndex:startIndex}):void 0}function sendToast(text){require(["toast"]).then(function(responses){return(0,responses[0])(text),Promise.resolve()})}function notifyAddedToPlayQueue(){return sendToast({text:_globalize.default.translate("HeaderAddedToPlayQueue"),icon:"&#xe03b;"}),Promise.resolve()}function notifyPlayingNext(){return sendToast({text:_globalize.default.translate("HeaderPlayingNext"),icon:"&#xe03b;"}),Promise.resolve()}function play(item,resume,queue,queueNext){var method=queue?queueNext?"queueNext":"queue":"play",resume={startPositionTicks:!1===resume?0:item.StartPositionTicks},item=(null!=item.ChapterIndex?(resume.ids=[item.Id],resume.serverId=item.ServerId):resume.items=[item],_playbackmanager.default[method](resume));return queueNext?item=item.then(notifyPlayingNext):queue&&(item=item.then(notifyAddedToPlayQueue)),item}function showItem(item,options){var itemsContainer;return options&&!options.parentId&&(options.itemElement||options.positionTo)&&(itemsContainer=(options.itemElement||options.positionTo).closest(".itemsContainer"))&&(options.parentId=itemsContainer.getAttribute("data-parentid")||null),_approuter.default.showItem(item,options)}function editItem(apiClient,item,options){if("Device"===item.Type||"User"===item.Type||"ActiveSession"===item.Type||"SeriesTimer"===item.Type||"Timer"===item.Type||"LiveTVTunerDevice"===item.Type||"LiveTVGuideSource"===item.Type)return showItem(item,options);var serverId=apiClient.serverId();return"VirtualFolder"===item.Type?function(item,options){var view=(options=options.positionTo).closest(".page"),refreshLibrary=!!options&&"true"===view.getAttribute("data-refreshlibrary");return require(["medialibraryeditor"]).then(function(responses){return(new responses[0]).show({refresh:refreshLibrary,library:item})})}(item,options):require(["metadataEditor"]).then(function(responses){return responses[0].show(item.Id,serverId)})}function getRejectedPromise(){return Promise.reject()}function alertUpdateImageError(){return require(["alert"]).then(function(responses){return(0,responses[0])(_globalize.default.translate("DefaultErrorMessage")).then(getRejectedPromise,getRejectedPromise)})}function moveImage(item,options,newIndex){return _connectionmanager.default.getApiClient(item).updateItemImageIndex(item.Id,item.ImageType,item.ImageIndex,newIndex).catch(alertUpdateImageError)}function moveChannel(item,options,newIndex){return _connectionmanager.default.getApiClient(item).setChannelSortIndex(item,newIndex)}function record(item,options){return"TvChannel"===item.Type?function(item,options){return require(["channelRecordingCreator"]).then(function(responses){return responses[0].createRecordingForChannel(item,options)})}(item,options):function(item){var type=item.Type,id=item.Id,serverId=item.ServerId,timerId="Timer"===type?item.Id:item.TimerId,seriesTimerId=item.SeriesTimerId,programId="Program"===type?id:item.ProgramId,status=item.Status;return programId||timerId||seriesTimerId?require(["recordingHelper"]).then(function(responses){return responses[0].toggleRecording(serverId,"Program"===type?id:null,timerId,status,seriesTimerId)}):Promise.resolve()}(item)}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_exports.default={executeCommand:function(command,item,options){if("open"===command||"link"===command){if("photo"!==item.MediaType)return showItem(item,options);command="play"}return"download"===command?function(item,options){var apiClient=_connectionmanager.default.getApiClient(item);if(options=options||{},"Log"===item.Type)return downloadFiles([apiClient.getLogDownloadUrl({Name:item.Name,Sanitize:options.Sanitize})]);if("MediaStream"===item.Type&&"Subtitle"===item.StreamType)return url="Videos/"+item.ItemId+"/"+item.MediaSourceId+"/Subtitles/"+item.Index+"/Stream."+item.Codec,apiClient.isMinServerVersion("4.6.5")&&(url+="?SetFilename=true"),downloadFiles([apiClient.getUrl(url)]);var url=options.mediaSourceId;return downloadFiles([apiClient.getItemDownloadUrl(item.Id,url)])}(item,options):"edit"===command?editItem(_connectionmanager.default.getApiClient(item),item,options):"delete"===command?function(item,options){return require(["deleteHelper"]).then(function(responses){return responses[0].deleteItem({item:item,navigate:options.navigateOnDelete||!1,positionTo:options.positionTo})})}(item,options):"identify"===command?function(item){return require(["itemIdentifier"]).then(function(responses){return responses[0].show(item)})}(item):"preview"===command?function(item){var apiClient=_connectionmanager.default.getApiClient(item);return apiClient.getText(apiClient.getUrl("Videos/"+item.ItemId+"/"+item.MediaSourceId+"/Subtitles/"+item.Index+"/Stream."+item.Codec)).then(function(result){return alertText({preFormattedText:_dom.default.stripScripts(result),confirmText:_globalize.default.translate("Close"),title:_globalize.default.translate("Subtitles")})})}(item):"removefromresume"===command?removeFromResume(item):"removefromnextup"===command?removeFromResume(item,0,"nextup"):"playtrailer"===command?function(item){var apiClient=_connectionmanager.default.getApiClient(item);return apiClient.getLocalTrailers(apiClient.getCurrentUserId(),item.Id).then(function(trailers){_playbackmanager.default.play({items:trailers})})}(item):"addtoplaylist"===command?addToList(item.Id,item.ServerId,"Playlist"):"addtocollection"===command?addToList(item.Id,item.ServerId,"Collection"):"connecttoserver"===command?function(item){return"AddServer"===item.Type||"Downloads"===item.Type?_approuter.default.showItem(item):"EmbyConnect"===item.Type?_approuter.default.showConnectLogin():(_loading.default.show(),item=_connectionmanager.default.getServerInfo(item.Id)||item,_connectionmanager.default.connectToServer(item,{enableAutoLogin:_appsettings.default.enableAutoLogin()}).then(function(result){return _approuter.default.handleConnectionResult(result)}))}(item):"setplaylistindex"===command?_playbackmanager.default.setCurrentPlaylistItem(item.PlaylistItemId):"multiselect"===command?function(options){return options.positionTo.closest(".itemsContainer").showMultiSelect(options.positionTo,!0),Promise.resolve()}(options):"wakeserver"===command?wakeServer(_connectionmanager.default.getApiClient(item)):"instantmix"===command?_playbackmanager.default.instantMix(item):"shuffle"===command?_playbackmanager.default.shuffle(item):"playallfromhere"===command?playAllFromHere(options.itemElement,item.ServerId):"queueallfromhere"===command?playAllFromHere(options.itemElement,item.ServerId,!0):"play"===command?play(item,!0):"playfrombeginning"===command?play(item,!1):"resume"===command||"playpause"===command?play(item,!0):"queue"===command?play(item,!1,!0):"queuenext"===command?play(item,!1,!0,!0):"overview"===command?alertText(_dom.default.stripScripts(item.Overview||"")):"programlink"===command?((program=item.CurrentProgram||item).ServerId||(program.ServerId=item.ServerId),showItem(program,options)):"season"===command?(_approuter.default.showItem(item.SeasonId,item.ServerId),Promise.resolve()):"series"===command?(_approuter.default.showItem(item.SeriesId,item.ServerId),Promise.resolve()):"album"===command?(_approuter.default.showItem(item.AlbumId,item.ServerId),Promise.resolve()):"artist"===command?(_approuter.default.showItem(item.ArtistItems[0].Id,item.ServerId),Promise.resolve()):"markplayed"===command?function(item){var apiClient=_connectionmanager.default.getApiClient(item);return apiClient.markPlayed(apiClient.getCurrentUserId(),item.Id)}(item):"markunplayed"===command?function(item){var apiClient=_connectionmanager.default.getApiClient(item);return apiClient.markUnplayed(apiClient.getCurrentUserId(),item.Id)}(item):"favorite"===command?markFavorite(item,!0):"unfavorite"===command?markFavorite(item,!1):"searchimageproviders"===command?function(item){return require(["imageDownloader"]).then(function(responses){responses=responses[0];_connectionmanager.default.getApiClient(item);return(new responses).show({item:item.OwnerItem,imageType:item.ImageType})})}(item):"addimage"===command?function(item){return require(["imageUploader"]).then(function(responses){return responses[0].show({imageType:item.ImageType,item:item.OwnerItem})})}(item):"moveimageleft"===command?moveImage(item,0,item.ImageIndex-1):"moveimageright"===command?moveImage(item,0,item.ImageIndex+1):"addimagefromurl"===command?function(item){return require(["prompt"]).then(function(responses){return(0,responses[0])({title:_globalize.default.translate(item.ImageTag?"HeaderSetImageFromUrl":"HeaderAddImageFromUrl"),label:_globalize.default.translate("LabelUrl")}).then(function(url){return _connectionmanager.default.getApiClient(item).updateItemImageFromUrl(item.Id,item.ImageType,item.ImageIndex,url).catch(alertUpdateImageError)})})}(item):"togglechanneldisabled"===command?function(item,options){if(!options.eventType||"change"!==options.eventType)return Promise.resolve();var options=options.eventTarget.checked,apiClient=_connectionmanager.default.getApiClient(item);return _loading.default.show(),apiClient.setChannelDisabled(item,!options).then(function(updatedChannel){_loading.default.hide()})}(item,options):"toggleitemselected"===command?function(item,options){var checked;return options.eventType&&"change"===options.eventType&&(checked=options.eventTarget.checked,item.Selected=checked,(checked=options.itemElement)&&(options=checked.closest(".itemsContainer"))&&-1!==(checked=options.indexOfElement(checked))&&options.onItemUpdated(checked,item)),Promise.resolve()}(item,options):"togglecheckbox"===command?function(options){return(options=options.itemElement.querySelector(".chkItemCheckbox")).checked=!options.checked,options.dispatchEvent(new CustomEvent("change",{cancelable:!0,bubbles:!0})),Promise.resolve()}(options):"movechannelup"===command?moveChannel(item,0,item.SortIndexNumber-1):"movechanneldown"===command?moveChannel(item,0,item.SortIndexNumber+1):"copytoclipboard"===command?function(item){return navigator.clipboard.writeText(item.AccessToken)}(item):"seektoposition"===command?function(item){return"LyricsLine"===item.Type&&null==item.StartPositionTicks?Promise.resolve():_playbackmanager.default.seek(item.StartPositionTicks||0)}(item):"session_shownowplayingitem"===command&&item.NowPlayingItem?showItem(item.NowPlayingItem,options):"session_stop"===command?_connectionmanager.default.getApiClient(item.ServerId).sendPlayStateCommand(item.Id,"Stop"):"session_playpause"===command?_connectionmanager.default.getApiClient(item.ServerId).sendPlayStateCommand(item.Id,"PlayPause"):"session_sendmessage"===command?function(item){return require(["prompt"]).then(function(responses){(0,responses[0])({title:_globalize.default.translate("HeaderSendMessage"),label:_globalize.default.translate("LabelMessageText"),confirmText:_globalize.default.translate("ButtonSend")}).then(function(text){return text?_connectionmanager.default.getApiClient(item).sendMessageCommand(item.Id,{Text:text,TimeoutMs:5e3}):Promise.reject()})})}(item):"serverinfo"===command?function(item){return require(["alert"]).then(function(responses){var responses=responses[0],apiClient=_connectionmanager.default.getApiClient(item),html="";return html+='<div style="overflow-x:hidden;">',apiClient.serverVersion()&&(html=(html+='<h4 style="margin:0;" class="secondaryText">'+_globalize.default.translate("Version")+"</h4>")+"<div>"+apiClient.serverVersion()+"</div>"),item.LastConnectionMode?html+='<h4 style="margin-bottom:0;" class="secondaryText">'+_globalize.default.translate("HeaderLastConnectedTo")+"</h4>":html+='<h4 style="margin-bottom:0;" class="secondaryText">'+_globalize.default.translate("HeaderServerAddress")+"</h4>",html+="<div>"+apiClient.serverAddress()+"</div>",item.RemoteAddress&&(html=(html+='<h4 style="margin-bottom:0;" class="secondaryText">'+_globalize.default.translate("RemoteWAN")+"</h4>")+"<div>"+item.RemoteAddress+"</div>"),responses({title:item.Name,html:html+="</div>",centerText:!1})})}(item):"record"===command?record(item,options):Promise.reject();var program}}});