define(["baseTab","cardBuilder","serverNotifications","events","imageLoader","focusManager","connectionManager","datetime","dom","emby-itemscontainer","emby-scroller"],function(BaseTab,cardBuilder,serverNotifications,events,imageLoader,focusManager,connectionManager,datetime,dom){"use strict";function LiveTvScheduleTab(view,params){BaseTab.apply(this,arguments),this.view=view,this.params=params,this.apiClient=connectionManager.getApiClient(params.serverId),this.activeRecordingsItemsContainer=view.querySelector(".activeRecordings .itemsContainer"),this.activeRecordingsItemsContainer.fetchData=function(){var apiClient=this.apiClient;return apiClient.getLiveTvRecordings({UserId:apiClient.getCurrentUserId(),IsInProgress:!0,Fields:this.requestedItemFields+",PrimaryImageAspectRatio",EnableTotalRecordCount:!1,EnableImageTypes:"Primary,Thumb,Backdrop"})}.bind(this),this.activeRecordingsItemsContainer.getListOptions=function(){return{renderer:cardBuilder,options:{shape:"autooverflow",cardLayout:!1,fields:["ParentNameOrName","ChannelName"],showAirTime:!0,showAirEndTime:!0,preferThumb:"auto",overlayText:!1,centerText:!0,multiSelect:!1},virtualScrollLayout:"horizontal-grid"}}.bind(this),this.activeRecordingsItemsContainer.parentContainer=this.activeRecordingsItemsContainer.closest(".verticalSection")}return Object.assign(LiveTvScheduleTab.prototype,BaseTab.prototype),LiveTvScheduleTab.prototype.onResume=function(options){BaseTab.prototype.onResume.apply(this,arguments),this.serverNotificationHandler||(serverNotificationHandler=function(){this.paused?this.needsRefresh=!0:this.onResume({refresh:!0})}.bind(this),events.on(serverNotifications,"TimerCreated",serverNotificationHandler),events.on(serverNotifications,"TimerCancelled",serverNotificationHandler),events.on(serverNotifications,"RecordingStarted",serverNotificationHandler),events.on(serverNotifications,"RecordingEnded",serverNotificationHandler),this.serverNotificationHandler=serverNotificationHandler);var serverNotificationHandler=this.apiClient,promises=[],view=this.view,autoFocus=(options=options||{}).autoFocus||view.contains(document.activeElement),instance=(this.needsRefresh&&(options.refresh=!0,this.needsRefresh=!1),promises.push(this.activeRecordingsItemsContainer.resume(options)),options.refresh&&(promises.push(serverNotificationHandler.getLiveTvTimers({IsActive:!1,IsScheduled:!0})),promises[1].then(function(result){return function(view,timers){for(var items=timers.map(function(t){return t.Type="Timer",t}),groups=[],currentGroupName="",currentGroup=[],timers=imageLoader.getPrimaryImageAspectRatio(items)||1,i=0,length=items.length;i<length;i++){var item=items[i],dateText="";if(item.StartDate)try{var premiereDate=datetime.parseISO8601Date(item.StartDate,!0),dateText=datetime.toLocaleDateString(premiereDate,{weekday:"long",month:"short",day:"numeric"})}catch(err){}dateText!==currentGroupName?(currentGroup.length&&groups.push({name:currentGroupName,items:currentGroup}),currentGroupName=dateText,currentGroup=[item]):currentGroup.push(item)}currentGroup.length&&groups.push({name:currentGroupName,items:currentGroup});var html="";for(i=0,length=groups.length;i<length;i++)html=(html=(html=(html+='<div class="verticalSection focusable" data-focusabletype="nearest">')+('<h2 class="sectionTitle sectionTitle-cards padded-left">'+groups[i].name+"</h2>")+'<div is="emby-scroller" class="padded-top-focusscale padded-bottom-focusscale" data-framesize="matchgrandparent" data-centerfocus="card" data-mousewheel="false">')+'<div is="emby-itemscontainer" class="itemsContainer scrollSlider focuscontainer-x padded-left padded-right">'+"</div>")+"</div>"+"</div>";var view=view.querySelector(".upcomingRecordings"),itemsContainers=(html?view.classList.remove("hide"):view.classList.add("hide"),view.innerHTML=html,view.querySelectorAll(".itemsContainer")),cardLayout=1.5<=timers;for(i=0,length=groups.length;i<length;i++)cardBuilder.buildCards(groups[i].items,{itemsContainer:itemsContainers[i],shape:"autooverflow",fields:["ParentNameOrName","ChannelName"],showAirTime:!0,showAirEndTime:!0,cardLayout:cardLayout,centerText:!cardLayout,action:"edit",cardFooterAside:!1,overlayText:!1,showChannelLogo:cardLayout,preferThumb:cardLayout||null,multiSelect:!1})}(view,result.Items),Promise.resolve()})),this);Promise.all(promises).then(function(responses){autoFocus&&instance.autoFocus()})},LiveTvScheduleTab.prototype.onPause=function(){BaseTab.prototype.onPause.apply(this,arguments),this.activeRecordingsItemsContainer.pause()},LiveTvScheduleTab.prototype.destroy=function(){BaseTab.prototype.destroy.apply(this,arguments);var serverNotificationHandler=this.serverNotificationHandler;serverNotificationHandler&&(events.off(serverNotifications,"TimerCreated",serverNotificationHandler),events.off(serverNotifications,"TimerCancelled",serverNotificationHandler),events.off(serverNotifications,"RecordingStarted",serverNotificationHandler),events.off(serverNotifications,"RecordingEnded",serverNotificationHandler),this.serverNotificationHandler=null),this.view=null,this.params=null,this.apiClient=null,this.activeRecordingsItemsContainer=null},LiveTvScheduleTab});