/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.swt.editor;

import java.awt.Paint;
import java.util.ResourceBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.swt.editor.SWTPaintCanvas;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.swt.SWTUtils;

class SWTOtherEditor
extends Composite {
    private Button antialias;
    private SWTPaintCanvas backgroundPaintCanvas;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle((String)"org.jfree.chart.editor.LocalizationBundle");

    public SWTOtherEditor(Composite parent, int style, JFreeChart chart) {
        super(parent, style);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        this.setLayout((Layout)layout);
        Group general = new Group((Composite)this, 0);
        general.setLayout((Layout)new GridLayout(3, false));
        general.setText(localizationResources.getString("General"));
        this.antialias = new Button((Composite)general, 32);
        this.antialias.setText(localizationResources.getString("Draw_anti-aliased"));
        this.antialias.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.antialias.setSelection(chart.getAntiAlias());
        new Label((Composite)general, 0).setText(localizationResources.getString("Background_paint"));
        this.backgroundPaintCanvas = new SWTPaintCanvas((Composite)general, 0, SWTUtils.toSwtColor((Device)this.getDisplay(), (Paint)chart.getBackgroundPaint()));
        GridData bgGridData = new GridData(4, 0x1000000, true, false);
        bgGridData.heightHint = 20;
        this.backgroundPaintCanvas.setLayoutData(bgGridData);
        Button selectBgPaint = new Button((Composite)general, 8);
        selectBgPaint.setText(localizationResources.getString("Select..."));
        selectBgPaint.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        selectBgPaint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(SWTOtherEditor.this.getShell());
                dlg.setText(localizationResources.getString("Background_paint"));
                dlg.setRGB(SWTOtherEditor.this.backgroundPaintCanvas.getColor().getRGB());
                RGB rgb = dlg.open();
                if (rgb != null) {
                    SWTOtherEditor.this.backgroundPaintCanvas.setColor(new Color((Device)SWTOtherEditor.this.getDisplay(), rgb));
                }
            }
        });
    }

    public void updateChartProperties(JFreeChart chart) {
        chart.setAntiAlias(this.antialias.getSelection());
        chart.setBackgroundPaint((Paint)SWTUtils.toAwtColor((Color)this.backgroundPaintCanvas.getColor()));
    }
}

