/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.qm.QMEvent;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;

public class QMMetaEvent
implements QMEvent {
    protected final QMMObject object;
    protected final QMEventAction action;
    protected final String sessionId;

    public QMMetaEvent(QMMObject object, QMEventAction action, String sessionId) {
        this.object = object;
        this.action = action;
        this.sessionId = sessionId;
    }

    @Override
    public QMMObject getObject() {
        return this.object;
    }

    @Override
    public QMEventAction getAction() {
        return this.action;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return (Object)((Object)this.action) + " " + this.object;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("type", this.object.getObjectType().getId());
        result.put("object", this.object.toMap());
        result.put("action", this.action.getId());
        result.put("sessionId", this.sessionId);
        return result;
    }

    public static QMMetaEvent fromMap(Map<String, Object> map) {
        QMMObject eventObject;
        QMMObject.ObjectType objectType = QMMObject.ObjectType.getById(JSONUtils.getString(map, "type"));
        if (objectType == null) {
            return null;
        }
        Map<String, Object> object = JSONUtils.getObject(map, "object");
        switch (objectType) {
            case ConnectionInfo: {
                eventObject = QMMConnectionInfo.fromMap(object);
                break;
            }
            case StatementExecuteInfo: {
                eventObject = QMMStatementExecuteInfo.fromMap(object);
                break;
            }
            case StatementInfo: {
                eventObject = QMMStatementInfo.fromMap(object);
                break;
            }
            case TransactionInfo: {
                eventObject = QMMTransactionInfo.fromMap(object);
                break;
            }
            default: {
                return null;
            }
        }
        QMEventAction action = QMEventAction.getById(JSONUtils.getInteger(map, "action"));
        String sessionId = JSONUtils.getString(map, "sessionId");
        return new QMMetaEvent(eventObject, action, sessionId);
    }
}

