/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.struct;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public abstract class AbstractDataType<DS extends DBPDataSource>
implements DBSDataType {
    private final DS dataSource;

    public AbstractDataType(DS dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getTypeName();
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    @Nullable
    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @NotNull
    public DS getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    public String getFullTypeName() {
        return DBUtils.getFullTypeName(this);
    }

    @Override
    public Integer getScale() {
        return 0;
    }

    @Override
    public int getMinScale() {
        return 0;
    }

    @Override
    public int getMaxScale() {
        return 0;
    }

    @Override
    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        return DBUtils.getDefaultOperators(this);
    }

    @Override
    public Integer getPrecision() {
        return 0;
    }

    @Override
    public long getMaxLength() {
        return 0L;
    }

    @Override
    public long getTypeModifiers() {
        return 0L;
    }

    @Override
    @Nullable
    public Object geTypeExtension() {
        return null;
    }

    @Override
    @Nullable
    public DBSDataType getComponentType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public String toString() {
        return this.getTypeName();
    }
}

