/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;

public class SpreadsheetCommandHandler
extends AbstractHandler {
    public static final String CMD_COLUMNS_FIT_VALUE = "org.jkiss.dbeaver.core.resultset.grid.columnsFitValue";
    public static final String CMD_COLUMNS_FIT_SCREEN = "org.jkiss.dbeaver.core.resultset.grid.columnsFitScreen";
    public static final String CMD_COLUMNS_HIDE_EMPTY = "org.jkiss.dbeaver.core.resultset.grid.columnsHideEmpty";

    public static SpreadsheetPresentation getActiveSpreadsheet(ExecutionEvent event) {
        IResultSetPresentation presentation;
        IResultSetController resultSet = ResultSetHandlerMain.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet != null && (presentation = resultSet.getActivePresentation()) instanceof SpreadsheetPresentation) {
            return (SpreadsheetPresentation)presentation;
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String actionId;
        SpreadsheetPresentation spreadsheet = SpreadsheetCommandHandler.getActiveSpreadsheet(event);
        if (spreadsheet == null) {
            return null;
        }
        switch (actionId = event.getCommand().getId()) {
            case "org.jkiss.dbeaver.core.resultset.grid.columnsFitValue": {
                spreadsheet.getSpreadsheet().packColumns(true);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.columnsFitScreen": {
                spreadsheet.getSpreadsheet().packColumns(false);
                break;
            }
            case "org.jkiss.dbeaver.core.resultset.grid.columnsHideEmpty": {
                ResultSetModel model = spreadsheet.getController().getModel();
                HashSet<DBDAttributeBinding> attributes = new HashSet<DBDAttributeBinding>(model.getVisibleAttributes());
                for (ResultSetRow row : model.getAllRows()) {
                    attributes.removeIf(attribute -> !DBUtils.isNullValue((Object)model.getCellValue((DBDAttributeBinding)attribute, row)));
                }
                if (attributes.isEmpty()) break;
                for (DBDAttributeBinding attribute2 : attributes) {
                    model.setAttributeVisibility(attribute2, false);
                }
                spreadsheet.refreshData(true, false, true);
            }
        }
        return null;
    }
}

