/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import org.eclipse.draw2dl.Bendpoint;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PrecisionPoint;

public class RelativeBendpoint
implements Bendpoint {
    private Connection connection;
    private float weight = 0.5f;
    private Dimension d1;
    private Dimension d2;

    public RelativeBendpoint() {
    }

    public RelativeBendpoint(Connection conn) {
        this.setConnection(conn);
    }

    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    public Point getLocation() {
        PrecisionPoint a1 = new PrecisionPoint(this.getConnection().getSourceAnchor().getReferencePoint());
        PrecisionPoint a2 = new PrecisionPoint(this.getConnection().getTargetAnchor().getReferencePoint());
        this.getConnection().translateToRelative(a1);
        this.getConnection().translateToRelative(a2);
        return new PrecisionPoint((a1.preciseX() + this.d1.preciseWidth()) * (1.0 - (double)this.weight) + (double)this.weight * (a2.preciseX() + this.d2.preciseWidth()), (a1.preciseY() + this.d1.preciseHeight()) * (1.0 - (double)this.weight) + (double)this.weight * (a2.preciseY() + this.d2.preciseHeight()));
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
    }

    public void setRelativeDimensions(Dimension dim1, Dimension dim2) {
        this.d1 = dim1;
        this.d2 = dim2;
    }

    public void setWeight(float w) {
        this.weight = w;
    }
}

