/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.util.Iterator;
import org.eclipse.draw2dl.FreeformFigure;
import org.eclipse.draw2dl.FreeformHelper;
import org.eclipse.draw2dl.FreeformListener;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.LayeredPane;
import org.eclipse.draw2dl.geometry.Rectangle;

public class FreeformLayeredPane
extends LayeredPane
implements FreeformFigure {
    private FreeformHelper helper = new FreeformHelper(this);

    public FreeformLayeredPane() {
        this.setLayoutManager(null);
    }

    @Override
    public void add(IFigure child, Object constraint, int index) {
        super.add(child, constraint, index);
        this.helper.hookChild(child);
    }

    @Override
    public void addFreeformListener(FreeformListener listener) {
        this.addListener(FreeformListener.class, listener);
    }

    @Override
    public void fireExtentChanged() {
        Iterator iter = this.getListeners(FreeformListener.class);
        while (iter.hasNext()) {
            ((FreeformListener)iter.next()).notifyFreeformExtentChanged();
        }
    }

    @Override
    protected void fireMoved() {
    }

    protected FreeformHelper getFreeformHelper() {
        return this.helper;
    }

    @Override
    public Rectangle getFreeformExtent() {
        return this.helper.getFreeformExtent();
    }

    @Override
    protected void primTranslate(int dx, int dy) {
        this.bounds.x += dx;
        this.bounds.y += dy;
    }

    @Override
    public void remove(IFigure child) {
        this.helper.unhookChild(child);
        super.remove(child);
    }

    @Override
    public void removeFreeformListener(FreeformListener listener) {
        this.removeListener(FreeformListener.class, listener);
    }

    @Override
    public void setFreeformBounds(Rectangle bounds) {
        this.helper.setFreeformBounds(bounds);
    }

    protected void superFireMoved() {
        super.fireMoved();
    }
}

