/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.redshift;

import java.sql.ResultSet;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandlerProvider;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftTable;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class RedshiftTableColumn
extends PostgreTableColumn {
    private String columnEncoding;
    private boolean distKey;
    private int sortKey;

    public RedshiftTableColumn(RedshiftTable table) {
        super(table);
    }

    public RedshiftTableColumn(DBRProgressMonitor monitor, RedshiftTable table, JDBCResultSet dbResult) throws DBException {
        super(monitor, (PostgreTableBase)table, dbResult);
        this.columnEncoding = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"encoding");
        this.distKey = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"attisdistkey");
        this.sortKey = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"attsortkeyord");
    }

    @Property(viewable=true, order=21)
    public String getColumnEncoding() {
        return this.columnEncoding;
    }

    @Property(viewable=false, order=22)
    public boolean isDistKey() {
        return this.distKey;
    }

    @Property(viewable=false, order=23)
    public int getSortKey() {
        return this.sortKey;
    }

    @Override
    public int getAttributeGeometrySRID(DBRProgressMonitor monitor) {
        return 0;
    }

    @Override
    @Nullable
    public String getAttributeGeometryType(DBRProgressMonitor monitor) {
        return this.getTypeName();
    }

    @Override
    @Property(viewable=true, editable=true, updatable=true, order=20, listProvider=PostgreAttribute.DataTypeListProvider.class)
    public String getFullTypeName() {
        PostgreDataType dataType = this.getDataType();
        if (dataType != null && dataType.getObjectId() == 1042L) {
            PostgreTypeHandler handler = PostgreTypeHandlerProvider.getTypeHandler(dataType);
            if (handler != null) {
                return "char" + handler.getTypeModifiersString(dataType, this.getTypeMod());
            }
            return "char";
        }
        return super.getFullTypeName();
    }
}

