/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.notifications.DatabaseNotificationPopup;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class NotificationPopupMessage
extends DatabaseNotificationPopup {
    private final DBPDataSource dataSource;
    private String messageText;
    private int iconType;

    public NotificationPopupMessage(DBPDataSource dataSource, String text, int iconType) {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        this.dataSource = dataSource;
        this.messageText = text;
        this.iconType = iconType;
    }

    @Override
    protected String getPopupShellTitle() {
        return this.dataSource == null ? GeneralUtils.getProductName() : this.dataSource.getContainer().getName();
    }

    @Override
    protected Image getPopupShellImage(int maximumHeight) {
        boolean hasIcon;
        boolean bl = hasIcon = this.iconType == 1 || this.iconType == 8 || this.iconType == 4;
        if (hasIcon) {
            switch (this.iconType) {
                case 1: {
                    return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_ERROR);
                }
                case 8: {
                    return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_WARNING);
                }
            }
            return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_INFO);
        }
        return null;
    }

    @Override
    protected void createContentArea(Composite composite) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(this.messageText);
    }

    public static void showMessage(DBPDataSource dataSource, String text, long delayClose, int iconType) {
        Display.getDefault().syncExec(() -> {
            NotificationPopupMessage popup = new NotificationPopupMessage(dataSource, text, iconType);
            if (delayClose > 0L) {
                popup.setDelayClose(delayClose);
            }
            popup.open();
        });
    }
}

