/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;

public class TextWithOpen
extends Composite {
    private final Text text;
    private final ToolBar toolbar;

    public TextWithOpen(Composite parent) {
        super(parent, 0);
        ToolItem toolItem;
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.setLayout((Layout)gl);
        boolean useTextEditor = this.isPlainTextEditor();
        this.text = new Text((Composite)this, 0x800 | (useTextEditor ? 514 : 4));
        GridData gd = new GridData(772);
        if (useTextEditor) {
            gd.heightHint = this.text.getLineHeight();
        }
        this.text.setLayoutData((Object)gd);
        this.toolbar = new ToolBar((Composite)this, 0x800000);
        if (useTextEditor) {
            toolItem = new ToolItem(this.toolbar, 0);
            toolItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.TEXTFIELD));
            toolItem.setToolTipText("Edit text");
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String newText = EditTextDialog.editText(TextWithOpen.this.getShell(), "Edit text", TextWithOpen.this.getText());
                    if (newText != null) {
                        TextWithOpen.this.setText(newText);
                    }
                }
            });
        }
        toolItem = new ToolItem(this.toolbar, 0);
        toolItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER));
        toolItem.setToolTipText("Browse");
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextWithOpen.this.openBrowser();
            }
        });
        gd = new GridData(66);
        this.toolbar.setLayoutData((Object)gd);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String str) {
        this.text.setText(str);
    }

    protected boolean isPlainTextEditor() {
        return false;
    }

    protected void openBrowser() {
    }

    public Text getTextControl() {
        return this.text;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.toolbar.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }
}

