/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.impl.auth.SessionContextImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.LocalProjectImpl;
import org.jkiss.dbeaver.registry.LocalWorkspaceSession;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public abstract class BaseWorkspaceImpl
implements DBPWorkspaceEclipse {
    private static final Log log = Log.getLog(BaseWorkspaceImpl.class);
    public static final String DEFAULT_RESOURCES_ROOT = "Resources";
    protected static final String PROP_PROJECT_ACTIVE = "project.active";
    private static final String WORKSPACE_ID = "workspace-id";
    private final DBPPlatform platform;
    private final IWorkspace eclipseWorkspace;
    private final SessionContextImpl workspaceAuthContext;
    protected final Map<IProject, LocalProjectImpl> projects = new LinkedHashMap<IProject, LocalProjectImpl>();
    protected DBPProject activeProject;
    private final List<DBPProjectListener> projectListeners = new ArrayList<DBPProjectListener>();

    protected BaseWorkspaceImpl(DBPPlatform platform, IWorkspace eclipseWorkspace) {
        this.platform = platform;
        this.eclipseWorkspace = eclipseWorkspace;
        this.workspaceAuthContext = new SessionContextImpl(null);
    }

    @NotNull
    protected SMSession acquireWorkspaceSession(@NotNull DBRProgressMonitor monitor) throws DBException {
        return new LocalWorkspaceSession((DBPWorkspace)this);
    }

    public abstract void initializeProjects();

    public static Properties readWorkspaceInfo(Path metadataFolder) {
        Properties props = new Properties();
        Path versionFile = metadataFolder.resolve("dbeaver-workspace.properties");
        if (Files.exists(versionFile, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = Files.newInputStream(versionFile, new OpenOption[0]);){
                    props.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return props;
    }

    public static void writeWorkspaceInfo(Path metadataFolder, Properties props) {
        Path versionFile = metadataFolder.resolve("dbeaver-workspace.properties");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream os = Files.newOutputStream(versionFile, new OpenOption[0]);){
                props.store(os, "DBeaver workspace version");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<IProject, LocalProjectImpl> map = this.projects;
        synchronized (map) {
            for (LocalProjectImpl project : this.projects.values()) {
                project.dispose();
            }
            this.projects.clear();
        }
        if (!this.projectListeners.isEmpty()) {
            log.warn((Object)("Some project listeners are still register: " + this.projectListeners));
            this.projectListeners.clear();
        }
        DBVModel.checkGlobalCacheIsEmpty();
    }

    @NotNull
    public IWorkspace getEclipseWorkspace() {
        return this.eclipseWorkspace;
    }

    @NotNull
    public List<DBPProject> getProjects() {
        return new ArrayList<DBPProject>(this.projects.values());
    }

    public DBPProject getActiveProject() {
        return this.activeProject;
    }

    public void setActiveProject(DBPProject project) {
        DBPProject oldActiveProject = this.activeProject;
        this.activeProject = project;
        if (!CommonUtils.equalObjects((Object)oldActiveProject, (Object)project)) {
            this.platform.getPreferenceStore().setValue(PROP_PROJECT_ACTIVE, project == null ? "" : project.getName());
            this.fireActiveProjectChange(oldActiveProject, this.activeProject);
        }
    }

    public DBPProject getProject(@NotNull IProject project) {
        return this.projects.get(project);
    }

    public DBPProject getProject(@NotNull String projectName) {
        IProject eProject = this.eclipseWorkspace.getRoot().getProject(projectName);
        if (!eProject.exists()) {
            return null;
        }
        return this.getProject(eProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectListener(DBPProjectListener listener) {
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectListener(DBPProjectListener listener) {
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.remove(listener);
        }
    }

    @NotNull
    public SMSessionContext getAuthContext() {
        return this.workspaceAuthContext;
    }

    @NotNull
    public DBPPlatform getPlatform() {
        return this.platform;
    }

    public boolean isActive() {
        return true;
    }

    @NotNull
    public Path getAbsolutePath() {
        return this.eclipseWorkspace.getRoot().getLocation().toFile().toPath();
    }

    @NotNull
    public Path getMetadataFolder() {
        return this.getAbsolutePath().resolve(".metadata");
    }

    public void save(DBRProgressMonitor monitor) throws DBException {
        try {
            this.eclipseWorkspace.save(true, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            throw new DBException("Error saving Eclipse workspace", (Throwable)e);
        }
    }

    protected void fireActiveProjectChange(DBPProject oldActiveProject, DBPProject activeProject) {
        DBPProjectListener[] dBPProjectListenerArray = this.getListenersCopy();
        int n = dBPProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPProjectListener listener = dBPProjectListenerArray[n2];
            listener.handleActiveProjectChange(oldActiveProject, activeProject);
            ++n2;
        }
    }

    protected void fireProjectAdd(LocalProjectImpl project) {
        DBPProjectListener[] dBPProjectListenerArray = this.getListenersCopy();
        int n = dBPProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPProjectListener listener = dBPProjectListenerArray[n2];
            listener.handleProjectAdd((DBPProject)project);
            ++n2;
        }
    }

    protected void fireProjectRemove(LocalProjectImpl project) {
        DBPProjectListener[] dBPProjectListenerArray = this.getListenersCopy();
        int n = dBPProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPProjectListener listener = dBPProjectListenerArray[n2];
            listener.handleProjectRemove((DBPProject)project);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DBPProjectListener[] getListenersCopy() {
        DBPProjectListener[] listeners;
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            listeners = this.projectListeners.toArray(new DBPProjectListener[0]);
        }
        return listeners;
    }

    public static String readWorkspaceId() {
        Properties workspaceInfo = BaseWorkspaceImpl.readWorkspaceInfo(GeneralUtils.getMetadataFolder());
        String workspaceId = workspaceInfo.getProperty(WORKSPACE_ID);
        if (CommonUtils.isEmpty((String)workspaceId)) {
            workspaceId = "D" + Long.toString(Math.abs(SecurityUtils.generateRandomLong()), 36).toUpperCase();
            workspaceInfo.setProperty(WORKSPACE_ID, workspaceId);
            BaseWorkspaceImpl.writeWorkspaceInfo(GeneralUtils.getMetadataFolder(), workspaceInfo);
        }
        return workspaceId;
    }

    public boolean isAdmin() {
        return this.hasRealmPermission("admin");
    }

    public boolean hasRealmPermission(String permission) {
        return true;
    }

    public boolean supportsRealmFeature(String feature) {
        return true;
    }
}

