/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLExecutionContext;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedure;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKey;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class MySQLStructureAssistant
extends JDBCStructureAssistant<MySQLExecutionContext> {
    private final MySQLDataSource dataSource;

    public MySQLStructureAssistant(MySQLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_TABLE_COLUMN};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    protected void findObjectsByMask(@NotNull MySQLExecutionContext executionContext, @NotNull JDBCSession session, @NotNull DBSObjectType objectType, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references) throws SQLException {
        MySQLCatalog catalog;
        MySQLCatalog mySQLCatalog = catalog = params.getParentObject() instanceof MySQLCatalog ? (MySQLCatalog)params.getParentObject() : null;
        if (catalog == null && !params.isGlobalSearch()) {
            catalog = executionContext.getContextDefaults().getDefaultCatalog();
        }
        if (objectType == RelationalObjectType.TYPE_TABLE) {
            this.findTablesByMask(session, catalog, params, references);
        } else if (objectType == RelationalObjectType.TYPE_CONSTRAINT) {
            this.findConstraintsByMask(session, catalog, params, references);
        } else if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
            this.findProceduresByMask(session, catalog, params, references);
        } else if (objectType == RelationalObjectType.TYPE_TABLE_COLUMN) {
            this.findTableColumnsByMask(session, catalog, params, references);
        }
    }

    private void findTablesByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        QueryParams queryParams = new QueryParams("TABLE_NAME", "TABLE_SCHEMA,TABLE_NAME", "information_schema.TABLES");
        if (params.isSearchInComments()) {
            queryParams.setCommentColumnName("TABLE_COMMENT");
        }
        if (catalog != null) {
            queryParams.setSchemaColumnName("TABLE_SCHEMA");
        }
        queryParams.setMaxResults(params.getMaxResults() - objects.size());
        String sql = MySQLStructureAssistant.generateQuery(queryParams);
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            MySQLStructureAssistant.fillParameters(dbStat, params, catalog, true, false);
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEMA");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    objects.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(tableName, (DBSObject)this.dataSource.getCatalog(catalogName), null, MySQLTableBase.class, RelationalObjectType.TYPE_TABLE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog tableCatalog;
                            MySQLCatalog mySQLCatalog = tableCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (tableCatalog == null) {
                                throw new DBException("Table catalog '" + catalogName + "' not found");
                            }
                            MySQLTableBase table = (MySQLTableBase)tableCatalog.getTableCache().getObject(monitor, (DBSObject)tableCatalog, tableName);
                            if (table == null) {
                                throw new DBException("Table '" + tableName + "' not found in catalog '" + catalogName + "'");
                            }
                            return table;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findProceduresByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        QueryParams queryParams = new QueryParams("ROUTINE_NAME", "ROUTINE_SCHEMA,ROUTINE_NAME", "information_schema.ROUTINES");
        if (params.isSearchInComments()) {
            queryParams.setCommentColumnName("ROUTINE_COMMENT");
        }
        if (catalog != null) {
            queryParams.setSchemaColumnName("ROUTINE_SCHEMA");
        }
        queryParams.setMaxResults(params.getMaxResults() - objects.size());
        if (params.isSearchInDefinitions()) {
            queryParams.setDefinitionColumnName("ROUTINE_DEFINITION");
        }
        String sql = MySQLStructureAssistant.generateQuery(queryParams);
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            MySQLStructureAssistant.fillParameters(dbStat, params, catalog, true, true);
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_SCHEMA");
                    final String procName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_NAME");
                    objects.add((DBSObjectReference)new AbstractObjectReference<MySQLCatalog>(procName, this.dataSource.getCatalog(catalogName), null, MySQLProcedure.class, RelationalObjectType.TYPE_PROCEDURE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog procCatalog;
                            MySQLCatalog mySQLCatalog = procCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (procCatalog == null) {
                                throw new DBException("Procedure catalog '" + catalogName + "' not found");
                            }
                            MySQLProcedure procedure = procCatalog.getProcedure(monitor, procName);
                            if (procedure == null) {
                                throw new DBException("Procedure '" + procName + "' not found in catalog '" + procCatalog.getName() + "'");
                            }
                            return procedure;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findConstraintsByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        QueryParams queryParams = new QueryParams("CONSTRAINT_NAME", "TABLE_SCHEMA,TABLE_NAME,CONSTRAINT_NAME,CONSTRAINT_TYPE", "information_schema.TABLE_CONSTRAINTS");
        if (catalog != null) {
            queryParams.setSchemaColumnName("TABLE_SCHEMA");
        }
        queryParams.setMaxResults(params.getMaxResults() - objects.size());
        String sql = MySQLStructureAssistant.generateQuery(queryParams);
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            MySQLStructureAssistant.fillParameters(dbStat, params, catalog, false, false);
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEMA");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    final String constrName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
                    String constrType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
                    final boolean isFK = "FOREIGN KEY".equals(constrType);
                    final boolean isCheck = "CHECK".equals(constrType);
                    objects.add((DBSObjectReference)new AbstractObjectReference<MySQLCatalog>(constrName, this.dataSource.getCatalog(catalogName), null, isFK ? MySQLTableForeignKey.class : MySQLTableConstraint.class, RelationalObjectType.TYPE_CONSTRAINT){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog tableCatalog;
                            MySQLCatalog mySQLCatalog = tableCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (tableCatalog == null) {
                                throw new DBException("Constraint catalog '" + catalogName + "' not found");
                            }
                            MySQLTable table = tableCatalog.getTable(monitor, tableName);
                            if (table == null) {
                                throw new DBException("Constraint table '" + tableName + "' not found in catalog '" + tableCatalog.getName() + "'");
                            }
                            Object constraint = isFK ? table.getAssociation(monitor, constrName) : (isCheck ? table.getCheckConstraint(monitor, constrName) : table.getUniqueKey(monitor, constrName));
                            if (constraint == null) {
                                throw new DBException("Constraint '" + constrName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return constraint;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findTableColumnsByMask(JDBCSession session, final @Nullable MySQLCatalog catalog, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> objects) throws SQLException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        QueryParams queryParams = new QueryParams("COLUMN_NAME", "TABLE_SCHEMA,TABLE_NAME,COLUMN_NAME", "information_schema.COLUMNS");
        if (params.isSearchInComments()) {
            queryParams.setCommentColumnName("COLUMN_COMMENT");
        }
        if (catalog != null) {
            queryParams.setSchemaColumnName("TABLE_SCHEMA");
        }
        queryParams.setMaxResults(params.getMaxResults() - objects.size());
        if (params.isSearchInDefinitions()) {
            queryParams.setDefinitionColumnName("GENERATION_EXPRESSION");
        }
        String sql = MySQLStructureAssistant.generateQuery(queryParams);
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            MySQLStructureAssistant.fillParameters(dbStat, params, catalog, true, true);
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    final String catalogName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEMA");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
                    final String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
                    objects.add((DBSObjectReference)new AbstractObjectReference<MySQLCatalog>(columnName, this.dataSource.getCatalog(catalogName), null, MySQLTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        @NotNull
                        public String getFullyQualifiedName(DBPEvaluationContext context) {
                            return String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)MySQLStructureAssistant.this.dataSource, (String)catalogName)) + '.' + DBUtils.getQuotedIdentifier((DBPDataSource)MySQLStructureAssistant.this.dataSource, (String)tableName) + '.' + DBUtils.getQuotedIdentifier((DBPDataSource)MySQLStructureAssistant.this.dataSource, (String)columnName);
                        }

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            MySQLCatalog tableCatalog;
                            MySQLCatalog mySQLCatalog = tableCatalog = catalog != null ? catalog : MySQLStructureAssistant.this.dataSource.getCatalog(catalogName);
                            if (tableCatalog == null) {
                                throw new DBException("Column catalog '" + catalogName + "' not found");
                            }
                            MySQLTableBase table = (MySQLTableBase)tableCatalog.getTableCache().getObject(monitor, (DBSObject)tableCatalog, tableName);
                            if (table == null) {
                                throw new DBException("Column table '" + tableName + "' not found in catalog '" + tableCatalog.getName() + "'");
                            }
                            MySQLTableColumn column = table.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static String generateQuery(@NotNull QueryParams params) {
        boolean addParentheses;
        StringBuilder sql = new StringBuilder("SELECT ").append(params.getSelect()).append(" FROM ").append(params.getFrom()).append(" WHERE ");
        boolean bl = addParentheses = params.getCommentColumnName() != null || params.getDefinitionColumnName() != null;
        if (addParentheses) {
            sql.append("(");
        }
        sql.append(params.getObjectNameColumn()).append(" LIKE ? ");
        if (params.getCommentColumnName() != null) {
            sql.append("OR ").append(params.getCommentColumnName()).append(" LIKE ?");
        }
        if (params.getDefinitionColumnName() != null) {
            sql.append(" OR ").append(params.getDefinitionColumnName()).append(" LIKE ?");
        }
        if (addParentheses) {
            sql.append(") ");
        }
        if (params.getSchemaColumnName() != null) {
            sql.append("AND ").append(params.getSchemaColumnName()).append(" = ? ");
        }
        sql.append("ORDER BY ").append(params.getObjectNameColumn()).append(" LIMIT ").append(params.getMaxResults());
        return sql.toString();
    }

    private static void fillParameters(@NotNull JDBCPreparedStatement statement, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @Nullable MySQLCatalog catalog, boolean hasCommentColumn, boolean hasDefinitionColumn) throws SQLException {
        String mask = params.getMask().toLowerCase(Locale.ENGLISH);
        statement.setString(1, mask);
        int idx = 2;
        if (params.isSearchInComments() && hasCommentColumn) {
            statement.setString(idx, mask);
            ++idx;
        }
        if (params.isSearchInDefinitions() && hasDefinitionColumn) {
            statement.setString(idx, mask);
            ++idx;
        }
        if (catalog != null) {
            statement.setString(idx, catalog.getName());
        }
    }

    public boolean supportsSearchInCommentsFor(@NotNull DBSObjectType objectType) {
        return objectType == RelationalObjectType.TYPE_TABLE || objectType == RelationalObjectType.TYPE_PROCEDURE || objectType == RelationalObjectType.TYPE_TABLE_COLUMN;
    }

    public boolean supportsSearchInDefinitionsFor(@NotNull DBSObjectType objectType) {
        return objectType == RelationalObjectType.TYPE_PROCEDURE || objectType == RelationalObjectType.TYPE_TABLE_COLUMN;
    }

    private static final class QueryParams {
        @NotNull
        private final String objectNameColumn;
        @Nullable
        private String commentColumnName;
        @Nullable
        private String schemaColumnName;
        @NotNull
        private final String select;
        @NotNull
        private final String from;
        private int maxResults;
        @Nullable
        private String definitionColumnName;

        private QueryParams(@NotNull String objectNameColumn, @NotNull String select, @NotNull String from) {
            this.objectNameColumn = objectNameColumn;
            this.select = select;
            this.from = from;
        }

        @NotNull
        private String getObjectNameColumn() {
            return this.objectNameColumn;
        }

        @Nullable
        private String getCommentColumnName() {
            return this.commentColumnName;
        }

        private void setCommentColumnName(@Nullable String commentColumnName) {
            this.commentColumnName = commentColumnName;
        }

        @Nullable
        private String getSchemaColumnName() {
            return this.schemaColumnName;
        }

        private void setSchemaColumnName(@Nullable String schemaColumnName) {
            this.schemaColumnName = schemaColumnName;
        }

        @NotNull
        public String getSelect() {
            return this.select;
        }

        @NotNull
        public String getFrom() {
            return this.from;
        }

        @Nullable
        private String getDefinitionColumnName() {
            return this.definitionColumnName;
        }

        private void setDefinitionColumnName(@Nullable String definitionColumnName) {
            this.definitionColumnName = definitionColumnName;
        }

        private int getMaxResults() {
            return this.maxResults;
        }

        private void setMaxResults(int maxResults) {
            this.maxResults = maxResults;
        }
    }
}

