/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.terminal;

import java.io.PrintWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListenerDefault;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorAddIn;
import org.jkiss.dbeaver.ui.editors.sql.terminal.SQLTerminalMessages;
import org.jkiss.dbeaver.ui.editors.sql.terminal.SQLTerminalView;
import org.jkiss.dbeaver.ui.editors.sql.terminal.SQLTerminalViewSwitchHandler;
import org.jkiss.utils.CommonUtils;

public class SQLTerminalEditorAddIn
implements SQLEditorAddIn {
    private static final Log log = Log.getLog(SQLTerminalViewSwitchHandler.class);
    private static final String BUNDLE_NAME = "org.jkiss.dbeaver.ui.editors.sql.terminal";
    private static final String TERMINAL_VIEW_ENABLED_PROPERTY = "org.jkiss.dbeaver.ui.editors.sql.show.consoleView.isEnabled";
    private static final String TERMINAL_VIEW_ENABLED_VALUE_TRUE = "true";
    private static final String TERMINAL_VIEW_ENABLED_VALUE_FALSE = "false";
    private static final String TERMINAL_VIEW_ENABLED_VALUE_DEFAULT = "default";
    private static final QualifiedName FILE_TERMINAL_VIEW_ENABLED_PROP_NAME = new QualifiedName("org.jkiss.dbeaver.ui.editors.sql.terminal", "org.jkiss.dbeaver.ui.editors.sql.show.consoleView.isEnabled");
    private SQLEditor editor;
    private TerminalViewContext viewContext;
    private final SQLEditorListener editorListener = new SQLEditorListenerDefault(){

        public void onDataReceived(@NotNull DBPPreferenceStore contextPrefStore, @NotNull ResultSetModel resultSet, String name) {
            if (SQLTerminalEditorAddIn.this.isTerminalViewEnabled() && CommonUtils.isNotEmpty((String)name)) {
                SQLTerminalEditorAddIn.this.obtainViewContext().view.printQueryData(contextPrefStore, resultSet, name);
            }
        }

        public void onQueryResult(@NotNull DBPPreferenceStore contextPrefStore, @NotNull SQLQueryResult result) {
            if (SQLTerminalEditorAddIn.this.isTerminalViewEnabled()) {
                SQLTerminalEditorAddIn.this.obtainViewContext().view.printQueryResult(contextPrefStore, result);
            }
        }
    };

    public void init(@NotNull SQLEditor editor) {
        this.editor = editor;
        this.viewContext = null;
        this.editor.addListener(this.editorListener);
    }

    public void cleanup(@NotNull SQLEditor editor) {
        this.editor.removeListener(this.editorListener);
    }

    @Nullable
    public PrintWriter getServerOutputConsumer() {
        return (PrintWriter)UIUtils.syncExec((RunnableWithResult)new RunnableWithResult<PrintWriter>(){

            public PrintWriter runWithResult() {
                if (SQLTerminalEditorAddIn.this.editor.getActivePreferenceStore().getBoolean("SQLEditor.SQLTerminal.showServerOutput") && SQLTerminalEditorAddIn.this.isTerminalViewEnabled()) {
                    return SQLTerminalEditorAddIn.this.obtainViewContext().view.getOutputWriter();
                }
                return null;
            }
        });
    }

    @NotNull
    private TerminalViewContext obtainViewContext() {
        if (this.viewContext == null && this.isTerminalViewEnabled()) {
            this.viewContext = new TerminalViewContext();
        }
        return this.viewContext;
    }

    private void resetViewContext() {
        this.viewContext = null;
    }

    public void toggleTerminalView() {
        boolean wasEnabled = this.isTerminalViewEnabled();
        if (wasEnabled) {
            if (this.viewContext != null) {
                this.viewContext.dispose();
            }
            this.setConcoleViewEnabled(false);
        } else {
            this.setConcoleViewEnabled(true);
            if (this.editor.hasMaximizedControl()) {
                this.editor.toggleResultPanel(true, false);
            }
            this.obtainViewContext();
        }
        this.editor.getActivePreferenceStore().firePropertyChangeEvent("SQLEditor.ConsoleView.showConsoleViewByDefault", (Object)wasEnabled, (Object)(!wasEnabled ? 1 : 0));
    }

    /*
     * Exception decompiling
     */
    public boolean isTerminalViewEnabled() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl30 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl30 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean getInitialConsoleViewEnabled() {
        IFile activeFile = EditorUtils.getFileFromInput((IEditorInput)this.editor.getEditorInput());
        if (activeFile != null) {
            try {
                String fileValue = activeFile.getPersistentProperty(FILE_TERMINAL_VIEW_ENABLED_PROP_NAME);
                if (fileValue != null) {
                    return fileValue.equals(TERMINAL_VIEW_ENABLED_VALUE_TRUE);
                }
            }
            catch (CoreException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.editor.getActivePreferenceStore().getBoolean("SQLEditor.ConsoleView.showConsoleViewByDefault");
    }

    private void setConcoleViewEnabled(@Nullable Boolean enabled) {
        if (enabled == null) {
            this.editor.setPartProperty(TERMINAL_VIEW_ENABLED_PROPERTY, TERMINAL_VIEW_ENABLED_VALUE_DEFAULT);
        } else {
            String value = enabled != false ? TERMINAL_VIEW_ENABLED_VALUE_TRUE : TERMINAL_VIEW_ENABLED_VALUE_FALSE;
            this.editor.setPartProperty(TERMINAL_VIEW_ENABLED_PROPERTY, value);
            this.editor.setResultSetAutoFocusEnabled(enabled == false);
            IFile activeFile = EditorUtils.getFileFromInput((IEditorInput)this.editor.getEditorInput());
            if (activeFile != null) {
                try {
                    activeFile.setPersistentProperty(FILE_TERMINAL_VIEW_ENABLED_PROP_NAME, value);
                }
                catch (CoreException e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private class TerminalViewContext {
        public final SQLTerminalView view;
        public final CTabItem tabItem;

        public TerminalViewContext() {
            CTabFolder tabsContainer = SQLTerminalEditorAddIn.this.editor.getResultTabsContainer();
            this.view = new SQLTerminalView(SQLTerminalEditorAddIn.this.editor.getSite(), tabsContainer, 0);
            this.tabItem = new CTabItem(tabsContainer, 64);
            this.tabItem.setControl(this.view.getControl());
            this.tabItem.setText(SQLTerminalMessages.sql_terminal_item_text);
            this.tabItem.setToolTipText("");
            this.tabItem.setImage(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_CONSOLE).createImage());
            this.tabItem.setData((Object)this.view);
            tabsContainer.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void close(CTabFolderEvent event) {
                    CTabItem cTab;
                    Widget item = event.item;
                    if (item instanceof CTabItem && (cTab = (CTabItem)item).getData() instanceof SQLTerminalView) {
                        SQLTerminalEditorAddIn.this.setConcoleViewEnabled(false);
                    }
                }
            });
            this.tabItem.addDisposeListener(e -> {
                CTabItem cTab;
                Object item = e.getSource();
                if (item instanceof CTabItem && (cTab = (CTabItem)item).getData() instanceof SQLTerminalView) {
                    SQLTerminalEditorAddIn.this.setConcoleViewEnabled(false);
                }
                if (tabsContainer.getItemCount() == 0 && !SQLTerminalEditorAddIn.this.editor.hasMaximizedControl()) {
                    SQLTerminalEditorAddIn.this.editor.toggleResultPanel(false, true);
                }
                SQLTerminalEditorAddIn.this.resetViewContext();
            });
            SQLTerminalEditorAddIn.this.editor.getResultTabsContainer().setSelection(this.tabItem);
            UIUtils.disposeControlOnItemDispose((CTabItem)this.tabItem);
        }

        public void dispose() {
            this.tabItem.dispose();
            this.view.dispose();
        }
    }
}

