"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNewDesign = void 0;
const node_process_1 = __importDefault(require("node:process"));
const electron_better_ipc_1 = require("electron-better-ipc");
const electron_util_1 = require("electron-util");
const elementReady = require("element-ready");
const selectors_1 = __importDefault(require("./browser/selectors"));
const config_1 = __importDefault(require("./config"));
const autoplay_1 = require("./autoplay");
const conversation_list_1 = require("./browser/conversation-list");
const { nativeTheme } = require('@electron/remote');
const selectedConversationSelector = '._5l-3._1ht1._1ht2';
const selectedConversationNewDesign = '[role=navigation] [role=grid] [role=row] [role=gridcell] [role=link][aria-current]';
const preferencesSelector = '._10._4ebx.uiLayer._4-hy';
const preferencesSelectorNewDesign = 'div[class="bdao358l om3e55n1 g4tp4svg"] > div:nth-of-type(3) > div';
const messengerSoundsSelector = `${preferencesSelector} ._374d ._6bkz`;
const conversationMenuSelectorNewDesign = '[role=menu]';
async function withMenu(menuButtonElement, callback) {
    const { classList } = document.documentElement;
    // Prevent the dropdown menu from displaying
    classList.add('hide-dropdowns');
    // Click the menu button
    menuButtonElement.click();
    // Wait for the menu to close before removing the 'hide-dropdowns' class
    const menuLayer = document.querySelector('.j83agx80.cbu4d94t.l9j0dhe7.jgljxmt5.be9z9djy > div:nth-child(2) > div');
    if (menuLayer) {
        const observer = new MutationObserver(() => {
            if (!menuLayer.hasChildNodes()) {
                classList.remove('hide-dropdowns');
                observer.disconnect();
            }
        });
        observer.observe(menuLayer, { childList: true });
    }
    else {
        // Fallback in case .uiContextualLayerPositioner is missing
        classList.remove('hide-dropdowns');
    }
    await callback();
}
async function withSettingsMenu(callback) {
    // If ui is new, get the new settings menu
    const settingsMenu = (await elementReady(selectors_1.default.userMenu, { stopOnDomReady: false }));
    await withMenu(settingsMenu, callback);
}
async function selectMenuItem(itemNumber) {
    let selector;
    // Wait for menu to show up
    await elementReady(conversationMenuSelectorNewDesign, { stopOnDomReady: false });
    const items = document.querySelectorAll(`${conversationMenuSelectorNewDesign} [role=menuitem]`);
    // Negative items will select from the end
    if (itemNumber < 0) {
        selector = -itemNumber <= items.length ? items[items.length + itemNumber] : null;
    }
    else {
        selector = itemNumber <= items.length ? items[itemNumber - 1] : null;
    }
    if (selector) {
        selector.click();
    }
}
async function selectOtherListViews(itemNumber) {
    // In case one of other views is shown
    clickBackButton();
    await withSettingsMenu(() => {
        selectMenuItem(itemNumber);
    });
}
function clickBackButton() {
    const backButton = document.querySelector('._30yy._2oc9');
    if (backButton) {
        backButton.click();
    }
}
electron_better_ipc_1.ipcRenderer.answerMain('show-preferences', async () => {
    if (isPreferencesOpen()) {
        return;
    }
    await openPreferences();
});
electron_better_ipc_1.ipcRenderer.answerMain('new-conversation', async () => {
    document.querySelector('[href="/new/"]').click();
});
electron_better_ipc_1.ipcRenderer.answerMain('new-room', async () => {
    document.querySelector('.qi72231t.nu7423ey.tav9wjvu.flwp5yud.tghlliq5.gkg15gwv.s9ok87oh.s9ljgwtm.lxqftegz.bf1zulr9.fsf7x5fv.tgm57n0e.jez8cy9q.s5oniofx.m8h3af8h.l7ghb35v.kjdc1dyq.kmwttqpk.dnr7xe2t.aeinzg81.cr00lzj9.rn8ck1ys.s3jn8y49.g4tp4svg.jl2a5g8c.f14ij5to.l3ldwz01.icdlwmnq.g90fjkqk.jvc6uz2b.bdao358l.alzwoclg.i85zmo3j.jcxyg2ei.srn514ro.oxkhqvkx.rl78xhln.nch0832m.om3e55n1.qmqpeqxj.e7u6y3za.qwcclf47.nmlomj2f.frfouenu.bonavkto.djs4p424.r7bn319e').click();
});
electron_better_ipc_1.ipcRenderer.answerMain('log-out', async () => {
    if (config_1.default.get('useWorkChat')) {
        document.querySelector('._5lxs._3qct._p').click();
        // Menu creation is slow
        setTimeout(() => {
            const nodes = document.querySelectorAll('._54nq._9jo._558b._2n_z li:last-child a');
            nodes[nodes.length - 1].click();
        }, 250);
    }
    else {
        await withSettingsMenu(() => {
            selectMenuItem(-1);
        });
    }
});
electron_better_ipc_1.ipcRenderer.answerMain('find', () => {
    document.querySelector('[type="search"]').focus();
});
async function openSearchInConversation() {
    const mainView = document.querySelector('.rq0escxv.l9j0dhe7.du4w35lb.j83agx80.rj1gh0hx.buofh1pr.g5gj957u.hpfvmrgz.i1fnvgqd.gs1a9yip.owycx6da.btwxx1t3.jb3vyjys.gitj76qy');
    const rightSidebarIsClosed = Boolean(mainView.querySelector('div:only-child'));
    if (rightSidebarIsClosed) {
        document.documentElement.classList.add('hide-r-sidebar');
        document.querySelector('.j9ispegn.pmk7jnqg.k4urcfbm.datstx6m.b5wmifdl.kr520xx4.mdpwds66.b2cqd1jy.n13yt9zj.eh67sqbx')?.click();
    }
    await elementReady(selectors_1.default.rightSidebarSegments, { stopOnDomReady: false });
    const segments = document.querySelectorAll(selectors_1.default.rightSidebarSegments).length;
    // If there are three segmetns in right sidebar (two users chat) then button index is 4
    // If there are not three segments (usually four, it's a group chat) then button index is 6
    const buttonIndex = segments === 3 ? 4 : 6;
    await elementReady(selectors_1.default.rightSidebarButtons, { stopOnDomReady: false });
    const buttonList = document.querySelectorAll(selectors_1.default.rightSidebarButtons);
    if (buttonList.length > buttonIndex) {
        buttonList[buttonIndex].click();
    }
    // If right sidebar was closed when shortcut was clicked, then close it back.
    if (rightSidebarIsClosed) {
        document.querySelector('.j9ispegn.pmk7jnqg.k4urcfbm.datstx6m.b5wmifdl.kr520xx4.mdpwds66.b2cqd1jy.n13yt9zj.eh67sqbx')?.click();
        // Observe sidebar so when it's hidden, remove the utility class. This prevents split
        // display of sidebar.
        const sidebarObserver = new MutationObserver(records => {
            const removedRecords = records.filter(({ removedNodes }) => removedNodes.length > 0 && removedNodes[0].tagName === 'DIV');
            // In case there is a div removed, hide utility class and stop observing
            if (removedRecords.length > 0) {
                document.documentElement.classList.remove('hide-r-sidebar');
                sidebarObserver.disconnect();
            }
        });
        sidebarObserver.observe(mainView, { childList: true, subtree: true });
    }
}
electron_better_ipc_1.ipcRenderer.answerMain('search', (isNewDesign) => {
    if (isNewDesign) {
        openSearchInConversation();
    }
    else {
        document.querySelector('._3szo:nth-of-type(1)').click();
    }
});
electron_better_ipc_1.ipcRenderer.answerMain('insert-gif', () => {
    document.querySelector('.om3e55n1.cgu29s5g > div:nth-child(3) > span > div').click();
});
electron_better_ipc_1.ipcRenderer.answerMain('insert-emoji', async () => {
    document.querySelector('.om3e55n1.cgu29s5g > div:nth-child(5) > span > div').click();
});
electron_better_ipc_1.ipcRenderer.answerMain('insert-sticker', () => {
    document.querySelector('.om3e55n1.cgu29s5g > div:nth-child(2) > span > div').click();
});
electron_better_ipc_1.ipcRenderer.answerMain('attach-files', () => {
    document.querySelector('.om3e55n1.cgu29s5g > div:nth-child(1) > span > div').click();
});
electron_better_ipc_1.ipcRenderer.answerMain('focus-text-input', () => {
    document.querySelector('[role=textbox][contenteditable=true]').focus();
});
electron_better_ipc_1.ipcRenderer.answerMain('next-conversation', nextConversation);
electron_better_ipc_1.ipcRenderer.answerMain('previous-conversation', previousConversation);
electron_better_ipc_1.ipcRenderer.answerMain('mute-conversation', async ({ isNewDesign }) => {
    await openMuteModal(isNewDesign);
});
electron_better_ipc_1.ipcRenderer.answerMain('delete-conversation', async ({ isNewDesign }) => {
    await deleteSelectedConversation(isNewDesign);
});
electron_better_ipc_1.ipcRenderer.answerMain('hide-conversation', async ({ isNewDesign }) => {
    const index = selectedConversationIndex(isNewDesign);
    if (index !== -1) {
        await hideSelectedConversation(isNewDesign);
        const key = index + 1;
        await jumpToConversation(isNewDesign, key);
    }
});
async function openHiddenPreferences() {
    if (!isPreferencesOpen()) {
        document.documentElement.classList.add('hide-preferences-window');
        const style = document.createElement('style');
        // Hide both the backdrop and the preferences dialog
        style.textContent = `${preferencesSelector} ._3ixn, ${preferencesSelector} ._59s7 { opacity: 0 !important }`;
        document.body.append(style);
        await openPreferences();
        if (!isNewDesign) {
            // Will clean up itself after the preferences are closed
            document.querySelector(preferencesSelector).append(style);
        }
        return true;
    }
    return false;
}
async function toggleSounds({ checked }) {
    const shouldClosePreferences = await openHiddenPreferences();
    const soundsCheckbox = document.querySelector(messengerSoundsSelector);
    if (typeof checked === 'undefined' || checked !== soundsCheckbox.checked) {
        soundsCheckbox.click();
    }
    if (shouldClosePreferences) {
        await closePreferences();
    }
}
electron_better_ipc_1.ipcRenderer.answerMain('toggle-sounds', toggleSounds);
electron_better_ipc_1.ipcRenderer.answerMain('toggle-mute-notifications', async () => {
    const shouldClosePreferences = await openHiddenPreferences();
    const notificationCheckbox = document.querySelector(selectors_1.default.notificationCheckbox);
    if (shouldClosePreferences) {
        await closePreferences();
    }
    return !isNewDesign && !notificationCheckbox.checked;
});
electron_better_ipc_1.ipcRenderer.answerMain('toggle-message-buttons', () => {
    document.body.classList.toggle('show-message-buttons', !config_1.default.get('showMessageButtons'));
});
electron_better_ipc_1.ipcRenderer.answerMain('show-active-contacts-view', async () => {
    await selectOtherListViews(2);
});
electron_better_ipc_1.ipcRenderer.answerMain('show-message-requests-view', async () => {
    await selectOtherListViews(3);
});
electron_better_ipc_1.ipcRenderer.answerMain('show-hidden-threads-view', async () => {
    await selectOtherListViews(4);
});
electron_better_ipc_1.ipcRenderer.answerMain('toggle-unread-threads-view', async () => {
    await selectOtherListViews(6);
});
electron_better_ipc_1.ipcRenderer.answerMain('toggle-video-autoplay', () => {
    (0, autoplay_1.toggleVideoAutoplay)();
});
electron_better_ipc_1.ipcRenderer.answerMain('reload', () => {
    location.reload();
});
function setTheme() {
    nativeTheme.themeSource = config_1.default.get('theme');
    setThemeElement(document.documentElement);
    updateVibrancy();
}
function setThemeElement(element) {
    const useDarkColors = Boolean(nativeTheme.shouldUseDarkColors);
    element.classList.toggle('dark-mode', useDarkColors);
    element.classList.toggle('light-mode', !useDarkColors);
    element.classList.toggle('__fb-dark-mode', useDarkColors);
    element.classList.toggle('__fb-light-mode', !useDarkColors);
    removeThemeClasses(useDarkColors);
}
function removeThemeClasses(useDarkColors) {
    // TODO: Workaround for Facebooks buggy frontend
    // The ui sometimes hardcodes ligth mode classes in the ui. This removes them so the class
    // in the root element would be used.
    const className = useDarkColors ? '__fb-light-mode' : '__fb-dark-mode';
    for (const element of document.querySelectorAll(`.${className}`)) {
        element.classList.remove(className);
    }
}
async function observeTheme() {
    /* Main document's class list */
    const observer = new MutationObserver((records) => {
        // Find records that had class attribute changed
        const classRecords = records.filter(record => record.type === 'attributes' && record.attributeName === 'class');
        // Check if dark mode classes exists
        const isDark = classRecords.some(record => {
            const { classList } = record.target;
            return classList.contains('dark-mode') && classList.contains('__fb-dark-mode');
        });
        // If config and class list don't match, update class list
        if (nativeTheme.shouldUseDarkColors !== isDark) {
            setTheme();
        }
    });
    observer.observe(document.documentElement, { attributes: true, attributeFilter: ['class'] });
    /* Added nodes (dialogs, etc.) */
    const observerNew = new MutationObserver((records) => {
        const nodeRecords = records.filter(record => record.addedNodes.length > 0);
        for (const nodeRecord of nodeRecords) {
            for (const newNode of nodeRecord.addedNodes) {
                const { classList } = newNode;
                const isLight = classList.contains('light-mode') || classList.contains('__fb-light-mode');
                if (nativeTheme.shouldUseDarkColors === isLight) {
                    setThemeElement(newNode);
                }
            }
        }
    });
    /* Observe only elements where new nodes may need dark mode */
    const menuElements = await elementReady('.j83agx80.cbu4d94t.l9j0dhe7.jgljxmt5.be9z9djy > div:nth-of-type(2) > div', { stopOnDomReady: false });
    if (menuElements) {
        observerNew.observe(menuElements, { childList: true });
    }
    // Attribute notation needed here to guarantee exact (not partial) match.
    const modalElements = await elementReady(preferencesSelectorNewDesign, { stopOnDomReady: false });
    if (modalElements) {
        observerNew.observe(modalElements, { childList: true });
    }
}
function setPrivateMode() {
    document.documentElement.classList.toggle('private-mode', config_1.default.get('privateMode'));
    if (electron_util_1.is.macos) {
        (0, conversation_list_1.sendConversationList)();
    }
}
function updateVibrancy() {
    const { classList } = document.documentElement;
    classList.remove('sidebar-vibrancy', 'full-vibrancy');
    switch (config_1.default.get('vibrancy')) {
        case 'sidebar':
            classList.add('sidebar-vibrancy');
            break;
        case 'full':
            classList.add('full-vibrancy');
            break;
        default:
    }
    electron_better_ipc_1.ipcRenderer.callMain('set-vibrancy');
}
function updateSidebar() {
    const { classList } = document.documentElement;
    classList.remove('sidebar-hidden', 'sidebar-force-narrow', 'sidebar-force-wide');
    switch (config_1.default.get('sidebar')) {
        case 'hidden':
            classList.add('sidebar-hidden');
            break;
        case 'narrow':
            classList.add('sidebar-force-narrow');
            break;
        case 'wide':
            classList.add('sidebar-force-wide');
            break;
        default:
    }
}
async function updateDoNotDisturb() {
    const shouldClosePreferences = await openHiddenPreferences();
    if (shouldClosePreferences) {
        await closePreferences();
    }
}
function renderOverlayIcon(messageCount) {
    const canvas = document.createElement('canvas');
    canvas.height = 128;
    canvas.width = 128;
    canvas.style.letterSpacing = '-5px';
    const ctx = canvas.getContext('2d');
    ctx.fillStyle = '#f42020';
    ctx.beginPath();
    ctx.ellipse(64, 64, 64, 64, 0, 0, 2 * Math.PI);
    ctx.fill();
    ctx.textAlign = 'center';
    ctx.fillStyle = 'white';
    ctx.font = '90px sans-serif';
    ctx.fillText(String(Math.min(99, messageCount)), 64, 96);
    return canvas;
}
electron_better_ipc_1.ipcRenderer.answerMain('update-sidebar', () => {
    updateSidebar();
});
electron_better_ipc_1.ipcRenderer.answerMain('set-theme', setTheme);
electron_better_ipc_1.ipcRenderer.answerMain('set-private-mode', setPrivateMode);
electron_better_ipc_1.ipcRenderer.answerMain('update-vibrancy', () => {
    updateVibrancy();
});
electron_better_ipc_1.ipcRenderer.answerMain('render-overlay-icon', (messageCount) => ({
    data: renderOverlayIcon(messageCount).toDataURL(),
    text: String(messageCount),
}));
electron_better_ipc_1.ipcRenderer.answerMain('render-native-emoji', (emoji) => {
    const canvas = document.createElement('canvas');
    const context = canvas.getContext('2d');
    const systemFont = electron_util_1.is.linux ? 'emoji, system-ui' : 'system-ui';
    canvas.width = 256;
    canvas.height = 256;
    context.textAlign = 'center';
    context.textBaseline = 'middle';
    if (electron_util_1.is.macos) {
        context.font = `256px ${systemFont}`;
        context.fillText(emoji, 128, 154);
    }
    else {
        context.textBaseline = 'bottom';
        context.font = `225px ${systemFont}`;
        context.fillText(emoji, 128, 256);
    }
    const dataUrl = canvas.toDataURL();
    return dataUrl;
});
electron_better_ipc_1.ipcRenderer.answerMain('zoom-reset', ({ isNewDesign }) => {
    setZoom(isNewDesign, 1);
});
electron_better_ipc_1.ipcRenderer.answerMain('zoom-in', ({ isNewDesign }) => {
    const zoomFactor = config_1.default.get('zoomFactor') + 0.1;
    if (zoomFactor < 1.6) {
        setZoom(isNewDesign, zoomFactor);
    }
});
electron_better_ipc_1.ipcRenderer.answerMain('zoom-out', ({ isNewDesign }) => {
    const zoomFactor = config_1.default.get('zoomFactor') - 0.1;
    if (zoomFactor >= 0.8) {
        setZoom(isNewDesign, zoomFactor);
    }
});
electron_better_ipc_1.ipcRenderer.answerMain('jump-to-conversation', async (key) => {
    await jumpToConversation(await isNewDesign(), key);
});
async function nextConversation() {
    const newDesign = await isNewDesign();
    const index = selectedConversationIndex(newDesign, 1);
    if (index !== -1) {
        await selectConversation(newDesign, index);
    }
}
async function previousConversation() {
    const newDesign = await isNewDesign();
    const index = selectedConversationIndex(newDesign, -1);
    if (index !== -1) {
        await selectConversation(newDesign, index);
    }
}
async function jumpToConversation(isNewDesign, key) {
    const index = key - 1;
    await selectConversation(isNewDesign, index);
}
// Focus on the conversation with the given index
async function selectConversation(isNewDesign, index) {
    const list = isNewDesign
        ? await elementReady(selectors_1.default.conversationListNewDesign, { stopOnDomReady: false })
        : await elementReady(selectors_1.default.conversationList, { stopOnDomReady: false });
    if (!list) {
        console.error('Could not find conversations list', selectors_1.default.conversationList);
        return;
    }
    const conversation = list.children[index];
    if (!conversation) {
        console.error('Could not find conversation', index);
        return;
    }
    (isNewDesign ? conversation.querySelector('[role=link]') : conversation.firstChild.firstChild).click();
}
function selectedConversationIndex(isNewDesign, offset = 0) {
    const selected 
    // Old UI
    = document.querySelector(selectedConversationSelector)
        // Newest UI
        ?? document.querySelector(selectedConversationNewDesign);
    if (!selected) {
        return -1;
    }
    const newSelected = isNewDesign
        ? selected.parentNode.parentNode.parentNode
        : selected;
    const list = [...newSelected.parentNode.children];
    const index = list.indexOf(newSelected) + offset;
    return ((index % list.length) + list.length) % list.length;
}
function setZoom(isNewDesign, zoomFactor) {
    const node = document.querySelector('#zoomFactor');
    node.textContent = `${isNewDesign ? selectors_1.default.conversationSelectorNewDesign : selectors_1.default.conversationSelector} {zoom: ${zoomFactor} !important}`;
    config_1.default.set('zoomFactor', zoomFactor);
}
async function withConversationMenu(isNewDesign, callback) {
    // eslint-disable-next-line @typescript-eslint/ban-types
    let menuButton = null;
    if (isNewDesign) {
        const conversation = document.querySelector(`${selectedConversationNewDesign}`)?.parentElement?.parentElement?.parentElement?.parentElement;
        menuButton = conversation?.querySelector('[aria-label=Menu][role=button]') ?? null;
    }
    else {
        menuButton = document.querySelector(`${selectedConversationSelector} [aria-haspopup=true] [role=button]`);
    }
    if (menuButton) {
        await withMenu(menuButton, callback);
    }
}
async function openMuteModal(isNewDesign) {
    await withConversationMenu(isNewDesign, () => {
        selectMenuItem(isNewDesign ? 2 : 1);
    });
}
/*
This function assumes:
- There is a selected conversation.
- That the conversation already has its conversation menu open.

In other words, you should only use this function within a callback that is provided to `withConversationMenu()`, because `withConversationMenu()` makes sure to have the conversation menu open before executing the callback and closes the conversation menu afterwards.
*/
function isSelectedConversationGroup(isNewDesign) {
    const separator = isNewDesign;
    document.querySelector(`${conversationMenuSelectorNewDesign} [role=menuitem]:nth-child(4)`);
    return Boolean(separator);
}
async function hideSelectedConversation(isNewDesign) {
    await withConversationMenu(isNewDesign, () => {
        const [isGroup, isNotGroup] = isNewDesign ? [5, 6] : [4, 3];
        selectMenuItem(isSelectedConversationGroup(isNewDesign) ? isGroup : isNotGroup);
    });
}
async function deleteSelectedConversation(isNewDesign) {
    await withConversationMenu(isNewDesign, () => {
        const [isGroup, isNotGroup] = isNewDesign ? [6, 7] : [5, 4];
        selectMenuItem(isSelectedConversationGroup(isNewDesign) ? isGroup : isNotGroup);
    });
}
async function openPreferences() {
    await withSettingsMenu(() => {
        selectMenuItem(1);
    });
    await elementReady(preferencesSelectorNewDesign, { stopOnDomReady: false });
}
function isPreferencesOpen() {
    return Boolean(document.querySelector('[aria-label=Preferences]'));
}
async function closePreferences() {
    const closeButton = await elementReady(selectors_1.default.closePreferencesButton, { stopOnDomReady: false });
    closeButton?.click();
    // Wait for the preferences window to be closed, then remove the class from the document
    const preferencesOverlayObserver = new MutationObserver(records => {
        const removedRecords = records.filter(({ removedNodes }) => removedNodes.length > 0 && removedNodes[0].tagName === 'DIV');
        // In case there is a div removed, hide utility class and stop observing
        if (removedRecords.length > 0) {
            document.documentElement.classList.remove('hide-preferences-window');
            preferencesOverlayObserver.disconnect();
        }
    });
    const preferencesOverlay = document.querySelector(preferencesSelectorNewDesign);
    preferencesOverlayObserver.observe(preferencesOverlay, { childList: true });
}
function insertionListener(event) {
    if (event.animationName === 'nodeInserted' && event.target) {
        event.target.dispatchEvent(new Event('mouseover', { bubbles: true }));
    }
}
async function observeAutoscroll() {
    const mainElement = await elementReady('._4sp8', { stopOnDomReady: false });
    if (!mainElement) {
        return;
    }
    const scrollToBottom = () => {
        // eslint-disable-next-line @typescript-eslint/ban-types
        const scrollableElement = document.querySelector('[role=presentation] .scrollable');
        if (scrollableElement) {
            scrollableElement.scroll({
                top: Number.MAX_SAFE_INTEGER,
                behavior: 'smooth',
            });
        }
    };
    const hookMessageObserver = async () => {
        const chatElement = await elementReady('[role=presentation] .scrollable [role = region] > div[id ^= "js_"]', { stopOnDomReady: false });
        if (chatElement) {
            // Scroll to the bottom when opening different conversation
            scrollToBottom();
            const messageObserver = new MutationObserver((record) => {
                const newMessages = record.filter(record => 
                // The mutation is an addition
                record.addedNodes.length > 0
                    // ... of a div       (skip the "seen" status change)
                    && record.addedNodes[0].tagName === 'DIV'
                    // ... on the last child       (skip previous messages added when scrolling up)
                    && chatElement.lastChild.contains(record.target));
                if (newMessages.length > 0) {
                    // Scroll to the bottom when there are new messages
                    scrollToBottom();
                }
            });
            messageObserver.observe(chatElement, { childList: true, subtree: true });
        }
    };
    hookMessageObserver();
    // Hook it again if conversation changes
    const conversationObserver = new MutationObserver(hookMessageObserver);
    conversationObserver.observe(mainElement, { childList: true });
}
async function observeThemeBugs() {
    const rootObserver = new MutationObserver((record) => {
        const newNodes = record
            .filter(record => record.addedNodes.length > 0 || record.removedNodes.length > 0);
        if (newNodes) {
            removeThemeClasses(Boolean(nativeTheme.shouldUseDarkColors));
        }
    });
    rootObserver.observe(document.documentElement, { childList: true, subtree: true });
}
// Listen for emoji element dom insertion
document.addEventListener('animationstart', insertionListener, false);
// Inject a global style node to maintain custom appearance after conversation change or startup
document.addEventListener('DOMContentLoaded', async () => {
    const newDesign = await isNewDesign();
    const style = document.createElement('style');
    style.id = 'zoomFactor';
    document.body.append(style);
    // Set the zoom factor if it was set before quitting
    const zoomFactor = config_1.default.get('zoomFactor');
    setZoom(newDesign, zoomFactor);
    // Enable OS specific styles
    document.documentElement.classList.add(`os-${node_process_1.default.platform}`);
    // Restore sidebar view state to what is was set before quitting
    updateSidebar();
    // Activate Dark Mode if it was set before quitting
    setTheme();
    // Observe for dark mode changes
    observeTheme();
    // Activate Private Mode if it was set before quitting
    setPrivateMode();
    // Configure do not disturb
    if (electron_util_1.is.macos) {
        await updateDoNotDisturb();
    }
    // Prevent flash of white on startup when in dark mode
    // TODO: find a CSS-only solution
    if (!electron_util_1.is.macos && nativeTheme.shouldUseDarkColors) {
        document.documentElement.style.backgroundColor = '#1e1e1e';
    }
    // Disable autoplay if set in settings
    (0, autoplay_1.toggleVideoAutoplay)();
    // Hook auto-scroll observer
    observeAutoscroll();
    // Hook broken dark mode observer
    observeThemeBugs();
});
// Handle title bar double-click.
window.addEventListener('dblclick', (event) => {
    const target = event.target;
    const titleBar = target.closest('._36ic._5l-3,._5742,._6-xk,._673w');
    if (!titleBar) {
        return;
    }
    electron_better_ipc_1.ipcRenderer.callMain('titlebar-doubleclick');
}, {
    passive: true,
});
window.addEventListener('load', () => {
    if (location.pathname.startsWith('/login')) {
        const keepMeSignedInCheckbox = document.querySelector('#u_0_0');
        keepMeSignedInCheckbox.checked = config_1.default.get('keepMeSignedIn');
        keepMeSignedInCheckbox.addEventListener('change', () => {
            config_1.default.set('keepMeSignedIn', !config_1.default.get('keepMeSignedIn'));
        });
    }
});
// Toggles styles for inactive window
window.addEventListener('blur', () => {
    document.documentElement.classList.add('is-window-inactive');
});
window.addEventListener('focus', () => {
    document.documentElement.classList.remove('is-window-inactive');
});
// It's not possible to add multiple accelerators
// so this needs to be done the old-school way
document.addEventListener('keydown', async (event) => {
    // The `!event.altKey` part is a workaround for https://github.com/electron/electron/issues/13895
    const combineKey = electron_util_1.is.macos ? event.metaKey : event.ctrlKey && !event.altKey;
    if (!combineKey) {
        return;
    }
    if (event.key === ']') {
        await nextConversation();
    }
    if (event.key === '[') {
        await previousConversation();
    }
    const number = Number.parseInt(event.code.slice(-1), 10);
    if (number >= 1 && number <= 9) {
        await jumpToConversation(await isNewDesign(), number);
    }
});
// Pass events sent via `window.postMessage` on to the main process
window.addEventListener('message', async ({ data: { type, data } }) => {
    if (type === 'notification') {
        showNotification(data);
    }
    if (type === 'notification-reply') {
        await sendReply(data.reply);
        if (data.previousConversation) {
            await selectConversation(await isNewDesign(), data.previousConversation);
        }
    }
});
function showNotification({ id, title, body, icon, silent }) {
    const image = new Image();
    image.crossOrigin = 'anonymous';
    image.src = icon;
    image.addEventListener('load', () => {
        const canvas = document.createElement('canvas');
        const context = canvas.getContext('2d');
        canvas.width = image.width;
        canvas.height = image.height;
        context.drawImage(image, 0, 0, image.width, image.height);
        electron_better_ipc_1.ipcRenderer.callMain('notification', {
            id,
            title,
            body,
            icon: canvas.toDataURL(),
            silent,
        });
    });
}
async function sendReply(message) {
    const inputField = document.querySelector('[contenteditable="true"]');
    if (!inputField) {
        return;
    }
    const previousMessage = inputField.textContent;
    // Send message
    inputField.focus();
    insertMessageText(message, inputField);
    const sendButton = await elementReady('._30yy._38lh', { stopOnDomReady: false });
    if (!sendButton) {
        console.error('Could not find send button');
        return;
    }
    sendButton.click();
    // Restore (possible) previous message
    if (previousMessage) {
        insertMessageText(previousMessage, inputField);
    }
}
function insertMessageText(text, inputField) {
    // Workaround: insert placeholder value to get execCommand working
    if (!inputField.textContent) {
        const event = new InputEvent('textInput', {
            bubbles: true,
            cancelable: true,
            data: '_',
            view: window,
        });
        inputField.dispatchEvent(event);
    }
    document.execCommand('selectAll', false, undefined);
    document.execCommand('insertText', false, text);
}
electron_better_ipc_1.ipcRenderer.answerMain('notification-callback', (data) => {
    window.postMessage({ type: 'notification-callback', data }, '*');
});
electron_better_ipc_1.ipcRenderer.answerMain('notification-reply-callback', async (data) => {
    const previousConversation = selectedConversationIndex(await isNewDesign());
    data.previousConversation = previousConversation;
    window.postMessage({ type: 'notification-reply-callback', data }, '*');
});
async function isNewDesign() {
    return Boolean(await elementReady('._9dls', { stopOnDomReady: true }));
}
exports.isNewDesign = isNewDesign;
electron_better_ipc_1.ipcRenderer.answerMain('check-new-ui', async () => isNewDesign());
